<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('driver-salary-report'); ?> </h6>
	</div>
	<div class="panel-body">
		<?= form_open();?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('driver');?></label>
                    <?= form_dropdown('driver_id',$drivers,set_value('driver_id',$sel_driver_id),"class='form-control'"); ?>
                    <?= form_error('driver_id');?>
                </div>
            </div>
		</div>

		<div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'get_details','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('get')));?>
                    </div>
                </div>
            </div>
		</div>


		<?= form_close(); ?>
	</div>
</div>

<?php
if(!empty($driver_salaries)){

        if($this->uri->uri_to_assoc(4)){
            $uriArray = $this->uri->uri_to_assoc(3);
            $uriString = $this->uri->assoc_to_uri($uriArray);
        }else{
            $uriString = $sel_driver_id;
        }
	?>
    <div class="panel panel-primary">
        <div class="panel-heading">
            <h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('report'); ?> </h6>
        </div>
        <div class="panel-body">
            <?= form_open();?>
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?= $this->lang->line('date'); ?></th>
                        <th><?= $this->lang->line('driver-name'); ?></th>
                        <th><?= $this->lang->line('mobile'); ?></th>
	                    <th><?= $this->lang->line('from-date'); ?></th>
                        <th><?= $this->lang->line('to-date'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        <th><?= $this->lang->line('payment-mode'); ?></th>
	                    <th colspan="4"><?= $this->lang->line('actions'); ?></th>
                        </tr>
                        </thead>
                        <?php $i=0;
                        foreach($driver_salaries as $key => $salary){$i++;
                            $salary_id = $salary['id'];
                        	?>
                        	<tr>
                        		<td><?= $i; ?></td>
                        		<td><?= dateFormat($salary['paid_date']); ?></td>
                        		<td><?= $salary['name']; ?></td>
                        		<td><?= $salary['mobile']; ?></td>
                        		<td><?= dateFormat($salary['from_date']); ?></td>
                        		<td><?= dateFormat($salary['to_date']); ?></td>
                        		<td class="text-right"><?= $salary['amount']; ?></td>
                        		<td><div class="text-bold"><?= ($salary['cash_bank'] != 0)?"Bank":'';?></div
                        			><?= $salary['ledger_name']; ?></td>
                                <?php
                                $menuArray = array(585,586,587,588);
                                app_table_links($salary_id.'/'.$uriString,$menuArray,4);
                                ?>
                                	</tr>	
                                	<?php
                                }
                                ?>
                    	</table>
                    </div>
                </div>
			</div>
		</div>
	</div>

<?php

}?>