<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("purchase"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
				<div class="col-md-4">
                    <label class="required"><?=$this->lang->line('voucher-types');?></label>
                    <?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control voucher-type' disabled");?>
                    <?=form_error('vtype_id');?>
                </div>

                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
					<div class="input-group">
						<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
						<?=form_input('bill_no',set_value('bill_no',$voucher_no),"class='form-control text-right number' id='sbill-ajax'");?>
					</div>                     
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('bill_date',set_value('bill_date',cdateFormat($voucher_date)),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label class="required"><?=$this->lang->line('invoice-no');?></label>
                    <?=form_input('invoice_no',set_value('invoice_no',$invoice_no),"class='form-control' readonly");?>
                    <?=form_error('invoice_no');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('invoice-date');?></label>
                    <?=form_input('invoice_date',set_value('invoice_date',cdateFormat($invoice_date)),"class='datepicker form-control' disabled");?>
                    <?= form_error('invoice_date');?>
                </div>
            	<div class="col-md-6">
                    <label class="required"><?=$this->lang->line('vendor');?></label>
                    <?=form_dropdown("purchase[vendor_id]",$vendors,set_value("purchase[vendor_id]",$vendor_id),"class='form-control customer_type' disabled");?>
                    <?=form_error('purchase[vendor_id]');?>
                </div>
            </div>
        </div>

<?php
if(!empty($purchase_temp_data)){
	$bill_freight = $purchase_temp_data[0]['bill_freight'];
	$other_exp = $purchase_temp_data[0]['other_expense'];
	$bill_disc_per = $purchase_temp_data[0]['bill_discount_per'];
	$bill_disc_amt = $purchase_temp_data[0]['bill_discount_amt'];
	$cess = $purchase_temp_data[0]['cess'];
	$cr_period = $purchase_temp_data[0]['cr_period'];
	$payment_mode = $purchase_temp_data[0]['payment_mode'];

?>
<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
        <table class="table table-bordered table-striped">
        <thead>
        <tr class="bg-success">
        <th>#</th>
        <th><?= $this->lang->line('item-name');?></th>
        <th><?= $this->lang->line('quantity');?></th>
        <th><?= $this->lang->line('unit'); ?></th>
        <th><?= $this->lang->line('rate'); ?></th>
        <th><?= $this->lang->line('amount'); ?></th>
        <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
        <th><?= $this->lang->line('net-value'); ?></th>
        <?php $colspan = 2;if(empty($presumptive_tax) && $purchase_cst){$colspan-=1;?>
        	<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
		<?php }?>
        <?php if(empty($presumptive_tax)){$colspan-=2;?>
            <th><?= $this->lang->line('vat'); ?> (%)</th>
            <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
        <?php }?>
        <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
        <th><?= $this->lang->line('godown'); ?></th>
        </tr>
		</thead>
		<?php
		$i=$totalAmount=$totalDiscountAmt=$totalNetValue=$totalVatAmt=$totalNetAmount=0;
		$grandNetAmount=$total_cst_amount = 0;
		foreach($purchase_temp_data as $key => $item){$i++;
			$itemID = $item['item_id'];
			$item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
			$qty = $item['qty'];
			$rate = $item['rate'];
			$discount_per = $item['discount_per'];
			$discount_amt = $item['discount_amt'];
			$cst_percent = $item['cst'];
			$vat = 0;$vatAmount = 0;$cst_amount = 0;
			$amount = $item['amount'];
			$totalAmount += $amount;
			$netValue = $amount-$discount_amt;
			if(empty($presumptive_tax)){
				if($cst_percent == 0){
					$vat = $this->stock->get_item_vat($itemID);
					$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
					$totalVatAmt += $vatAmount;
				}else{
					$cst_amount = ($netValue*$cst_percent)/100;
				}
			}
			$total_cst_amount += $cst_amount;
			$totalNetValue += $netValue;
			$netAmount = $netValue+$vatAmount+$cst_amount;
			$totalNetAmount += $netAmount;
			$totalDiscountAmt += $discount_amt;
			?>
            <tr>
            <td class="text-center"><?= $i; ?></td>
            <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
            <td class="text-right"><?= $qty; ?></td>
            <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
            <td class="text-right"><?= numberFormat($rate); ?></td>
            <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
            <?php if(empty($presumptive_tax) && $purchase_cst){?>
            	<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
			<?php }?>
            <?php if(empty($presumptive_tax)){?>
                <td class="text-right"><?= $vat; ?></td>
                <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
            <?php }?>
            <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
            <td>
            	<?= form_dropdown('godown_id_'.$item['id'],$godowns,set_value('godown_id_'.$item['id']),'class="form-control width-150"'); ?>
                <?= form_error('godown_id_'.$item['id']); ?>
            </td>
            </tr>
            <?php
		}
		$grandNetAmount = round_this($totalNetAmount);
		?>
        <tr>
        <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
        <?php if(empty($presumptive_tax) && $purchase_cst){?>
            <td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
        <?php }?>
        <?php if(empty($presumptive_tax)){?>
            <td class="disabled"></td>
            <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
        <?php }?>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
        <td class="disabled"></td>
        </tr>
    	<?php
		$presumptive_tax_amt = 0;
		if(!empty($presumptive_tax)){
			$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
			$grandNetAmount += round_this($presumptive_tax_amt);
			$totalVatAmt = round_this($presumptive_tax_amt);
			?>
            <tr>
            <td colspan="<?=(10-$colspan);?>" class="text-right">
            <span class="text-bold">
            	<?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %
            </span>
            </td>
            <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
            <td colspan="2" class="disabled"></td>
            </tr>
    	<?php }
		$cess_amt = (($totalVatAmt+$total_cst_amount)*$cess)/100;
		$grandNetAmount += round_this($cess_amt);
		?>
        <tr>
        <td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
        <?=$this->lang->line('cess');?> @ <?=$cess;?> %
        </td>
        <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
        <td colspan="2" class="disabled"></td>
        </tr>
        <tr>
        <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
        <td colspan="<?=(8-$colspan);?>" class="text-right text-bold">
        <div class="row">
        	<div class="col-md-3"><?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode',$payment_mode),'class="form-control payment-mode" disabled'); ?><?= form_error('payment_mode');?></div>
        	<div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
        	<div class="col-md-3"><?= form_input(array('name'=>'credit_period','class'=>'form-control number text-right'),set_value('credit_period',$cr_period),'disabled'); ?><?=form_error('credit_period');?></div>
        	<div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
        </div>
        </td>
        <td class="text-right"><?= numberFormat(round_this($bill_freight)); ?></td>
        <td colspan="2" class="disabled"></td>
        </tr>
        <?php if($payment_mode >2){?>
    <tr>
	<td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
    <div class="cd-ajax <?php if($payment_mode <= 2){?>hide<?php }?>">
    <div class="row">
        <div class="col-md-3">
            <?php $transaction_types = $this->dms->transaction_types();?>
            <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control" disabled'); ?>
        </div>

        <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label>     </div>
        <div class="col-md-3">
            <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control' disabled");?>
            <?=form_error('cd_no');?>
        </div>

        <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
        <div class="col-md-2">
        <?=form_input('cheque_date',set_value('cheque_date',cdateFormat($pdc)),"class='form-control' disabled");?>
        <?=form_error('cheque_date');?>
        </div>
    </div>
    </div>
	</td>
    <td></td>
	</tr>
	<?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=(8-$colspan);?>" class="text-right">
    <div class="row">
    	<div class="col-md-8 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?><?=form_error('remarks');?></div>
    	<div class="col-md-4 pull-right text-bold"><?= $this->lang->line('other-expense');?></div>
    </div>
    </td>
    <td class="text-right"><?= numberFormat(round_this($other_exp)); ?></td>
    <td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
    </tr>

    <?php
	if($this->input->post('freight')){
		$grandNetAmount += $this->input->post('freight');
	}else{
		$grandNetAmount += $bill_freight;
	}
	if($this->input->post('other_expense')){
		$grandNetAmount += $this->input->post('other_expense');
	}else{
		$grandNetAmount += $other_exp;
	}
	if($this->input->post('bill_discount_amt')){
		$grandNetAmount -= $this->input->post('bill_discount_amt');
	}else{
		$grandNetAmount -= $bill_disc_amt;
	}
	?>

	<?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=(10-$colspan);?>">
    <div class="row">
    	<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    </div>
    </td>
    <td class="text-right"><?= numberFormat(round_off($grandNetAmount)); ?></td>

	<td colspan="2" class="disabled"></td>
	</tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="2">
		<?=$this->lang->line('discount');?> %
	</td>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-left">
        	<?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per',$bill_disc_per),'disabled'); ?><?=form_error('bill_discount_per');?>
        </div>
    	<div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
    	<div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt',$bill_disc_amt),'disabled'); ?><?=form_error('bill_discount_amt');?></div>
    	<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
	<td colspan="2" class="disabled"></td>
	</tr>

	</table>
    <input type="hidden" name="grand_total_amount" id="grand_total" value="<?= round_this($grandNetAmount); ?>">
	</div>

	<div class="row">
	<div class="col-md-12">
		<div class="form-group">
			<div class="text-right">
				<?= form_submit(array('name'=>'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('generate-bill')));?>
			</div>
		</div>
	</div>
	</div>

	</div>
	</div>
</div>
</div>
	<?= form_close();
}
?>