<?php if(!empty($quotations)){ ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('quotation-report'); ?></h6>
    </div>
    <div class="panel-body">
    <?php
    if(!empty($quotations)){
        $presumtiveTax = $this->stock->get_tax_type();
        if($this->uri->uri_to_assoc(4)){
            $uriArray = $this->uri->uri_to_assoc(3);
            $uriString = $this->uri->assoc_to_uri($uriArray);
        }else{
            $uriString = $from_date.'/'.$to_date;
        }
        ?>
        <div class="row">
            <div class="col-md-12">
                <?= export_to_excel('excel/quotations_excel/quotations/'.$from_date.'/'.$to_date); ?>
            </div>
            <div class="col-md-12">
            <div class='table-responsive'>
			<table class="table table-bordered table-striped">
            <thead>
            <tr class="bg-success">
            <th>#</th>
            <th><?= $this->lang->line('bill-no'); ?></th>
            <th><?= $this->lang->line('bill-date'); ?></th>
            <th><?= $this->lang->line('customer'); ?></th>
            <th><?= $this->lang->line('net-amount'); ?></th>
            <th><?= $this->lang->line('quotation-type'); ?></th>
            <th colspan="5"><?= $this->lang->line('actions');?></th>
            </tr>
            </thead>
            <?php
            foreach($quotations as $qKey=>$quotation){
				
                $q_date = $quotation['qt_date'];
				$l_date = '2017-07-01';
                $netAmount=0;$totalNetAmount=0;$discountAmount=0;$totalVatAmount=0;
                $discountAmount = $quotation['qt_discount_amt'];
                $cess = $quotation['cess'];
                $quotationID = $quotation['id'];
                $quotation_status = $quotation['qt_status'];
                $quotation_type = $quotation_types[$quotation['qt_type']];
                $totalVatAmt=0;$grandNetAmount=0;$totalCst=0;$cst=0;

                foreach($quotation_items[$quotationID] as $qiKey=>$quotation_item){

                    $itemID = $quotation_item['item_id'];
                    $qty = $quotation_item['qty'];
                    $rate = $quotation_item['rate'];
                    $cstPercent = $quotation_item['cst'];
                    $discountPer = $quotation_item['discount_per'];
                    $discountAmt = $quotation_item['discount_amt'];
                    $vatAmount=0;$cstAmount=0;$vat=0;
					$amount = $quotation_item['amount'];
					$netValue = $amount-$discountAmt;
					if($q_date < $l_date)
					{
						if($cstPercent == 0)
						{
							$vat = $this->stock->get_item_vat($itemID);
						}
						$cstAmount = ($cstPercent*$netValue)/100;
						if(empty($presumtiveTax))
						{
							$vatAmount = $quotation_item['vat_amt'];//($vat*$netValue)/100;
						}
						else
						{
							$cstAmount=0;
						}
                    	$netValue += $cstAmount+$vatAmount;
						$totalCst += $cstAmount;
						if(!empty($presumtiveTax))
						{
                    		$pmTaxAmt = ($presumtiveTax[0]*$grandNetAmount)/100;
                    		$gnTotalVatAmount = $pmTaxAmt;
							$grandNetAmount += $pmTaxAmt;
                		}
						$cessAmount=0;
                		$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
                		$grandNetAmount += $cessAmount;
					}
					else
					{
						$cgst = $this->stock->get_item_cgst($itemID);
						$sgst = $this->stock->get_item_sgst($itemID);
						$cgstAmount = $quotation_item['cgst_amt'];
						$sgstAmount = $quotation_item['sgst_amt'];
						$vatAmount = $cgstAmount+$sgstAmount;
						$netValue += $vatAmount;
					}
                    $totalVatAmt += $vatAmount;
                    $grandNetAmount += $netValue; 
				}
                $gnTotalVatAmount=$totalVatAmt;
                $grandNetAmount -= $discountAmount;
                ?>
                <tr>
                <td><?= $count++; ?></td>
                <td><?= $quotation['qt_no']; ?></td>
                <td><?= dateFormat($quotation['qt_date']); ?></td>
                <td><?= $quotation['customer_name']; ?><div><?= $quotation['mobile_no']; ?></div></td>
                <td class="text-right"><?= numberFormat(get_rounded($grandNetAmount)); ?></td>
                <td><?= $quotation_type; ?></td>
                <?php app_table_links($quotationID.'/'.$uriString,array(366,367,368,369));	?>
                <?php
                if($quotation_status == 0){
                    app_table_links($quotationID.'/'.$uriString,array(370));
                }else{?>
                    <td class="text-center"><a title="<?= $this->lang->line('sales-order-generated'); ?>"><i class="icon-file opacity-5"></i></a>  </td>
                <?php
                }
                ?>
                </tr>
                <?php
			}
            ?>
        	</table>
            </div>
            </div>
        </div>

        <div class="row">
        <div class="col-md-12">
            <div class="pagination"><?= $links; ?></div>
        </div>
        </div>
		<?php } ?>
	</div>
</div>
<?php } ?>