<style>
*{	font-size:10px;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center; font-size:12px;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:700;}
.data-list td{	font-size:8px;}
.disabled{background-color:#E2E2E1;}
.italic{ font-style:italic;}
.has-border{ border:1px solid #999;}
.has-border-left{border-left:1px solid #999;}
.data-list tr td{  border-right:1px solid #999;}
.data-list tr th{border:1px solid #999;}
.declaration{font-size:8px;}
.terms-conditions{font-size:8px;font-family: ss;}
</style>
<?php
if(!empty($quotations)){
	$presumtiveTax = $this->stock->get_tax_type();
	$quotation = $quotations[0];
	$qtn_no = $quotation['qt_no'];
	$qtn_date = $quotation['qt_date'];
	$customer_name = $quotation['customer_fname'].' '.$quotation['customer_lname'];
	$customer_address = $quotation['address'];
	$customer_phone = (!empty($quotation['phone_no']))?'Ph : '.$quotation['phone_no'].', ':'';
	$customer_mobile = (!empty($quotation['mobile_no']))?'Mob : '.$quotation['mobile_no']:'';
	?>
    <div class="pdf-head">QUOTATION</div>
    <table  class="data-table" border="0">
    <tr>
    <td class="text-right" colspan="4">
        <span class="text-bold">Quotation No. : <?= $qtn_no; ?></span><br/>
        <span class="text-bold">Quotation Date : <?= dateFormat($qtn_date); ?></span>
    </td>
    </tr>
    </table>
    <table  class="data-table" border="0">
    <tr>
    <td width="20%" rowspan="3"><span class="text-bold">Customer </span></td>
    <td width="80%"><?= $customer_name; ?></td>
    </tr>
    <tr>
    <td><?= $customer_address; ?></td>
    </tr>
    <tr>
    <td><?php echo $customer_phone; ?><?php echo $customer_mobile; ?> </td>
    </tr>
    </table>
	<?php
    $itmSpc=$qtySpc=$untSpc=$rtSpc=$amtSpc=0;$cstSpc=0;
    if(empty($cst_enabled)){
        $cstSpc = 60;
    }
    if(!empty($presumtiveTax)){
        $cstSpc = 150;
    }
    ?>
	<table class="data-list">
    <thead>
    <tr>
    <th width="20">#</th>
    <th width="<?= 130+$cstSpc; ?>">Item</th>
    <th width="50">Qty.</th>
    <th width="55">Rate</th>
    <th width="60">Amount</th>
    <th width="50">Discount</th>
	<?php 
		$b_date = $qtn_date;
		$l_date = '2017-07-01';
		if($b_date < $l_date)
		{
			if(!empty($cst_enabled) && empty($presumtiveTax)){ ?>
				<th width="45">CST</th>
			<?php } ?>
			<?php if(empty($presumtiveTax)){ ?>
				<th width="30">VAT (%)</th>
				<th width="55">VAT Amt.</th>
			<?php }
		}
		else
		{
	?>	
    		<th width="30">GST (%)</th>
			<th width="55">GST Amt.</th>	
	<?php		
		}
			 ?>
    <th width="70">Net Amount</th>
    </tr>
    </thead>
    <?php
	$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
	$grandNetAmount=0;$totalCst=0;
	$cst=0;
	foreach($quotations as $key=>$item){$i++;

		$itemID = $item['item_id'];
		$qty = $item['qty'];
		$rate = $item['rate'];
		$cstPercent = $item['cst'];
		$discountPer = $item['discount_per'];
		$discountAmt = $item['discount_amt'];
		$amount = $item['amount'];
		$totalAmount += $amount;
		$totalDiscountAmt += $discountAmt;
		$netValue = $amount-$discountAmt;
		$totalNetValue += $netValue;
		$vatAmount=0;$cstAmount=0;$vat=0;
		if($b_date < $l_date)
		{	
			if($cstPercent == 0){
				$vat = $this->stock->get_item_vat($itemID);
			}else{
				$cst=1;
			}
		
			$cstAmount = ($cstPercent*$netValue)/100;
			
			if(empty($presumtiveTax)){
				$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
			}else{
				$cstAmount=0;
			}
			$netValue += $cstAmount;
			$totalCst += $cstAmount;
		}
		else
		{
			$cgst = $this->stock->get_item_cgst($itemID);
			$sgst = $this->stock->get_item_sgst($itemID);
			$cgstAmount = 	$item['cgst_amt'];
			$sgstAmount = 	$item['sgst_amt'];
			$vatAmount = $cgstAmount+$sgstAmount;

		}
		$totalVatAmt += $vatAmount;
		$netAmount = $netValue+$vatAmount;
		$totalNetAmount += $netAmount;
		
		?>
		<tr>
		<td width="20" class="text-center has-border-left"><?= $i; ?></td>
		<td width="<?= 130+$cstSpc; ?>"><?= $item['item_code']; ?> / <?= $item['item_name']; ?></td>
		<td width="50" class="text-right"><?= $qty; ?> <?= $item['symbol']; ?></td>
		<td width="55" class="text-right"><?= numberFormat($rate); ?></td>
        <td width="60" class="text-right"><?= numberFormat($amount); ?></td>
		<td width="50" class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
		<?php 
			if($b_date < $l_date)
			{
				if(!empty($cst_enabled) && empty($presumtiveTax)){ ?>
					<td width="45" class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
				<?php } ?>
				<?php if(empty($presumtiveTax)){ ?>
					<td width="30" class="text-right"><?= $vat; ?></td>
					<td width="55" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
				<?php 
				}
			}
			else
			{
		?>	
        		<td width="30" class="text-right"><?= ($cgst+$sgst); ?></td>
				<td width="55" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>	
		<?php		
			}
		?>
		<td width="70" class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
		</tr>
		<?php
	}
	$grandNetAmount = round_this($totalNetAmount);
	?>
    <tr>
    <td class="text-right text-bold has-border disabled" colspan="4">Total</td>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <?php 
		if($b_date < $l_date)
		{
			if(!empty($cst_enabled) && empty($presumtiveTax)){ ?>
				<td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalCst)); ?></td>
			<?php } ?>
			<?php if(empty($presumtiveTax)){ ?>
				<td class="disabled has-border"></td>
				<td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalVatAmt)); ?></td>
	<?php 
			}
		}
		else
		{
	?>
    		<td class="disabled has-border"></td>
			<td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php		
		}
	?>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>
	<?php
	$gnTotalVatAmount=$totalVatAmt;
	if($b_date < $l_date)
	{
		if(!empty($presumtiveTax)){
			$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
			$gnTotalVatAmount = round_this($pmTaxAmt);
			$grandNetAmount += round_this($pmTaxAmt);
			?>
			<tr>
			<td class="text-right text-bold" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">Presumptive Tax @ <?= $presumtiveTax[0]; ?> %</td>
			<td class="text-right text-bold has-border"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
			</tr>
			<?php
		}
		$cessAmount=0;
		$cess = $this->stock->get_cess();
		$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
		$grandNetAmount += round_this($cessAmount);
	}
	?>
    <tr>
    <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">Cess ( <?= $cess; ?> %)</td>
    <td class="text-right text-bold has-border"><?= numberFormat(round_this($cessAmount)); ?></td>
    </tr>
    <tr>
    <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">Discount </td>
    <td class="text-right text-bold has-border"><?= numberFormat(round_this($quotations[0]['qt_discount_amt'])); ?></td>
    </tr>

    <?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">Round Off </td>
    <td class="text-right text-bold has-border"><?= numberFormat(round_off($grandNetAmount)); ?></td>
    </tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold no-border" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">Net Amount</td>
    <?php $grandNetAmount -= $quotations[0]['qt_discount_amt']; ?>
    <td class="text-right text-bold has-border">
    <label><?= numberFormat(get_rounded($grandNetAmount)); ?></label>
    </td>
    </tr>
	</table>
    <div class="text-left italic"><?= $this->to_words->num_to_words(get_rounded($grandNetAmount)); ?></div>
    <div><span class="text-bold">Remarks : </span><?=  $quotations[0]['remarks']; ?></div>
    <div class="text-right text-bold">Authorised Signatory.</div>
<?php
}?>