<?= form_open(); ?>
<?php $bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']); ?>
<div class="panel panel-primary">

    <div class="panel-heading">
    <h6 class="panel-title"><i class="icon-database"> <?= $this->lang->line("edit")." ".$this->lang->line("$voucher_name-bill"); ?> </i></h6>
    </div>
    <div class="panel-body">

        <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label><?=$this->lang->line('voucher-types');?></label>
                <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
            </div>
            <div class="col-md-4">
                <label class="required"><?=$this->lang->line('bill-no');?></label>
                <div class="input-group">
                    <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                     <?=form_input('bill_no',set_value('bill_no',$sales_array[0]['bill_no']),"class='form-control text-right number' id='sbill-ajax'");?>
                </div>
                <?= form_error('bill_no');?>
            </div>
            <div class="col-md-4">
                <label class="required"><?=$this->lang->line('bill-date');?></label>
				<?=form_input('bill_date',set_value('bill_date',cdateFormat($sales_array[0]['bill_date'])),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                <?= form_error('bill_date');?>
            </div>
        </div>
        </div>

        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label><?=$this->lang->line('invoice-no');?></label>
                    <input type="text" class="form-control" disabled value="<?=$return_bill_no;?>">
                </div>
            	<div class="col-md-3">
                    <label><?=$this->lang->line('customer-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$this->dms->desig_name($sales_array[0]['customer_type_id']);?>">
                </div>
                <div class="col-md-6">
                    <label><?=$this->lang->line('customer-name');?></label>
                    <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <div class="col-md-<?=(empty($presumptive_tax) && $sales_cst)?4:6;?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <?php if(empty($presumptive_tax) && $sales_cst){?>
                <div class="col-md-2">
                    <label><?=$this->lang->line('cst');?> %</label>
                    <?= form_input(array('name'=>'cst','class'=>'form-control text-right decimal cst'),set_value('cst')); ?>
                    <?= form_error('cst');?>
                </div>
                <?php }?>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty amount-ajax decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate amount-ajax decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                    <?= form_error('amount');?>
                </div>
            </div>
        </div>

        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>

        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>

	</div>
</div>

<div class="row">
<div class="col-md-12">

    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name');?></th>
    <th><?= $this->lang->line('quantity');?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    <th><?= $this->lang->line('rate'); ?></th>
    <th><?= $this->lang->line('net-value'); ?></th>
    <?php 
		$b_date = $sales_array[0]['bill_date'];
		$l_date = '2017-07-01';
		if($b_date < $l_date)
		{ 
			$colspan = 2;
			if(empty($presumptive_tax) && $sales_cst)
			{
				$colspan-=1;
	?>
    			<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
	<?php 
			}
	?>
    <?php 
			if(empty($presumptive_tax))
			{
				$colspan-=2;
	?>
        		<th><?= $this->lang->line('vat'); ?> (%)</th>
        		<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php 
			}
		}
		else
		{
	?>	
    		<th><?= $this->lang->line('cgst'); ?> (%)</th>
            <th><?= $this->lang->line('sgst'); ?> (%)</th>
        	<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
        	<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>	
	<?php		
		}
	?>
    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    <th colspan='2'><?=$this->lang->line('actions');?></th>
    </tr>
    </thead>
    <?php
    $i=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
    $cess = $sales_array[0]['cess'];
    foreach($sales_array as $key => $item)
    {
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $netValue = $item['amount'];
		if($b_date < $l_date)
		{
			$a=8;$b=6;
	        if(empty($presumptive_tax))
			{
     	       if($cst_percent == 0)
			   {
        	        $vat = $this->stock->get_item_vat($itemID);
        	        $vatAmount = $item['vat_amt'];
        	        $totalVatAmt += $vatAmount;
        	    }
				else
				{
        	        $cst_amount = ($netValue*$cst_percent)/100;
        	    }
        	}
			$total_cst_amount += $cst_amount;
			$netAmount = $netValue+$vatAmount+$cst_amount;
		}
		else
		{
			$a=10; $b=8;
			$cgst = $this->stock->get_item_cgst($itemID);
			$sgst = $this->stock->get_item_sgst($itemID);
			$cgstAmount = $item['cgst_amt'];
			$sgstAmount = $item['sgst_amt'];
        	$vatAmount = $cgstAmount + $sgstAmount;
        	$totalVatAmt += $vatAmount;	
			$netAmount = $netValue+$vatAmount;	
		}
        $totalNetValue += $netValue;
        $totalNetAmount += $netAmount;
        ?>
        <tr>
        <td><?= $i; ?></td>
        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td class="text-right"><?= $qty; ?></td>
        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td class="text-right"><?= numberFormat($rate); ?></td>
        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php 
			if($b_date < $l_date)
			{
				if(empty($presumptive_tax) && $sales_cst)
				{
		?>
    		    	<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
		<?php 
				}
		?>
        <?php 
				if(empty($presumptive_tax))
				{
		?>
            		<td class="text-right"><?= $vat; ?></td>
            		<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php 
				}
			}
			else
			{
		?>
        		<td class="text-right"><?= $cgst; ?></td>
                <td class="text-right"><?= $sgst; ?></td>
            	<td class="text-right"><?= numberFormat(round_this($cgstAmount)); ?></td>
            	<td class="text-right"><?= numberFormat(round_this($sgstAmount)); ?></td>
        <?php		
			}
		?>
        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        <?php $uri_array = $this->uri->uri_to_assoc(1);?>
        <?php app_table_links('idu/'.$item['id'].$redirect,array(508,509));?>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php
		if($b_date < $l_date)
		{ 
			if(empty($presumptive_tax) && $sales_cst)
			{
	?>
    			<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php 
			}
	?>
    <?php 
			if(empty($presumptive_tax))
			{
	?>
        		<td class="disabled"></td>
        		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php 
			}
		}
		else
		{
	?>
    		<td class="disabled"></td>
            <td class="text-right text-bold" colspan="2">GST Amt.</td>
        	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php		
		}
	?>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    <td colspan="2" class="disabled"></td>
    </tr>

    <?php $presumptive_tax_amt = 0;
		if($b_date < $l_date)
		{
			if(!empty($presumptive_tax))
			{
				$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
				$grandNetAmount += round_this($presumptive_tax_amt);
	?>
        		<tr>
        		<td colspan="<?=($a-$colspan);?>" class="text-right">
        		<span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
        		<td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
        		<td colspan="2" class="disabled"></td>
        		</tr>
    <?php
			}
	?>
    <?php 
			$cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
    		$grandNetAmount += round_this($cess_amt);
		}
	?>
    <tr>
    <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        <div class="row">
            <div class="col-md-9"><?= form_dropdown('area_id',$areas,set_value('area_id',$sales_array[0]['area_id']),'class="form-control"'); ?><?= form_error('area_id');?></div>
            <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
        </div>
    </td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
    <td colspan="2" class="disabled"></td>
    </tr>

    <tr>
    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold"><?= $this->lang->line('freight');?></td>
    <td class="text-right"><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$sales_array[0]['bill_freight'])); ?><?=form_error('freight');?></td>
    <td colspan="2" class="disabled"></td>
    </tr>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        <div class="row">
        <div class="col-md-8 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$sales_array[0]['narration'])); ?><?=form_error('remarks');?></div>
        <div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
        </div>
    </td>
    <td class="text-right"><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$sales_array[0]['other_expense'])); ?><?=form_error('other_expense');?></td>
    <td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
    </tr>
    <?php
	if($this->input->post('freight')){
		$grandNetAmount += $this->input->post('freight');
	}else{
		$grandNetAmount += $sales_array[0]['bill_freight'];
	}
	if($this->input->post('other_expense')){
		$grandNetAmount += $this->input->post('other_expense');
	}else{
		$grandNetAmount += $sales_array[0]['other_expense'];
	}
	?>
    <?php if(show_round_off()){ ?>
        <tr>
        <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
        <div class="row">
            <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
        </div>
        </td>
        <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
        <td colspan="2" class="disabled"></td>
        </tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    <div class="row">
        <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    <td colspan="2" class="disabled"></td>
    </tr>
    <input type="hidden" name="grand_total" id="grand_total" value="<?=round_this($grandNetAmount); ?>">
    </table>
    </div>

    <div class="row">
	<div class="col-md-12">
		<div class="form-group">
			<div class="text-right">
				<?= form_submit(array('name'=>'btn_update','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('update')."  ".$this->lang->line('bill')));?>
			</div>
		</div>
	</div>
	</div>

</div>
</div>

<?= form_close(); ?>