<?= form_open(); ?>

<div class="panel panel-primary">

    <div class="panel-heading">
    <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("new")." ".$this->lang->line("$voucher_name-bill"); ?></h6>
    </div>
    <div class="panel-body">

        <div class="form-group">
            <div class="row">
				<div class="col-md-4">
                    <label class="required"><?=$this->lang->line('voucher-types');?></label>
                    <?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control voucher-type' disabled");?>
                    <?=form_error('vtype_id');?>
                </div>

                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                    	<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
	                    <?=form_input('bill_no',set_value('bill_no',$voucher_no),"class='form-control text-right number' id='sbill-ajax'");?>
                    </div>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('bill_date',set_value('bill_date',cdateFormat($voucher_date)),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label><?=$this->lang->line('invoice-no');?></label>
                    <?= form_input(array('name'=>'return_bill_no','class'=>'form-control'),set_value('return_bill_no',$return_bill),"disabled"); ?>
                    <?=form_error('return_bill_no');?>
                </div>
            	<div class="col-md-3">
                    <label class="required"><?=$this->lang->line('customer-types');?></label>
                    <?=form_dropdown("customer_type",$customerTypes,set_value("customer_type",$custType),"class='form-control customer_type' disabled");?>
                    <?=form_error('customer_type');?>
                </div>
                <div class="col-md-6">
                <label class="required"><?=$this->lang->line('customer-name');?></label>
                    <div class="input-group">
						<?= form_dropdown('customer_id',$customers,set_value('customer_id',$cust_id),"class='form-control customers' disabled"); ?>
                        <span class="input-group-addon" title="<?= $this->lang->line('new'); ?>"><i class="icon-user"></i></span>
                    </div>
                    <?= form_error('customer_id');?>
                </div>
            </div>
        </div>


    </div>

</div>

<?php
$bill_freight=0;$bill_other_exp=0;
if(!empty($sales_temp_data))
{
	$bill_freight = $sales_temp_data[0]['bill_freight'];
	$bill_other_exp = $sales_temp_data[0]['other_expense'];
	$uri_array = $this->uri->uri_to_assoc(3);
	?>

	<div class="row">
	<div class="col-md-12">
	<div class='table-responsive'>
	<table class="table table-bordered table-striped">
	<thead>
	<tr class="bg-success">
	<th>#</th>
	<th><?= $this->lang->line('item-name');?></th>
	<th><?= $this->lang->line('quantity');?></th>
	<th><?= $this->lang->line('unit'); ?></th>
	<th><?= $this->lang->line('rate'); ?></th>
	<th><?= $this->lang->line('net-value'); ?></th>
    <?php $colspan = 2;if(empty($presumptive_tax) && $sales_cst){$colspan-=1;?>
    	<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
	<?php }?>
    <?php if(empty($presumptive_tax)){$colspan-=2;?>
        <th><?= $this->lang->line('vat'); ?> (%)</th>
        <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php }?>
	<th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    <th><?= $this->lang->line('godown'); ?></th>
	</tr>
	</thead>
	<?php
	$i=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
	$grandNetAmount=0;$total_cst_amount = 0;
	foreach($sales_temp_data as $key => $item){
		$i++;
		$rout_id = $item['rout_id'];
		$itemID = $item['item_id'];
		$item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
		$qty = $item['qty'];
		$rate = $item['rate'];
		$cst_percent = $item['cst'];
		$vat = 0;$vatAmount = 0;$cst_amount = 0;
		$netValue = $item['amount'];
		if(empty($presumptive_tax)){
			if($cst_percent == 0){
				$vat = $this->stock->get_item_vat($itemID);
				$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
				$totalVatAmt += $vatAmount;
			}else{
				$cst_amount = ($netValue*$cst_percent)/100;
			}
		}
		$total_cst_amount += $cst_amount;
		$totalNetValue += $netValue;
		$netAmount = $netValue+$vatAmount+$cst_amount;
		$totalNetAmount += $netAmount;
		?>
		<tr>
		<td class="text-center"><?= $i; ?></td>
		<td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
		<td class="text-right"><?= $qty; ?></td>
		<td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
		<td class="text-right"><?= numberFormat($rate); ?></td>
		<td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php if(empty($presumptive_tax) && $sales_cst){?>
        	<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
		<?php }?>
        <?php if(empty($presumptive_tax)){?>
            <td class="text-right"><?= $vat; ?></td>
            <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php }?>
		<td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        <td class="text-right">
        <?= form_dropdown('godown_id_'.$rout_id,$godowns,set_value('godown_id_'.$rout_id),"class='form-control width-150'"); ?>
          <?= form_error('godown_id_'.$rout_id);?>
        </td>
		</tr>
		<?php
	}
	$grandNetAmount = round_this($totalNetAmount);
	?>
	<tr>
	<td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
	<td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php if(empty($presumptive_tax) && $sales_cst){?>
    	<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php }?>
    <?php if(empty($presumptive_tax)){?>
        <td class="disabled"></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php }?>
	<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    <td class="disabled"></td>
	</tr>
    <?php $presumptive_tax_amt = 0;if(!empty($presumptive_tax)){
	$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
	$grandNetAmount += round_this($presumptive_tax_amt);
	?>
	<tr>
	<td colspan="<?=(8-$colspan);?>" class="text-right">
	<span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
	<td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
    <td class="disabled"></td>
	</tr>
    <?php }?>
    <?php $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
	$grandNetAmount += round_this($cess_amt);?>

    <tr>
    <td colspan="2" class="text-right text-bold required"><?=$this->lang->line('area');?></td>
	<td colspan="<?=(6-$colspan);?>" class="text-right text-bold">
    	<div class="row">
            <div class="col-md-8"><?= form_dropdown('area_id',$areas,set_value('area_id'),'class="form-control"'); ?><?= form_error('area_id');?></div>
            <div class="col-md-4 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
		</div>
	</td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
    <td class="disabled"></td>
	</tr>

    <tr>
	<td colspan="<?=(8-$colspan);?>" class="text-right text-bold"><?= $this->lang->line('freight');?></td>
	<td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$bill_freight)); ?><?=form_error('freight');?></td>
    <td class="disabled"></td>
	</tr>

    <tr>
	<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
	<td colspan="<?=(6-$colspan);?>" class="text-right text-bold">
		<div class="row">
		<div class="col-md-8 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?><?=form_error('remarks');?></div>
        <div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
		</div>
	</td>
	<td><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$bill_other_exp)); ?><?=form_error('other_expense');?></td>
    <td class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
	</tr>
    <?php
	if($this->input->post('freight')){
		$grandNetAmount += $this->input->post('freight');
	}else{
		$grandNetAmount += $bill_freight;
	}
	if($this->input->post('other_expense')){
		$grandNetAmount += $this->input->post('other_expense');
	}else{
		$grandNetAmount += $bill_other_exp;
	}
	?>
    <?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>">
    <div class="row">
        <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold">
    	<div class="in-line" id="round_off"><?= numberFormat(round_off($grandNetAmount)); ?></div>
	</td>
    <td class="disabled"></td>
	</tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>">
    <div class="row">
        <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold">
    	<div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
	</td>
    <td class="disabled"></td>
	</tr>
	<input type="hidden" name="grand_total" id="grand_total" value="<?=round_this($grandNetAmount); ?>">
	</table>
	</div>

	<div class="row">
	<div class="col-md-12">
		<div class="form-group">
			<div class="text-right">
				<?= form_submit(array('name'=>'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('generate-bill')));?>
			</div>
		</div>
	</div>
	</div>

	</div>
	</div>

	<?= form_close();
}
?>