<?= export_to_excel('excel/sales_excel/sales'.$redirect); ?>
<div class="table-responsive block">
    <table class="table table-striped table-condensed table-bordered tbl-brdr">
        <tr class="bg-success">
            <th>#</th>
            <th><?=$this->lang->line('date');?></th>
            <th><?=$this->lang->line('bill-no');?></th>
            <th><?=$this->lang->line('bill-type');?></th>
            <th><?=$this->lang->line('customer');?></th>
            <th><?=$this->lang->line('net')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('advance')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('paid')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('payment-mode');?></th>
            <th><?=$this->lang->line('sales-man');?></th>
            <th colspan='6'><?=$this->lang->line('actions');?></th>
        </tr>
<?php
	    foreach($sales_array as $key => $value):
	        $flag=0;
		    $bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
		    $total_amount = 0;$total_tax = 0;$presum_amount = 0; $total_taxable = 0; $total_cess = 0; $advance_amt=0; $paid_amt=0;

            $item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

		    foreach($item_details as $item_key => $item_value):
			    
			    $net_value = ($item_value['amount']-$item_value['discount_amt']);                     
                $taxable = $item_value['taxable_amt'];
                $vat = $item_value['vat'];
                $tax_amount = $item_value['vat_amt'];
                $cess_amount = $item_value['cess_amt'];
                
                $total_taxable += $taxable;
                $total_tax += $tax_amount;
                $total_cess += $cess_amount;
			    $total_amount += $taxable+$tax_amount+$cess_amount;
		    endforeach;
		                 
            $total_amount += (($value['bill_freight']+$value['other_expense'])); 
            
                
            $conditions1 = array('a.group_id' => $value['group_id'],'a.book_status'=>1);
            $book_array = $this->book_obj->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','a.paid_amount','a.balance_amount','a.doctor','a.delivery_date','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat','b.vat_amt'),'conditions' => $conditions1)); 
            if(!empty($book_array))
            {
                $flag=1;
                $advance_amt = $book_array[0]['paid_amount'];
               // $paid_amt = $book_array[0]['balance_amount'];
            }
            $paid_amt = $total_amount-$advance_amt;
?>
            <tr>
                <td class="text-center"><?=++$offset;?></td>
                <td class="text-center"><?=dateFormat($value['bill_date']);?></td>
                <td><?=$bill_prefix.' '.$value['bill_no'];?></td>
                <td><?php if($value['s_type']=="sale"){ echo "sales"; }else{ echo "medicine";} ?></td>
                <td><?=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);?></td>
                <td class="text-right"><?=numberFormat(get_rounded($total_amount));?></td>
                <td class="text-right"><?=numberFormat(get_rounded($advance_amt));?></td>
                <td class="text-right"><?=numberFormat(get_rounded($paid_amt));?></td>
                <td><?=$this->stock->ledger_name($value['payment_mode']);?></td>
                <td><?=$this->sales_obj->get_user($value['user_id']);?></td>
        <?php 
                if($flag==1)
                {
                    if($value['bill_status'] < 2)
                    {
                        app_table_links('id/'.$value['id'].$redirect,array(325,686,324,439,630,684));
                    }
                    else
                    {
        	            app_table_links('id/'.$value['id'].$redirect,array(325,686,439,630,684),6);
		            }
                }
                else
                {
                    if($value['bill_status'] < 2)
                    {
                        if($value['s_type']=="sale")
                        {
        	                app_table_links('id/'.$value['id'].$redirect,array(325,323,324,439,630,684));
                        }
                        else
                        {
                            app_table_links('id/'.$value['id'].$redirect,array(325,323,324,638,684),6);
                        }
                    }
                    else
                    {
                        if($value['s_type']=="sale")
                        {
        	                app_table_links('id/'.$value['id'].$redirect,array(325,439,630),5);
                        }
                        else
                        {
                            app_table_links('id/'.$value['id'].$redirect,array(325,638),5);
                        }
		            }
                }
?>
            </tr>
	    <?php endforeach;?>
	</table>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="pagination"><?=$links;?></div>
	</div>
</div>