<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('edit-sales-order'); ?></h6>
    </div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id',$sales_order['item_id']),'class="form-control item_name" readonly disabled'); ?>
                    <?= form_error('item_id');?>
            	</div>

				<?php
                $cSpan=0;
                $presumtiveTax = $this->stock->get_tax_type();
                $sales_CST = $this->stock->get_constant(array('sales_cst'));
                if(!empty($sales_CST) || !empty($cst_enabled)){
                    $cSpan =1;
                }
                ?>

                <div class="col-md-<?= 6-($cSpan)*2; ?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id',$sales_order['godown_id']),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>

				<?php if((!empty($sales_CST) || !empty($cst_enabled)) && empty($presumtiveTax)){ ?>
                    <div class="col-md-2">
                    <?php $disabled_cst = "";if(empty($sales_order['cst'])){$disabled_cst = "readonly";}?>
                        <label><?=$this->lang->line('cst');?> %</label>
                        <?=form_input('cst',set_value('cst',round_this($sales_order['cst'])),"class='form-control text-right decimal cst' $disabled_cst");?>
                        <?= form_error('cst');?>
                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty',round_this($sales_order['qty']))); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id',$sales_order['unit_id']),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate',round_this($sales_order['rate']))); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount decimal'),set_value('amount',round_this($sales_order['amount']))); ?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per',round_this($sales_order['discount_per']))); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt',round_this($sales_order['discount_amt']))); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
        </div>
        <?php $rate = $this->stock->get_item_rate($sales_order['item_id']); ?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-2 float-left">
                    <?=$this->lang->line('rate');?> :
                    <label type="text" class="rate-per text-right"><?= numberFormat(round_this($rate)); ?></label>
                    <?php
                    $itemPrimaryUnits = $this->stock->get_primary_unit($sales_order['item_id']);
                    if(!empty($itemPrimaryUnits)){?><label id="primary-unit"> / <?= $itemPrimaryUnits['symbol']; ?></label><?php } ?>
                </div>

                <div class="col-md-2 pull-right">
                    <?php $disabled_vat = "";if($sales_order['cst'] != 0){$disabled_vat = "readonly";}?>
                    <label><?=$this->lang->line('vat');?> <?=$this->lang->line('amt');?></label>
                    <?=form_input('vat_amt',set_value('vat_amt',round_this($sales_order['vat_amt'])),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                    <?= form_error('vat_amt');?>
                </div>
                <?php $vat_percent = $this->stock->get_item_vat($sales_order['item_id']);?>
                <div class="col-md-2 pull-right">
                    <label><?=$this->lang->line('vat');?> %</label>
                    <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent))); ?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="text-right">
                <?=form_button(array('type' => 'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('update')));?>
            </div>
        </div>
	</div>
</div>
<?= form_close(); ?>