<style>
*{	font-size:10px;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center; font-size:12px;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:700;}
.data-list td{	font-size:8px;}
.disabled{background-color:#E2E2E1;}
.italic{ font-style:italic;}
.has-border{ border:1px solid #666;}
.has-border-left{border-left:1px solid #666;}
.data-list tr td{  border-right:1px solid #666;}
.data-list tr th{border:1px solid #666;}
.declaration{font-size:8px;}
.g-total{ font-size:11px !important;}
.terms-conditions{font-size:8px;font-family: ss;}
</style>
<?php
$bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']);
$custTypeID = $sales_array[0]['customer_type_id'];
$customerID = $sales_array[0]['customer_id'];
$customerType = $this->dms->get_desig($custTypeID,1);
$customerDetails = $this->stock->get_customer($custTypeID,$customerID,1);
$customer_name = $customerDetails['name'];
$customer_address = $customerDetails['address'].' ';
$customer_mobile = (!empty($customerDetails['mobile_no']))?'Mob : '.$customerDetails['mobile_no'].' ':'';
$customer_phone = (!empty($customerDetails['phone_no']))?'Ph : '.$customerDetails['phone_no'].' ':'';
$customer_email = (!empty($customerDetails['email_id']))?'Email : '.$customerDetails['email_id'].' ':'';
$tin = NULL;
if(isset($customerDetails['tin']))
{
	$tin = 'Tin :'.$customerDetails['tin'];
}
?>
<div class="pdf-head">SALES RETURN</div>
<table  class="data-table" border="0">
    <tr>
        <td class="text-left">
            <span class="text-bold">Invoice. No. : </span><?= $bill_prefix.' '.$sales_array[0]['bill_no'];?><br>
            <span class="small">Ref. No. <?= $sales_array[0]['group_id']; ?></span>
        </td>
        <td class="text-right"><span class="text-bold">Invoice. Date : </span><?=dateFormat($sales_array[0]['bill_date']);?></td>
    </tr>
</table>
<div></div>
<table  class="data-table" border="0">
    <tr><td>To ,</td></tr>
    <tr><td class="vendor text-bold"><?= $customer_name; ?></td></tr>
    <tr><td class="vendor"><?= $customer_address; ?><?= $customer_email; ?></td></tr>
    <tr><td class="vendor"><?= $customer_phone; ?><?= $customer_mobile; ?><?= $tin; ?></td></tr>
</table>
<div></div>
<table class="table data-table data-list" border="0">
    <thead>
    <tr>
        <th width="4%">#</th>
        <th width="30%">Item</th>
        <th width="6%">Qty.</th>
        <th width="10%">Rate</th>
        <th width="10%">Discount</th>
        <th width="10%">Taxable</th>
        <th width="10%">VAT Amt.</th>
        <th width="10%">CESS Amt.</th>
        <th width="10%">Total</th>
    </tr>
    </thead>
<?php
    $i=0; $colspan=2; $totalDiscountAmt=0; $totalTaxable=0; $totalVatAmt=0; $totalCessAmt=0; $totalNetAmount=0;
	$cess = $sales_array[0]['cess'];
    foreach($sales_array as $key => $item)
    {
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $netValue = $item['amount'];
        $discount = $item['discount_amt'];
        
        $taxable=0; $vatAmt=0; $cessAmt=0;
        $taxable = $item['taxable_amt'];
        $vat = $item['vat'];
        $vatAmt = $item['vat_amt'];
        $cessAmt = $item['cess_amt'];
                			
        $netAmount = $taxable+$vatAmt+$cessAmt;
                			
        $totalNetValue += $netValue;
        $totalDiscount += $discount;
        $totalTaxable += $taxable;
        $totalVatAmt += $vatAmt;
        $totalCessAmt += $cessAmt;
        $totalNetAmount += $netAmount;
?>
        <tr>
            <td width="4%" class="text-center has-border-left"><?= $i; ?></td>
            <td width="30%"><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
            <td width="6%" class="text-right"><?= $qty; ?></td>
            <td width="10%" class="text-right"><?= numberFormat($rate); ?></td>
            <td width="10%" class="text-right"><?= numberFormat($discount); ?></td>
            <td width="10%" class="text-right"><?= numberFormat($taxable); ?></td>
            <td width="10%" class="text-right"><?= numberFormat($vatAmt); ?></td>
            <td width="10%" class="text-right"><?= numberFormat($cessAmt); ?></td>
            <td width="10%" class="text-right"><?= numberFormat($netAmount); ?></td>
        </tr>
<?php
    }
    $grandNetAmount = round_this($totalNetAmount);
?>
	<tr>
        <td class="text-right text-bold has-border disabled" colspan="4">Total</td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat($totalDiscount); ?></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat($totalTaxable); ?></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat($totalVatAmt); ?></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat($totalCessAmt); ?></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat($totalNetAmount); ?></td>
    </tr>
    <tr>
        <td colspan="<?=(10-$colspan);?>" class="text-right">Freight</td>
        <td class="text-right has-border"><?=numberFormat(round_this($sales_array[0]['bill_freight']));?></td>
    </tr>
    <tr>
        <td colspan="<?=(10-$colspan);?>" class="text-right">Other expense</td>
        <td class="text-right has-border"><?=numberFormat(round_this($sales_array[0]['other_expense']));?></td>
    </tr>
<?php
	$grandNetAmount += (($sales_array[0]['bill_freight']+$sales_array[0]['other_expense']));
?>
    <?php if(show_round_off()){ ?>
        <tr>
            <td class="text-right" colspan="<?=(10-$colspan);?>">Round Off</td>
            <td class="text-right has-border"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
        </tr>
    <?php } ?>
    <tr>
        <td class="text-right text-bold g-total" colspan="<?=(10-$colspan);?>">Net Amount (<?= get_currency();?>)</td>
        <td class="text-right text-bold has-border g-total"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    </tr>
</table>
<div class="text-left italic"><?= $this->to_words->num_to_words(get_rounded($grandNetAmount)); ?></div>
<div><span class="text-bold">Payment mode : </span><?= strtoupper($payment_mode); ?></div>
<div><span class="">Narration : </span><?= $sales_array[0]['narration']; ?></div>