<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-cart-checkout"> </i><?= $this->lang->line('stock-transfer'); ?> </h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('transfer-id');?></label>
                    <?= form_input(array('name'=>'transfer_no','class'=>'form-control text-right number'),set_value('transfer_no',$transfer_Id)); ?>
                    <?= form_error('transfer_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('date');?></label>
                    <?= form_input(array('name'=>'transfer_date','class'=>'datepicker form-control transfer_date'),set_value('transfer_date',$t_date)); ?>
                    <?= form_error('transfer_date');?>
                </div>
            </div>
        </div>
   
        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class=" form-control item_name select-full"'); ?>
                    <?= form_error('item_id');?>        
                </div>
               <!-- <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_from_id',$godown_from,set_value('godown_from_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_from_id');?>
                </div>-->
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty discount_per decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>        
                </div>         
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit discount_per"'); ?>
                    <?= form_error('unit_id');?>        
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('sales');?> <?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'sale_rate','class'=>'form-control text-right sale-rate decimal'),set_value('sale_rate')); ?>
                    <?= form_error('sale_rate');?>        
                </div>  
            </div>
        </div>
        
           <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>

        <div class="form-group">
            <div class='row'> 
                <div class='col-md-12'> 
                    <?=form_submit(array('name'=>'add_stock','class'=>'btn btn-primary pull-right','value'=>$this->lang->line('add')));?>    
                </div>  
            </div>  
        </div>
<?php 
        if(!empty($temp_stock_items))
        { 
?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <div class='table-responsive'>
                            <table class="table table-bordered table-striped">
                                <thead>
                                <tr class="bg-success">
                                    <th>#</th>
                                    <th><?= $this->lang->line('item-name'); ?></th>
                                    <th><?= $this->lang->line('godown'); ?></th>
                                    <th><?= $this->lang->line('quantity'); ?></th>
                                    <th><?= $this->lang->line('unit'); ?></th>
                                    <th class="text-center"><?= $this->lang->line('edit'); ?></th>
                                    <th class="text-center"><?= $this->lang->line('delete'); ?></th>
                                </tr>       
                                </thead>
<?php 
                                $i=0;
                                foreach($temp_stock_items as $key=>$temp)
                                {
                                    $i++;
?>
                                    <tr>
                                        <td><?= $i; ?></td>
                                        <td><?= $temp['item_code']; ?> / <?= $temp['item_name']; ?>/ <?= $temp['model_no']; ?></td>
                                        <td><?= $temp['godown_code'] .'/'.$temp['godown_name']; ?></td>
                                        <td><?= $temp['qty']; ?></td>
                                        <td><?= $temp['symbol']; ?></td>
                                        <?php $uri_array = $this->uri->uri_to_assoc(1)?>
                                        <td class="text-center"><a href="<?= base_url('stock_transfer/edit_temp_item/'.$temp['id'].'/'.$this->uri->assoc_to_uri($uri_array)); ?>" title="<?= $this->lang->line('update'); ?>" class="text-primary"><i class="glyphicon glyphicon-pencil"></i></a></td>
                                        <td class="text-center"><a href="<?= base_url('stock_transfer/remove_temp_item/'.$temp['id'].'/'.$this->uri->assoc_to_uri($uri_array)); ?>" title="<?= $this->lang->line('remove'); ?>" class="text-danger"><i class="glyphicon glyphicon-remove delete"></i></a></td>
                                    </tr>
<?php
                                }
?>
                            </table>
                        </div>
                    </div>
                </div>
            </div> 

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label class="required"><?=$this->lang->line('transfer-to');?></label>
                        <?= form_dropdown('godown_to_id',$godown_to,set_value('godown_to_id'),'class="select2-container select-full"'); ?>
                        <?= form_error('godown_to_id');?>
                    </div>
                    <div class="col-md-4">
                        <label><?=$this->lang->line('freight');?></label>
                        <?=form_input(array('name'=>'freight','class'=>'form-control'),set_value('freight'));?>
                        <?=form_error('freight');?>
                    </div>
                    <div class="col-md-4">
                        <label><?=$this->lang->line('other-expense');?></label>
                        <?=form_input(array('name'=>'other_expense','class'=>'form-control'),set_value('other_expense'));?>
                        <?=form_error('other_expense');?>
                    </div>
                </div>    
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label><?=$this->lang->line('narration');?></label>
                        <?= form_textarea(array('name'=>'narration','rows'=>3,'class'=>'form-control'),set_value('narration')); ?>
                        <?= form_error('narration');?>
                    </div>
                </div>    
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                    	<?=form_submit(array('name'=>'save_stock','class'=>'btn btn-primary pull-right','value'=>$this->lang->line('save')));?>
                    </div>
                </div>    
            </div>
<?php 
        } 
?>
    </div>
</div>
<?= form_close(); ?>