<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-cart-checkout"> <?= $this->lang->line('stock-transfer').' '.$this->lang->line('view'); ?> </i></h6>
</div>
<div class="panel-body">

<div class="form-group">
<div class="row">

    <div class="col-md-6">
        <label><?=$this->lang->line('transfer-id');?></label>
        <?= form_input(array('name'=>'transfer_no','class'=>'form-control text-right number','disabled'=>'disabled'),set_value('transfer_no',$stock_transfer['transfer_no'])); ?>
    </div>
    <div class="col-md-6">
        <label><?=$this->lang->line('date');?></label>
        <?= form_input(array('name'=>'transfer_date','class'=>'form-control datepicker','disabled'=>'disabled'),set_value('transfer_date',dateFormat($stock_transfer['transfer_date']))); ?>
    </div>
</div>
</div>  

<div class="form-group">
<div class="row">
<div class="col-md-12">
    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name'); ?></th>
    <th><?= $this->lang->line('godown'); ?></th>
    <th><?= $this->lang->line('quantity'); ?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    </tr>       
    </thead>
    <?php $i=0;
    foreach($stock_transfer_items as $key=>$stock){$i++;
        ?>
        <tr>
        <td><?= $i; ?></td>
        <td><?= $stock['item_code']; ?> / <?= $stock['item_name']; ?> / <?= $stock['model_no']; ?></td>
        <td><?= $stock['godown_code'] .'/'.$stock['godown_name']; ?></td>
        <td><?= $stock['qty']; ?></td>
        <td><?= $stock['symbol']; ?></td>
        </tr>
        <?php
    }?>
    </table>
    </div>

</div>
</div>
</div> 
<div class="form-group">
    
    <div class="row">

       <div class="col-md-4">
            <label class="required"><?=$this->lang->line('transfer-to');?></label>
            <?= form_input(array('name'=>'godown_to_id','class'=>'form-control','disabled'=>'disabled'),set_value('godown_to_id',$stock_transfer['godown_code'].'/'.$stock_transfer['godown_name']."[".$stock_transfer['branch_name']."]")); ?>
            <?= form_error('godown_to_id');?>
        </div>
        <div class="col-md-4">

              <label><?=$this->lang->line('freight');?></label>
              <?=form_input(array('name'=>'freight','class'=>'form-control','disabled'=>'disabled'),set_value('freight',$stock_transfer['freight']));?>
              <?=form_error('freight');?>
        </div>
        <div class="col-md-4">

              <label><?=$this->lang->line('other-expense');?></label>
              <?=form_input(array('name'=>'other_expense','class'=>'form-control','disabled'=>'disabled'),set_value('other_expense',$stock_transfer['other_expense']));?>
              <?=form_error('other_expense');?>
        </div>

    
    </div>    
</div>
<div class="form-group">

    <div class="row">
        <div class="col-md-12">
            <label><?=$this->lang->line('narration');?></label>
            <?= form_textarea(array('name'=>'narration','rows'=>3,'class'=>'form-control','disabled'=>'disabled'),set_value('narration',$stock_transfer['narration'])); ?>
            <?= form_error('narration');?>
        </div>
    </div>    
</div>
<div class="row">
    <div class="col-md-6 pull-left text-bold"><?=$this->lang->line('created-by')." : ".get_username($stock_transfer['created_by']);?></div>
    <div class="col-md-6 text-right text-bold"><?=$this->lang->line('created-on')." : ".dateTimeFormat($stock_transfer['created_on']);?></div>
</div>
<?php if($stock_transfer['st_status']==1):?>
<div class="row">
    <div class="col-md-6 pull-left text-bold"><?=$this->lang->line('approved-by')." : ".get_username($stock_transfer['approved_by']);?></div>
    <div class="col-md-6 text-right text-bold"><?=$this->lang->line('approved-on')." : ".dateTimeFormat($stock_transfer['approved_on']);?></div>
</div>
<?php endif;?>
</div>
</div>
</div>


