<?= form_open(); ?>

<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('achievement-settings'); ?> </h6>
</div>
<div class="panel-body">

<div class="form-group">
    <div class="row">
        <div class="col-md-4">
            <label class="required"><?=$this->lang->line('code');?></label>
            <?= form_input(array('name'=>'ach_code','class'=>'form-control'),set_value('ach_code')); ?>
            <?= form_error('ach_code');?>
        </div>

        <div class="col-md-4">
            <label class="required"><?=$this->lang->line('point');?></label>
            <?= form_input(array('name'=>'point','class'=>'form-control'),set_value('point')); ?>
            <?= form_error('point');?>
        </div>
        
        <div class="col-md-4">
            <label class=""><?=$this->lang->line('achievement-name');?></label>
            <?= form_input(array('name'=>'ach_name','class'=>'form-control'),set_value('ach_name')); ?>
            <?= form_error('ach_name');?>
        </div>
    </div>
</div>

<div class="form-group">
    <div class="row">
        <div class="col-md-6">
            <label class="required"><?=$this->lang->line('gift');?></label>
            <?= form_input(array('name'=>'gift_name','class'=>'form-control'),set_value('gift_name')); ?>
            <?= form_error('gift_name');?>
        </div>

        <div class="col-md-6">
            <label><?=$this->lang->line('description');?></label>
            <?= form_textarea(array('name'=>'description','class'=>'form-control','rows'=>2),set_value('description')); ?>
            <?= form_error('description');?>
        </div>
    </div>
</div>

<div class="form-group">
    <div class="row">
        <div class="col-md-12">
        	<?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right','content'=>$this->lang->line('save')));?>
        </div>
    </div>    
</div>


<?= form_close(); ?>

<?php if(!empty($achievements)){ ?>
<div class="row">
    <div class="col-md-12">
        <?= export_to_word('word/target_achievements_word/target_achievements/'); ?>
    </div>
    </div>
<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
        <table class="table table-bordered table-striped">
        <thead>
        <tr class="bg-success">
        <th>#</th>
        <th><?= $this->lang->line('code'); ?></th>
        <th><?= $this->lang->line('achievement-name'); ?></th>
        <th><?= $this->lang->line('point'); ?></th>
        <th><?= $this->lang->line('gift'); ?></th>
        <th><?= $this->lang->line('description'); ?></th>
        <th><?= $this->lang->line('delete'); ?></th>
        </tr>       
        </thead>
        
        <?php
		$i=0;
		foreach($achievements as $key=>$achievement){$i++;
			?>
            <tr>
            <td><?= $i; ?></td>
            <td><?= $achievement['ach_code']; ?></td>
            <td><?= $achievement['ach_name']; ?></td>
            <td><?= $achievement['point']; ?></td>
            <td><?= $achievement['gift_name']; ?></td>
            <td><?= $achievement['description']; ?></td>
             <?= app_table_links($achievement['id'],array(328)); ?>
            </tr>
            <?php
		}?>
        </table>
        </div>
	</div>
</div>
<?php } ?>

</div>
</div>
