<?=form_open();?>
<div class="form-group">
	<div class="row">
		<?php if($branch_status)
		{
			?>
			<div class="col-md-4">
				<label class="required"><?= $this->lang->line('branch');?></label>
				<?=form_dropdown('branch_id',$branch_array,set_value('branch_id',$branch_id),'class="form-control"');?>
				<?=form_error('branch_id');?>
			</div>
			<?php
		}
		?>
		<div class="col-md-2">
			<label class="required"><?= $this->lang->line('year');?></label>
			<?=form_dropdown('year',$years,set_value('year',$year),'class="select2-container select-full"');?>
			<?=form_error('year');?>
		</div>			
		<div class="col-md-6">
			<label class="required"><?= $this->lang->line('month');?></label>
			<div class="row">
				<div class="col-md-8">
					<?=form_dropdown('month',$months,set_value('month',$month),'class="form-control"');?>
					<?=form_error('month');?>
				</div>
				<div class="col-md-4">
					<?=form_submit(array('name'=>'btn_search','value'=>$this->lang->line('search'),'class'=>'btn btn-info btn-loading'));?>	
				</div>
			</div>
		</div>
	</div>
</div>
<?=form_close();?>
<?php
if(!empty($user_array))
{
	?>
	<div class="form-group">
		<div class="row">
			<div class="col-md-12">
			    <?= export_to_word('word/attendance_word/attendance/'.$branch_id.'/'.$year.'/'.$month); ?>
			    <div class="table-responsive block vr-mincroll">
					<table class="table table-striped table-condensed table-bordered tbl-brdr">
						<tr class="bg-success">
						<th class="text-center">#</th>
						<th><?=$this->lang->line('employee');?></th>
						<th><?=$this->lang->line('designation');?></th>
						<th class="text-center"><?=$this->lang->line('total-marked');?></th>
						<th class="text-center"><?=$this->lang->line('leaves-taken');?></th>
						<th class="text-center"><?=$this->lang->line('total-present');?></th>	
						<th class="text-center">%</th>
						</tr>
						<?php $i = 0;foreach($user_array as $ukey => $uvalue)
						{
							?>
							<tr>
								<td class="text-center"><?= ++$i;?></td>
								<td><?= $uvalue['sname'];?></td>
								<td><?= $uvalue['desig'];?></td>
								<td class="text-center"><?= $uvalue['marked'];?></td>
								<td class="text-center"><?= $uvalue['absent'];?></td>
								<td class="text-center"><?= $uvalue['present'];?></td>
								<?php $percent = 0;if($uvalue['marked'] > 0){$percent = ($uvalue['present']/$uvalue['marked']);}?>
								<td class="text-center text-bold"><a href="#" title="Click for Details" data-toggle="modal" data-target="#form_modal" class="show-attended" data-id="<?=$ukey;?>" yr-id="<?=$year;?>" mon-id="<?=$month;?>"><?= numberFormat($percent)." %";?></a></td>
							</tr>
							<?php
						}
						?>
					</table>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>