<div class="panel panel-primary">
<div class="panel-heading"><h6 class="panel-title"><i class="icon-clipboard"></i><?=$this->lang->line('add-voucher');?></h6></div>
<div class="panel-body">
<?php
if($hav_access)
{
	?>
	<div class="row">
		<div class="col-md-12">
	    	<?=anchor("ledgers/add/vouchers/add/v-type/$vtype",'<i class="icon-plus-circle2"></i>',array('title' => 'Add New Ledger','class' => 'export-menu'));?>
	    </div>
	</div>
	<?php
}
?>
<?=form_open();?>
<div class="form-group">
	<div class="row">

        <div class="col-md-4">
		<label class="required"><?=$this->lang->line('voucher-types');?></label>
		<?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control voucher-type' $disabled");?>
		<?=form_error('vtype_id');?>
		</div>

        <div class="col-md-4">
		<label class="required"><?=$this->lang->line('date');?></label>
		<?php
		if($previous_status == '1')
		{
		?>
        <?=form_input('vdate',set_value('vdate',cdateFormat($voucher_date)),"class='datepicker form-control' id='date-ajax' $disabled");?>
		<?=form_error('vdate');?>
		<?php
		}
		else
		{
		?>
		<?=form_input('vdate',set_value('vdate',cdateFormat($voucher_date)),"class='form-control' id='date-ajax' $disabled readonly");?>
		<?=form_error('vdate');?>
		<?php
		}
		?>
		</div>

		<div class="col-md-4">
		<label class="required"><?=$this->lang->line('voucher-no');?></label>
        <?=form_input('vno',set_value('vno',$voucher_no),"class='form-control text-right' onKeyPress='return isNumberKeys(event)' id='vno-ajax' $disabled");?>
		<?=form_error('vno');?>
		</div>
	</div>
</div>
<div class="form-group">
	<div class="row">
        <div class="col-md-4">
		<label class="required"><?=$this->lang->line('debit');?></label>
		<?=form_dropdown("dr_ledger",$dr_ledgers,set_value("dr_ledger"),"class='select2-container select-full'");?>
		<?=form_error('dr_ledger');?>
		</div>

        <div class="col-md-4">
		<label class="required"><?=$this->lang->line('credit');?></label>
		<?=form_dropdown("cr_ledger",$cr_ledgers,set_value("cr_ledger"),"class='select2-container select-full'");?>
		<?=form_error('cr_ledger');?>
		</div>

        <div class="col-md-4">
		<label class="required"><?=$this->lang->line('amount');?></label>
		<?=form_input(array('name'=>'vamount','class'=>'form-control text-right','onKeyPress' => 'return isNumberKey(event)'),set_value('vamount'));?>
		<?=form_error('vamount');?>
		</div>
	</div>
</div>
<div class="form-group">
    <div class="row">
        <div class="col-md-4">
		    <label><?=$this->lang->line('particulars');?></label>
		    <?=form_dropdown("particulars",$users,set_value("particulars"),"class='select2-container select-full'");?>
		    <?=form_error('particulars');?>
		</div>
        <div class="col-md-8">
            <label><?=$this->lang->line('narration');?></label>
            <?=form_textarea(array('name'=>'narration','class'=>'form-control','cols' => 3,'rows' => 2),set_value('narration'));?>
            <?=form_error('narration');?>
        </div>
    </div>
</div>

<div class="form-group">
    <div class="row">
        <div class="col-md-12">
        	<?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add')));?>
        </div>
    </div>
</div>
<?=form_close();?>

<?php
if(count($voucher_temp_data) > 0)
{
	$i = 0;
	?>
	<div class="row block">
	<div class="col-md-12">
	<div class="table-responsive">
	<table class="table table-striped table-condesed table-bordered">
	<tr class="bg-success">
	<th>#</th>
	<th><?=$this->lang->line('voucher-types');?></th>
	<th><?=$this->lang->line('voucher-no');?></th>
	<th><?=$this->lang->line('date');?></th>
	<th><?=$this->lang->line('debit');?></th>
	<th><?=$this->lang->line('credit');?></th>
	<th><?=$this->lang->line('amount');?></th>
	<th><?=$this->lang->line('particulars');?></th>
	<th><?=$this->lang->line('narration');?></th>
    <th><?=$this->lang->line('edit');?></th>
    <th><?=$this->lang->line('delete');?></th>
	</tr>
	<?php foreach($voucher_temp_data as $key => $value):?>
	<tr>
		<td class="text-center"><?=++$i;?></td>
		<td class="text-center"><?=$this->vouchers->voucher_name($value['vtype_id']);?></td>
		<td class="text-center"><?=$value['vno'];?></td>
		<td class="text-center"><?=dateFormat($value['vdate']);?></td>
		<td class="text-center"><?=$this->accounts->get_ledger_name($value['dr_ledger']);?></td>
        <td class="text-center"><?=$this->accounts->get_ledger_name($value['cr_ledger']);?></td>
        <td class="text-right"><?=$value['vamount'];?></td>
        <td class="text-center"><?=get_username($value['particulars']);?></td>
        <td ><?=$value['narration'];?></td>
		<?php app_table_links($value['id'],$action_array);?>
	</tr>
	<?php endforeach;?>
	</table>
	</div>
	</div>
	</div>

    <?=form_open();?>
    <?php
	if($vtype != 4)
	{
		?>
		<h6 class="heading-hr"><i class="icon-certificate"></i><?=$this->lang->line('cheque-dd-details');?></h6>
		<div class="form-group">
			<div class="row">
				<div class="col-md-4">
					<label><?=$this->lang->line('transaction-type');?></label>
					<?php $transaction_types = $this->dms->transaction_types();?>
		            <?= form_dropdown('ccd',$transaction_types,set_value('ccd'),'class="form-control"'); ?>
		            <?=form_error('ccd');?>
				</div>

				<div class="col-md-4">
					<label><?=$this->lang->line('cd-no');?></label>
					<?=form_input('cd_no',set_value('cd_no'),"class='form-control'");?>
					<?=form_error('cd_no');?>
				</div>

				<div class="col-md-4">
				<label><?=$this->lang->line('cheque-date');?></label>
				<?=form_input('cheque_date',set_value('cheque_date',cdateFormat($voucher_date)),"class='datepicker form-control'");?>
				<?=form_error('cheque_date');?>
				</div>
			</div>
		</div>
		<?php
	}
	?>

   <!-- <div class="form-group">
        <div class="row">
            <div class="col-md-12">
            <label><?=$this->lang->line('narration');?></label>
            <?=form_textarea(array('name'=>'narration','class'=>'form-control','cols' => 3,'rows' => 1),set_value('narration'));?>
            <?=form_error('narration');?>
            </div>
        </div>
    </div> -->
    <input type="hidden" name="vt" value="<?=$vtype;?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <?=form_submit(array('name' => 'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('save')));?>
            </div>
        </div>
    </div>
    <?=form_close();?>
    <?php
}
?>
</div>
</div>