<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MailSending extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('lead/lead_model','lead');
        $this->load->model('mail/mail_model','mail');
        $this->load->library('email_lib');
    }

    public function index(){
        $pending_emails = $this->mail->get_pending_emails();
        
        foreach($pending_emails as $email){
            $attachments = array();
            $files = array_filter(explode('@@', $email->attachment));
            foreach($files as $file){
                $attachments[] = $_SERVER["DOCUMENT_ROOT"].'/assets/files/mail/'.$file;
            }
            if(filter_var($email->recipient,FILTER_VALIDATE_EMAIL)){
                if($this->email_lib->sendEmail(array($email->recipient), array(), $email->subject, $email->message, $attachments)){
                    $this->mail->mark_as_sent($email->id);
                }else{
                    $this->mail->mark_as_fail($email->id);
                }
            }else{
                $this->mail->mark_as_fail($email->id);
            }
        }
    }
    
    public function report(){
        
        $ltypes = $this->lead->ltype_list();
        
        $this->template->title('Mail Sending');
        $this->template->main_heading('Mail Sending');
        $this->template->slice('cms/message');
        $this->template->slice('mail/sending',array('ltypes'=>$ltypes));
        $this->template->render();
    }
    
    public function report_ajax(){
        $list = $this->mail->get_emails();
        $data = array();
        $no = $this->input->post('start');
        foreach($list as $email){
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $email->recipient;
            $row[] = $email->ltype_name;
            $row[] = $email->cname;
            $row[] = $email->location;
            $row[] = $email->subject;
            $row[] = $email->fname;
            $row[] = date('d/m/Y h:i A',strtotime($email->created_on));
            
            $eclass=$estatus="";
            if($email->status=='pending'){ $eclass="badge-info"; $estatus="Pending"; }
            else if($email->status=='sent'){ $eclass="badge-success"; $estatus="Sent"; }
            else if($email->status=='failed'){ $eclass="badge-danger"; $estatus="Failed"; }
            $row[] = '<span class="badge '.$eclass.'">'.$estatus.'</span>';
           
            $data[] = $row;
        }
 
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->mail->count_emails_all(),
            "recordsFiltered" => $this->mail->count_emails_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }
    
    public function ltype_report(){
        
        $ltypes = $this->lead->ltype_list();
        
        $this->template->title('Mail Sending');
        $this->template->main_heading('Mail Sending');
        $this->template->slice('cms/message');
        $this->template->slice('mail/ltype_report',array('ltypes'=>$ltypes));
        $this->template->render();
    }
    
    public function ltype_report_ajax(){
        $list = $this->mail->get_ltype_emails();
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $email){
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $email->ltype_name;
            $row[] = $email->subject;
            $row[] = $email->fname;
            $row[] = date('d/m/Y',strtotime($email->date));
            
            $eclass=$estatus="";
            if($email->status=='pending'){ $eclass="badge-info"; $estatus="Pending"; }
            else if($email->status=='sent'){ $eclass="badge-success"; $estatus="Sent"; }
            else if($email->status=='failed'){ $eclass="badge-danger"; $estatus="Failed"; }
            $row[] = '<span class="badge '.$eclass.'">'.$estatus.'</span>';
           
            $data[] = $row;
        }
 
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->mail->count_ltype_emails_all(),
            "recordsFiltered" => $this->mail->count_ltype_emails_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }
}
