<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ajax extends MY_Controller{
    
    public function __construct()
    {
		parent :: __construct();
		
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
	}
	
	public function work_details()
	{
        $work_id = $this->input->get('wid');
	    
	    $this->load->model('work/work_model','work');
	    $this->load->library(array('work_lib'));
	    
	    $work_det = $this->work_lib->work_details($work_id);
        $work_updates = $this->work_lib->work_updates($work_id);
		
		$this->load->view('work/work_details',array('work_det'=>$work_det,'work_updates'=>$work_updates));
	}
	
	public function mail_details(){
	    
        $rid = $this->input->get('rid');
        $mail_det = $this->db->select(array('c.name','m.*'))->from('client_mail as m')->join('client_master as c','m.client_id=c.id')->where('m.id',$rid)->row_array();
        
        $this->load->view('client/mail_details',array('mail_det'=>$mail_det));
	}
	
	public function remark_details()
	{
        $work_id = $this->input->get('wid');
	    
	    $this->load->model('work/work_model','work');
	    $this->load->library(array('work_lib'));
	    
		$this->load->view('work/remark_details',array('work_id'=>$work_id));
	}
	
	public function completed_work_details()
	{
	   $work_id = $this->input->get('wid'); 
	   $this->load->model('work/work_model','work');
	   $this->load->library(array('work_lib'));
	    
	   $work_det = $this->work_lib->work_details($work_id);
       $work_updates = $this->work_lib->work_updates($work_id);
		
	   $this->load->view('work/work_details',array('work_det'=>$work_det,'work_updates'=>$work_updates));
	}
	
	public function get_ltype()
	{ 
	    $ltypes=array();
		
		$this->load->model('lead/lead_model','lead'); 
		$ltypes = $this->lead->ltype_list();
  
        echo json_encode($ltypes);
	}
	
	public function start_break()
	{
	    $uid = $this->session->userdata('uid');
	    $cur_date = date('Y-m-d');
	    $cur_time = date('H:i:00');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
	    $this->load->model('work/work_model','work');
	    
	    $insid = $this->work->f_save('other_details',array('cdate'=>$cur_date,'staff'=>$uid,'wtype'=>5,'stime'=>$cur_time));
	    if($insid)
	    {
	        $insid2 = $this->work->f_save('work_status',array('type'=>5,'work_id'=>$insid,'staff_id'=>$uid,'udate'=>$cur_date,'sstatus'=>1,'stime'=>$cur_date_time,'status'=>1));
	    
	        $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'udate'=>$cur_date,'staff_id'=>$uid,'id !='=>$insid2,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row))
            {
                if($row['type']=='1')
                {
                    $this->db->update("work_status",array('estatus'=>-1,'etime'=>$cur_date_time),array('id'=>$row['id']));
                }
                else
                {
                    $this->db->update("work_status",array('estatus'=>5,'etime'=>$cur_date_time),array('id'=>$row['id']));
                }
            }
	    }
	}
	
	public function end_break()
	{
	    $uid = $this->session->userdata('uid');
	    $cur_date = date('Y-m-d');
	    $cur_time = date('H:i:00');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
	    $this->load->model('work/work_model','work');
	    
	    if($this->db->update('other_details',array('etime'=>$cur_time),array('cdate'=>$cur_date,'staff'=>$uid,'wtype'=>5)))
	    {
	        $this->db->update('work_status',array('estatus'=>5,'etime'=>$cur_date_time),array('type'=>5,'staff_id'=>$uid,'udate'=>$cur_date,'estatus'=>0,'status'=>1));
	    
	        $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>-1,'udate'=>$cur_date,'staff_id'=>$uid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row))
            {
                $this->db->update('work_status',array('estatus'=>2),array('id'=>$row['id']));
                
                $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$cur_date,'sstatus'=>3,'stime'=>$cur_date_time,'status'=>1);
                $this->work->f_save('work_status',$data);
            }
	    }
	}
	
	public function end_call()
	{
	    $uid = $this->session->userdata('uid');
	    $cur_date = date('Y-m-d');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
	    $this->load->model('work/work_model','work');
	    
	    if($this->db->update('call_details',array('etime'=>$cur_date_time),array('cdate'=>$cur_date,'staff'=>$uid,'etime'=>'0000-00-00 00:00:00')))
	    {
	        $this->db->update('work_status',array('estatus'=>5,'etime'=>$cur_date_time),array('type'=>2,'staff_id'=>$uid,'udate'=>$cur_date,'status'=>1,'estatus'=>0));
	        
	        $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>-1,'udate'=>$cur_date,'staff_id'=>$uid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row))
            {
                $this->db->update('work_status',array('estatus'=>2),array('id'=>$row['id']));
                
                $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$cur_date,'sstatus'=>3,'stime'=>$cur_date_time,'status'=>1);
                $this->work->f_save('work_status',$data);
            }
	    }
	}
	
	public function end_discuss()
	{
	    $uid = $this->session->userdata('uid');
	    $cur_date = date('Y-m-d');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
	    $this->load->model('work/work_model','work');
	    
	    if($this->db->update('discussion_details',array('etime'=>$cur_date_time),array('cdate'=>$cur_date,'staff'=>$uid,'etime'=>'0000-00-00 00:00:00')))
	    {
	        $this->db->update('work_status',array('estatus'=>5,'etime'=>$cur_date_time),array('type'=>3,'staff_id'=>$uid,'udate'=>$cur_date,'status'=>1,'estatus'=>0));
	        
	        $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>-1,'udate'=>$cur_date,'staff_id'=>$uid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row))
            {
                $this->db->update('work_status',array('estatus'=>2),array('id'=>$row['id']));
                
                $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$cur_date,'sstatus'=>3,'stime'=>$cur_date_time,'status'=>1);
                $this->work->f_save('work_status',$data);
            }
	    }
	}
	
	public function end_other()
	{
	    $uid = $this->session->userdata('uid');
	    $cur_date = date('Y-m-d');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
	    $this->load->model('work/work_model','work');
	    
	    if($this->db->update('other_details',array('etime'=>$cur_date_time),array('cdate'=>$cur_date,'staff'=>$uid,'etime'=>'0000-00-00 00:00:00')))
	    {
	        $row1 = $this->db->select(array('id'))->from('work_status')->where(array('staff_id'=>$uid,'udate'=>$cur_date,'status'=>1,'estatus'=>0))->where_not_in('type',array(1,2,3,5))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row1))
            {	        
	            $this->db->update('work_status',array('estatus'=>5,'etime'=>$cur_date_time),array('id'=>$row1['id']));
            }
            
	        $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>-1,'udate'=>$cur_date,'staff_id'=>$uid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row))
            {
                $this->db->update('work_status',array('estatus'=>2),array('id'=>$row['id']));
                
                $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$cur_date,'sstatus'=>3,'stime'=>$cur_date_time,'status'=>1);
                $this->work->f_save('work_status',$data);
            }
	    }
	}
	
	public function product_rows()
	{
	    $this->load->model('product/product_model','product');
	    
	    $products = $this->product->get_all(array());
        $ptypes = $this->product->payment_types();
        
        $this->load->view('estimate/new_row',array('products'=>$products,'ptypes'=>$ptypes));
	}
	
	public function get_products()
	{
	    $product_list = array();
	    $this->load->model('product/product_model','product');
	    $ptype = $_POST['ptype'];
	    
	    $products = $this->product->get_all(array('conditions'=>array('ptype'=>$ptype)));
        foreach($products as $product)
        {
            $product_list[$product['id']] = $product['name'];
        }
        
        echo json_encode($product_list);
	}
	
	public function expiry()
	{
	    $this->load->model('general/general_model','general');
	    $this->load->model('client/client_model','client');
	    $this->load->model('product/product_model','product');
	    
	    $cur_date = date('Y-m-d');
	    $nxt_date = date('Y-m-d',strtotime("+10 days"));
	    
	    $expiring = $expired = array();
	    if($this->utype=='2' || $this->utype=='7')
	    {
	        $args['conditions']['expiry_date >='] = $cur_date;
	        $args['conditions']['expiry_date <='] = $nxt_date;
	        $expiring = $this->general->get_expiry($args);
	    
    	    $args1['conditions']['expiry_date <'] = date('Y-m-d');
    	    $expired = $this->general->get_expiry($args1);
	    }
	    $this->load->view('user/expiry_notification',array('expiring'=>$expiring,'expired'=>$expired));
	}
	
	public function enq_notif()
	{
	    $datas = $this->db->select('*')->from('enquiry')->where(array('staff'=>$this->uid,'followup_date'=>date('Y-m-d')))->get()->result_array();
	    
	    $this->load->view('user/followup_notification',array('datas'=>$datas));
	}
	
	public function lead_notif(){
        
        $cdate = date('Y-m-d');
        $datas = $this->db->query("select l.* from lead_details as l left join lead_progress as p on l.id=p.lead_id where p.staff='$this->uid' and p.fdate='$cdate' and l.id not in (select lead_id from lead_progress where pdate='$cdate') group by p.lead_id")->result_array();
        
        $this->load->view('user/lead_notification',array('datas'=>$datas));
	}
	
	public function time_assign()
	{
	    $datas = array();
	/*    if($this->uid==2){
	        $this->db->select(array('w.id','w.description','w.client_id','c.name'));
    	    $this->db->from('works as w');
    	    $this->db->join('client_master as c','w.client_id=c.id');
	        $this->db->where(array('w.status'=>1,'w.wstatus'=>1,'w.category'=>0,'w.wtime'=>0));
	        $this->db->order_by('w.id','desc');
	        $rows = $this->db->get()->result_array();
    	    foreach($rows as $row){
    	        $wurl = base_url('work/time_assign/id/'.$row['client_id']);
    	        $datas[] = array('wid'=>$row['id'],'work'=>substr($row['description'],0,25),'client'=>$row['name'],'wurl'=>$wurl);
    	    }
	    }*/
	    echo json_encode($datas);
	}
	
	public function inform()
	{
	    $datas = array();
	    if($this->uid==31 || $this->uid==36 || $this->uid==40 || $this->uid==41 || $this->uid==43 || $this->uid==46 || $this->uid==48 || $this->uid==51){
    	    $this->db->select(array('w.id','w.description','w.contact_no','s.etime','c.name','u.fname'));
    	    $this->db->from('works as w');
    	    $this->db->join('work_status as s','w.id=s.work_id');
    	    $this->db->join('client_master as c','w.client_id=c.id');
    	    $this->db->join('users as u','s.staff_id=u.id');
    	    $this->db->where(array('w.status'=>1,'w.wstatus'=>2,'w.category'=>0,'s.type'=>1,'s.estatus'=>5,'s.etime >='=>'2023-09-28 00:00:00'));
    	    $this->db->where("w.id not in (select work_id from work_inform where status=1)");
    	    $this->db->where("w.client_id not in(30,51,56,58,72,101,170,171)");
    	    $this->db->order_by('s.etime','desc');
    	    $rows = $this->db->get()->result_array();
    	    foreach($rows as $row){
    	        $etime = date('d/m/Y h:i A',strtotime($row['etime']));
    	        $wurl = base_url('work/view_informed_staff_det/id/'.$row['id']);
    	        $datas[] = array('wid'=>$row['id'],'work'=>substr($row['description'],0,25),'time'=>$etime,'client'=>$row['name'],'staff'=>$row['fname'],'wurl'=>$wurl,'contactno'=>$row['contact_no']);
    	    }
	    }
	    echo json_encode($datas);
	}
	
	public function pay_graph(){
	    
	    $start_year=2011; $end_year=date('Y'); $start_date=date('Y-01-01'); $end_date=date('Y-12-31'); $start_month=date('Y-01'); $end_month=date('Y-12'); $year_list=$years=$months=$yincome=$yexpense=$mincome=$mexpense=$year_income=$year_expense=$month_income=$month_expense=array();
	    $this->load->model('estimate/estimate_model','estimate');
	    if($this->utype=='2' || $this->utype=='7'){
    	    //$rows = $this->db->select(array('YEAR(pdate) as year','SUM(amount) as amount'))->from('invoice_payments as p')->join('invoice_payment_items as pi','p.id=pi.pay_id')->where(array('p.status'=>1,'pi.status'=>1))->group_by('YEAR(pdate)','asc')->get()->result_array();
    	    $rows = $this->db->query("SELECT YEAR(vdate) as year,SUM(vamount) as amount FROM `vouchers` WHERE status=1 and vtype_id=1 group by YEAR(vdate)")->result_array();
    	    $rows1 = $this->db->query("SELECT YEAR(vdate) as year,SUM(vamount)as amount FROM `vouchers` WHERE status=1 and vtype_id=2 group by YEAR(vdate)")->result_array();
    	    foreach($rows as $row){
    	        $year_expense[$row['year']] = $row['amount'];
    	    }
    	    foreach($rows1 as $row1){
    	        $year_income[$row1['year']] = $row1['amount']; 
    	    }
    	    for($i=$start_year;$i<=$end_year;$i++){
    	        $year_list[$i] = $i;
    	        $amt=$amt1=0;
    	        if(isset($year_income[$i])){ $amt = $year_income[$i]; }
    	        if(isset($year_expense[$i])){ $amt1 = $year_expense[$i]; }
    	        
    	        $years[] = $i; $yincome[] = $amt; $yexpense[] = $amt1;
    	    }
    	    
    	    //$rows1 = $this->db->select(array('MONTH(pdate) as month','SUM(amount) as amount'))->from('invoice_payments as p')->join('invoice_payment_items as pi','p.id=pi.pay_id')->where(array('p.pdate >='=>$start_date,'p.pdate <='=>$end_date,'p.status'=>1,'pi.status'=>1))->group_by('MONTH(pdate)','asc')->get()->result_array();
    	    $rows2 = $this->db->query("SELECT MONTH(vdate) as month,SUM(vamount) as amount FROM `vouchers` WHERE status=1 and vtype_id=1 group by MONTH(vdate)")->result_array();
    	    $rows3 = $this->db->query("SELECT MONTH(vdate) as month,SUM(vamount) as amount FROM `vouchers` WHERE status=1 and vtype_id=2 group by MONTH(vdate)")->result_array();
    	    foreach($rows2 as $row2){
    	        $month_expense[$row2['month']] = $row2['amount'];
    	    }
    	    foreach($rows3 as $row3){
    	        $month_income[$row3['month']] = $row3['amount']; 
    	    }
    	    for($i=1;$i<=12;$i++){
    	        
    	        $month = date('F', mktime(0, 0, 0, $i, 10)); 
    	        $amt2=$amt3=0;
    	        if(isset($month_income[$i])){ $amt2 = $month_income[$i]; }
    	        if(isset($month_expense[$i])){ $amt3 = $month_expense[$i]; }
    	        
    	        $months[] = $month; $mincome[] = $amt2; $mexpense[] = $amt3;
    	    }
	    }
	    
	    $this->load->view('user/payment_graph',array('year_list'=>$year_list,'years'=>$years,'yincome'=>$yincome,'yexpense'=>$yexpense,'months'=>$months,'mincome'=>$mincome,'mexpense'=>$mexpense));
	}
	
	public function get_month_pay()
	{
	    $year = $this->input->post('year');
	    $start_date=date($year.'-01-01'); $end_date=date($year.'-12-31');
	    $months=$mincome=$mexpense=$month_income=$month_expense=$data=array();
	    
	    //$rows = $this->db->select(array('MONTH(pdate) as month','SUM(amount) as amount'))->from('invoice_payments as p')->join('invoice_payment_items as pi','p.id=pi.pay_id')->where(array('p.pdate >='=>$start_date,'p.pdate <='=>$end_date,'p.status'=>1,'pi.status'=>1))->group_by('MONTH(pdate)','asc')->get()->result_array();
    	$rows = $this->db->query("SELECT MONTH(vdate) as month,SUM(vamount) as amount FROM `vouchers` WHERE status=1 and vtype_id=1 and vdate >= '$start_date' and vdate <= '$end_date' group by MONTH(vdate)")->result_array();
    	$rows1 = $this->db->query("SELECT MONTH(vdate) as month,SUM(vamount) as amount FROM `vouchers` WHERE status=1 and vtype_id=2 and vdate >= '$start_date' and vdate <= '$end_date' group by MONTH(vdate)")->result_array();
    	foreach($rows as $row){
    	    $month_expense[$row['month']] = $row['amount'];
    	}
    	foreach($rows1 as $row1){
    	    $month_income[$row1['month']] = $row1['amount']; 
    	}
    	for($i=1;$i<=12;$i++){
    	        
    	   $month = date('F', mktime(0, 0, 0, $i, 10)); 
    	   $amt=$amt1=0;
    	   if(isset($month_income[$i])){ $amt = $month_income[$i]; }
    	   if(isset($month_expense[$i])){ $amt1 = $month_expense[$i]; }
    	        
    	   $months[] = $month; $mincome[] = $amt; $mexpense[] = $amt1;
    	}
    	
    	$data[0] = $months;
    	$data[1] = $mincome;
    	$data[2] = $mexpense;
    	
	    echo json_encode($data);
	}
	
	public function get_branches()
	{
	    $cid = $this->input->post('cid');
	    $this->load->model('client/client_model','client');
	    $rows = $this->client->get_branches(array('conditions'=>array('client_id'=>$cid)));
	    echo json_encode($rows);
	}
	
	public function objection()
    {
        $works_id = $this->input->get('wid');
        $status = $this->input->get('status');
        if($works_id!='' && $status!=''){
            $this->db->update('work_status',array('objection'=>$status),array('id'=>$works_id));
        }
    }
    
    public function profile()
	{
        $uid = $this->session->userdata('uid');
        $utype = $this->session->userdata('utype');
	    
	    $this->load->model('users/user_model','user');
	    $user_det = $this->user->get_user($uid);
	    
	    $sdate = date('Y-m-01');
	    $edate = date('Y-m-t');
	    
	    $work_data=$lead_data = array(); $total=0;
	    if($utype == 5 || $utype == 6){
	        $this->db->select(array('l.lstatus','COUNT(*) as cnt','ls.remark','ls.color'));
	        $this->db->from('lead_details as l');
	        $this->db->join('lead_status as ls','l.lstatus=ls.id');
	        $this->db->where(array('l.status'=>1,'l.assigned_to'=>$uid));
	        $this->db->group_by('lstatus');
	        $lead_data = $this->db->get()->result_array();
	        
	        $this->db->select('COUNT(*) as cnt');
	        $this->db->from('lead_details');
	        $this->db->where(array('status'=>1,'assigned_to'=>$uid));
	        $row = $this->db->get()->row_array();
	        $total = $row['cnt'];
	    }else if($utype==4){
	        $this->db->select(array('w.id','w.wtime','SUM(TIME_TO_SEC(TIMEDIFF(etime,stime))) AS taken'));
	        $this->db->from('works as w');
	        $this->db->join('work_status as ws','w.id=ws.work_id');
	        $this->db->where(array('ws.type'=>1,'w.status'=>1,'ws.staff_id'=>$uid,'ws.estatus >'=>0,'ws.udate >='=>'2022-07-01'));
	        $this->db->group_by('w.id');
	        $work_data = $this->db->get()->result_array();
	    }
		
		$this->load->view('user/dashboard_profile',array('user_det'=>$user_det,'lead_data'=>$lead_data,'work_data'=>$work_data,'total'=>$total));
	}
	
	public function get_modules()
	{
	    $product = $this->input->post('product');
	    $modules = $this->db->get_where('modules',array('product_id'=>$product,'status'=>1))->result_array();
	    
	    $this->load->view('proposal/module',array('modules'=>$modules));
	}
}