<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Balance_sheet extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();

		$this->load->library('accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d');
		$liability_array = $asset_array = array();$dc = "";$diff_open_bal_dr = $diff_open_bal_cr = $opening_bal = $total_dr = $total_cr = $profit_loss_dr = $profit_loss_cr = 0;
		
		if(isset($_POST['btn_search']))
		{
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
		}
		
		if(!empty($from_date) && !empty($to_date))
		{
			$gross_expense = $gross_income = 0;$closed_stock = 0;
			$next_date = date('Y-m-d',(strtotime($to_date)+86400));
			$pre_date = date('Y-m-d',(strtotime($from_date)-86400));
			
			$closed = $this->accounts->last_closed_yr($from_date);
			if($closed)
			{
				$open_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
			}
			else
			{
				$open_date  = $fiscal_start_date;
			}				

			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=7 or primary_group_id=8 or primary_group_id=9 or primary_group_id=11 or primary_group_id=12)"));
			foreach($account_groups as $key => $value)
			{				
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);								
			    $voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
			
			    $vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
				if($vamount > 0)
				{					
					$liability_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
					$total_cr += $vamount;
				}
				elseif($vamount < 0)					
				{					
					$vamount = -$vamount;
					$total_dr += $vamount;
					$asset_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);					
				}
			}	
			
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=1 or primary_group_id=2)"));
			foreach($account_groups as $key => $value)
			{							
				if($value['id'] == 16)
				{	
				    $closed_stock=0;
				}
				else
				{
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
					$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					if($vamount > 0)
					{					
						$asset_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$total_dr += $vamount;
					}
					elseif($vamount < 0)					
					{					
						$vamount = -$vamount;
						$total_cr += $vamount;
						$liability_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);					
					}
				}
				
			}
	
			$profit_loss = $this->accounts->opening_bal(7,$from_date);//Profit & Loss A/c
	
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
			foreach($account_groups as $key => $value)
			{		
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);												
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
				$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
				$gross_expense += $vamount;							
			}	
			
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
			foreach($account_groups as $key => $value)
			{	
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);											
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
				$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
				$gross_income += $vamount;		
			}
		
		    $profit_loss += ($gross_income - $gross_expense);
			if($profit_loss > 0)
			{
				$profit_loss_cr = $profit_loss;
				$total_cr += $profit_loss_cr;
			}
			elseif($profit_loss < 0)
			{
				$profit_loss_dr = -$profit_loss;
				$total_dr += $profit_loss_dr;
			}

			if($total_dr > $total_cr)
			{
				$diff_open_bal_cr = $total_dr - $total_cr;
				$total_cr += $diff_open_bal_cr;
			}
			elseif($total_cr > $total_dr)
			{
				$diff_open_bal_dr = $total_cr - $total_dr;
				$total_dr += $diff_open_bal_dr;
			}
		} 
		
		$this->template->title('Balance Sheet');
		$this->template->main_heading('Balance Sheet');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('balance-sheet') => 'no_link'));
		$this->template->slice('account_reports/balance_sheet_search',array('from_date' => $from_date,'to_date' => $to_date));
		if(!empty($liability_array) || !empty($asset_array) || !empty($profit_loss))
		{
			$this->template->append('account_reports/balance_sheet',array('liability_array' => $liability_array,'asset_array' => $asset_array,'open_bal_dr' => $diff_open_bal_dr,'open_bal_cr' => $diff_open_bal_cr,'total_dr' => $total_dr,'total_cr' => $total_cr,'profit_loss_dr' => $profit_loss_dr,'profit_loss_cr' => $profit_loss_cr,'from_date' => $from_date,'to_date' => $to_date));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('cms/message');
		$this->template->render();
	}
}