<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Client extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('client/client_model','client');
        $this->load->model('estimate/estimate_model','estimate');
        $this->load->model('product/product_model','product');
        $this->load->model('server/server_model','server');
        $this->load->model('whatsapp/whatsapp_model','whatsapp');
        $this->load->library('general');
	}

    public function add()
    {
        if(isset($_POST['btn_save']))
        { 
            $file_upload_error = true;
			if($_FILES['wfile']['name'] != '')
			{
				$fileName = $_FILES['wfile']['name'];
				
				$config['upload_path'] =  FCPATH.'assets/files/client/';
				$config['allowed_types'] = 'pdf';
			    $config['max_size']	= '15000000';
				
				$config['file_name'] = $fileName;
				$this->load->library('upload');
				$this->upload->initialize($config);
					
				if($this->upload->do_upload('wfile')){
					$file_upload_error = false;
					$config['image_library'] = 'gd2';
					$config['source_image']	= $fileName;
					$config['create_thumb'] = TRUE;
					$config['maintain_ratio'] = false;
					$config['width']	= 150;
					$config['height']	= 120;

					$this->load->library('image_lib', $config); 
                    $this->image_lib->resize();
                }else{
					$file_upload_error = true;
				}
			}else{
				$fileName = '';
				$file_upload_error = false;
			}
			if($file_upload_error){
				$this->message->set('Invalid File !!','e');
			}else{
                $data = $this->input->post(NULL,true);
                unset($data['btn_save']);
                
                $row = $this->db->select_max('no')->from('client_master')->get()->row_array();
                $no = $row['no']+1;
                
                $data['no'] = $no;
                if(!empty($data['modules'])){
                    $data['modules'] = implode('@',$data['modules']);
                }
                $data['wfile'] = $fileName;
               
                $rows = $this->db->query("select * from client_master where name='$data[name]'")->result_array();
                if(empty($rows)){
                    if($fileName !='')
                    {
                       $data['file_attach']=1; 
                    }
                    else
                    {
                       $data['file_attach']=2;  
                    }
                    $cid = $this->client->f_save('client_master',$data);
                    if($cid){
                        unset($data['no']);
                        $data['client_id'] = $cid;
                        $this->client->f_save('client_branch',$data);
                        $this->message->set('Client Added Successfully !!','s');
                    }else{
                        $this->message->set('Client could not be Added !!','e');
                    }
                }else{
                    $this->message->set('Client already Exist !!','e');
                }
			}
        }
        
        $state_list = $this->general->states_list();
        $server_list = $this->server->server_list();
        $server_list[''] = 'Select'; ksort($server_list);
        $module_list = $this->product->module_list();
        
        $this->template->title('Client');
        $this->template->main_heading('Client');
        $this->template->slice('cms/message');
        $this->template->slice('client/add',array('state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list));
        $this->template->render();
    }
    
    public function report()
    {
       $arg_ftch = $args = array(); $state="";$agrmnt_attchd="";
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('state',true)))
    		{
    		    $state = $this->input->post('state',true);
    		    $args['conditions']['state'] = $state;
    		    $arg_ftch['conditions']['state'] = $state;
    		}
    		if(!empty($this->input->post('agrmnt_attchd',true)))
    		{
    		    $agrmnt_attchd = $this->input->post('agrmnt_attchd',true);
    		    $args['conditions']['file_attach'] = $agrmnt_attchd;
    		    $arg_ftch['conditions']['file_attach'] = $agrmnt_attchd;
    		}
    		
    		$args['order_by'] = 'no';
            $args['order'] = 'asc';
            
            $arg_ftch['order_by'] = 'no';
            $arg_ftch['order'] = 'asc';
            
            $clients = $this->client->get_all($args);
            $clients_agreemnt_ntattchd = $this->client->get_all_agreement_not_attached($arg_ftch);
        }
        else
        {
          $args['order_by'] = 'no';
          $args['order'] = 'asc';
          
          $arg_ftch['order_by'] = 'no';
          $arg_ftch['order'] = 'asc';
          $clients = $this->client->get_all($args);
          $clients_agreemnt_ntattchd = $this->client->get_all_agreement_not_attached($arg_ftch);
        }
        $state_list = $this->general->states_list();
        $state_list[''] = '';
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);

        $this->template->title('Client');
        $this->template->main_heading('Client');
        $this->template->slice('client/search_report',array('clients'=>$clients,'state_list'=>$state_list,'state'=>$state,'agrmnt_attchd'=>$agrmnt_attchd,'clients_agreemnt_ntattchd'=>$clients_agreemnt_ntattchd,'redirect'=>'client/report'));
        $this->template->slice('client/report',array('clients'=>$clients,'state_list'=>$state_list,'server_list'=>$server_list,'clients_agreemnt_ntattchd'=>$clients_agreemnt_ntattchd));
        $this->template->render();
    }
    
    public function branch()
    {
        if(isset($_POST['btn_save']))
        { 
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
                
            if(!empty($data['modules'])){
                $data['modules'] = implode('@',$data['modules']);
            }
            $data['ustatus'] = 1;
            $rows = $this->db->query("select * from client_branch where name='$data[name]'")->result_array();
            if(empty($rows)){
                if($this->client->f_save('client_branch',$data)){
                    $this->message->set('Branch Added Successfully !!','s');
                }else{
                    $this->message->set('Branch could not be Added !!','e');
                }
            }else{
                $this->message->set('Branch already Exist !!','e');
            }
        }
        
        $clients = $this->client->listing(array('status'=>1));
        $state_list = $this->general->states_list();
        $server_list = $this->server->server_list();
        $server_list[''] = 'Select'; ksort($server_list);
        $module_list = $this->product->module_list();
        
        $this->template->title('Client');
        $this->template->main_heading('Branch');
        $this->template->slice('cms/message');
        $this->template->breadcrumb(array('Branch'=>'no_link','Report'=>'client/branch_report'));
        $this->template->slice('client/branch',array('clients'=>$clients,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list));
        $this->template->render();
    }
    
    public function branch_report()
    {
        $args = array(); $client_id="";
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('client_id',true)))
    		{
    		    $client_id = $this->input->post('client_id',true);
    		    $args['conditions']['client_id'] = $client_id;
    		}
        }
        
        $branches = $this->client->get_branches($args);
        
        $clients = $this->client->listing(array('status'=>1));
        $state_list = $this->general->states_list();
        $state_list[''] = '';
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);

        $this->template->title('Client');
        $this->template->main_heading('Branch Report');
        $this->template->breadcrumb(array('Branch'=>'client/branch','Report'=>'no_link'));
        $this->template->slice('client/branch_report',array('clients'=>$clients,'client_id'=>$client_id,'state_list'=>$state_list,'server_list'=>$server_list,'branches'=>$branches));
        $this->template->render();
    }
    
    public function delete_branch()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $branch_id = $uri_array['id'];
        
        if($this->db->update('client_branch',array('status'=>0),array('id'=>$branch_id))){
            $this->message->set('Branch Deleted Successfully !!','s');
        }else{
            $this->message->set('Branch could not be Deleted !!','w');
        }
        
        redirect('client/branch_report');
    }
    
    public function update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $client_id = $uri_array['id'];
        if(!empty($client_id)){
            $args = array();
            $args['conditions']['id'] = $client_id;
            $client_det = $this->client->get_all($args);
            $fn=0;
            if(isset($_POST['btn_update'])){  
                $file_upload_error = true;
				if($_FILES['wfile']['name'] != ''){
					$fileName = $_FILES['wfile']['name'];
					
					$config['upload_path'] =  FCPATH.'assets/files/client/';
					$config['allowed_types'] = 'pdf';
					$config['max_size']	= '15000000';
				
					$config['file_name'] = $fileName;
					$this->load->library('upload');
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('wfile')){
						$file_upload_error = false;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = false;
						$config['width'] = 150;
						$config['height'] = 120;

						$this->load->library('image_lib', $config); 
                        $this->image_lib->resize();
                    }else{
						$file_upload_error = true;
					}
				}else{
    				$fn=1;
					$file_upload_error = false;
				}
				if($file_upload_error){
					$this->message->set('Invalid File !!','e');
				}else{
                    $data = $this->input->post(NULL,true);
                    unset($data['btn_update']);
                    
                    if(!empty($data['modules'])){
                        $data['modules'] = implode('@',$data['modules']);
                    }
                    
                    if($fn=='0'){
                        $data['wfile'] = $fileName;
                    }
                    if($this->db->update("client_master",$data,array('id'=>$client_id))){
                        $this->message->set('Client Details Updated Successfully !!','s');
                    }else{
                        $this->message->set('Client Details could not be Updated !!','e');
                    }
                    redirect('client/report');
    			}
            }
            
            $state_list = $this->general->states_list();
            $server_list = $this->server->server_list();
            $server_list[''] = 'Select'; ksort($server_list);
            $module_list = $this->product->module_list();
            
            $this->template->title('Client Update');
            $this->template->main_heading('Client Update');
            $this->template->slice('cms/message');
            $this->template->slice('client/update',array('client_id'=>$client_id,'client_det'=>$client_det,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list));
            $this->template->render();
        }
    }
    
    public function inactive_report()
    {
        $clients_agreemnt_ntattchd='';$agrmnt_attchd='';
        $args = array(); $state="";
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('state',true)))
    		{
    		    $state = $this->input->post('state',true);
    		    $args['state'] = $state;
    		}
        }
        
        $clients = $this->client->get_all_inactive($args);
        
        $state_list = $this->general->states_list();
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);
        
        $this->template->title('Inactive Client');
        $this->template->main_heading('Inactive Client');
        $this->template->slice('client/search_report',array('clients'=>$clients,'state_list'=>$state_list,'state'=>$state,'agrmnt_attchd'=>$agrmnt_attchd,'redirect'=>'client/inactive_report'));
        $this->template->slice('client/report',array('clients'=>$clients,'state_list'=>$state_list,'server_list'=>$server_list,'clients_agreemnt_ntattchd'=>$clients_agreemnt_ntattchd));
        $this->template->render();
    }
    
    public function search()
	{
		$skey=""; $clients=array();
                  
        if(isset($_POST['btn_search']))
        {
            $data = $this->input->post(NULL,true);
            $skey = strtoupper($data['skey']);
                
            $this->db->select('*');
            $this->db->from('client_master');
            $this->db->where("name like '%$skey%' or mobile_no like '%$skey%' or email like '%$skey%'");
            $clients = $this->db->get()->result_array();
        }
            
        $this->template->title('Client Details');
        $this->template->main_heading('Search Client');
        $this->template->slice('cms/message');
        $this->template->slice('client/search',array('skey'=>$skey,'clients'=>$clients));
        $this->template->render();
	}
	
	public function details()
	{
	    $client_id = $this->uri->segment(3);
		$client_det = $this->client->get_details($client_id);
		$branches = $this->client->get_branches(array('conditions'=>array('client_id'=>$client_id)));
		
		$state_list = $this->general->states_list();
		$state_list[''] = ''; ksort($state_list);
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);
        $module_list = $this->product->module_list();
        $status_list = array('0'=>'','1'=>'Active','2'=>'Inactive');

		$this->template->title('Client Details');
		$this->template->main_heading('Client Profile');
        $this->template->slice('cms/message');
		$this->template->slice('client/details',array('client_id'=>$client_id,'client_det'=>$client_det,'branches'=>$branches,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list,'status_list'=>$status_list));
        $this->template->render();
	}
	
	public function profile()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		
		$state_list = $this->general->states_list();
		$state_list[''] = ''; ksort($state_list);
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);
        $module_list = $this->product->module_list();
        $status_list = array('0'=>'','1'=>'Active','2'=>'Inactive');

		$this->template->title('Client Details');
		$this->template->main_heading('Branch Profile');
        $this->template->slice('cms/message');
		$this->template->slice('client/profile',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list,'status_list'=>$status_list));
        $this->template->render();
	}
	
	public function edit_profile()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		
		$state_list = $this->general->states_list();
		$state_list[''] = ''; ksort($state_list);
        $server_list = $this->server->server_list();
        $server_list[0] = ''; ksort($server_list);
        $module_list = $this->product->module_list();
        $status_list = array('0'=>'','1'=>'Active','2'=>'Inactive');
        
        if(isset($_POST['btn_update'])){  
            $data = $this->input->post(NULL,true);
            unset($data['btn_update']);
                    
            if(!empty($data['modules'])){
                        $data['modules'] = implode('@',$data['modules']);
            }
            if($this->db->update("client_branch",$data,array('id'=>$branch_id))){
                        $this->message->set('Branch Details Updated Successfully !!','s');
                    }else{
                        $this->message->set('Branch Details could not be Updated !!','e');
                    }
            redirect('client/profile/'.$branch_id);
            
        }
        
      
		$this->template->title('Update Client Details');
		$this->template->main_heading('Update Branch Profile');
        $this->template->slice('cms/message');
		$this->template->slice('client/edit_profile',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list,'status_list'=>$status_list));
        $this->template->render();
	}
	
	public function estimate()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		$estimates = $this->estimate->get_all(array('conditions'=>array('e.branch_id'=>$branch_id),'order_by'=>'e.edate','order'=>'asc'));
		$ptypes = array('0'=>'Product','1'=>'Service');

		$this->template->title('Client Details');
		$this->template->main_heading('Branch Estimates');
        $this->template->slice('cms/message');
		$this->template->slice('client/estimate',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'estimates'=>$estimates,'ptypes'=>$ptypes));
        $this->template->render();
	}
	
	public function invoice()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		$invoices = $this->estimate->get_all_invoice(array('conditions'=>array('i.branch_id'=>$branch_id),'order_by'=>'i.idate','order'=>'asc'));
		$ptypes = array('0'=>'Product','1'=>'Service');

		$this->template->title('Client Details');
		$this->template->main_heading('Branch Invoices');
        $this->template->slice('cms/message');
		$this->template->slice('client/invoice',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'invoices'=>$invoices,'ptypes'=>$ptypes));
        $this->template->render();
	}
	
	public function payment()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		$payments = $this->estimate->get_all_payment(array('conditions'=>array('p.branch_id'=>$branch_id),'order_by'=>'p.pdate','order'=>'asc'));

		$this->template->title('Client Details');
		$this->template->main_heading('Branch Payments');
        $this->template->slice('cms/message');
		$this->template->slice('client/payment',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'payments'=>$payments));
        $this->template->render();
	}
	
	public function due()
	{
	    $branch_id = $this->uri->segment(3);
		$branch_det = $this->client->get_branch_details($branch_id);
		$dues = $this->estimate->get_all_invoice(array('conditions'=>array('i.branch_id'=>$branch_id,'ii.payment_status'=>0),'order_by'=>'i.idate','order'=>'asc'));
		$ptypes = array('0'=>'Product','1'=>'Service');

		$this->template->title('Client Details');
		$this->template->main_heading('Branch Dues');
        $this->template->slice('cms/message');
		$this->template->slice('client/due',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'dues'=>$dues,'ptypes'=>$ptypes));
        $this->template->render();
	}
	
	public function feedback()
	{
	    if(isset($_POST['btn_send']))
        {
            $data = $this->input->post(NULL,true);
            
            print_r($data);
        }
        
        $res = $this->whatsapp->send('9633081340','halo'); print_r($res); die;
	    
	    $clients = $this->client->get_all(array());
	    
	    $this->template->title('Client Feedback');
		$this->template->main_heading('Client Feedback');
        $this->template->slice('cms/message');
		$this->template->slice('client/feedback',array('clients'=>$clients));
        $this->template->render();
	}
	
	public function feedback1()
	{
	    $data = $this->input->post(NULL,true);
            
        print_r($data);
	}
	
	public function branch_update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $branch_id = $uri_array['id'];
        if(!empty($branch_id)){
            $args = array();
            $args['conditions']['id'] = $branch_id;
            $branch_det = $this->client->get_branches($args);
             $fn=0;
            if(isset($_POST['btn_update'])){  
                $data = $this->input->post(NULL,true);
                    unset($data['btn_update']);
                    if($this->db->update("client_branch",$data,array('id'=>$branch_id))){
                        $this->message->set('Branch Details Updated Successfully !!','s');
                    }else{
                        $this->message->set('Branch Details could not be Updated !!','e');
                    }
                    redirect('client/branch_report');
            }
        }
        $clients = $this->client->listing(array('status'=>1));
        $state_list = $this->general->states_list();
        $server_list = $this->server->server_list();
        $server_list[''] = 'Select'; ksort($server_list);
        $module_list = $this->product->module_list();
        
        $this->template->title('Branch Update');
        $this->template->main_heading('Branch Update');
        $this->template->slice('cms/message');
        $this->template->slice('client/branch_update',array('branch_id'=>$branch_id,'branch_det'=>$branch_det,'state_list'=>$state_list,'server_list'=>$server_list,'module_list'=>$module_list,'clients'=>$clients));
        $this->template->render();
    }
	
	public function mail_log(){
        $client=$fdate=$tdate=$status=''; $args=$mails=array();
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('client',true))){
                $client = $this->input->post('client',true);
                $args['m.client_id'] = $client;
            }
            if(!empty($this->input->post('fdate',true))){
                $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['m.fdate >='] = $fdate;
            }
            if(!empty($this->input->post('tdate',true))){
                $tdate = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['m.fdate <='] = $tdate;
            }
            if(!empty($this->input->post('status',true))){
                $status = $this->input->post('status',true);   
                $args['m.status'] = $status;
            }
        }
	    $mails = $this->client->get_mails($args);
        $clients = $this->client->listing(array());

	    $this->template->title('Client');
        $this->template->main_heading('Mail Log');
        $this->template->slice('cms/message');
        $this->template->slice('client/mail_log',array('clients'=>$clients,'client'=>$client,'fdate'=>$fdate,'tdate'=>$tdate,'status'=>$status,'mails'=>$mails));
        $this->template->render();
	}
	
	public function mail_update(){
        $uri_array = $this->uri->uri_to_assoc(3); 
        $mid = $uri_array['id'];
        $mail_det = $this->db->select(array('c.name','c.url_soft','m.*'))->from('client_mail as m')->join('client_master as c','m.client_id=c.id')->where('m.id',$mid)->get()->row_array();
        if(isset($_POST['btn_save'])){
            $rid = $this->input->post('rid',true);
            $cdate = date('Y-m-d',strtotime($this->input->post('cdate',true)));
            $credit = $this->input->post('credit',true);
            
            $row = $this->db->select(array('c.name','c.url_soft','m.*'))->from('client_mail as m')->join('client_master as c','m.client_id=c.id')->where('m.id',$rid)->get()->row_array();
            
            $this->db->update('client_mail',array('tdate'=>$cdate,'status'=>2),array('id'=>$rid));
            
            $data = array();
            $data['client_id'] = $row['client_id'];
            $data['fdate'] = $cdate;
            $data['credit'] = $credit;
            $data['status'] = 1;
            $this->client->f_save('client_mail',$data);
            
            $url = $row['url_soft'].'/api/mailup/';
            $myvars = 'credit='.$credit;
            $ch = curl_init( $url );
            curl_setopt( $ch, CURLOPT_POST, 1);
            curl_setopt( $ch, CURLOPT_POSTFIELDS, $myvars);
            curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt( $ch, CURLOPT_HEADER, 0);
            curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
            $response = curl_exec( $ch );
            curl_close($ch);
            
            redirect('client/mail_log');
        }
        
        $this->template->title('Client');
        $this->template->main_heading('Mail Credit Update');
        $this->template->slice('cms/message');
        $this->template->slice('client/mail_update',array('mail_det'=>$mail_det));
        $this->template->render();
	}
	
} ?>