<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Daybooks extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();

		$this->load->library('accounts');
	}
	
	public function index()
	{
	    $fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
	    $from_date = $to_date = date('Y-m-d');
		$vouchers_array = array();$vtype_id = $opening_bal = 0;$dc = "";
		
		if(isset($_POST['btn_search']))
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				
			$this->session->set_userdata(array('vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));
    		$data_array = array('table' => 'vouchers','columns' => array('group_id','vtype_id','vno','vdate','dr_ledger','cr_ledger','vamount','narration','table_name','table_id'),'conditions' => array('vamount >'=>0,'status' => 1),'between' => "vdate between '$from_date' and '$to_date'",'order_by' => 'vdate','order' => 'asc');
    			
    		if($vtype_id > 0)
    		{
    			$data_array['conditions']['vtype_id'] = $vtype_id;
    		}
    		
    		$vouchers_array = $this->dms->get_data($data_array);
    	}
		
		$vtype_array = $this->dms->get_data(array('table' => 'voucher_types','columns' => array('id','vtype'),'conditions' => array('status' => 1),'order_by' => 'vid','order' => 'asc'));
        $vtypes[0] = "All"; 
        foreach($vtype_array as $key => $value)
        {
        	$vtypes[$value['id']] = $value['vtype'];
        }
		
		$this->template->title('Day Book');
		$this->template->main_heading('Day Book');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('day-book') => 'no_link'));
		$this->template->slice('account_reports/daybook_search',array('vtypes' => $vtypes,'vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));	
		if(!empty($vouchers_array))
		{
			$this->template->append('account_reports/daybooks',array('voucher_array' => $vouchers_array,'vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('cms/message');
		$this->template->render();
	}
}