<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class enquiry extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('client/client_model','client');
        $this->load->model('users/user_model','user');
	}
	
	public function add()
    {
        if(isset($_POST['btn_save']))
        { 
            $file_upload_error = true; $fileName = '';
			if($_FILES['wfile']['name'] != ''){
                $fileName = $_FILES['wfile']['name'];
				$config['upload_path'] =  FCPATH.'assets/files/client/';
				$config['allowed_types'] = 'pdf';
				$config['max_size']	= '15000000';
				$config['file_name'] = $fileName;
				$this->load->library('upload');
				$this->upload->initialize($config);
				if($this->upload->do_upload('wfile')){
					$file_upload_error = false;
					$config['image_library'] = 'gd2';
					$config['source_image']	= $fileName;
					$config['create_thumb'] = TRUE;
					$config['maintain_ratio'] = false;
					$config['width']	= 150;
					$config['height']	= 120;
					$this->load->library('image_lib', $config); 
                    $this->image_lib->resize();
                }
			}else{
			    $file_upload_error = false;
			}
			if($file_upload_error){
				$this->message->set('Invalid File !!','e');
			}else{
            	$data = $this->input->post(NULL,true);
                
                unset($data['btn_save']);
                $enq_no = 1;
                $rows_enqno = $this->db->query("select max(enq_no) as enq_no from enquiry where status = '1'")->row_array();
                if(!empty($rows_enqno)){
                    $enq_no += $rows_enqno['enq_no'];
                }
                
                $data['wfile'] = $fileName;
                $data['status'] = 1;
                $data['enq_no'] = $enq_no;
                if($data['demo_type'] !='')
                {
                    $data['demo_status'] = 1;
                }
                else
                {
                    $data['demo_status'] = 0;    
                }
                
                $data['followup_date'] = date('Y-m-d',strtotime($data['followup_date']));
                
                if($data['followup_date']=='0000-00-00' || $data['followup_date']=='1970-01-01' || $data['followup_date']==''){ unset($data['followup_date']); }
                
                
                $rows = $this->db->query("select * from enquiry where name='$data[name]'")->result_array();
                if(empty($rows))
                {
                    if($this->client->f_save('enquiry',$data))
                    {
                        $this->message->set('Enquiry Added Successfully !!','s');
                    }
                    else
                    {
                        $this->message->set('Enquiry could not be Added !!','e');
                    }
                }
                else
                {
                    $this->message->set('Enquiry already Exist !!','e');
                }
			}
        }
        $enq_types = array('Direct'=>'Direct','Telecalling'=>'Telecalling','Incoming'=>'Incoming','Social Media Marketing'=>'Social Media Marketing');
        $users = $this->user->listing(array());
        $this->template->title('Enquiry');
        $this->template->main_heading('Enquiry');
        $this->template->slice('cms/message');
        $this->template->slice('enquiry/add',array('users'=>$users,'enq_types'=>$enq_types));
        $this->template->render(); 
    }
    
    public function report()
    {
        $args = array(); $args['enq_status'] = 0; $from_date = $to_date = ""; $staff=""; $status=""; $enq_stat="";
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('client',true)))
    		{
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		} 
    		if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
    		if(!empty($this->input->post('enq_stat',true)))
    		{
    		    $enq_stat = $this->input->post('enq_stat',true);
    		    $args['enq_status'] = $enq_stat;
    		}
    		if(!empty($this->input->post('status',true)))
    		{
    		    $status = $this->input->post('status',true);
    		    $args['status'] = $status;
    		}
    		$enquiry = $this->client->get_enquiry_det($args);
        }
         
        $enquiry = $this->client->get_enquiry_det1($args);
        $clients = $this->client->get_all(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Enquiry Report');
        $this->template->main_heading('Enquiry Report');
        $this->template->slice('enquiry/search',array('clients'=>$clients,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff,'enq_stat'=>$enq_stat,'status'=>$status));
        $this->template->slice('enquiry/report',array('enquiry'=>$enquiry,'users'=>$users));
        $this->template->render();
    }
    
    public function delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $enquiry_id = $uri_array['id'];  
        
        if($this->db->update("enquiry",array('status'=>0),array('id'=>$enquiry_id)))
        {
            $this->message->set('Enquiry Deleted Successfully !!','s');
        }
        
        redirect('enquiry/report');
    }
    
    public function demo_report()
    {
            
            $args = array(); $from_date = $to_date = ""; $staff=""; $demo_type="";
            
            if(isset($_POST['btn_get']))
            {
                if(!empty($this->input->post('client',true)))
        		{
        		    $client = $this->input->post('client',true);
        		    $args['client'] = $client;
        		}
        		if(!empty($this->input->post('fdate',true)))
        		{
        		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
        		    $args['fdate'] = $from_date;
        		}
        		if(!empty($this->input->post('tdate',true)))
        		{
        		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
    			    $args['tdate'] = $to_date;
        		} 
        		if(!empty($this->input->post('staff',true)))
        		{
        		    $staff = $this->input->post('staff',true);
        		    $args['staff'] = $staff;
        		}
        		if(!empty($this->input->post('demo_type',true)))
        		{
        		    $demo_type = $this->input->post('demo_type',true);
        		    $args['demo_type'] = $demo_type;
        		}
            
            }
            $demo_types = array(''=>'SELECT','online'=>'Online','offline'=>'Offline');
            $enquiry = $this->client->get_enquiry_demo_det($args);
            $clients = $this->client->get_all($args);
            $users = $this->user->listing(array());
            $this->template->title('Enquiry Demo Report');
            $this->template->main_heading('Enquiry Demo Report');
            $this->template->slice('enquiry/demo_search',array('clients'=>$clients,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff,'demo_types'=>$demo_types,'demo_type'=>$demo_type));
            $this->template->slice('enquiry/demo_report',array('enquiry'=>$enquiry,'users'=>$users));
            $this->template->render();
      
    }
    
    public function followup()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $enquiry_id = $uri_array['id'];
        
        if(!empty($enquiry_id))
        {
            $enq_det = $this->client->enquiry_details($enquiry_id);
            if(isset($_POST['btn_save']))
            {
                $file_upload_error = TRUE; $audio="";
                if(!empty($_FILES['audio']['name']))
                {
    				$ext = pathinfo($_FILES['audio']['name'], PATHINFO_EXTENSION);
    				
    				$audio = rand(0,1000)."enquiry".date('YmdHis').".".$ext;
    			
    				$config['upload_path'] =  FCPATH.'assets/files/enquiry_audio/';
    				$config['allowed_types'] = '*';
    				$config['file_name'] = $audio;
    
    				$this->load->library('upload');
    				$this->upload->initialize($config);
    
    				if(!$this->upload->do_upload('audio'))
    				{
    					$file_upload_error = false;
    				}
    			}
    			
    			if($file_upload_error == false)
    			{
    				$this->message->set('Invalid File','e');
    			}
    			else
    			{
                    $enquiry_id = $this->input->post('enquiry_id',true);
                    $enq_no = $this->input->post('enq_no',true);
                    $edate = date('Y-m-d',strtotime($this->input->post('ndate',true)));
                    $time_enq = date('h:i A',strtotime($this->input->post('ntime_enq',true)));
                    $fstatus = $this->input->post('nstatus',true);
                    $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                    
                    $enq_followup = array();
                    $enq_followup['enq_no'] = $enq_no;
                    $enq_followup['status'] = $fstatus;
                    $enq_followup['date'] = $edate;
                    $enq_followup['time'] = $time_enq;
                    $enq_followup['audio'] = $audio;
                    $enq_followup['followup_date'] = '';
                    
                    if($fdate!='0000-00-00' || $fdate!='1970-01-01' || $fdate!=''){ $enq_followup['followup_date'] = $fdate; }
                    
                    if($this->client->f_save('enquiry_followup1',$enq_followup))
                    {
                        if(isset($enq_followup['followup_date']))
                        {
                            $this->db->update('enquiry',array('followup_date'=>$enq_followup['followup_date']),array('id'=>$enquiry_id));
                        }
                        $this->message->set('Enquiry Follow Up Status Updated Successfully !!','s');
                    }
    			}
    			
                redirect('enquiry/followup/id/'.$enquiry_id);
            }
            
            $this->template->title('Enquiry Details');
            $this->template->main_heading('Enquiry Details');
            $this->template->slice('cms/message');
            $this->template->slice('enquiry/followup',array('enquiry_id'=>$enquiry_id,'enq_det'=>$enq_det));
            $this->template->render();
        }
    }
    
    public function add_client()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $enquiry_id = $uri_array['id'];  
        if(!empty($enquiry_id))
        {
            $enq_det = $this->client->enquiry_details($enquiry_id);
             if(isset($_POST['btn_save']))
              {    
                  $enquiry_id = $this->input->post('enquiry_id',true);
                  $file_upload_error = true;
				  #upload the photo if one is selected.
				  if($_FILES['wfile']['name'] != ''){

					//$ext = pathinfo($_FILES['wfile']['name'], PATHINFO_EXTENSION); 
					$ext = $_FILES['wfile']['name'];
					#file name initialization
					
					
					$fileName = $ext;
					
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/files/client/';
					$config['allowed_types'] = 'pdf';
					$config['max_size']	= '15000000';
				
					$config['file_name'] = $fileName;
					$this->load->library('upload');
					$this->upload->initialize($config);
					
						if($this->upload->do_upload('wfile')){
						    
						    $file_upload_error = false;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('image_lib', $config); 
                            $this->image_lib->resize();
                            
						}
						else{
						$file_upload_error = true;
					}
					
				}
				else{
					$fileName = $enq_det['wfile']; #dummy image in case no image uploaded
					$file_upload_error = false;
				}
				if($file_upload_error){
					//$this->message->set($this->lang->line('invalid-syllabus'),'e');
					$this->message->set('Invalid File !!','e');
				}
			else
			{
            	
                $data = $this->input->post(NULL,true);
                $client_array = array();
                $client_array['name'] = $data['name'];
                $client_array['mobile_no'] = $data['mobile_no'];
                $client_array['sftadmin_no'] = $data['sftadmin_no'];
                $client_array['email'] = $data['email'];
              /*  $client_array['soft_type'] = $data['soft_type'];
                $client_array['software_cost'] = $data['software_cost'];
                $client_array['server_charge'] = $data['server_charge'];
                $client_array['swrenewal_charge'] = $data['swrenewal_charge'];
                $client_array['soft_renwal_date'] = $data['soft_renwal_date'];*/
                $client_array['wfile'] = $fileName;
                $client_array['status'] = 1;
                $enq_array['enq_status'] = 1;
                $rows = $this->db->query("select * from client_master where name='$data[name]'")->result_array();
                
                if(empty($rows))
                {
                    if($this->client->f_save('client_master',$client_array))
                    {
                        $this->db->update("enquiry",$enq_array,array('id'=>$enquiry_id));
                        $this->message->set('Client Added Successfully !!','s');
                    }
                    else
                    {
                        $this->message->set('Client could not be Added !!','e');
                    }
                }
                else
                {
                    $this->message->set('Client already Exist !!','e');
                }
			}
				
              }
            $this->template->title('Add Client');
            $this->template->main_heading('Add Client');
            $this->template->slice('cms/message');
            $this->template->slice('enquiry/add_client',array('enquiry_id'=>$enquiry_id,'enq_det'=>$enq_det));
            $this->template->render();
        }
    }
    
    public function update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        if(!empty($up_id))
        {
            
           $enq_det = $this->client->enquiry_details($up_id);
           $fn =0;
           if(isset($_POST['btn_update']))
            { 
                 $file_upload_error = true;
				#upload the photo if one is selected.
				if($_FILES['wfile']['name'] != ''){

					//$ext = pathinfo($_FILES['wfile']['name'], PATHINFO_EXTENSION); 
					$ext = $_FILES['wfile']['name'];
					#file name initialization
					
					
					$fileName = $ext;
					
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/files/client/';
					$config['allowed_types'] = 'pdf';
					$config['max_size']	= '15000000';
				
					$config['file_name'] = $fileName;
					$this->load->library('upload');
					$this->upload->initialize($config);
					
						if($this->upload->do_upload('wfile')){
						    
						    $file_upload_error = false;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('image_lib', $config); 
                            $this->image_lib->resize();
                       
						}
						else{
						$file_upload_error = true;
					}
				}
				else{
    				
                    
                        $fn=1;
				#dummy image in case no image uploaded
					$file_upload_error = false;
				}
				if($file_upload_error){
					//$this->message->set($this->lang->line('invalid-syllabus'),'e');
					$this->message->set('Invalid File !!','e');
				}
                else
			{
                
                
                $data = $this->input->post(NULL,true);
                unset($data['btn_update']);
                if($fn=='0')
                {
                $data['wfile'] = $fileName;
                }
                //print_r($up_id);
                 if($data['demo_type'] !='')
                {
                $data['demo_status'] = 1;
                }
                else
                {
                $data['demo_status'] = 0;    
                }
                if($this->db->update("enquiry",$data,array('id'=>$up_id)))
                {
                    $this->message->set('Enquiry Details Updated Successfully !!','s');
                }
                else
                {
                    $this->message->set('Enquiry Details could not be Updated !!','e');
                }
                redirect('enquiry/report');
			}    
                
            }
           
           $enq_types = array('Direct'=>'Direct','Telecalling'=>'Telecalling','Incoming'=>'Incoming','Social Media Marketing'=>'Social Media Marketing');
           $users = $this->user->listing(array());
           $this->template->title('Enquiry Update');
           $this->template->main_heading('Enquiry Update');
           $this->template->slice('cms/message');
           $this->template->slice('enquiry/update',array('enquiry'=>$enq_det,'enq_id'=>$up_id,'users'=>$users,'enq_types'=>$enq_types));
           $this->template->render();
            
        }
    }
    
    public function reject_client()
    {
       $uri_array = $this->uri->uri_to_assoc(3);
       $enquiry_id = $uri_array['id'];  
        
        if($this->db->update("enquiry",array('status'=>2),array('id'=>$enquiry_id)))
        {
            $this->db->update("enquiry",array('enq_status'=>2),array('id'=>$enquiry_id));
            $this->message->set('Enquiry Rejected Successfully !!','s');
        }
        
        redirect('enquiry/report');
    }  
    
    public function reject_report()
    {
        $args = array(); $from_date = $to_date = ""; $staff="";
        if(isset($_POST['btn_get']))
        {
           if(!empty($this->input->post('client',true)))
    		{
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		} 
    		if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
            
        }
        $enquiry = $this->client->get_enquiry_rejected_det($args);
        $clients = $this->client->get_all($args);
        $users = $this->user->listing(array());
        $this->template->title('Rejected Enquiry Report');
        $this->template->main_heading('Rejected Enquiry Report');
        $this->template->slice('enquiry/rejected_search',array('clients'=>$clients,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('enquiry/rejected_report',array('enquiry'=>$enquiry,'users'=>$users));
        $this->template->render();
    }
    
    public function add_demo_pwd()
    {
        if(isset($_POST['btn_save']))
        { 
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            if($this->client->f_save('demo_usn_pwd',$data))
            {
               $this->message->set('Demo Username and Password Added Successfully !!','s');
            }
            else
            {
              $this->message->set('Demo Username and Password could not be Added !!','e');
            }
        
        }
        $users = $this->user->listing(array());
        $this->template->title('Add Username and Password');
        $this->template->main_heading('Add Username and Password');
        $this->template->slice('cms/message');
        $this->template->slice('enquiry/add_demo_pwd',array('users'=>$users));
        $this->template->render(); 
    }
    
    public function demo_pwd_report()
    {
        $demo_rep_up = $this->client->get_demo_pwd_det();
        $users = $this->user->listing(array());
        $this->template->title('Add Username and Password');
        $this->template->main_heading('Add Username and Password');
        $this->template->slice('cms/message');
        $this->template->slice('enquiry/demo_pwd_report',array('users'=>$users,'demo_rep_up'=>$demo_rep_up));
        $this->template->render(); 
    }
    
	public function demo_pwd_update()
	{
	    echo $up_id = $this->uri->segment(4);
	    
	    if(isset($_POST['btn_update']))
	    {
	        $data = $this->input->post(NULL,true);
	        $up_id = $data['up_id'];
	        
            unset($data['btn_update']);
            unset($data['up_id']);
            if($this->db->update('demo_usn_pwd',$data,array('id'=> $up_id)))
            {
               $this->message->set('Demo Username and Password Updated Successfully !!','s');
            }
            else
            {
              $this->message->set('Demo Username and Password could not be Updated !!','e');
            }
            redirect('enquiry/demo_pwd_report');
	    }
	    
	    $res_old = $this->db->select(array('soft_type','soft_url','adm_uname','adm_pwd','accnt_uname','accnt_pwd','staff_uname','staff_pwd','stud_uname','stud_pwd','prncpl_uname','prncpl_pwd','lib_uname','lib_pwd','oprator_uname','oprator_pwd','chairman_uname','chairman_pwd','hod_uname','hod_pwd','admin_video','account_video','chairman_video','principal_video','staff_video','student_video','library_video','hod_video','operator_video'))->get_where('demo_usn_pwd',array('id'=>$up_id))->row_array();

	    $this->template->title('Email');
        $this->template->main_heading('Email Update');
        $this->template->slice('cms/message');
        $this->template->slice('enquiry/demo_pwd_update',array('up_id'=>$up_id,'res_old'=>$res_old));
        $this->template->render();
	}
}    
?>