<? if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Estimate extends MY_Controller {

    public function __construct(){
		parent ::__construct();
		
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('product/product_model','product');
        $this->load->model('client/client_model','client');
        $this->load->model('estimate/estimate_model','estimate');
        $this->load->library(array('general','to_words'));
	}

    public function add(){
        $eid = ""; $branch_id=""; $branches=array();
        $temp_data = $this->db->select(array('e.id as eid','e.client_id','e.branch_id','e.edate','ei.*'))->from('estimate as e')->join('estimate_items as ei','e.id=ei.es_id')->where(array('e.status'=>'-1','ei.status !='=>'0'))->get()->result_array();
        if(!empty($temp_data)){ $eid = $temp_data[0]['eid']; }
        $estimate_array = array(); $cnt=0;
        if(isset($_POST['btn_add'])){
            $data = $this->input->post(NULL,true);
            $estimate_array['edate'] = date('Y-m-d',strtotime($data['edate']));
            $estimate_array['client_id'] = $data['client_id'];
            $estimate_array['branch_id'] = $data['branch_id'];
            $estimate_array['status'] = -1;
            unset($data['client_id']);
            unset($data['branch_id']);
            unset($data['edate']);
            unset($data['btn_add']); 
            if(empty($temp_data)){ 
                $est_id = $this->product->insert('estimate',$estimate_array);
            }else{
                $est_id = $temp_data[0]['eid'];
            }
            if($est_id){
                $data['es_id'] = $est_id;
                $data['status'] = -1;
                
                if($this->product->insert('estimate_items',$data)){
                    $this->message->set('Product Added to Estimate !','s');
                }else{
                    $this->message->set('Product could not be Added to Estimate !','e');
                }
            }
            redirect('estimate/add');
        }
        if(isset($_POST['btn_save'])){
            if($eid != ''){
                if($this->db->update('estimate',array('status'=>1),array('id'=>$eid))){
                    if($this->db->update('estimate_items',array('status'=>1),array('es_id'=>$eid,'status !='=>0))){
                        $this->message->set('Estimate Generated Successfully !','s');
                    }else{
                        $this->message->set('Estimate could not be Generated !','e');
                    }
                }
            }
            redirect('estimate/add');
        }
        
        $ptypes = array('0'=>'Product','1'=>'Service');
        $products = $this->product->get_all(array('conditions'=>array('ptype'=>0)));
        $pay_types = $this->product->payment_type_list();
        $pay_types[''] = 'Not Applicable';
        $clients = $this->client->listing(array('status'=>1));
        
        $client_id=""; $edate = date('Y-m-d'); $disabled="";
        if(!empty($temp_data)){
            $client_id = $temp_data[0]['client_id'];
            $branch_id = $temp_data[0]['branch_id'];
            $branches = $this->client->get_branches_list(array('conditions'=>array('client_id'=>$client_id)));
            $edate = $temp_data[0]['edate'];
            $disabled = "disabled";
        }
        
        $this->template->title('Estimate');
        $this->template->main_heading('Add Estimate');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/add',array('clients'=>$clients,'client_id'=>$client_id,'branches'=>$branches,'branch_id'=>$branch_id,'edate'=>$edate,'disabled'=>$disabled,'ptypes'=>$ptypes,'products'=>$products,'pay_types'=>$pay_types,'temp_data'=>$temp_data));
        $this->template->render();
    }
    
    public function delete_item(){
        $item_id = $this->uri->segment(3);
        
        $row = $this->db->select('*')->from('estimate_items')->where(array('id'=>$item_id,'status !='=>0))->get()->row_array();
        if(!empty($row)){
            if($this->db->update('estimate_items',array('status'=>0),array('id'=>$item_id))){
                $rows = $this->db->select('*')->from('estimate_items')->where(array('es_id'=>$row['es_id'],'status !='=>0))->get()->result_array();
                if(empty($rows)){
                    $this->db->update('estimate',array('status'=>0),array('id'=>$row['es_id']));
                }
                $this->message->set('Estimate Item Deleted Successfully !!','s');
            }else{
                $this->message->set('Estimate Item could not be Deleted !!','e');
            }
        }
        redirect('estimate/add');
    }
    
    public function report()
    {
        $clients = $this->client->listing(array('status'=>1));
        $client_id=$estatus=""; $fdate=$edate=date('Y-m-d'); $estimates=array(); $args = array();
        if(isset($_POST['btn_get'])){
            $data = $this->input->post(NULL,true);
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['edate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['edate <='] = $edate;
            }
            if($data['estatus']!=''){
                $estatus = $data['estatus'];
                $args['conditions']['estatus'] = $estatus;
            }
        }
        
        $args['order_by'] = 'edate';
        $args['order'] = 'asc';
        
        $estimates = $this->estimate->get_report($args);
        
        if(empty($estimates)){
            $this->message->set('No Result Found !!','w');
        }
        
        if(!empty($estimates) && !isset($_POST['btn_get'])){ $fdate = $estimates[0]['edate']; }
        
        $this->template->title('Estimate');
        $this->template->main_heading('Estimate Report');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'estimates'=>$estimates));
        $this->template->render();
    }
    
    public function estimate_pdf(){ 
        $pdf_name = 'Estimate'; $pdf_contents = ''; $ptypes = array('0'=>'Product','1'=>'Service');
			 
		if(!$this->uri->segment(3)){
			echo "<script>alert('Invalid Estimate');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		
		$estimate_id = $this->uri->segment(3);
		
		$estimate_det = $this->estimate->get_all(array('conditions'=>array('e.id'=>$estimate_id)));

		if(empty($estimate_det)){
			echo "<script>alert('Invalid Estimate');window.close();</script>";
		}else{
		    $pdf_contents = $this->load->view('estimate/estimate_pdf',array('estimate_det'=>$estimate_det,'ptypes'=>$ptypes),true);
		} 
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function view(){
        $estimate_id = $this->uri->segment(3);
        
        $statuses = array('0'=>'Pending','1'=>'Invoice','2'=>'Rejected');
        $ptypes = array('0'=>'Product','1'=>'Service');
        $estimate_det = $this->estimate->get_all(array('conditions'=>array('e.id'=>$estimate_id)));
        
        if(empty($estimate_det)){
            $this->message->set('Invalid Estimate !!','w');
        }
        
        $this->template->title('Estimate');
        $this->template->main_heading('View Estimate');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/view',array('estimate_det'=>$estimate_det,'statuses'=>$statuses,'ptypes'=>$ptypes));
        $this->template->render();
    }
    
    public function delete(){
        $estimate_id = $this->uri->segment(3);
        $row = $this->db->select('*')->from('estimate')->where(array('id'=>$estimate_id,'status !='=>0))->get()->row_array();
        if(!empty($row)){
            if($this->db->update('estimate',array('status'=>0),array('id'=>$estimate_id))){
                $this->message->set('Estimate Deleted Successfully !!','s');
            }else{
                $this->message->set('Estimate could not be Deleted !!','e');
            }
        }else{
            $this->message->set('Invalid Estimate !!','w');
        }
        redirect('estimate/report');
    }
    
    public function reject(){
        $estimate_id = $this->uri->segment(3);
        
        $row = $this->db->select('*')->from('estimate')->where(array('id'=>$estimate_id,'status !='=>0))->get()->row_array();
        if(!empty($row)){
            if($this->db->update('estimate',array('estatus'=>2),array('id'=>$estimate_id))){
                $this->message->set('Estimate Rejected Successfully !!','s');
            }else{
                $this->message->set('Estimate could not be Rejected !!','e');
            }
        }else{
            $this->message->set('Invalid Estimate !!','w');
        }
        
        redirect('estimate/report');
    }
    
    public function invoice(){
        $estimate_id = $this->uri->segment(3);
        
        $statuses = array('0'=>'Pending','1'=>'Invoice');
        $ptypes = array('0'=>'Product','1'=>'Service');
        $estimate_det = $this->estimate->get_all(array('conditions'=>array('e.id'=>$estimate_id)));
        
        $row = $this->db->select_max('refno')->from('invoice')->get()->row_array();
        $refno = $row['refno']+1;
        if(empty($estimate_det)){
            $this->message->set('Invalid Estimate !!','w');
            redirect('estimate/report');
        }else{
            if(isset($_POST['btn_save'])){
                $data = $this->input->post(NULL,true);
                $row = $this->db->select_max('refno')->from('invoice')->get()->row_array();
                $invoice_array['idate'] = date('Y-m-d',strtotime($data['idate']));
                $invoice_array['refno'] = $refno;
                $invoice_array['es_id'] = $estimate_id;
                $invoice_array['client_id'] = $estimate_det[0]['client_id'];
                $invoice_array['branch_id'] = $estimate_det[0]['branch_id'];
                $inv_id = $this->product->insert('invoice',$invoice_array);
                if($inv_id){
                    foreach($estimate_det as $estimate){
                        $renew_date=''; 
                        if($estimate['validity']!='0' && $estimate['pay_type']!=''){ 
                            $duration = "+".$estimate['validity'].' '.$estimate['pay_type']; 
                            $renew_date = date('Y-m-d',strtotime($duration,strtotime($data['idate']))); 
                        }
                        $items_array=array();
                        $items_array['inv_id'] = $inv_id;
                        $items_array['ptype'] = $estimate['ptype'];
                        $items_array['product_id'] = $estimate['product_id'];
                        $items_array['cost'] = $estimate['cost'];
                        $items_array['renewal'] = $estimate['renewal'];
                        $items_array['validity'] = $estimate['validity'];
                        $items_array['pay_type'] = $estimate['pay_type'];
                        $items_array['renew_date'] = $renew_date;
                        $items_array['remark'] = $estimate['remark'];
                        
                        $inv_item = $this->product->insert('invoice_items',$items_array);
                        if($inv_item!='' && $estimate['validity']!='0' && $estimate['pay_type']!=''){
                            $row_check = $this->db->select('*')->from('expiry_notification')->where(array('client_id'=>$estimate_det[0]['client_id'],'branch_id'=>$estimate_det[0]['branch_id'],'product_id'=>$estimate['product_id'],'status'=>1))->get()->row_array();
                            if(empty($row_check)){
                                $this->product->insert('expiry_notification',array('client_id'=>$estimate_det[0]['client_id'],'branch_id'=>$estimate_det[0]['branch_id'],'inv_item_id'=>$inv_item,'product_id'=>$estimate['product_id'],'expiry_date'=>$renew_date,'amount'=>$estimate['renewal']));
                            }else{
                                $this->db->update('expiry_notification',array('inv_item_id'=>$inv_item,'expiry_date'=>$renew_date,'amount'=>$estimate['renewal']),array('id'=>$row_check['id']));
                            }
                        }
                    }
                    
                    $this->db->update('estimate',array('estatus'=>1),array('id'=>$estimate_id));
                    
                    $this->message->set('Invoice Generated Successfully !','s');
                }else{
                    $this->message->set('Invoice could not be Generated !','e');
                }
                redirect('estimate/report');
            }
        }
        
        $this->template->title('Invoice');
        $this->template->main_heading('New Invoice');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/invoice',array('estimate_det'=>$estimate_det,'statuses'=>$statuses,'ptypes'=>$ptypes,'refno'=>$refno,'estimate_id'=>$estimate_id));
        $this->template->render();
    }
    
    public function invoice_report(){
        $clients = $this->client->listing(array('status'=>1));
        $branch_id=$client_id=""; $fdate=$edate=date('Y-m-d'); $invoices=$product_ids=$arg1=$args=array();
        if(isset($_POST['btn_get'])){
            $data = $this->input->post(NULL,true);
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['i.client_id'] = $client_id;
                $arg1['conditions']['client_id'] = $client_id;
            }
            if($data['branch_id']!=''){
                $branch_id = $data['branch_id'];
                $args['conditions']['i.branch_id'] = $branch_id;
            }
            if(!empty($data['product_ids'])){
                $product_ids = $data['product_ids'];
                $product_str = implode(',',$product_ids);
                $args['where'] = "ii.product_id in ($product_str)";
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['i.idate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['i.idate <='] = $edate;
            }
        }
        
        $args['order_by'] = 'i.idate';
        $args['order'] = 'asc'; 
        
        $invoices = $this->estimate->get_all_invoice($args);
        $products = $this->product->product_list();
        $arg1['conditions']['status'] = 1;
        $branchs = $this->client->list_branch($arg1);
        if(empty($invoices)){
            $this->message->set('No Result Found !!','w');
        }
        
        if(!empty($invoices) && !isset($_POST['btn_get'])){ $fdate = $invoices[0]['idate']; }
        
        $this->template->title('Invoice');
        $this->template->main_heading('Invoice Report');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/invoice_report',array('clients'=>$clients,'client_id'=>$client_id,'products'=>$products,'product_ids'=>$product_ids,'fdate'=>$fdate,'edate'=>$edate,'invoices'=>$invoices,'branch_id'=>$branch_id,'branchs'=>$branchs));
        $this->template->render();
    }
    
    public function invoice_pdf(){ 
        $pdf_contents = ''; $ptypes = array('0'=>'Product','1'=>'Service');
			
		if(!$this->uri->segment(3)){
			echo "<script>alert('Invalid Invoice');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		$invoice_id = $this->uri->segment(3);
		$invoice_det = $this->estimate->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        $pdf_name = 'Invoice'.$invoice_id; 
        
        if(empty($invoice_det)){
			echo "<script>alert('Invalid Invoice');window.close();</script>";
		}else{
		    $pdf_contents = $this->load->view('estimate/invoice_pdf',array('invoice_det'=>$invoice_det,'ptypes'=>$ptypes),true);
		}
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function edit_invoice(){
        $invoice_id = $this->uri->segment(3);
        $ptypes = array('0'=>'Product','1'=>'Service');
        $invoice_det = $this->estimate->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        
        if(empty($invoice_det)){
            $this->message->set('Invalid Invoice !!','w');
        }
        
        if(isset($_POST['btn_update'])){
            $data = $this->input->post(NULL,true);
            if($this->db->update('invoice',array('idate'=>$data['idate']),array('id'=>$invoice_det[0]['iid']))){
                foreach($invoice_det as $details){ $invid = $details['id'];
                    $renew_date = '';
                    if($data["validity$invid"]!='0' && $data["pay_type$invid"]!=''){
                        $duration = "+".$data["validity$invid"].' '.$data["pay_type$invid"]; 
                        $renew_date = date('Y-m-d',strtotime($duration,strtotime($data['idate'])));
                    }
                    if($this->db->update('invoice_items',array('validity'=>$data["validity$invid"],'pay_type'=>$data["pay_type$invid"],'renewal'=>$data["renewal$invid"],'renew_date'=>$renew_date),array('id'=>$invid))){
                        if($data["validity$invid"]!='0' && $data["pay_type$invid"]!=''){
                            $row_check = $this->db->select('*')->from('expiry_notification')->where(array('inv_item_id'=>$invid,'status'=>1))->get()->row_array();
                            if(!empty($row_check)){
                                $this->db->update('expiry_notification',array('expiry_date'=>$renew_date,'amount'=>$data["renewal$invid"]),array('id'=>$row_check['id']));
                            }else{
                                $row_check2 = $this->db->select('*')->from('expiry_notification')->where(array('client_id'=>$invoice_det[0]['client_id'],'branch_id'=>$invoice_det[0]['branch_id'],'product_id'=>$details['product_id'],'status'=>1))->get()->row_array();
                                if(empty($row_check2)){
                                    $this->product->insert('expiry_notification',array('client_id'=>$invoice_det[0]['client_id'],'branch_id'=>$invoice_det[0]['branch_id'],'inv_item_id'=>$invid,'product_id'=>$details['product_id'],'expiry_date'=>$renew_date,'amount'=>$data["renewal$invid"]));
                                }else{
                                    $this->db->update('expiry_notification',array('inv_item_id'=>$invid,'expiry_date'=>$renew_date,'amount'=>$data["renewal$invid"]),array('id'=>$row_check2['id']));
                                }
                            }
                        }
                    }
                }
            }
            redirect('estimate/invoice_report');
        }
        
        $pay_types = $this->product->payment_type_list();
        $pay_types[''] = 'Not Applicable';
        
        $this->template->title('Invoice');
        $this->template->main_heading('View Invoice');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/edit_invoice',array('invoice_id'=>$invoice_id,'invoice_det'=>$invoice_det,'ptypes'=>$ptypes,'pay_types'=>$pay_types));
        $this->template->render();
    }
    
    public function view_invoice(){
        $invoice_id = $this->uri->segment(3);
        $ptypes = array('0'=>'Product','1'=>'Service');
        $invoice_det = $this->estimate->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        
        if(empty($invoice_det)){
            $this->message->set('Invalid Invoice !!','w');
        }
        
        $this->template->title('Invoice');
        $this->template->main_heading('View Invoice');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/view_invoice',array('invoice_det'=>$invoice_det,'ptypes'=>$ptypes));
        $this->template->render();
    }
    
    public function delete_invoice(){
        $invoice_id = $this->uri->segment(3);
        $row = $this->db->select('*')->from('invoice')->where(array('id'=>$invoice_id,'status !='=>0))->get()->row_array();
        if(!empty($row)){
            $estimate_id = $row['es_id'];
            if($this->db->update('invoice',array('status'=>0),array('id'=>$invoice_id))){
                $this->db->update('estimate',array('estatus'=>0),array('id'=>$estimate_id));
                $this->message->set('Invoice Deleted Successfully !!','s');
            }else{
                $this->message->set('Invoice could not be Deleted !!','e');
            }
        }else{
            $this->message->set('Invalid Invoice !!','w');
        }
        redirect('estimate/invoice_report');
    }
    
    public function payment(){
        $invoice_id = $this->uri->segment(3);
        $nid=0;
        $ptypes = array('0'=>'Product','1'=>'Service');
        $invoice_det = $this->estimate->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        $payment_modes = $this->general->payment_modes();
        
        $billnum = 1;
        $row_billnum = $this->db->select_max('bllno_id')->from('invoice_payments')->get()->row_array();
        if(!empty($row_billnum)) {
            $billnum += $row_billnum['bllno_id'];
        }
        
        if(empty($invoice_det)){
            $this->message->set('Invalid Invoice !!','w');
        }else{
            if(isset($_POST['btn_save'])){
                $data = $this->input->post(NULL,true);
                if(!empty($data['posted'])){
                    $row = $this->db->select_max('refno')->from('invoice_payments')->get()->row_array();
                    $refno = $row['refno']+1;
                    $pdate = date('Y-m-d',strtotime($data['pdate']));
                    $s=$data['bill_no']; 
                    preg_match("/([0-9]+)/", $s, $matches);
                    $bllno = $matches[1];
                    $pay_array = array('pdate'=>$pdate,'refno'=>$refno,'bill_no'=>$data['bill_no'],'bllno_id'=>$bllno,'client_id'=>$invoice_det[0]['client_id'],'branch_id'=>$invoice_det[0]['branch_id'],'pmode'=>$data['pmode'],'remark'=>$invoice_det[0]['remark']);
                    $pay_id = $this->product->insert('invoice_payments',$pay_array);
                    if($pay_id){
                        $total=0; 
                        foreach($data['posted'] as $item_id){
                            $item_array = array();
                            $item_array['pay_id'] = $pay_id;
                            $item_array['inv_id'] = $item_id;
                            $item_array['product_id'] = $data["product$item_id"];
                            $item_array['amount'] = $data["amount$item_id"];
                            
                            $total += $data["amount$item_id"];
                            
                            $this->product->insert('invoice_payment_items',$item_array);
                            
                            $due = $this->estimate->get_due($item_id);
                            if($due<=0){
                                $this->db->update('invoice_items',array('payment_status'=>1),array('id'=>$item_id));
                            }
                        }
                        
                        $nid++;
			            $voucher_array= array();
                        $voucher_array['group_id'] = $this->general->get_group_id('vouchers');
                        $voucher_array['vtype_id'] = 2;
                        $voucher_array['vno'] = $refno;
                        $voucher_array['vorder_no'] = $nid;
                        $voucher_array['vdate'] = $pdate;
                        $voucher_array['dr_ledger'] = $data['pmode'];
                        $voucher_array['cr_ledger'] = 27;
                        $voucher_array['vamount'] = $total;
                        $voucher_array['table_name'] = 'invoice_payments';
                        $voucher_array['table_id'] = $pay_id;
                        $voucher_array['status'] = 1;
                        $this->product->insert('vouchers',$voucher_array);
                    }
                    redirect('estimate/invoice_report');
                }else{
                    $this->message->set('Select atleast one item from the list !!','w');
                }
            }
        }
        
        $this->template->title('Invoice');
        $this->template->main_heading('Invoice Payment');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/payment',array('invoice_det'=>$invoice_det,'ptypes'=>$ptypes,'invoice_id'=>$invoice_id,'payment_modes'=>$payment_modes,'billnum'=>$billnum));
        $this->template->render();
    }
    
    public function payment_report(){
        $clients = $this->client->listing(array('status'=>1));
        $branch_id='';$client_id=""; $fdate=$edate=date('Y-m-d'); $estimates=array(); $arg1=$args = array();
        if(isset($_POST['btn_get'])){
            $data = $this->input->post(NULL,true);
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
                $arg1['conditions']['client_id'] = $client_id;
            }
            if($data['branch_id']!=''){
                $branch_id = $data['branch_id'];
                $args['conditions']['branch_id'] = $branch_id;
                
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['pdate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['pdate <='] = $edate;
            }
        }
        $arg1['conditions']['status'] = 1;
        $branchs = $this->client->list_branch($arg1);
        $args['order_by'] = 'bllno_id';
        $args['order'] = 'asc';
        
        $payments = $this->estimate->get_payment_report($args);
        
        if(empty($payments)){
            $this->message->set('No Result Found !!','w');
        }
        
        if(!empty($payments) && !isset($_POST['btn_get'])){ $fdate = $payments[0]['pdate']; }
        
        $this->template->title('Payment');
        $this->template->main_heading('Payment Report');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/payment_report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'payments'=>$payments,'branch_id'=>$branch_id,'branchs'=>$branchs));
        $this->template->render();
    }
    
    public function payment_pdf(){ 
        $pdf_contents = ''; $ptypes = array('0'=>'Product','1'=>'Service');
			
		if(!$this->uri->segment(3)){
			echo "<script>alert('Invalid Payment');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		
		$payment_id = $this->uri->segment(3);
		$payment_det = $this->estimate->get_all_payment(array('conditions'=>array('p.id'=>$payment_id)));
		$pdf_name = 'Receipt'.$payment_id; 
		
		if(empty($payment_det)){
			echo "<script>alert('Invalid Payment');window.close();</script>";
		}else{
		    $pdf_contents = $this->load->view('estimate/payment_pdf',array('payment_det'=>$payment_det,'ptypes'=>$ptypes),true);
		} 
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function view_payment(){
        $payment_id = $this->uri->segment(3);
        $payment_det = $this->estimate->get_all_payment(array('conditions'=>array('p.id'=>$payment_id)));
        
        if(empty($payment_det)){
            $this->message->set('Invalid Payment !!','w');
        }
        
        $this->template->title('Payment');
        $this->template->main_heading('View Payment');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/view_payment',array('payment_det'=>$payment_det));
        $this->template->render();
    }
    
    public function delete_payment(){
        $payment_id = $this->uri->segment(3);
        $row = $this->db->select('*')->from('invoice_payments')->where(array('id'=>$payment_id,'status !='=>0))->get()->row_array();
        if(!empty($row)){
            if($this->db->update('invoice_payments',array('status'=>0),array('id'=>$payment_id))){
                $rows1 = $this->db->select('*')->from('invoice_payment_items')->where(array('pay_id'=>$payment_id,'status !='=>0))->get()->result_array();
                foreach($rows1 as $row1){
                    $this->db->update('invoice_payment_items',array('status'=>0),array('id'=>$row1['id']));
                    $this->db->update('invoice_items',array('payment_status'=>0),array('id'=>$row1['inv_id']));
                }
                $this->db->update('vouchers',array('status'=>0),array('table_name'=>'invoice_payments','table_id'=>$payment_id));
                
                $this->message->set('Invoice Deleted Successfully !!','s');
            }else{
                $this->message->set('Invoice could not be Deleted !!','e');
            }
        }else{
            $this->message->set('Invalid Invoice !!','w');
        }
        
        redirect('estimate/payment_report');
    }
    
    public function due_report()
    {
        $clients = $this->client->listing(array('status'=>1));
        $client_id=""; $fdate=$edate=date('Y-m-d'); $invoices=array(); $args = array();
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['i.client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['i.idate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['i.idate <='] = $edate;
            }
        }
        
        $invoices = $this->estimate->get_invoice_due_report($args);
        
        if(empty($invoices))
        {
            $this->message->set('No Result Found !!','w');
        }
        
        if(!empty($invoices) && !isset($_POST['btn_get'])){ $fdate = $invoices[0]['idate']; }
        
        $this->template->title('Invoice');
        $this->template->main_heading('Due Report');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/due_report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'invoices'=>$invoices));
        $this->template->render();
    }
    
    public function expiry_report()
    {
        $client_id=""; $edate=date('Y-m-d'); $product_ids=$invoices=$args=$expiries=array();
        
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if(!empty($data['product_ids'])){
                $product_ids = $data['product_ids'];
                $product_str = implode(',',$product_ids);
                $args['where'] = "product_id in ($product_str)";
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['expiry_date <'] = $edate;
            }
        }
        
        $args['order_by'] = 'expiry_date';
        $args['order'] = 'asc';
        $expiries = $this->estimate->get_expiry_report($args);
        
        if(empty($expiries))
        {
            $this->message->set('No Result Found !!','w');
        }
        
        $clients = $this->client->listing(array('status'=>1));
        $products = $this->product->product_list();
        
        $this->template->title('Expiry');
        $this->template->main_heading('Expiry Report');
        $this->template->slice('cms/message');
        $this->template->slice('estimate/expiry_report',array('clients'=>$clients,'client_id'=>$client_id,'products'=>$products,'product_ids'=>$product_ids,'edate'=>$edate,'expiries'=>$expiries));
        $this->template->render();
    }
    
    public function rejected_report()
    {
       $clients = $this->client->listing(array('status'=>1));
       $client_id=$estatus=""; $fdate=$edate=date('Y-m-d'); $estimates=array(); $args = array(); 
       if(isset($_POST['btn_get'])){
            
         $data = $this->input->post(NULL,true);
         if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['edate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['edate <='] = $edate;
            }
            
                $args['conditions']['estatus'] = 2;
           
            $args['order_by'] = 'edate';
            $args['order'] = 'asc';
            
            $estimates = $this->estimate->get_report($args);
            
            if(empty($estimates)){
                $this->message->set('No Result Found !!','w');
            }
            
            if(!empty($estimates) && !isset($_POST['btn_get'])){ $fdate = $estimates[0]['edate']; }
            
       }
       $this->template->title('Rejected Estimate');
       $this->template->main_heading('Rejected Estimate Report');
       $this->template->slice('cms/message');
       $this->template->slice('estimate/rejected_report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'estimates'=>$estimates));
       $this->template->render(); 
        
    }
    
}
?>