<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

    class Lead_excel extends MY_Controller{

    	public function __construct(){
    
    		parent ::__construct();
    		
    		$utype = $this->session->userdata('utype'); 
            $uid = $this->session->userdata('uid');
                
            $this->load->model('lead/lead_model','lead');
            $this->load->model('users/user_model','user');
            $this->load->library('my_excel');
    	}
    	
    	public function sample()
	    {
	        $this->my_excel->set_title('Lead Sample');
			$line = 1;
			$this->my_excel->set_column_width('A',15);
			$this->my_excel->set_cell_value('A'.$line,'Date');
			$this->my_excel->set_column_width('B',35);
			$this->my_excel->set_cell_value('B'.$line,'Name');
			$this->my_excel->set_column_width('C',25);
			$this->my_excel->set_cell_value('C'.$line,'Location');			
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Mobile');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Landline');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Whatsapp');
			$this->my_excel->set_column_width('G',25);
			$this->my_excel->set_cell_value('G'.$line,'Email');
			$this->my_excel->set_column_width('H',25);			
			$this->my_excel->set_cell_value('H'.$line,'Website');
			$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Source');
			$this->my_excel->set_column_width('J',20);			
			$this->my_excel->set_cell_value('J'.$line,'Assigned To');
			$this->my_excel->set_column_width('K',15);			
			$this->my_excel->set_cell_value('K'.$line,'Status');
			$this->my_excel->set_column_width('L',15);			
			$this->my_excel->set_cell_value('L'.$line,'Date');
			$this->my_excel->set_column_width('M',25);			
			$this->my_excel->set_cell_value('M'.$line,'Remarks');
			$this->my_excel->set_column_width('N',15);			
			$this->my_excel->set_cell_value('N'.$line,'Date');
			$this->my_excel->set_column_width('O',25);			
			$this->my_excel->set_cell_value('O'.$line,'Remarks');
			$this->my_excel->set_column_width('P',15);			
			$this->my_excel->set_cell_value('P'.$line,'Date');
			$this->my_excel->set_column_width('Q',25);			
			$this->my_excel->set_cell_value('Q'.$line,'Remarks');
			
			$this->my_excel->set_bg_color_range('A'.$line,16);
			$this->my_excel->set_font_size('A'.$line.':'.'Q'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'Q'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'Q'.$line,'C');
			
			$this->my_excel->set_column_width('S',25);
			$this->my_excel->set_cell_value('S'.$line,'Staff Name');
			$this->my_excel->set_column_width('T',20);
			$this->my_excel->set_cell_value('T'.$line,'Status');
			$this->my_excel->set_data_align('S'.$line.':T'.$line,'C');
			$this->my_excel->set_bold('S'.$line.':T'.$line);
			$this->my_excel->set_bg_color_range('S'.$line,1);
			
			$line1=$line;
			$users = $this->user->get_all();
			foreach($users as $user)
			{
			    $line++;
			    $this->my_excel->set_cell_value('S'.$line,$user['fname']);
			}
			
			$lstatus_list = $this->lead->lstatus_list();
			foreach($lstatus_list as $lstatus)
			{
			    $line1++;
			    $this->my_excel->set_cell_value('T'.$line1,$lstatus);
			}
			
			$this->my_excel->output_excel();
	    }
	    
	    public function assigned_report()
	    {
	        $uri_array = $this->uri->uri_to_assoc(4);
	        $args = array(); 
	        $lstatuses = $this->lead->lstatuses(); $lstatuses[0] = array('remark'=>'Default','color'=>'#ffff'); ksort($lstatuses);
	        
	        if(isset($uri_array['sid']))
	        {
	            $args['conditions']['assigned_to'] = $uri_array['sid'];
	        }
	        if(isset($uri_array['ltype']))
	        {
	            $args['conditions']['ltype'] = $uri_array['ltype'];
	        }
	        if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
	        {
	            $fdate = date('Y-m-d',strtotime($uri_array['fdate']));
	            $tdate = date('Y-m-d',strtotime($uri_array['tdate']));
	            $args['between'] = "cdate between '$fdate' and '$tdate'";
	        }
	        if(isset($uri_array['status']))
	        {
	            $args['conditions']['lstatus'] = $uri_array['status'];
	        }
	        
	        $leads = $this->lead->get_all_leads($args);
	        if(!empty($leads))
            {
                $this->my_excel->set_title('Lead Assigned');
                $line = 5;
                $this->my_excel->set_column_width('A',15);
    			$this->my_excel->set_cell_value('A'.$line,'Date');
    			$this->my_excel->set_column_width('B',45);
    			$this->my_excel->set_cell_value('B'.$line,'Name');
    			$this->my_excel->set_column_width('C',25);
    			$this->my_excel->set_cell_value('C'.$line,'Location');			
    			$this->my_excel->set_column_width('D',20);
    			$this->my_excel->set_cell_value('D'.$line,'Mobile');
    			$this->my_excel->set_column_width('E',20);
    			$this->my_excel->set_cell_value('E'.$line,'Landline');
    			$this->my_excel->set_column_width('F',20);
    			$this->my_excel->set_cell_value('F'.$line,'Whatsapp');
    			$this->my_excel->set_column_width('G',40);
    			$this->my_excel->set_cell_value('G'.$line,'Email');
    			$this->my_excel->set_column_width('H',40);			
    			$this->my_excel->set_cell_value('H'.$line,'Website');
    			$this->my_excel->set_column_width('I',20);			
    			$this->my_excel->set_cell_value('I'.$line,'Source');
    			$this->my_excel->set_column_width('J',20);			
    			$this->my_excel->set_cell_value('J'.$line,'Collected By');
    			$this->my_excel->set_column_width('K',20);			
    			$this->my_excel->set_cell_value('K'.$line,'Assigned To');
    			$this->my_excel->set_column_width('L',15);			
    			$this->my_excel->set_cell_value('L'.$line,'Status');
    			$this->my_excel->set_column_width('M',15);			
    			$this->my_excel->set_cell_value('M'.$line,'Date');
    			$this->my_excel->set_column_width('N',45);			
    			$this->my_excel->set_cell_value('N'.$line,'Remarks');
    			$this->my_excel->set_column_width('O',15);			
    			$this->my_excel->set_cell_value('O'.$line,'Date');
    			$this->my_excel->set_column_width('P',45);			
    			$this->my_excel->set_cell_value('P'.$line,'Remarks');
    			$this->my_excel->set_column_width('Q',15);			
    			$this->my_excel->set_cell_value('Q'.$line,'Date');
    			$this->my_excel->set_column_width('R',45);			
    			$this->my_excel->set_cell_value('R'.$line,'Remarks');
    			$this->my_excel->set_column_width('S',15);			
    			$this->my_excel->set_cell_value('S'.$line,'Date');
    			$this->my_excel->set_column_width('T',45);			
    			$this->my_excel->set_cell_value('T'.$line,'Remarks');
    			$this->my_excel->set_column_width('U',15);			
    			$this->my_excel->set_cell_value('U'.$line,'Date');
    			$this->my_excel->set_column_width('V',45);			
    			$this->my_excel->set_cell_value('V'.$line,'Remarks');
    			
    			$this->my_excel->set_bg_color_range('A'.$line,21);
    			$this->my_excel->set_font_size('A'.$line.':'.'V'.$line,12);
    			$this->my_excel->set_bold('A'.$line.':'.'V'.$line);
    			$this->my_excel->set_data_align('A'.$line.':'.'V'.$line,'C');
    			$this->my_excel->set_border('A'.$line.':'.'V'.$line);
    			
    			foreach($leads as $lead)
    			{
    			    $follow_det = $this->lead->follow_details($lead['id']);
    			    $line++;
    			    $this->my_excel->set_cell_value('A'.$line,dateFormat($lead['cdate']));
    			    $this->my_excel->set_cell_value('B'.$line,$lead['cname']);
    			    $this->my_excel->set_cell_value('C'.$line,$lead['location']);
    			    $this->my_excel->set_cell_value('D'.$line,$lead['mobile']);
    			    $this->my_excel->set_cell_value('E'.$line,$lead['landline']);
    			    $this->my_excel->set_cell_value('F'.$line,$lead['whatsapp']);
    			    $this->my_excel->set_cell_value('G'.$line,$lead['email']);
    			    $this->my_excel->set_cell_value('H'.$line,$lead['website']);
    			    $this->my_excel->set_cell_value('I'.$line,$lead['source']);
    			    $this->my_excel->set_cell_value('J'.$line,$this->user->get_username($lead['collected_by']));
    			    $this->my_excel->set_cell_value('K'.$line,$this->user->get_username($lead['assigned_to']));
    			    $this->my_excel->set_cell_value('L'.$line,$lstatuses[$lead['lstatus']]['remark']);
    			    
    			    $this->my_excel->set_data_align('A'.$line,'C');
    			    $this->my_excel->set_data_align('C'.$line.':'.'L'.$line,'C');
    			    
    			    $char = 'L';
    			    foreach($follow_det as $follow)
    			    {
    			        $char++;
    			        $this->my_excel->set_cell_value($char.$line,dateFormat($follow['pdate']));
    			        $this->my_excel->set_data_align($char.$line,'C');
    			        $char++;
    			        $this->my_excel->set_cell_value($char.$line,$follow['remarks']);
    			    }
    			    
    			    if($lead['lstatus']=='0'){ $rcolor="FFFFFF"; }
    			    else if($lead['lstatus']=='1'){ $rcolor="95BFFD"; }
    			    else if($lead['lstatus']=='2'){ $rcolor="FDF095"; }
    			    else if($lead['lstatus']=='3'){ $rcolor="9AFAAD"; }
    			    else if($lead['lstatus']=='4'){ $rcolor="FCB3B1"; }
    			    
    			    $this->my_excel->set_bg_color('A'.$line,21,$lstatuses[$lead['lstatus']]['color']);
    			    $this->my_excel->set_border('A'.$line.':'.'V'.$line);
    			}
    			
    			$this->my_excel->output_excel();
            }
            else
            {
            }
	    }
	    
    }
?>