<? if(!defined('BASEPATH')) exit('No direct script access allowed');

class Expense extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->library(array('general','to_words'));
        $this->load->model('expense/expense_model','expense');
	}

    public function add()
    {
        if(isset($_POST['btn_save'])){
            
            $data = $this->input->post(NULL,true);
            if(!empty($data['particulars'])){
                
                $expense_array = array();
                $expense_array['cdate'] = $data['cdate'];//date('Y-m-d');
                $expense_array['client'] = $data['client'];
                $expense_array['remarks'] = $data['remarks'];
                $expense_id = $this->expense->insert('expense',$expense_array);
                if($expense_id){
                    $st=0;
                    foreach($data['particulars'] as $key=>$value){
                        
                        $file_upload_error = TRUE; $attachment="";
                        if(!empty($_FILES['attachment']['name'][$key])){
            				$ext = pathinfo($_FILES['attachment']['name'][$key], PATHINFO_EXTENSION);
            				
            				$attachment = rand(0,1000)."expense".date('YmdHis').".".$ext;
            			
            				$config['upload_path'] =  FCPATH.'assets/files/expense/';
            				$config['allowed_types'] = '*';
            				$config['file_name'] = $attachment;
            				
            				$_FILES['file']['name'] = $_FILES['attachment']['name'][$key];
                            $_FILES['file']['type'] = $_FILES['attachment']['type'][$key];
                            $_FILES['file']['tmp_name'] = $_FILES['attachment']['tmp_name'][$key];
                            $_FILES['file']['error'] = $_FILES['attachment']['error'][$key];
                            $_FILES['file']['size'] = $_FILES['attachment']['size'][$key];
            				
            				$this->load->library('upload');
            				$this->upload->initialize($config);
            
            				if($this->upload->do_upload('file'))
            				{
            					$file_upload_error = FALSE;
            				}
            			}else{
            			    $file_upload_error = FALSE;
            			}
            			
                        if($file_upload_error == FALSE){
                            $item_array = array();
                            $item_array['expense_id'] = $expense_id;
                            $item_array['particulars'] = $value;
                            $item_array['amount'] = $data['amount'][$key];
                            $item_array['attachment'] = $attachment;
                            if($this->expense->insert('expense_items',$item_array)){ $st++; }  
                        }
                    }
                }
            }
            
            if($st>0){
                $this->message->set('Expense Added Successfully !!','s');
            }else{
                $this->message->set('Expense could not be Added !!','e');
            }
        }
        
        $this->template->title('Expense');
        $this->template->main_heading('Add Expense');
        $this->template->slice('cms/message');
        $this->template->slice('expense/add');
        $this->template->render();
    }
    
    public function report()
    {
        $fdate=$tdate=date('Y-m-d'); $status=''; $args=$expenses=array(); $statuses = array(''=>'Select','1'=>'Pending','2'=>'Approved','3'=>'Rejected');
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('fdate',true)))
            {
                $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['conditions']['e.cdate >='] = $fdate;
            }
            if(!empty($this->input->post('tdate',true)))
            {
                $tdate = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['conditions']['e.cdate <='] = $tdate;
            }
            if(!empty($this->input->post('status',true)))
            {
                $status = $this->input->post('status',true);   
                $args['conditions']['e.estatus'] = $status;
            }
        }
        
        $expenses = $this->expense->get_expenses($args);
        if(empty($expenses)){
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Expense');
        $this->template->main_heading('Expense Report');
        $this->template->slice('cms/message');
        $this->template->slice('expense/report',array('fdate'=>$fdate,'tdate'=>$tdate,'statuses'=>$statuses,'status'=>$status,'expenses'=>$expenses));
        $this->template->render();
        
    }
    
    public function my_expense()
    {
        $fdate=$tdate=date('Y-m-d'); $status=''; $args=$expenses=array(); $statuses = array(''=>'Select','1'=>'Pending','2'=>'Approved','3'=>'Rejected');
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('fdate',true)))
            {
                $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['conditions']['e.cdate >='] = $fdate;
            }
            if(!empty($this->input->post('tdate',true)))
            {
                $tdate = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['conditions']['e.cdate <='] = $tdate;
            }
            if(!empty($this->input->post('status',true)))
            {
                $status = $this->input->post('status',true);   
                $args['conditions']['e.estatus'] = $status;
            }
        }
        
        $args['conditions']['e.created_by'] = $this->uid;
        $expenses = $this->expense->get_expenses($args);
        if(empty($expenses)){
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Expense');
        $this->template->main_heading('My Expense Report');
        $this->template->slice('cms/message');
        $this->template->slice('expense/my_expense',array('fdate'=>$fdate,'tdate'=>$tdate,'statuses'=>$statuses,'status'=>$status,'expenses'=>$expenses));
        $this->template->render();
        
    }
    
    public function approve()
    {
        $expense_id = $this->uri->segment(3);
        $args=array(); $statuses = array('0'=>'Default','1'=>'Pending','2'=>'Approved','3'=>'Rejected'); $nid=0;
        $args['conditions']['e.id'] = $expense_id;
        $expense_det = $this->expense->get_all($args);
        $payment_modes = $this->general->payment_modes();
        
        if(empty($expense_det)){
            $this->message->set('Invalid Expense !!','w');
        }else{
            if(isset($_POST['btn_save'])){
                $data = $this->input->post(NULL,true);
                $pdate = date('Y-m-d',strtotime($data['pdate']));
                $pay_array = array('estatus'=>2,'pdate'=>$pdate,'pmode'=>$data['pmode']);
                    
                if($this->db->update('expense',$pay_array,array('id'=>$expense_id))){
                    $nid++;
                    $voucher_array= array();
                    $voucher_array['group_id'] = $this->general->get_group_id('vouchers');
                    $voucher_array['vtype_id'] = 1;
                    $voucher_array['vno'] = $expense_id;
                    $voucher_array['vorder_no'] = $nid;
                    $voucher_array['vdate'] = $pdate;
                    $voucher_array['dr_ledger'] = 28;
                    $voucher_array['cr_ledger'] = $data['pmode'];
                    $voucher_array['vamount'] = $data['total_amt'];
                    $voucher_array['table_name'] = 'expense';
                    $voucher_array['table_id'] = $expense_id;
                    $voucher_array['status'] = 1;
                    $this->expense->insert('vouchers',$voucher_array);
                }
                    
                redirect('expense/report');
            }
        }
        
        $this->template->title('Expense');
        $this->template->main_heading('Expense Approval');
        $this->template->slice('cms/message');
        $this->template->slice('expense/approve',array('expense_id'=>$expense_id,'expense_det'=>$expense_det,'statuses'=>$statuses,'payment_modes'=>$payment_modes));
        $this->template->render();
    }
    
    public function reject()
    {
        $expense_id = $this->uri->segment(3);
        if($expense_id){
            if($this->db->update("expense",array('estatus'=>3),array('id'=>$expense_id))){
                $this->message->set('Expense Rejected Successfully !!','s');
            }
        }
        redirect('expense/report');
    }
    
    public function delete()
    {
        $del_id = $this->uri->segment(3);
        if($del_id){
            if($this->db->update("expense",array('status'=>0),array('id'=>$del_id))){
                $this->db->update("vouchers",array('status'=>0),array('table_name'=>'expense','table_id'=>$del_id));
                
                $this->message->set('Expense Deleted Successfully !!','s');
            }
        }
        redirect('expense/report');
    }
    
    public function view()
    {
        $expense_id = $this->uri->segment(3);
        
        $args=array(); $statuses = array('0'=>'Default','1'=>'Pending','2'=>'Approved','3'=>'Rejected');
        $args['conditions']['e.id'] = $expense_id;
        $expense_det = $this->expense->get_all($args);
        
        if(empty($expense_det)){
            $this->message->set('Invalid Expense !!','w');
        }
        
        $this->template->title('Expense');
        $this->template->main_heading('View Expense');
        $this->template->slice('cms/message');
        $this->template->slice('expense/view',array('expense_id'=>$expense_id,'expense_det'=>$expense_det,'statuses'=>$statuses));
        $this->template->render();
    }
}