<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
class Feedback extends MY_Controller {
    
    public function __construct(){

        parent ::__construct();
        
        $this->load->model('client/client_model','client');
        
        require APPPATH. 'views/vendor/autoload.php';
    }
    
    public function cron(){
        $time = date('H:i:s');
        $from = date('10:00:00');
        $to = date('17:00:00');
        $year = date('Y',strtotime(date('Y-m')." -1 month"));
        $month = date('m',strtotime(date('Y-m')." -1 month"));
        if(strtotime($time) > strtotime($from) && strtotime($time) < strtotime($to)){
            $rows = $this->db->query("select id,name,url_soft from client_master where url_soft!='' and id not in (select client_id from client_feedback where month='$month' and year='$year' and status=1) and status=1")->result_array();
            if(!empty($rows)){
                foreach($rows as $row){ 
                    $options = array('cluster' => 'ap2', 'useTLS' => true);
                    $pusher = new Pusher\Pusher('b9921647655a7403bfa1', '0a258a44f5a3d087a211', '1502055', $options);
                    $data['cid'] = $row['id'];
                    $data['url'] = $row['url_soft'];
                    $pusher->trigger('feedback-channel', 'feedback-event', $data);
                }
            }
        }
    }
    
    public function getform(){
        $client_id = $this->input->get('cid');
        $criterias = $this->db->get_where('feedback_criteria',array('status'=>1))->result_array();
	    
	    $this->load->view('feedback/add',array('client_id'=>$client_id,'criterias'=>$criterias));
	}
	
	public function criterias(){
        $criterias = $this->db->get_where('feedback_criteria',array('status'=>1))->result_array();
	    
	    echo json_encode($criterias);
	}
	
	public function save(){
	    $data = $this->input->post(NULL,true);
	    
	    $row = $this->db->get_where('client_master',array('url_soft'=>$data['url']))->row_array();
	    if(!empty($row)){
	        $data['client_id'] = $row['id'];
    	    $data['year'] = date('Y',strtotime(date('Y-m')." -1 month"));
            $data['month'] = date('m',strtotime(date('Y-m')." -1 month"));
            if(!empty($data['posted'])){
                $data['posted'] = implode('@',$data['posted']);
            }
    	    $data['created_on'] = date('Y-m-d H:i:s');
    	    
    	    $row1 = $this->db->get_where('client_feedback',array('client_id'=>$row['id'],'month'=>$data['month'],'year'=>$data['year']))->row_array();
	        if(empty($row1)){
	            $this->db->insert('client_feedback',$data);
	        }
	    }
	    echo 'success';
	}
	
	public function report(){
	    $args = array();
        $args['conditions'] = array('status'=>1);
	    $clients = $this->client->listing($args);
	    $client=$month='';
	    $feedbacks = array();
	    if(isset($_POST['btn_get'])){
	        $conditions = array();
	        if($this->input->post('client')!=''){
	            $client = $this->input->post('client');
	            $conditions['f.client_id'] = $client;
	        }
	        if($this->input->post('month')!='' && $this->input->post('month')!='0000-00' && $this->input->post('month')!='1970-01'){
	            $month = $this->input->post('month');
	            $mdate = date('Y-m-01',strtotime($month));
	            $conditions['f.year'] = date('Y',strtotime($mdate));
                $conditions['f.month'] = date('m',strtotime($mdate));
	        }
	        $feedbacks = $this->db->select(array('c.name','f.*'))->from('client_feedback as f')->join('client_master as c','f.client_id=c.id')->where($conditions)->get()->result_array();
	    }
	    
	    $criterias = $this->client->criterias();
	    
	    $this->template->title('Feedback');
        $this->template->main_heading('Feedback Report');
        $this->template->slice('cms/message');
        $this->template->slice('feedback/report',array('clients'=>$clients,'client'=>$client,'month'=>$month,'feedbacks'=>$feedbacks,'criterias'=>$criterias));
        $this->template->render();
	}
	
	public function criteria(){
	    if(isset($_POST['btn_save'])){
	        $criteria = $this->input->post('criteria');
	        $row = $this->db->get_where('feedback_criteria',array('criteria'=>$criteria,'status'=>1))->row_array();
	        if(empty($row)){
	            if($this->db->insert('feedback_criteria',array('criteria'=>$criteria,'status'=>1))){
	                $this->message->set('Criteria Added Successfully !!','s');
	            }else{
	                $this->message->set('Criteria Could not be Added !!','e');
	            }
	        }else{
	            $this->message->set('Criteria already exist !!','e');
	        }
	    }
	    
	    $criterias = $this->client->criterias(array('status'=>1));
	    
	    $this->template->title('Feedback');
        $this->template->main_heading('Feedback Report');
        $this->template->slice('cms/message');
        $this->template->slice('feedback/criteria',array('criterias'=>$criterias));
        $this->template->render();
	}
	
	public function delete_criteria(){
	    $del_id = $this->uri->segment(3);
        if($del_id){
            if($this->db->update("feedback_criteria",array('status'=>0),array('id'=>$del_id))){
                $this->message->set('Criteria Deleted Successfully !!','s');
            }
        }
        redirect('feedback/criteria');
	}
}