<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Followup extends MY_Controller {

    public function __construct(){

			parent ::__construct();
			
			$utype = $this->session->userdata('utype'); 
            $uid = $this->session->userdata('uid');
            
            $this->load->model('client/client_model','client');
            $this->load->model('work/work_model','work');
            $this->load->model('followup/followup_model','followup');
	}
	
	public function add()
    {
        $client = ""; $works=array();$args1 = array();
        
        if(isset($_POST['btn_get']))
        {  
            $client = $this->input->post('client',true);
            
            $args = array();
            $args['conditions']['client_id'] = $client;
            $args['where'] = "wstatus !='2'";
            
            $works = $this->work->get_all($args);
        }
        
        if(isset($_POST['btn_save']))
        {  
            $file_upload_error = TRUE; $attach=""; $audio="";
            
            if(!empty($_FILES['wfile']['name']))
            {
				$ext = pathinfo($_FILES['wfile']['name'], PATHINFO_EXTENSION);
				
				$attach = rand(0,1000)."work".date('YmdHis').".".$ext;
			
				$config['upload_path'] =  FCPATH.'assets/files/work/followup_attachment/';
				$config['allowed_types'] = '*';
				$config['file_name'] = $attach;

				$this->load->library('upload');
				$this->upload->initialize($config);

				if(!$this->upload->do_upload('wfile'))
				{
					$file_upload_error = false;
				}
			}
			
			if(!empty($_FILES['waudio']['name']))
            {
				$ext = pathinfo($_FILES['waudio']['name'], PATHINFO_EXTENSION);
				
				$audio = rand(0,1000)."work".date('YmdHis').".".$ext;
			
				$config['upload_path'] =  FCPATH.'assets/files/work/followup_audio/';
				$config['allowed_types'] = '*';
				$config['file_name'] = $audio;

				$this->load->library('upload');
				$this->upload->initialize($config);

				if(!$this->upload->do_upload('waudio'))
				{
					$file_upload_error = false;
				}
			}

			if($file_upload_error == false)
			{
				$this->message->set('Invalid File','e');
			}
			else
			{
                $data = $this->input->post(NULL,true);
                
                $follow_array = array();
                $follow_array['pdate'] = $data['pdate'];
                $follow_array['person'] = $data['person'];
                $follow_array['contact_no'] = $data['contact_no'];
                $follow_array['attachment'] = $attach;
                $follow_array['audio'] = $audio;
                
                $follow_array['status'] = 1;
                
                $st=0;
                for($k=1;$k<=$data['no'];$k++)
    		    { 
    		        if(isset($_POST["aid$k"]))
    			    {
    			        $follow_array['work_id'] = $_POST["aid$k"];
    			        $follow_array['remarks'] = $_POST["remark$k"];
    			        
    		            if($this->followup->f_save('followup',$follow_array))
                        {
                            $st++;
                        }
    			    }   
                }
                $works1 = $this->work->get_pending_work($args1);
                foreach($works1 as $work)
                {
                    if($work['fcnt'] == '1')
                    {
                        $priority = 1;
                        $u_wrk_array = array();
                        $u_wrk_array['priority'] =$priority;
                       $this->db->update("works",$u_wrk_array,array('id'=>$work['id'])); 
                    }
                    else if($work['fcnt'] > '1')
                    {
                      $priority = 2; 
                      $u_wrk_array = array();
                      $u_wrk_array['priority'] =$priority;
                      $this->db->update("works",$u_wrk_array,array('id'=>$work['id']));
                    }
                    
                }
                if($st>0)
                {
                    $this->message->set('Followup Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('Followup could not be Added !!','e');
                }
            }
        }
        
        $args = array();
        $args['conditions'] = array('status'=>1);
        
        $clients = $this->client->listing($args);
        
        $this->template->title('Followup');
        $this->template->main_heading('Followup Add');
        $this->template->slice('cms/message');
        $this->template->slice('followup/add',array('clients'=>$clients,'client'=>$client,'works'=>$works));
        $this->template->render();
    }
    
    public function report()
    {
        $args = array(); $client = ""; $from_date = $to_date = "";
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('client',true)))
    		{
    		    $client = $this->input->post('client',true);
    		    $args['conditions']['client_id'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true)) && !empty($this->input->post('tdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
			    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    
			    $args['between'] = "pdate between '$from_date' and '$to_date'";
    		}
        }
        
        $followups = $this->followup->get_all($args);
        
        $clients = $this->client->listing(array());
        
        $this->template->title('Followup');
        $this->template->main_heading('Followup Report');
        $this->template->slice('followup/search',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date));
        $this->template->slice('followup/report',array('followups'=>$followups));
        $this->template->render();
    }
}