<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Lead extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('lead/lead_model','lead');
        $this->load->model('users/user_model','user');
        //$this->load->library(array('my_excel','encrypt','general'));
        $this->load->library(array('my_excel','general'));
	}

    public function add()
    {
        $uid = $this->session->userdata('uid');
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            $data['collected_by'] = $uid;
            if(!empty($data['assigned_to']))
            {
                $data['assigned_on'] = date('Y-m-d H:i:s');
            }
            
            $row1 = $this->db->select_max('refno')->from('lead_details')->get()->row_array();
            $data['refno'] = $row1['refno']+1;
            
            $row = $this->db->select('id')->from('lead_details')->where(array('cname'=>$data['cname'],'mobile'=>$data['mobile'],'status'=>1))->get()->row_array();
            if(empty($row))
            {
                if($this->lead->f_save('lead_details',$data))
                {
                    $this->message->set('Lead Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('Lead could not be Added !!','e');
                }
            }
            else
            {
                $this->message->set('Lead already Exist !!','w');
            }
        }
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select';
        $users = $this->user->listing(array());
        
        $this->template->title('Add Lead');
        $this->template->main_heading('Add Lead');
        $this->template->slice('cms/message');
        $this->template->slice('lead/add',array('ltypes'=>$ltypes,'users'=>$users));
        $this->template->render();
    }
    
    public function import()
    {
        $uid = $this->session->userdata('uid');
        $error_array = array();
        if(isset($_POST['btn_upload']))
        { 
		    $file_upload_error=TRUE; $filename=''; $inscnt=0;
			if(!empty($_FILES['cfile']['name']))
            {
                $ext = pathinfo($_FILES['cfile']['name'], PATHINFO_EXTENSION);
				
				$filename = rand(0,1000)."lead".date('YmdHis').".".$ext;
			
				$config['upload_path'] =  FCPATH.'assets/files/lead/';
				$config['allowed_types'] = 'xls|xlsx|csv';
				$config['file_name'] = $filename;

				$this->load->library('upload');
				$this->upload->initialize($config);

				if(!$this->upload->do_upload('cfile'))
				{
					$file_upload_error = false;
				}
			}
			
			if($file_upload_error == false)
			{
				$this->message->set('Invalid File','e');
			}
			else
			{
			    $ltype = $this->input->post('ltype',TRUE);
			    
			    $file = FCPATH."assets/files/lead/".$filename;
			    if (!empty($file) && file_exists($file))
				{ 
				    require_once APPPATH.'third_party/phpExcel/PHPExcel/IOFactory.php';
				    
				    $objPHPExcel = PHPExcel_IOFactory::load($file);
				    
				    $last_row = $objPHPExcel->getActiveSheet()->getHighestDataRow();
				    $i=2;

					$invalid_dates = array('','0000-00-00','1970-01-01','0','');
					
					$row = $this->db->select_max('refno')->from('lead_details')->get()->row_array();
                    $refno = $row['refno'];
					
					for($i=2;$i<=$last_row;$i++)
					{  
						$error_rows = array(); $data=array();
                        
                        $data['ltype'] = $ltype;
						$cdate = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getValue();
						$data['cdate'] = PHPExcel_Style_NumberFormat::toFormattedString($cdate, 'YYYY-MM-DD');
						$data['cname']  = Trim($objPHPExcel->getActiveSheet()->getCell('B'.$i)->getValue());
						$data['location']  = Trim($objPHPExcel->getActiveSheet()->getCell('C'.$i)->getValue());
						$data['mobile']  = Trim($objPHPExcel->getActiveSheet()->getCell('D'.$i)->getValue());
						$data['landline']  = Trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getValue());
						$data['whatsapp']  = Trim($objPHPExcel->getActiveSheet()->getCell('F'.$i)->getValue());
						$data['email']  = Trim($objPHPExcel->getActiveSheet()->getCell('G'.$i)->getValue());
						$data['website']  = Trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getValue());
						$data['source']  = Trim($objPHPExcel->getActiveSheet()->getCell('I'.$i)->getValue());
						$assign = Trim($objPHPExcel->getActiveSheet()->getCell('J'.$i)->getValue());
						$data['assigned_to']  = $this->user->get_user_by_name($assign);
						
						$lstatus = Trim($objPHPExcel->getActiveSheet()->getCell('K'.$i)->getValue());
						$lstatus = $this->lead->get_lstatus_id($lstatus);
						$data['lstatus']  = $lstatus;
						
						$data['assigned_on']  = date('Y-m-d H:i:s');
						$data['collected_by']  = $uid;
						
						$date1 = $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getValue();
						$date1 = PHPExcel_Style_NumberFormat::toFormattedString($date1, 'YYYY-MM-DD');
						$remark1 = Trim($objPHPExcel->getActiveSheet()->getCell('M'.$i)->getValue());
						$date2 = $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getValue();
						$date2 = PHPExcel_Style_NumberFormat::toFormattedString($date2, 'YYYY-MM-DD');
						$remark2 = Trim($objPHPExcel->getActiveSheet()->getCell('O'.$i)->getValue());
						$date3 = $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getValue();
						$date3 = PHPExcel_Style_NumberFormat::toFormattedString($date3, 'YYYY-MM-DD');
						$remark3 = Trim($objPHPExcel->getActiveSheet()->getCell('Q'.$i)->getValue());
						
						if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$data['cdate'])){
							$data['cdate']='';
						}
						if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date1)){
							$date1='';
						}
						if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date2)){
							$date2='';
						}
						if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date3)){
							$date3='';
						}
						
						if(in_array($data['cdate'],$invalid_dates) || empty($data['cname']))
						{
						    if(in_array($data['cdate'],$invalid_dates))
						    {
								$error_rows['cdate'] = 'Invalid Date';
							}
							if(empty($data['cname']))
							{
								$error_rows['cname'] = 'Invalid Name';
							}
						}
						else
						{
						    $refno++;
						    $data['refno'] = $refno;
						    $lead_id = $this->lead->f_save('lead_details',$data);
						    if($lead_id)
                            {
                                $inscnt++;
                                $last_date=''; $last_remark='';
                                if(!in_array($date1,$invalid_dates) && !empty($remark1))
                                {
                                    $this->lead->f_save('lead_progress',array('lead_id'=>$lead_id,'staff'=>$uid,'pdate'=>$date1,'remarks'=>$remark1));
                                    $last_date=$date1; $last_remark=$remark1;
                                }
                                if(!in_array($date2,$invalid_dates) && !empty($remark2))
                                {
                                    $this->lead->f_save('lead_progress',array('lead_id'=>$lead_id,'staff'=>$uid,'pdate'=>$date2,'remarks'=>$remark2));
                                    $last_date=$date2; $last_remark=$remark2;
                                }
                                if(!in_array($date3,$invalid_dates) && !empty($remark3))
                                {
                                    $this->lead->f_save('lead_progress',array('lead_id'=>$lead_id,'staff'=>$uid,'pdate'=>$date3,'remarks'=>$remark3));
                                    $last_date=$date3; $last_remark=$remark3;
                                }
                                
                                if($last_date!='' && $last_remark!='')
                                {
                                    $this->db->update('lead_details',array('last_date'=>$last_date,'last_remarks'=>$last_remark),array('id'=>$lead_id));
                                }
                            }
						}
						
						if(!empty($error_rows))
						{
						    $error_array[$i] = implode(" ,",$error_rows);
						}
					}
				}
				
				if($inscnt > 0)
				{
				    $this->message->set('Lead Imported Successfully !','s');
				}
				else
				{
				    $this->message->set('Lead couldnot be Imported !','e');
				}
			}
		}
        
        $ltypes = $this->lead->ltype_list();
        
        $this->template->title('Import Lead');
        $this->template->main_heading('Import Lead');
        $this->template->slice('cms/message');
        $this->template->slice('lead/import',array('ltypes'=>$ltypes,'error_array'=>$error_array));
        $this->template->render();
    }
    
    public function report(){
        $uri_array = $this->uri->uri_to_assoc(3);
        $args = array(); $ltype = ""; $from_date = $to_date = ""; $collected=""; $assigned=""; $status="select";
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('ltype',true))){
                $ltype = $this->input->post('ltype',true);
                $args['conditions']['ltype'] = $ltype;
            }
            if(!empty($this->input->post('fdate',true)) && !empty($this->input->post('tdate',true))){
                $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['between'] = "cdate between '$from_date' and '$to_date'";
            }
            if(!empty($this->input->post('collected',true))){
                $collected = $this->input->post('collected',true);
                $args['conditions']['collected_by'] = $collected;
            }
            if(!empty($this->input->post('assigned',true))){
                $assigned = $this->input->post('assigned',true);
                $args['conditions']['assigned_to'] = $assigned;
            }
            if(!empty($this->input->post('status',true))){
                $status = $this->input->post('status',true);
                if($status=='called'){
                    $args['conditions']['lstatus >'] = 1;
                }else{
                    $args['conditions']['lstatus'] = $status;
                }
            }
        }else if(!empty($uri_array)){
            if(isset($uri_array['ltype']) && $uri_array['ltype']!=''){
                $ltype = $uri_array['ltype'];
                $args['conditions']['ltype'] = $ltype;
            }
        }    
        
        if(isset($_POST['btn_save'])){
            $data = $this->input->post(NULL,true);
            $upd_array = array(); $cond_array = array();
            $upd_array['assigned_to'] = $data['staff_id'];
            $upd_array['assigned_on'] = date('Y-m-d H:i:s');
            $checklist = $data['checklist'];
            $st=0;
            foreach($checklist as $checked){
                $cond_array['id'] = $checked;
                if($this->db->update('lead_details',$upd_array,$cond_array)){
                    $st++;
                }
            }
            if($st>0){
                $this->message->set('Lead Assigned Successfully !!','s');
            }else{
                $this->message->set('Lead could not be Assigned !!','e');
            }
        }
        
        $count_array = $this->lead->get_count_by_status($args);
        
        $args1=$args2=$args;
        $args1['conditions']['last_remarks !='] = '';
        $args2['conditions']['last_remarks'] = '';
        $called = $this->lead->get_call_count($args1);
        $not_called = $this->lead->get_call_count($args2);
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select';
        $users = $this->user->listing();
        $lstatus_list = $this->lead->lstatus_list(); $lstatus_list[''] = 'Select'; $lstatus_list['called'] = 'Called'; ksort($lstatus_list);
        $lstatuses = $this->lead->lstatuses();
        
        $this->template->title('Lead Report');
        $this->template->main_heading('Lead Report');
        $this->template->slice('cms/message');
        $this->template->slice('lead/report',array('ltypes'=>$ltypes,'ltype'=>$ltype,'lstatuses'=>$lstatuses,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'collected'=>$collected,'assigned'=>$assigned,'lstatus_list'=>$lstatus_list,'status'=>$status,'users'=>$users,'ltypes'=>$ltypes,'count_array'=>$count_array,'called'=>$called,'not_called'=>$not_called));
        $this->template->render();
    }
    
    public function ajax_report(){
        $ltypes = $this->lead->ltype_list();
        $lstatuses = $this->lead->lstatuses();
        $list = $this->lead->get_report();
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $leads) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<div class="icheck-primary d-inline"><input type="checkbox" name="checklist[]" id="aid'.$leads->id.'" class="chksub" value="'.$leads->id.'"><label for="aid'.$leads->id.'"></label></div>';
            $row[] = $leads->refno;
            $row[] = dateFormat($leads->cdate);
            $row[] = $ltypes[$leads->ltype];
            $row[] = $leads->cname;
            $row[] = $leads->location;
            $row[] = $leads->mobile;
            $row[] = $leads->principal;
            $row[] = $leads->manager;
            $row[] = $leads->percentage;
            $row[] =   '<a href="'.base_url('lead/view/'.$leads->id).'" target="blank_"><i class="fas fa-search text-primary"></i></a>&nbsp;&nbsp;
                        <a href="'.base_url('lead/update/'.$leads->id).'" target="blank_"><i class="fas fa-pencil-alt text-success"></i></a>&nbsp;&nbsp;
                        <a href="'.base_url('lead/delete/'.$leads->id).'"><i class="fas fa-times text-danger"></i></a>';
            $row[] = $leads->whatsapp;
            $row[] = $leads->email;
            $row[] = $this->user->get_username($leads->collected_by);
            $row[] = $this->user->get_username($leads->assigned_to);
            $row[] = $leads->lstatus;
            $row[] = $lstatuses[$leads->lstatus]['color'];
            
            $data[] = $row;
        }
 
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->lead->count_all(),
            "recordsFiltered" => $this->lead->count_report_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }
    
    public function view(){
        $lead_id = $this->uri->segment(3);
        
        $lead_det=$follow_det=array();
        $status_array = $this->lead->lstatus_list();
        
        if($lead_id){
            $lead_det = $this->lead->lead_details($lead_id);
            $follow_det = $this->lead->follow_details($lead_id);
        }else{
            $this->message->set('Invalid Lead !!','e');
        }
        $ltypes = $this->lead->ltype_list();
        
        $this->template->title('View Lead');
        $this->template->main_heading('View Lead');
        $this->template->slice('cms/message');
        $this->template->slice('lead/view',array('lead_det'=>$lead_det,'follow_det'=>$follow_det,'ltypes'=>$ltypes,'status_array'=>$status_array));
        $this->template->render();
    }
    
    public function update(){
        $lead_id = $this->uri->segment(3);
        if($lead_id){
            $lead_det = $this->lead->lead_details($lead_id);
        }else{
            $this->message->set('Invalid Lead !!','e');
        }
        if(isset($_POST['btn_update'])){  
            $data = $this->input->post(NULL,true);
            unset($data['btn_update']);
            if($this->db->update('lead_details',$data,array('id'=>$lead_id))){
                $this->message->set('Lead Updated Successfully !!','s');
            }else{
                $this->message->set('Lead could not be Updated !!','e');
            }
        }
        
        $ltypes = $this->lead->ltype_list();
        $users = $this->user->listing();
        $status_array = $this->lead->lstatus_list(); $status_array[''] = 'Select'; ksort($status_array);
        
        $this->template->title('Edit Lead');
        $this->template->main_heading('Edit Lead');
        $this->template->slice('cms/message');
        $this->template->slice('lead/edit',array('lead_id'=>$lead_id,'lead_det'=>$lead_det,'ltypes'=>$ltypes,'users'=>$users,'status_array'=>$status_array));
        $this->template->render();
    }
    
    public function delete()
    {
        $lead_id = $this->uri->segment(3);
        
        if($this->db->update('lead_details',array('status'=>0),array('id'=>$lead_id)))
        {
            $this->message->set('Lead Deleted Successfully !!','s');
        }
        else
        {
            $this->message->set('Lead could not be Deleted !!','e');
        }
        
        redirect('lead/report');
    }
    
    public function assigned()
    {
        $args = array(); $count_array = array(); $ltype = ""; $from_date = $to_date = ""; $collected=""; $assigned=""; $status=""; $redirect="";
        
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('ltype',true))){
    		    $ltype = $this->input->post('ltype',true);
    		    $redirect .= '/ltype/'.$ltype;
    		    $args['conditions']['ltype'] = $ltype;
    		}
    		if(!empty($this->input->post('fdate',true))){
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
			    $redirect .= '/fdate/'.$from_date;
			    $args['conditions']['cdate >='] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true))){
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $redirect .= '/tdate/'.$to_date;
			    $args['conditions']['cdate <='] = $to_date;
    		}
    		if(!empty($this->input->post('collected',true))){
    		    $collected = $this->input->post('collected',true);
    		    $redirect .= '/collect/'.$collected;
    		    $args['conditions']['collected_by'] = $collected;
    		}
    		if(!empty($this->input->post('status',true))){
    		    $status = $this->input->post('status',true);
    		    $redirect .= '/status/'.$status;
    		    $args['conditions']['lstatus'] = $status;
    		}
        }
        
        $args1 = $args;
        $args1['assigned_to'] = $this->uid;
        $count_array = $this->lead->get_count_by_status($args1);
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select';
        $lstatus_list = $this->lead->lstatus_list(); $lstatus_list[''] = 'Select'; ksort($lstatus_list);
        $lstatuses = $this->lead->lstatuses();
        $users = $this->user->listing();
        
        $this->template->title('Lead Assigned');
        $this->template->main_heading('Lead Assigned');
        $this->template->slice('cms/message');
        $this->template->slice('lead/assigned',array('uid'=>$this->uid,'ltypes'=>$ltypes,'ltype'=>$ltype,'lstatuses'=>$lstatuses,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'collected'=>$collected,'lstatus_list'=>$lstatus_list,'status'=>$status,'users'=>$users,'ltypes'=>$ltypes,'count_array'=>$count_array,'redirect'=>$redirect));
        $this->template->render();
    }
    
    public function ajax_assigned_list()
    {
        $ltypes = $this->lead->ltype_list();
        $lstatuses = $this->lead->lstatuses();
        $list = $this->lead->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $leads) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $leads->refno;
            $row[] = dateFormat($leads->cdate);
            $row[] = $ltypes[$leads->ltype];
            $row[] = $leads->cname;
            $row[] = $leads->mobile;
            $row[] = '<a href="'.base_url('lead/followup/'.$leads->id).'" target="blank_"><i class="fas fa-plus-circle text-warning"></i></a>&nbsp;&nbsp;&nbsp;
                      <a href="'.base_url('lead/proposal/'.$leads->id).'" target="blank_"><i class="fas fa-file-alt text-secondary"></i></a>&nbsp;&nbsp;&nbsp;
                      <a href="'.base_url('lead/view/'.$leads->id).'" target="blank_"><i class="fas fa-search text-primary"></i></a>&nbsp;&nbsp;&nbsp;
                      <a href="'.base_url('lead/update/'.$leads->id).'" target="blank_"><i class="fas fa-pencil-alt text-success"></i></a>';
            $html_list = '<select onchange="setlstatus('.$leads->id.',this.value)" style="width:120px;">';
            foreach($lstatuses as $lid => $ldet){
                $lsel="";
                if($leads->lstatus == $lid){ $lsel = 'selected'; }
                $html_list .= '<option value="'.$lid.'" '.$lsel.' >'.$ldet['remark'].'</option>';
            }
            $html_list .= '</select>';
            $row[] = $html_list;
            $row[] = $leads->percentage;
            $remaining = $this->getDateDifference($leads->deadline);
            $row[] = $remaining;
            $row[] = '<input type="text" value="'.$leads->principal.'" onblur="update_principal('.$leads->id.',this.value);" style="width:120px;">';
            $row[] = '<input type="text" value="'.$leads->manager.'" onblur="update_manager('.$leads->id.',this.value);" style="width:120px;">';
            $row[] = $leads->location;
            $row[] = dateFormat($leads->last_date);
            $row[] = $leads->last_remarks;
            $row[] = $leads->whatsapp;
            $row[] = $leads->email;
            $row[] = $this->user->get_username($leads->collected_by);
            $row[] = $leads->lstatus;
            $row[] = $lstatuses[$leads->lstatus]['color'];
            
            $data[] = $row;
        }
 
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->lead->count_all(),
            "recordsFiltered" => $this->lead->count_filtered(),
            "data" => $data,
        );
        
        //output to json format
        echo json_encode($output);
    }
    
    function getDateDifference($date){
        $remain="";
        if($date!=null && $date!=''){
            if($date >= date('Y-m-d H:i:s')){
                $currentDate = new DateTime();
                $givenDate = new DateTime($date);
                $interval = $currentDate->diff($givenDate);
                if($interval->days >= 1){
                    $remain = $interval->days.' day(s)';
                }else{
                    $hours = $interval->h;
                    $minutes = $interval->i;
                    $remain = $hours.' Hr : '.$minutes.' Min';
                }
            }else{
                $remain = "Exceeded";
            }
        }
        
        return $remain;
    }
    
    public function freport()
    {
        $args=array(); $ltype=$user=""; $from_date=$to_date=date('Y-m-d');
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('ltype',true)))
    		{
    		    $ltype = $this->input->post('ltype',true);
    		    $args['conditions']['l.ltype'] = $ltype;
    		}
    		if(!empty($this->input->post('fdate',true)) && !empty($this->input->post('tdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));
    		}
    		if(!empty($this->input->post('user',true)))
    		{
    		    $user = $this->input->post('user',true);
    		    $args['conditions']['p.created_by'] = $user;
    		}
        }
        
        if($this->utype == '5' || $this->utype == '6'){
            $args['conditions']['p.created_by'] = $this->uid;
        }
        
        $args['between'] = "p.pdate between '$from_date' and '$to_date'";
        
        $followups = $this->lead->get_followups($args);
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select'; ksort($ltypes);
        $users = $this->user->listing();
        $lstatuses = $this->lead->lstatuses(); $lstatuses[0] = array('remark'=>'Default','color'=>'#ffff');
        
        $this->template->title('Followup Report');
        $this->template->main_heading('Followup Report');
        $this->template->slice('cms/message');
        $this->template->slice('lead/freport',array('ltypes'=>$ltypes,'ltype'=>$ltype,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$user,'followups'=>$followups,'lstatuses'=>$lstatuses));
        $this->template->render();
    }
    
    public function proposal()
    {
        $lead_id = $this->uri->segment(3);
        
        $lead_det=array();
        if($lead_id)
        {
            $lead_det = $this->lead->lead_details($lead_id);
            
            $error_array = array();
            if(isset($_POST['btn_save']))
            {
    		    $file_upload_error=TRUE; $filename='';
    			if(!empty($_FILES['document']['name']))
                {
                    $ext = pathinfo($_FILES['document']['name'], PATHINFO_EXTENSION);
    				
    				$filename = rand(0,1000)."proposal".date('YmdHis').".".$ext;
    			
    				$config['upload_path'] =  FCPATH.'assets/files/lead_proposal/';
    				$config['allowed_types'] = 'doc|docx|pdf';
    				$config['file_name'] = $filename;
    
    				$this->load->library('upload');
    				$this->upload->initialize($config);
    
    				if(!$this->upload->do_upload('document'))
    				{
    					$file_upload_error = false;
    				}
    			}
    			
    			if($file_upload_error == false)
    			{
    				$this->message->set('Invalid File','e');
    			}
    			else
    			{
    			    $data = $this->input->post(NULL,true);
    			    unset($data['btn_save']);
    			    
    			    $row = $this->db->select_max('ref_no')->from('lead_proposal')->get()->row_array();
                    $data['ref_no'] = $row['ref_no']+1;
    			    $data['lead_id'] = $lead_id;
    			    $data['document'] = $filename;
    			    
    			    if($this->lead->f_save('lead_proposal',$data))
                    {
                        $this->message->set('Proposal Saved Successfully !!','s');
                    }
                    else
                    {
                        $this->message->set('Proposal could not be Saved !!','e');
                    }
    			}
            }
        }
        
        $states = $this->general->states_list();
        
        $this->template->title('Lead Proposal');
        $this->template->main_heading('Lead Proposal');
        $this->template->slice('cms/message');
        $this->template->slice('lead/proposal',array('lead_id'=>$lead_id,'lead_det'=>$lead_det,'states'=>$states));
        $this->template->render();
    }
    
    public function preport()
    {
        $args=array(); $ltype=$from_date=$to_date=$state="";
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('ltype',true)))
    		{
    		    $ltype = $this->input->post('ltype',true);
    		    $args['conditions']['l.ltype'] = $ltype;
    		}
    		if(!empty($this->input->post('fdate',true)) && !empty($this->input->post('tdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['between'] = "p.cdate between '$from_date' and '$to_date'";
    		}
    		if(!empty($this->input->post('state',true)))
    		{
    		    $state = $this->input->post('state',true);
    		    $args['conditions']['p.state'] = $state;
    		}
        }
        
        $proposals = $this->lead->get_proposals($args);
        
        $states = $this->general->states_list();
        $states[''] = 'Select'; ksort($states);
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select'; ksort($ltypes);
        
        $this->template->title('Proposal Report');
        $this->template->main_heading('Proposal Report');
        $this->template->slice('cms/message');
        $this->template->slice('lead/preport',array('ltypes'=>$ltypes,'ltype'=>$ltype,'fdate'=>$from_date,'tdate'=>$to_date,'states'=>$states,'state'=>$state,'proposals'=>$proposals));
        $this->template->render();
    }
    
    public function proposal_delete()
    {
        $pid = $this->uri->segment(3);
        
        if($this->db->update('lead_proposal',array('status'=>0),array('id'=>$pid)))
        {
            $this->message->set('Proposal Deleted Successfully !!','s');
        }
        else
        {
            $this->message->set('Proposal could not be Deleted !!','e');
        }
        
        redirect('lead/preport');
    }
    
    public function set_sstatus()
    {
        $lid = $this->input->post('lid');
        $sstatus = $this->input->post('rid');
        
        $this->db->update('lead_details',array('software_status'=>$sstatus),array('id'=>$lid));
    }
    
    public function set_lstatus()
    {
        $lid = $this->input->post('lid');
        $lstatus = $this->input->post('rid');
        
        $this->db->update('lead_details',array('lstatus'=>$lstatus),array('id'=>$lid));
    }
    
    public function set_percentage()
    {
        $lid = $this->input->post('lid');
        $perc = $this->input->post('perc');
        
        $this->db->update('lead_details',array('percentage'=>$perc),array('id'=>$lid));
    }
    
    public function save_follow(){
        $lid = $this->input->post('lid');
        if($lid){
            $sstatus = $this->input->post('sstatus');
            $deadline = $this->input->post('deadline');
            $lstatus = $this->input->post('lstatus');
            $percentage = $this->input->post('percentage');
            
            if($this->db->update('lead_details',array('software_status'=>$sstatus,'deadline'=>$deadline,'lstatus'=>$lstatus,'percentage'=>$percentage),array('id'=>$lid))){
                $this->message->set('Lead Updated Successfully !!','s');
            }
            
            redirect('lead/followup/'.$lid);
        }
    }
    
    public function update_principal()
    {
        $lid = $this->input->post('lid');
        $phone = $this->input->post('str');
        
        $this->db->update('lead_details',array('principal'=>$phone),array('id'=>$lid));
    }
    
    public function update_manager()
    {
        $lid = $this->input->post('lid');
        $phone = $this->input->post('str');
        
        $this->db->update('lead_details',array('manager'=>$phone),array('id'=>$lid));
    }
    
    public function followup()
    {
        $lead_id = $this->uri->segment(3);
        $uid = $this->session->userdata('uid');
        $lead_det=$follow_det=array();
        $status_array = $this->lead->lstatus_list(); ksort($status_array);
        
        if($lead_id)
        {
            $lead_det = $this->lead->lead_details($lead_id);
            $follow_det = $this->lead->follow_details($lead_id);
        }
        else
        {
            $this->message->set('Invalid Lead !!','e');
        }
        
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            
            $data['lead_id'] = $lead_id;
            $data['staff'] = $uid;
            
            if(!empty($data['pdate']) && !empty($data['remarks']))
            {
                if($this->lead->f_save('lead_progress',$data))
                {
                    $this->db->update('lead_details',array('last_date'=>$data['pdate'],'last_remarks'=>$data['remarks'],'followup_date'=>$data['fdate']),array('id'=>$lead_id));
                    $this->message->set('Followup Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('Followup could not be Added !!','e');
                }
            }
            redirect('lead/followup/'.$lead_id);
        }
        
        $ltypes = $this->lead->ltype_list();
        
        $this->template->title('Lead Followup');
        $this->template->main_heading('Lead Followup');
        $this->template->slice('cms/message');
        $this->template->slice('lead/followup',array('lead_id'=>$lead_id,'lead_det'=>$lead_det,'follow_det'=>$follow_det,'ltypes'=>$ltypes,'status_array'=>$status_array));
        $this->template->render();
    }
    
    public function ltype()
    {
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            
            $row = $this->db->select('id')->from('lead_types')->where('ltype_name',$data['ltype_name'])->get()->row_array();
            if(empty($row))
            {
                if($this->lead->f_save('lead_types',$data))
                {
                    $this->message->set('Lead Type Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('Lead Type could not be Added !!','e');
                }
            }
            else
            {
                $this->message->set('Lead Type already Exist !!','e');
            }
        }
        
        $ltypes = $this->lead->ltype_list();
        
        $args1=$args2=array();
        $args1['conditions']['last_remarks !='] = '';
        $args2['conditions']['last_remarks'] = '';
        $called = $this->lead->call_count_by_ltype($args1);
        $not_called = $this->lead->call_count_by_ltype($args2);
        
        $this->template->title('Lead Type');
        $this->template->main_heading('Lead Type');
        $this->template->slice('cms/message');
        $this->template->slice('lead/lead_type',array('ltypes'=>$ltypes,'called'=>$called,'not_called'=>$not_called));
        $this->template->render();
    }
    
    public function ltype_delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        
        $row = $this->db->select('id')->from('lead_details')->where('ltype',$del_id)->get()->row_array();
        if(empty($row))
        {
            if($this->db->update("lead_types",array('status'=>0),array('id'=>$del_id)))
            {
                $this->message->set('Lead Type Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Lead Type could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Lead Type could not be Deleted !!','w');
        }
        
        redirect('lead/ltype');
    }
    
    public function lstatus()
    {
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            
            $row = $this->db->select('id')->from('lead_status')->where('remark',$data['remark'])->get()->row_array();
            if(empty($row))
            {
                if($this->lead->f_save('lead_status',$data))
                {
                    $this->message->set('Lead Status Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('Lead Status could not be Added !!','e');
                }
            }
            else
            {
                $this->message->set('Lead Status already Exist !!','e');
            }
        }
        
        $lstatuses = $this->lead->lstatuses();
        
        $this->template->title('Lead Status');
        $this->template->main_heading('Lead Status');
        $this->template->slice('cms/message');
        $this->template->slice('lead/lead_status',array('lstatuses'=>$lstatuses));
        $this->template->render();
    }
    
    public function lstatus_update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $upd_id = $uri_array['id'];
        
        $lstatus_det = $this->db->select('*')->from('lead_status')->where('id',$upd_id)->get()->row_array();
        
        if(isset($_POST['btn_update']))
        {
            $data = $this->input->post(NULL,true);
            unset($data['btn_update']);
            
            if($this->db->update('lead_status',$data,array('id'=>$upd_id)))
            {
                $this->message->set('Lead Status Update Successfully !!','s');
            }
            else
            {
                $this->message->set('Lead Status could not be Updated !!','e');
            }
            
            redirect('lead/lstatus');
        }
        
        $this->template->title('Lead Status');
        $this->template->main_heading('Update Lead Status');
        $this->template->slice('cms/message');
        $this->template->slice('lead/update_lstatus',array('lstatus_det'=>$lstatus_det,'upd_id'=>$upd_id));
        $this->template->render();
    }
    
    public function lstatus_delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        
        $row = $this->db->select('id')->from('lead_details')->where('lstatus',$del_id)->get()->row_array();
        if(empty($row))
        {
            if($this->db->update("lead_status",array('status'=>0),array('id'=>$del_id)))
            {
                $this->message->set('Lead Status Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Lead Status could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Lead Status could not be Deleted !!','w');
        }
        
        redirect('lead/lstatus');
    }
}
?>