<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledger_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		
		$this->load->library('accounts');
		$this->load->model('accounts/ledger_report/ledger_report_model','ledger');
	}

	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); 
		$vouchers_array = array(); $ledger_id = $dc = $sub_group_id = ""; $opening_bal = 0;

		$breadcrumb = array($this->lang->line('account-reports') => 'no_link',$this->lang->line('ledgers') => 'no_link');
		$breadcrumb_url = $tbp = "";

		if(isset($_POST['btn_search']))
		{
			$ledger_id = $this->input->post('ledger_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
		}

		if(!empty($ledger_id) && !empty($from_date) && !empty($to_date))
		{
			$dc = $this->accounts->get_dc($ledger_id);

			$vouchers_array = array();
			
			$vouchers = $this->ledger->getVouchers($ledger_id,$from_date,$to_date);
			
			if(!empty($vouchers))
			{ 
				foreach($vouchers as $key => $value)
				{ 
					$vouchers_array[$value['group_id']] = $this->ledger->getVoucherBill1($value['group_id'],$ledger_id); 
					$vamount = $this->ledger->getBillAmount($value['group_id'],$ledger_id);
					$dr_amount = $cr_amount = 0;
					if($dc == 'dr')
					{
						$bill_amount = ($vamount['dr_amount'] - $vamount['cr_amount']);
						if($bill_amount > 0)
						{
							$dr_amount = $bill_amount;
						}
						elseif($bill_amount < 0){
							$cr_amount = -$bill_amount;
						}
					}
					else{
						$bill_amount = ($vamount['cr_amount'] - $vamount['dr_amount']);
						if($bill_amount > 0){
							$cr_amount = $bill_amount;
						}
						elseif($bill_amount < 0){
							$dr_amount = -$bill_amount;
						}
					}
					if($vouchers_array[$value['group_id']]['dr_ledger'] == $ledger_id){
					    
						$particular_id = $vouchers_array[$value['group_id']]['cr_ledger'];
					}
					else{
					    
						$particular_id = $vouchers_array[$value['group_id']]['dr_ledger'];
					}
					$ledger_name = $this->accounts->get_ledger_name($particular_id);
					$vouchers_array[$value['group_id']]['ledger_name'] = $ledger_name;
					$vouchers_array[$value['group_id']]['dr_amount'] = $dr_amount;
					$vouchers_array[$value['group_id']]['cr_amount'] = $cr_amount;
				}
			}

			$opening_bal = $this->accounts->opening_bal($ledger_id,$from_date);
			$open_voucher_bal = $this->accounts->voucher_bal($ledger_id,$from_date);
			if($dc == 'dr'){
				$opening_bal += ($open_voucher_bal['dr_amount'] - $open_voucher_bal['cr_amount']);
			}
			else{
				$opening_bal += ($open_voucher_bal['cr_amount'] - $open_voucher_bal['dr_amount']);
			}
		}
		
		$ledger_array = $this->accounts->get_legders();

		$ledger_array[''] = "Select";
		ksort($ledger_array);
		
		$this->template->title('Ledger Wise Report');
		$this->template->main_heading('Ledger Wise Report');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('account_reports/ledger_search',array('ledgers' => $ledger_array,'ledger_id' => $ledger_id,'from_date' => $from_date,'to_date' => $to_date));
		if(!empty($vouchers_array) || $opening_bal != 0)
		{
			$this->template->append('account_reports/ledgers',array('voucher_array' => $vouchers_array,'ledger_id' => $ledger_id,'sub_group_id' => $sub_group_id,'opening_bal' => $opening_bal,'dc' => $dc,'tbp' => $tbp));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('cms/message');
		$this->template->render();
	}
}