<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledgers extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		
		$this->load->model('accounts/ledger_model','ledger');
		$this->load->library('accounts');
	}

 	public function add()
	{
		$this->form_validation->set_rules('ledger_name','lang:ledger-name','required|xss_clean|max_length[128]|callback_ledger_exists');
		$this->form_validation->set_rules('sgroup_id','lang:under','required|xss_clean');
		$this->form_validation->set_rules('open_amount','lang:opening-balance','xss_clean|numeric|greater_or_equal[0]|less_than[10000000000000]');
		$this->form_validation->set_rules('dc_type','lang:dc','required|xss_clean');
		$this->form_validation->set_rules('description','lang:description','xss_clean');

		if($this->form_validation->run() === TRUE)
		{
			$data_ledger['ledger_name'] = $this->input->post('ledger_name',TRUE);
			$data_ledger['sgroup_id'] = $this->input->post('sgroup_id',TRUE);
			$data_ledger['dc'] = $this->ledger->get_dc($data_ledger['sgroup_id']);
			$data_ledger['description'] = $this->input->post('description',TRUE);
		
			$last_insert_id = $this->ledger->insert('ledgers',$data_ledger);
			if($last_insert_id)
			{
				if(!empty($this->input->post('open_amount',TRUE)))
				{
					$open_amount = $this->input->post('open_amount',TRUE);
					if($this->input->post('dc_type',TRUE) != $data_ledger['dc'])
					{
						$open_amount = -$open_amount;
					}
					
					$this->ledger->insert('ledger_open_bals',array('branch_id' => $this->session->userdata('under_id'),'ledger_id' => $last_insert_id,'open_amount' => $open_amount,'open_date' => $this->dms->get_fiscal_year()['start_date']));
				}
				$this->message->set($this->lang->line('ledger-add-success'));
			}
			else
			{
				$this->message->set($this->lang->line('ledger-add-error'));
			}
			redirect('ledgers/add');
		}
		
		$sub_groups = $this->ledger->get_sub_groups(1);
		$dc_array = array('dr' => 'Dr','cr' => 'Cr');

		$this->template->title('Add New Ledger');
		$this->template->main_heading('Add Ledger');
		$this->template->breadcrumb(array('Ledgers'=>'no_link','Report'=>'ledgers/report'));
		$this->template->slice('cms/message');
		$this->template->slice('ledgers/add',array('sub_groups' => $sub_groups,'dc_array' => $dc_array));
		$this->template->render();
	}

	public function update()
	{
		#----------ledger primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$ledger_id = $uri_array['id'];
			unset($uri_array['id']);

			#------------ledger details
			$row = $this->ledger->get(array('columns' => array('a.sub_group','b.id','b.company_id','b.ledger_name','b.sgroup_id','b.dc','b.description'),'conditions' => array('b.id'=>$ledger_id,'b.sgroup_id !=' => 15,'b.sgroup_id !=' => 23)));
			if(empty($row)){redirect('ledgers/report');}
			else
			{
				$ledger = $row[0];
				$disabled = "disabled";$msg_status = 0;
				$dc = $ledger['dc'];

				#-------------accounts library
				$this->load->library('accounts');

				#-------------validation
				if($ledger['company_id'] > 0)
				{
					$disabled = "";
					$this->form_validation->set_rules('ledger_name','lang:ledger-name',"required|xss_clean|max_length[128]|callback_ledger_exists[$ledger_id]");
					$this->form_validation->set_rules('sgroup_id','lang:under','required|xss_clean');
				}
				$this->form_validation->set_rules('vat','lang:used-vat-return','required|xss_clean');
				$this->form_validation->set_rules('open_amount','lang:opening-balance','xss_clean|greater_or_equal[0]|less_than[10000000000000]');
				$this->form_validation->set_rules('dc_type','lang:dc','required|xss_clean');
				$this->form_validation->set_rules('description','lang:description','xss_clean');

				#------------save
				if($this->form_validation->run() === true)
				{
					if($ledger['company_id'] > 0)
					{
						$data_ledger['ledger_name'] = $this->input->post('ledger_name',true);
						if($ledger['sgroup_id'] != $this->input->post('sgroup_id',true))
						{
						//	if(!$this->ledger->check_ledger($ledger_id)){
								$data_ledger['sgroup_id'] = $this->input->post('sgroup_id',true);
								$data_ledger['dc'] = $this->ledger->get_dc($data_ledger['sgroup_id']);
								$dc = $data_ledger['dc'];
						//	}
						//	else{
						//		$msg_status = 1;
						//	}
						}
						$data_ledger['description'] = $this->input->post('description',true);
						$this->ledger->update(array('table' => 'dms_ledgers','data' => $data_ledger,'conditions' => array('id' => $ledger_id)));
					}
					$fscal_start_date = $this->dms->get_fiscal_year()['start_date'];
					$company_id = $this->session->userdata('company_id');
					$branch_id = $this->session->userdata('under_id');
					$open_amount = $this->input->post('open_amount',true);
					$vat = $this->input->post('vat',true);
					if(!empty($open_amount) || $vat  == 1)
					{
						if($open_amount > 0 && ($this->input->post('dc_type',true) != $dc))
						{
							$open_amount = -$open_amount;
						}
						$lob_id = $this->ledger->if_exist_open_bal(array('conditions' => array('branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_date' => $fscal_start_date)));
						if($lob_id)
						{
							$this->ledger->update(array('table' => 'dms_ledger_open_bals','data' => array('open_amount' => $open_amount,'vat' => $vat),'conditions' => array('id' => $lob_id)));
						}
						else
						{
							$this->ledger->insert('dms_ledger_open_bals',array('company_id' => $company_id,'branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_amount' => $open_amount,'open_date' => $fscal_start_date,'vat' => $vat));
						}
					}
					else
					{
						$this->ledger->update(array('table' => 'dms_ledger_open_bals','data' => array('status' => 0),'conditions' => array('branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_date' => $fscal_start_date)));
					}
					$this->message->set($this->lang->line('ledger-updated'));
					if($msg_status)
					{
						$this->message->set($this->lang->line('ledger-updated-sgroup-error'),'w');
					}
					redirect("ledgers/report/".$this->uri->assoc_to_uri($uri_array));
				}

				#------------sub group
				$sub_groups = $this->ledger->get_sub_groups();
				$dc_array = array('dr' => 'Dr','cr' => 'Cr');
				$ledger_open_array = $this->accounts->cur_open_bal($ledger_id,1);

				#------------template
				$this->template->title('Edit Ledger Details');
				$this->template->main_heading($this->lang->line('ledger-settings'));
				$this->template->breadcrumb(array($this->lang->line('ledgers')=>'ledgers/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'ledgers/report'));
				$this->template->slice('dms/message');
				$this->template->slice('ledgers/update',array('ledger_array' => $ledger,'ledger_open_array' => $ledger_open_array,'sub_groups' => $sub_groups,'dc_array' => $dc_array,'ledger_id' => $ledger_id,'disabled' => $disabled));
				$this->template->other_script('ledgers/ledger');
				$this->template->render();
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

 	public function report()
	{
		$conditions = array(); $sub_group = ""; $redirect = "";

		$uri_array  = $this->uri->uri_to_assoc(3);

	    if($this->input->post('sub_group_id',true))
		{
			$sub_group = $this->input->post('sub_group_id',true);
			$conditions = array('b.sgroup_id'=>$sub_group);
			$redirect .= '/sg/'.$sub_group;
		}
		elseif(isset($uri_array['sg']))
		{
			$sub_group = $uri_array['sg'];
			$conditions = array('b.sgroup_id'=>$sub_group);
			$redirect .= '/sg/'.$sub_group;
		}

		$ledgers = $this->ledger->get(array('conditions' => $conditions,'order_by' => 'b.ledger_name','order' => 'asc'));

		$sub_groups = $this->ledger->get_sub_groups();

		$this->template->title('Ledger Reports');
		$this->template->main_heading('Ledger Reports');
		$this->template->breadcrumb(array($this->lang->line('ledgers')=>'ledgers/add',$this->lang->line('report')=>'no_link'));
		$this->template->slice('ledgers/search',array('sub_groups'=>$sub_groups,'sub_group' =>$sub_group));
		$this->template->slice('cms/message');
		if(!empty($ledgers))
		{
			$this->template->slice('ledgers/report',array('ledgers'=>$ledgers,'redirect' => $redirect));
		}
		$this->template->render();
	}

 	public function delete()
 	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			$ledger = $this->ledger->get(array('columns' => array('b.id'),'conditions' => array('b.id'=>$id,'b.sgroup_id !=' => 15,'b.sgroup_id !=' => 23)));
			if(!empty($ledger))
			{
				if(!$this->ledger->check_ledger($id))
				{
					if(!$this->ledger->if_exist_open_bal(array('conditions' => array('ledger_id' => $id,'open_amount >' => 0))))
					{
						if($this->ledger->update(array('table' => 'ledgers','data' => array('status' => 0),'conditions' => array('id'=>$id))))
						{
							$this->message->set($this->lang->line('ledger-deleted'),'s');
						}
						else
						{
							$this->message->set($this->lang->line('ledger-not-deleted'),'e');
						}
					}
					else
					{
						$this->message->set($this->lang->line('ledger-open-bal-delete-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('ledger-delete-voucher-error'),'e');
				}
			}
		}
		redirect('ledgers/report/'.$this->uri->assoc_to_uri($uri_array));
	}
 	#-----------------------------------------------

 	public function ledger_exists($ledger_name,$ledger_id = NULL)
 	{
 		if($this->ledger->check_exists($ledger_name,$ledger_id)){
 			return false;
 		}
 		return true;
 	}
}
?>