<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mail extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
        
        $this->load->library('upload');
        $this->load->model('mail/mail_model','mail');
        $this->load->model('lead/lead_model','lead');
	}

    public function add(){
        if(isset($_POST['btn_save'])){
            $file_upload_error=true; $fileName = '';
            if(!empty($_FILES['attachment'])){
                $files = $_FILES;
                $fcount = count($_FILES['attachment']['name']);
                for($i=0; $i<$fcount; $i++){
                    $_FILES['attachment']['name'] = $files['attachment']['name'][$i];
                    $_FILES['attachment']['type'] = $files['attachment']['type'][$i];
                    $_FILES['attachment']['tmp_name'] = $files['attachment']['tmp_name'][$i];
                    $_FILES['attachment']['error'] = $files['attachment']['error'][$i];
                    $_FILES['attachment']['size'] = $files['attachment']['size'][$i];
                    //$ext = pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION);
                    $file_name = $_FILES['attachment']['name'];
                    
                    $config['upload_path'] =  FCPATH.'assets/files/mail/';
                    $config['allowed_types'] = '*';
                    $config['file_name'] = $file_name;
                    $this->upload->initialize($config);
                    if($this->upload->do_upload('attachment')){
                        $file_upload_error = false;
                        $fileName .= $file_name.'@@';
                    }
                }
            }
            
            if($file_upload_error){
				$this->message->set('Invalid File !!','e');
			}else{
                $data = array();
                $data['title'] = $this->input->post('title');
                $data['subject'] = $this->input->post('subject');
                $data['attachment'] = $fileName;
                $data['content'] = $this->input->post('content');
                
                $temp_id = $this->mail->f_save('mail_template',$data);
                if($temp_id){
                    $this->message->set('Template Saved Successfully !!','s');
                }else{
                    $this->message->set('Template could not be Saved !!','e');
                }
			}
			redirect('mail/add');
        }
        
        $this->template->title('Mail Template');
        $this->template->main_heading('New Template');
        $this->template->slice('cms/message');
        $this->template->slice('mail/add');
        $this->template->render();
    }
    
    public function report(){
        
        $templates = $this->mail->get_templates();
        
        $this->template->title('Mail Template');
        $this->template->main_heading('Mail Report');
        $this->template->slice('cms/message');
        $this->template->slice('mail/report',array('templates'=>$templates));
        $this->template->render();
    }
    
    public function update(){
        $template_id = $this->uri->segment(3);
        $template = $this->mail->get_template($template_id);
        
        if(isset($_POST['btn_update'])){
            $temp_id = $this->input->post('template_id');
            $temp_det = $this->mail->get_template($temp_id);
            
            $file_upload_error=false; $fileName = $temp_det['attachment'];
            if(!empty($_FILES['attachment'])){
                $files = $_FILES;
                $fcount = count($_FILES['attachment']['name']);
                for($i=0; $i<$fcount; $i++){
                    $_FILES['attachment']['name'] = $files['attachment']['name'][$i];
                    $_FILES['attachment']['type'] = $files['attachment']['type'][$i];
                    $_FILES['attachment']['tmp_name'] = $files['attachment']['tmp_name'][$i];
                    $_FILES['attachment']['error'] = $files['attachment']['error'][$i];
                    $_FILES['attachment']['size'] = $files['attachment']['size'][$i];
                    //$ext = pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION);
                    //$file_name = 'attachment'.$i.time().'.'.$ext;
                    $file_name = $_FILES['attachment']['name'];
                    
                    $config['upload_path'] =  FCPATH.'assets/files/mail/';
                    $config['allowed_types'] = '*';
                    $config['file_name'] = $file_name;
                    $this->upload->initialize($config);
                    if($this->upload->do_upload('attachment')){
                        $file_upload_error = false;
                        $fileName .= $file_name.'@@';
                    }
                }
            }
            
            if($file_upload_error){
				$this->message->set('Invalid File !!','e');
			}else{
                $data = array();
                $data['title'] = $this->input->post('title');
                $data['subject'] = $this->input->post('subject');
                $data['attachment'] = $fileName;
                $data['content'] = $this->input->post('content');
                
                if($this->db->update('mail_template',$data,array('id'=>$temp_id))){
                    $this->message->set('Template Updated Successfully !!','s');
                }else{
                    $this->message->set('Template could not be Updated !!','e');
                }
			}
			redirect('mail/report');
        }
        
        $this->template->title('Mail Template');
        $this->template->main_heading('Update Template');
        $this->template->slice('cms/message');
        $this->template->slice('mail/edit',array('template'=>$template));
        $this->template->render();
    }
    
    public function delete(){
        $template_id = $this->uri->segment(3);
        if($this->db->update('mail_template',array('status'=>0),array('id'=>$template_id))){
            $this->message->set('Template Deleted Successfully !!','s');
        }else{
            $this->message->set('Template could not be Deleted !!','e');
        }
        redirect('mail/report');
    }
    
    public function delete_doc(){
        $template_id = $this->uri->segment(3);
        if($this->db->update('mail_template',array('attachment'=>''),array('id'=>$template_id))){
            $this->message->set('Attachment Deleted Successfully !!','s');
        }else{
            $this->message->set('Attachment could not be Deleted !!','e');
        }
        redirect('mail/update/'.$template_id);
    }
    
    public function send_mail(){
        $args=$leads=array(); $ltype='';
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('ltype',true))){
                $ltype = $this->input->post('ltype',true);
                $args['conditions']['ltype'] = $ltype;
                $leads = $this->lead->get_all_leads($args);
            }
        }
        
        if(isset($_POST['btn_send'])){
            $data = $this->input->post(NULL,true);
            
            if($data['ltype_id']!='' && $data['template_id']!='' && !empty($data['posted'])){
                $ltype_id = $data['ltype_id'];
                $temp_id = $data['template_id'];
                
                $temp_det = $this->mail->get_template($temp_id); 
                
                $subject = $temp_det['subject'];
                $message = $temp_det['content'];
                $attachment = $temp_det['attachment'];
                
                $status=0;
                if($this->mail->add_to_queue($ltype_id, $temp_id, 'dileeshrelents@gmail.com', $subject, $message, $attachment)){
                    $status++;
                }
                if($this->mail->add_to_queue($ltype_id, $temp_id, 'relentsoftware@gmail.com', $subject, $message, $attachment)){
                    $status++;
                }
                
                foreach($data['posted'] as $csmails){
                    $emails = array_filter(preg_split('/[\s,]+/', $csmails)); //array_filter(explode(',', $csmails));
                    foreach($emails as $email){
                        if ($this->mail->add_to_queue($ltype_id, $temp_id, $email, $subject, $message, $attachment)){
                            $status++;
                        }
                    }
                }
                
                if($status>0){
                    $this->message->set('Mail Added to Queue !!', 's');
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, base_url('MailSending/index')); // replace with your controller/function URL
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 1);
                    curl_setopt($ch, CURLOPT_HEADER, 0);
                    curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        
                    // Execute cURL request without waiting for a response
                    curl_exec($ch);
                    curl_close($ch);
                    
                    redirect('MailSending/report');
                }else{
                    $this->message->set('Mail could not be Send !!', 'e');
                }
            }
        }
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select';
        $templates = $this->mail->template_list();
        
        $this->template->title('Send Mail');
        $this->template->main_heading('Send Mail');
        $this->template->slice('cms/message');
        $this->template->slice('mail/send',array('ltypes'=>$ltypes,'ltype'=>$ltype,'templates'=>$templates,'leads'=>$leads));
        $this->template->render();
    }
    
    public function mail_report(){
        $ltype=$template=$fdate=$tdate=''; $args=$mails=array();
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('ltype',true))){
                $ltype = $this->input->post('ltype',true);
                $args['conditions']['m.ltype_id'] = $ltype;
            }
            if(!empty($this->input->post('template',true))){
                $template = $this->input->post('template',true);
                $args['conditions']['m.template_id'] = $template;
            }
            if(!empty($this->input->post('fdate',true)) && $this->input->post('fdate',true)!='0000-00-00' && $this->input->post('fdate',true)!= '1970-01-01'){
                $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['conditions']['m.date >='] = $fdate;
            }
            if(!empty($this->input->post('tdate',true)) && $this->input->post('tdate',true)!='0000-00-00' && $this->input->post('tdate',true)!= '1970-01-01'){
                $tdate = date('Y-m-d',strtotime($this->input->post('tdate',true)));
                $args['conditions']['m.date <='] = $tdate;
            }
            $mails = $this->mail->get_mail_counts($args);
        }
        
        $ltypes = $this->lead->ltype_list();
        $ltypes[''] = 'Select';
        $templates = $this->mail->template_list();
        
        $this->template->title('Mail Template');
        $this->template->main_heading('Template Report');
        $this->template->slice('cms/message');
        $this->template->slice('mail/mails',array('ltypes'=>$ltypes,'ltype'=>$ltype,'templates'=>$templates,'template'=>$template,'fdate'=>$fdate,'tdate'=>$tdate,'mails'=>$mails));
        $this->template->render();
    }
    
    /*
    public function updates(){
        $mails = $this->db->select(array('id','recipient'))->from('mail_queue')->where('ltype_id',0)->limit(1000,0)->get()->result_array();
        foreach($mails as $mail){
            $mailid = $mail['recipient'];
            $lead = $this->db->select('ltype')->from('lead_details')->like('email',$mailid,'both')->get()->row_array();
            
            $this->db->update('mail_queue',array('ltype_id'=>$lead['ltype']),array('id'=>$mail['id']));
        }
        
    }*/
}