<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product extends MY_Controller {

    public function __construct(){

		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('product/product_model','product');
	}

    public function add(){
        
        if(isset($_POST['btn_save'])){  
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            $data['modules'] = implode('@@',$data['modules']);
            $data['status'] = 1;
            if($this->product->f_save('products',$data)){
                $this->message->set('Product Added Successfully !!','s');
            }else{
                $this->message->set('Product could not be Added !!','e');
            }
        }
        
        $modules = $this->db->get_where('modules',array('status'=>1))->result_array();
        
        $this->template->title('Product');
        $this->template->main_heading('Add Product');
        $this->template->slice('cms/message');
        $this->template->slice('product/add',array('modules'=>$modules));
        $this->template->render();
    }
    
    public function report(){
        
        $args = array();
        $products = $this->product->get_all($args);
        
        $this->template->title('Product');
        $this->template->main_heading('Product Report');
        $this->template->slice('product/report',array('products'=>$products));
        $this->template->render();
    }
    
    public function update(){
        
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        if(!empty($up_id)){
            $args = array();
            $args['conditions']['id'] = $up_id;
            $product = $this->product->get_all($args);
            
            if(isset($_POST['btn_update'])){  
                $data = $this->input->post(NULL,true);
                unset($data['btn_update']);
                $data['modules'] = implode('@@',$data['modules']);
                if($this->db->update("products",$data,array('id'=>$up_id))){
                    $this->message->set('Product Updated Successfully !!','s');
                }else{
                    $this->message->set('Product could not be Updated !!','e');
                }
                redirect('product/report');
            }
            
            $modules = $this->db->get_where('modules',array('status'=>1))->result_array();
            
            $this->template->title('Product');
            $this->template->main_heading('Product Update');
            $this->template->slice('cms/message');
            $this->template->slice('product/update',array('product'=>$product,'pid'=>$up_id,'modules'=>$modules));
            $this->template->render();
        }
    }
    
    public function delete(){
        
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        $this->db->update("products",array('status'=>0),array('id'=>$del_id));
        redirect('product/report');
    }
    
    public function module(){
        
        if(isset($_POST['btn_save'])){
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            $data['items'] = implode('@@',$data['items']);
            $row = $this->db->select('id')->from('modules')->where('name',$data['name'])->get()->row_array();
            if(empty($row)){
                if($this->product->f_save('modules',$data)){
                    $this->message->set('Module Added Successfully !!','s');
                }else{
                    $this->message->set('Module could not be Added !!','e');
                }
            }else{
                $this->message->set('Module already Exist !!','e');
            }
        }
        
        $products = $this->product->get_all(array());
        $modules = $this->db->get_where('modules',array('status'=>1))->result_array();
        
        $this->template->title('Modules');
        $this->template->main_heading('Modules');
        $this->template->slice('cms/message');
        $this->template->slice('product/module',array('products'=>$products,'modules'=>$modules));
        $this->template->render();
    }
    
    public function module_delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        
        $row = $this->db->select('id')->from('client_master')->where("modules like '%@$del_id@%'")->get()->row_array();
        if(empty($row))
        {
            if($this->db->update("modules",array('status'=>0),array('id'=>$del_id)))
            {
                $this->message->set('Module Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Module could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Module could not be Deleted !!','w');
        }
        
        redirect('product/module');
    }
}
?>