<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Profit_loss extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		
		$this->load->library('accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$expense_array = $income_array = $indirect_expense_array = $indirect_income_array = array();$dc = "";
		$gross_expense = $gross_income = $net_expense = $net_income = 0;
		
		if(isset($_POST['btn_search']))
		{
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
		}
		
		if(!empty($from_date) && !empty($to_date))
		{
			$next_date = date('Y-m-d',(strtotime($to_date)+86400));
			
			$opening_stock_bal = $opening_ledger_stock_bal = 0;			
			$opening_voucher_stock_bal = $this->accounts->voucher_bal(16,$from_date,1);//stock in hand voucher			
			
			$opening_stock = ($opening_voucher_stock_bal['dr_amount'] - $opening_voucher_stock_bal['cr_amount']) + $opening_ledger_stock_bal;
			if($opening_stock != 0)
			{
				$expense_array[16] = array('group_name' => $this->lang->line('openings'),'vamount' => $opening_stock);
			}
			$gross_expense += $opening_stock;
			
			#-----------closed stock
			$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$to_date,1,$from_date);//stock in hand voucher			
			
			$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']);	
			if($closed_stock != 0)
			{
				$income_array[16] = array('group_name' => $this->lang->line('closings'),'vamount' => $closed_stock);
			}
			$gross_income += $closed_stock;

			#-----------expense		
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
			foreach($account_groups as $key => $value)
			{			
				$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);											
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);												
				$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
				if($value['id'] != 12)
				{
					if($vamount > 0)
					{					
						$expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$gross_expense += $vamount;
					}
					elseif($vamount < 0)				
					{
						$vamount = -$vamount;
						$income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
						$gross_income += $vamount;
					}
				}
				else
				{
					if($vamount > 0)
					{					
						$indirect_expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$net_expense += $vamount;
					}
					elseif($vamount < 0)				
					{
						$vamount = -$vamount;
						$indirect_income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
						$net_income += $vamount;		
					}
				}
			}	
			
			#-----------income
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
			foreach($account_groups as $key => $value)
			{	
				$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);											
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);												
				$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
				if($value['id'] != 10)
				{
					if($vamount > 0)
					{					
						$income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$gross_income += $vamount;
					}
					elseif($vamount < 0)					
					{
						$vamount = -$vamount;
						$expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
						$gross_expense += $vamount;	
					}
				}
				else
				{
					if($vamount > 0)
					{					
						$indirect_income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$net_income += $vamount;
					}
					elseif($vamount < 0)					
					{
						$vamount = -$vamount;
						$indirect_expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$net_expense += $vamount;				
					}
				}
			}			
		}
		
		$this->template->title('Profit & Loss A/c');
		$this->template->main_heading('Profit & Loss A/c');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('profit-and-loss') => 'no_link'));
		$this->template->slice('account_reports/profit_loss_search',array('from_date' => $from_date,'to_date' => $to_date));
		if(!empty($expense_array) || !empty($income_array) || !empty($indirect_expense_array) || !empty($indirect_income_array))
		{
			$this->template->append('account_reports/profit_loss',array('expense_array' => $expense_array,'income_array' => $income_array,'indirect_expense_array' => $indirect_expense_array,'indirect_income_array' => $indirect_income_array,'gross_expense' => $gross_expense,'gross_income' => $gross_income,'net_expense' => $net_expense,'net_income' => $net_income,'from_date' => $from_date,'to_date' => $to_date));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('cms/message');
		$this->template->render();
	}
}