<? if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Proposal extends MY_Controller {
    
    public function __construct(){
        
		parent ::__construct();
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
        
        $this->load->model('product/product_model','product');
    }
    
    public function add(){
        
        if(isset($_POST['btn_save'])){
            $data = $this->input->post(NULL);
            if(!empty($data['modules'])){
                $data['modules'] = implode('@@',$data['modules']);
            }
            $descs = $data['description'];
            $costs = $data['cost'];
            $remarks = $data['remarks'];
            unset($data['description']);
            unset($data['cost']);
            unset($data['remarks']);
            unset($data['btn_save']);
            
            $pid = $this->product->f_save('proposal',$data);
            if($pid){
                $items=array();
                $items['proposal_id'] = $pid;
                foreach($descs as $key=>$value){
                    if($value!=''){
                        $items['description'] = $value;
                        $items['cost'] = $costs[$key];
                        $items['remarks'] = $remarks[$key];
                        
                        $this->product->f_save('proposal_items',$items);
                    }    
                }
                $this->message->set('Proposal Added Successfully !!','s');
            }else{
                $this->message->set('Proposal could not be Added !!','e');
            }
            redirect('proposal/add');
        }
        
        $products = $this->product->get_all(array());
        
        $this->template->title('Proposal');
        $this->template->main_heading('Proposal');
        $this->template->slice('cms/message');
        $this->template->slice('proposal/add',array('products'=>$products));
        $this->template->render();
    }
    
    public function report(){
        
        $fdate=$tdate=$product_id=''; $proposals=$args=array();
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('fdate',true)) && $this->input->post('fdate',true) != '0000-00-00' && $this->input->post('fdate',true) != '1970-01-01'){
                $fdate = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['date >='] = $fdate;
            }
            if(!empty($this->input->post('tdate',true)) && $this->input->post('tdate',true) != '0000-00-00' && $this->input->post('tdate',true) != '1970-01-01'){
                $tdate = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['date <='] = $tdate;
            }
            if(!empty($this->input->post('product_id',true))){
                $product_id = $this->input->post('product_id',true);
                $args['product'] = $product_id;
            }
        }
        $args['status'] = 1;
        $proposals = $this->db->get_where('proposal',$args)->result_array();
        $products = $this->product->get_all(array());
        
        $this->template->title('Proposal Report');
        $this->template->main_heading('Proposal Report');
        $this->template->slice('cms/message');
        $this->template->slice('proposal/report',array('fdate'=>$fdate,'tdate'=>$tdate,'products'=>$products,'product_id'=>$product_id,'proposals'=>$proposals));
        $this->template->render();
    }
    
    public function template(){
        
        if(isset($_POST['btn_update'])){
            $content = $this->input->post('content');
            if($this->db->update("proposal_template",array('content'=>$content),array('id'=>1))){
                $this->message->set('Template Updated Successfully !!','s');
            }else{
                $this->message->set('Template could not be Updated !!','e');
            }
        }
        
        $template = $this->db->get_where('proposal_template',array('id'=>1))->row_array();
        
        $this->template->title('Proposal Template');
        $this->template->main_heading('Proposal Template');
        $this->template->slice('cms/message');
        $this->template->slice('proposal/template',array('template'=>$template));
        $this->template->render();
    }
    
    
    public function prints(){
        $pid = $this->uri->segment(3);
        
        $proposal = $this->db->get_where('proposal',array('id'=>$pid))->row_array();
        $items = $this->db->get_where('proposal_items',array('proposal_id'=>$pid,'status'=>1))->result_array();
        $product = $this->db->get_where('products',array('id'=>$proposal['product']))->row_array();
        $modules = $this->db->from('modules')->where_in('id',explode('@@',$proposal['modules']))->get()->result_array();
        $template = $this->db->get_where('proposal_template',array('id'=>1))->row_array();
        
        $this->load->view('proposal/print',array('proposal'=>$proposal,'items'=>$items,'template'=>$template,'product'=>$product,'modules'=>$modules));
    }
    
    public function update(){
        $pid = $this->uri->segment(3);
        $proposal = $this->db->get_where('proposal',array('id'=>$pid))->row_array();
        $items = $this->db->get_where('proposal_items',array('proposal_id'=>$pid,'status'=>1))->result_array();
        
        if(isset($_POST['btn_update'])){
            $data = $this->input->post(NULL);
            if(!empty($data['modules'])){
                $data['modules'] = implode('@@',$data['modules']);
            }
            $descs = $data['description'];
            $costs = $data['cost'];
            $remarks = $data['remarks'];
            unset($data['description']);
            unset($data['cost']);
            unset($data['remarks']);
            unset($data['btn_update']);
            
            if($this->db->update('proposal',$data,array('id'=>$pid))){
                $this->db->update('proposal_items',array('status'=>0),array('proposal_id'=>$pid));
                $items=array();
                $items['proposal_id'] = $pid;
                foreach($descs as $key=>$value){
                    if($value!=''){
                        $items['description'] = $value;
                        $items['cost'] = $costs[$key];
                        $items['remarks'] = $remarks[$key];
                        
                        $this->product->f_save('proposal_items',$items);
                    }    
                }
                $this->message->set('Proposal Updated Successfully !!','s');
            }else{
                $this->message->set('Proposal could not be Updated !!','e');
            }
            redirect('proposal/report');
        }
        
        $products = $this->product->get_all(array());
        $modules = $this->db->get_where('modules',array('product_id'=>$proposal['product'],'status'=>1))->result_array();
        
        $this->template->title('Proposal');
        $this->template->main_heading('Update Proposal');
        $this->template->slice('cms/message');
        $this->template->slice('proposal/update',array('products'=>$products,'modules'=>$modules,'proposal'=>$proposal,'items'=>$items));
        $this->template->render();
    }
    
    public function delete(){
        $pid = $this->uri->segment(3);
        
        if($this->db->update('proposal',array('status'=>0),array('id'=>$pid))){
            $this->message->set('Proposal Deleted Successfully !!','s');
        }else{
            $this->message->set('Proposal could not be Deleted !!','e');
        }
        redirect('proposal/report');
    }
}