<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Server extends MY_Controller {

    public function __construct(){

			parent ::__construct();
			
			$utype = $this->session->userdata('utype'); 
            $uid = $this->session->userdata('uid');
            
            $this->load->model('server/server_model','server');
	}

    public function add()
    {
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true);
            unset($data['btn_save']);
            
            $data['status'] = 1;
            
            if($this->server->f_save('servers',$data))
            {
                $this->message->set('Server Added Successfully !!','s');
            }
            else
            {
                $this->message->set('Server could not be Added !!','e');
            }
        }
        
        $this->template->title('Server');
        $this->template->main_heading('Add Server');
        $this->template->slice('cms/message');
        $this->template->slice('server/add',array());
        $this->template->render();
    }
    
    public function report()
    {
        $args = array(); $stype = "";
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('stype',true)))
    		{
    		    $stype = $this->input->post('stype',true);
    		    $args['conditions']['stype'] = $stype;
    		}
        }
        
        $servers = $this->server->get_all($args);
        
        $stypes = array('0'=>'Linux','1'=>'Windows');
        
        $this->template->title('Server');
        $this->template->main_heading('Server Report');
        $this->template->slice('server/search',array('stypes'=>$stypes,'stype'=>$stype));
        $this->template->slice('server/report',array('servers'=>$servers));
        $this->template->render();
    }
    
    public function update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        
        if(!empty($up_id))
        {
            $args = array();
            $args['conditions']['id'] = $up_id;
            $server = $this->server->get_all($args);
            
            if(isset($_POST['btn_update']))
            {  
                $data = $this->input->post(NULL,true);
                unset($data['btn_update']);
                
                if($this->db->update("servers",$data,array('id'=>$up_id)))
                {
                    $this->message->set('Server Updated Successfully !!','s');
                }
                else
                {
                    $this->message->set('Server could not be Updated !!','e');
                }
                
                redirect('server/report');
            }
            
            $this->template->title('Server');
            $this->template->main_heading('Server Update');
            $this->template->slice('cms/message');
            $this->template->slice('server/update',array('server'=>$server,'sid'=>$up_id));
            $this->template->render();
        }
    }
    
    public function delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        
        $this->db->update("servers",array('status'=>0),array('id'=>$del_id));
        
        redirect('server/report');
    }  
}
?>