<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class User extends MY_Controller {
        
        public function __construct(){

			parent ::__construct();
			
			$utype = $this->session->userdata('utype'); 
            $uid = $this->session->userdata('uid');
            
            
            $this->load->model('users/user_model','user');
            $this->load->model('client/client_model','client');
            $this->load->model('work/work_model','work');
            $this->load->library(array('work_lib'));
	    }
                 
        public function index()
    	{
    	    $error="";
    	    $uri_array = $this->uri->uri_to_assoc(3);
    	    if(!empty($uri_array) && $uri_array['eid']!='')
    	    {
                $eid = $uri_array['eid'];
                if($eid=='1'){ $error = "Account blocked. Please contact Admin !"; }
                else if($eid=='2'){ $error = "Invalid Username or Password !"; }
    	    }
    	    $this->load->view('login',array('error'=>$error));
    	}
    
    	public function login()
    	{
	    	$username = $this->input->post('username',true);
	    	$password = $this->input->post('password',true);
	    	
			if((!empty($username)) && (!empty($password)))
			{
				$res = $this->db->select(array('l.user_id','l.user_type','u.bstatus'))->from('login as l')->join('users as u','l.user_id=u.id')->where(array('l.uname'=>$username,'l.ups_key'=>$password))->get()->row_array();
                if($res)
				{
				    if($res['bstatus']==0)
				    {
    				    $urid = $res['user_id'];
    				    $user_type = $res['user_type'];
    				    $newdata = array('uid'  => $urid,'utype'=> $user_type,'logged_in' => TRUE,'under_id'=>1);
                        $this->session->set_userdata($newdata);
                        redirect('user/home');
				    }else{
				        redirect('user/index/eid/1');
				    }
				}else{
				   redirect('user/index/eid/2'); 
				}
			}
			
			$user_type = $this->session->userdata('utype'); 
			$urid = $this->session->userdata('uid'); 
			$args = array();
            $works = $this->work->get_all_my_ongoing_works($args);
            
			$this->template->title('Home');
        	$this->template->main_heading('Dashboard');
        	$this->template->slice('user/home',array('user_id'=>$urid,'user_type'=>$user_type,'works'=>$works));
        	$this->template->render();
	    }
	    
	    public function home()
	    {
            $user_type = $this->session->userdata('utype'); 
            $urid = $this->session->userdata('uid'); 
            $args = array();
            $works = $this->work->get_all_my_ongoing_works($args);
            //header('Refresh: 10.2');
            $this->template->title('Home');
        	$this->template->main_heading($this->lang->line('welcome'));
        	$this->template->slice('user/home',array('user_id'=>$urid,'user_type'=>$user_type,'works'=>$works));
        	$this->template->render();
		}
	
		public function logout()
		{
			$this->session->sess_destroy();
			redirect('user/index');
		}
		
		public function add()
	    {
            if(isset($_POST['btn_save'])){  
                $file_upload_error=$file_upload_error1=$file_upload_error2=true; $fileName = ''; $imageName="user.jpg";$aadharName = '';
				if($_FILES['biodata']['name'] != ''){
				    $ext = pathinfo($_FILES['biodata']['name'], PATHINFO_EXTENSION);
					$fileName = time().'biodata'.'.'.$ext;
					
					$config['upload_path'] =  FCPATH.'assets/files/biodata/';
					$config['allowed_types'] = '*';
					$config['file_name'] = $fileName;
					$config['max_size']	= '10600';
                	$config['max_width']  = '10560';
                	$config['max_height']  = '21600';
					$this->load->library('upload');
					$this->upload->initialize($config);
					if($this->upload->do_upload('biodata')){
						$file_upload_error = false;
					}
				}
				else{
						$file_upload_error = false;
						$fileName = '';
					}
				if($_FILES['photo']['name'] != ''){
                    $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					$imageName = time().'photo'.'.'.$ext;
                					
                    $config['upload_path'] =  FCPATH.'assets/images/photos/';
                    $config['allowed_types'] = '*';
                    $config['max_size']	= '10600';
                	$config['max_width']  = '10560';
                	$config['max_height']  = '21600';
                    $config['file_name'] = $imageName;
                    $this->load->library('upload');
                    $this->upload->initialize($config);
                    					
                    if($this->upload->do_upload('photo')){
                    	$file_upload_error1 = false;
                    	$config['image_library'] = 'gd2';
                    	$config['source_image']	= $imageName;
                    	$config['create_thumb'] = TRUE;
                    	$config['maintain_ratio'] = false;
                    	$config['width']	= 2560;
                    	$config['height']	= 1600;
                    
                    	$this->load->library('image_lib', $config); 
                        $this->image_lib->resize();
                    }
                }
                else{
                	    $file_upload_error1 = false;
                	    $imageName='';
                    }
                  
                 if($_FILES['aadhar']['name'] != ''){ 
                  $ext = pathinfo($_FILES['aadhar']['name'], PATHINFO_EXTENSION);
                  $aadharName = time().'aadhar'.'.'.$ext;
                  $config['upload_path'] =  FCPATH.'assets/files/aadhar/';
                  $config['allowed_types'] = '*';
                  $config['file_name'] = $aadharName;
                  $config['max_size']	= '10600';
                  $config['max_width']  = '10560';
                  $config['max_height']  = '21600';
	              $this->load->library('upload');
	              $this->upload->initialize($config);
                  if($this->upload->do_upload('aadhar')){
                	$file_upload_error2 = false;
                	}
                     }
                    	else{
                    		$file_upload_error2 = false;
                    		$aadharName = '';
                    	}
                 
				  if($file_upload_error || $file_upload_error1 || $file_upload_error2){
					$this->message->set('Invalid File !!','e');
				}
                else{
                    $data = $this->input->post(NULL,true); 
                    $username = $data['username'];
                    $password = $data['password'];
                    unset($data['btn_save']);
                    unset($data['username']);
                    unset($data['password']);
                    $data['status'] = 1;
                    $data['biodata'] = $fileName;
                    $data['photo'] = $imageName;
                    $data['aadhar'] = $aadharName;
                    $user_id = $this->user->f_save('users',$data);
                
                if($user_id)
                {
                    if(!empty($username) && !empty($password))
                    {
                        $log_data = array('user_id'=>$user_id,'user_type'=>$data['utype'],'uname'=>$username,'ups_key'=>$password);
                        $this->db->insert('login',$log_data);
                    }
                    
                    $this->message->set('User Added Successfully !!','s');
                }
                else
                {
                    $this->message->set('User could not be Added !!','e');
                }
            }    
            }    
	        $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman','9'=>'Accounts Staff');
	        
	        $this->template->title('Users');
            $this->template->main_heading('Add User');
            $this->template->slice('cms/message');
            $this->template->slice('user/add',array('designations'=>$designations));
            $this->template->render();
	    }
	    
	    public function report()
	    {
	        $args = array(); $desig = ""; 
	        
            if(isset($_POST['btn_get']))
            {
                if(!empty($this->input->post('desig',true)))
        		{
        		    $desig = $this->input->post('desig',true);
        		    $args['conditions']['utype'] = $desig;
        		}
            }
            
	        $users = $this->user->get_all($args);
	        
	        $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman');
	        
	        $this->template->title('Users');
            $this->template->main_heading('User Report');
            $this->template->slice('cms/message');
            $this->template->slice('user/search',array('designations'=>$designations,'desig'=>$desig));
            $this->template->slice('user/report',array('users'=>$users,'designations'=>$designations));
            $this->template->render();
	    }
	    
	    public function block()
    	{
    	    $uri_array = $this->uri->uri_to_assoc(3);
    	    if(!empty($uri_array) && $uri_array['id']!='' && $uri_array['status']!='')
    	    {
                $this->db->update("users",array('bstatus'=>$uri_array['status']),array('id'=>$uri_array['id']));
    	    }
    	    
    	    redirect('user/report');
    	}
	    
	    public function update()
        {
            $uri_array = $this->uri->uri_to_assoc(3);
            $up_id = $uri_array['id'];
            if(!empty($up_id)){
                $args = array();
                $args['conditions']['id'] = $up_id;
                $user = $this->user->get_all($args);
                $usp = $this->user->get_unpwd($up_id);
                $fn =0;
                if(isset($_POST['btn_update']))
                {  
                    $file_upload_error=$file_upload_error1=$file_upload_error2=true; $fileName = ''; $imageName="no_profile_pic.jpg"; $f1=$f2=$f3=0;$aaharName='';
    				if($_FILES['biodata']['name'] != ''){
    				    $ext = pathinfo($_FILES['biodata']['name'], PATHINFO_EXTENSION);
    					$fileName = time().'biodata'.'.'.$ext;
    					
    					$config['upload_path'] =  FCPATH.'assets/files/biodata/';
    					$config['allowed_types'] = 'pdf|doc';
    					$config['file_name'] = $fileName;
    					$this->load->library('upload');
    					$this->upload->initialize($config);
    					if($this->upload->do_upload('biodata')){
    						$file_upload_error = false;
    						$f1=1;
    					}else{
    						$file_upload_error = true;
    					}
    				}else{
    				    $file_upload_error=false;
    				}
    				if($_FILES['photo']['name'] != ''){
                        $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
    					$imageName = time().'photo'.'.'.$ext;
                    					
                        $config['upload_path'] =  FCPATH.'assets/images/photos/';
                        $config['allowed_types'] = '*';
                        $config['file_name'] = $imageName;
                        $this->load->library('upload');
                        $this->upload->initialize($config);
                        					
                        if($this->upload->do_upload('photo')){
                        	$file_upload_error1 = false;
                        	$config['image_library'] = 'gd2';
                        	$config['source_image']	= $imageName;
                        	$config['create_thumb'] = TRUE;
                        	$config['maintain_ratio'] = false;
                        	$config['width']	= 200;
                        	$config['height']	= 200;
                        
                        	$this->load->library('image_lib', $config); 
                            $this->image_lib->resize();
                            $f2=1;
                        }else{
                    	    $file_upload_error1 = true;
                        }
                    }else{
    				    $file_upload_error1=false;
    				}
    				
    				if($_FILES['aadhar']['name'] != ''){
    				     $ext = pathinfo($_FILES['aadhar']['name'], PATHINFO_EXTENSION);
    				     $aaharName = time().'aadhar'.'.'.$ext;
    				     $config['upload_path'] =  FCPATH.'assets/files/aadhar/';
    				     $config['allowed_types'] = '*';
    				     $config['file_name'] = $aaharName;
    					 $this->load->library('upload');
    					 $this->upload->initialize($config);
    					 if($this->upload->do_upload('aadhar')){
    						$file_upload_error2 = false;
    						$f3=1;
    					}else{
    						$file_upload_error2 = true;
    					}
    				    
    				}
    				else{
    				    $file_upload_error2=false;
    				}
    				
                    if($file_upload_error || $file_upload_error1 || $file_upload_error2){
    					$this->message->set('Invalid File !!','e');
    				}else{
                        $data = $this->input->post(NULL,true);
                        $username = $data['username'];
                        $password = $data['password'];
                        unset($data['btn_update']);
                        unset($data['username']);
                        unset($data['password']);
                        if($f1 == 1){
                            $data['biodata'] = $fileName;
                        }
                        if($f2 == 1){
                            $data['photo'] = $imageName;
                        }
                         if($f3 == 1){
                            $data['aadhar'] = $aaharName;
                        }
                        if($this->db->update("users",$data,array('id'=>$up_id))){
                            $log_data = array('user_type'=>$data['utype'],'uname'=>$username,'ups_key'=>$password);
                            $res = $this->db->select(array('id'))->get_where('login',array('user_id'=>$up_id))->row_array();
                            if($res){
                                $this->db->update("login",$log_data,array('user_id'=>$up_id));
            				}else{
            				    $log_data['user_id'] = $up_id;
            				  $this->db->insert('login',$log_data);  
            				}
            				$this->message->set('User Details Updated Successfully !!','s');
                        }else{
                            $this->message->set('User Details could not be Updated !!','e');
                        }
                        redirect('user/report');
			        }    
                }
            }
            $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman');

            $this->template->title('User Update');
            $this->template->main_heading('User Update');
            $this->template->slice('cms/message');
            $this->template->slice('user/update',array('user'=>$user,'usid'=>$up_id,'designations'=>$designations,'usp'=>$usp));
            $this->template->render();
        }
        
        public function add_email()
	    {
	        if(isset($_POST['btn_save']))
            {
              $data = $this->input->post(NULL,true);  
              $log_data = array('staff_id'=>$data['staff_id'],'email'=>$data['email_id'],'passwd'=>$data['password']);
              $this->db->insert('user_email',$log_data);
              $this->message->set('User Added Successfully !!','s');
            }
            $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman');
	        $users = $this->user->listing(array());
	        $this->template->title('Email');
            $this->template->main_heading('Add User Email');
            $this->template->slice('cms/message');
            $this->template->slice('user/add_email',array('designations'=>$designations,'users'=>$users));
            $this->template->render();
	    }
	    
	    public function report_email()
	    {
	        $args = array(); $desig = ""; $users_email="";
	        
            if(isset($_POST['btn_get']))
            {
                if(!empty($this->input->post('desig',true)))
        		{
        		    $desig = $this->input->post('desig',true);
        		    $args['conditions']['utype'] = $desig;
        		}
            }
	       $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman');
           $users = $this->user->get_all($args); 
	        //$users_email
	        $this->template->title('Email');
            $this->template->main_heading('User Email Report');
            $this->template->slice('cms/message');
            $this->template->slice('user/email_search',array('designations'=>$designations,'desig'=>$desig));
            $this->template->slice('user/email_report',array('users'=>$users,'designations'=>$designations));
            $this->template->render(); 
	    }
	    
	public function user_previlage()
	{
	    $this->load->model('users/user_model','user');
        
        $utype_id=''; $users = array(); $user_id=''; $menus=array(); $sub_menus=array(); $user_menus=array();
              
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            $utype_id = $data['utype_id'];
            $user_id = $data['user_id'];
            
            $users = $this->user->list_all_user($utype_id);
            $menus = $this->user->get_menus(); 
            $sub_menus = $this->user->get_submenus();
            
            $user_menus = $this->user->get_user_menus($utype_id,$user_id);
        }
        
        if(isset($_POST['btn_save']))
        {   
            $data1 = $this->input->post(NULL,true);
            $group = "";
            if($data1['user']!='' && $data1['user']!='0'){ $group='individual'; }else{ $group='group'; }
           
            $umenus = $data1['usermenu']; 
            $ins=0;
            
            $this->user->delete(array('table' =>'user_privileges','conditions'=> array('owner_id'=>$data1['user'],'user_group'=>$group,'user_type'=>$data1['utype'])));
            
            foreach($umenus as $umenu)
            {
                if($this->user->insert("user_privileges",array('owner_id'=>$data1['user'],'menu_id'=>$umenu,'user_group'=>$group,'user_type'=>$data1['utype'])))
                {
                    $ins++;
                }
            }
            
            if($ins >0)
            {
                $this->message->set('Previlage Saved Successfully !!','s');
            }
        }   
       
        $utypes = $this->user->list_all_usertype();
        
        $this->template->title('User Previlage');
        $this->template->main_heading('User Previlage');
        $this->template->slice('cms/message');
        $this->template->slice('user/user_previlage',array('utypes'=>$utypes,'utype_id'=>$utype_id,'users'=>$users,'user_id'=>$user_id,'menus'=>$menus,'sub_menus'=>$sub_menus,'user_menus'=>$user_menus));
        $this->template->render();
	}
	
	
	public function edit_email()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        $args = $args_email = array();$user_email='';
        if(!empty($up_id))
        {
            $args_email['conditions']['id'] = $up_id;
             $user_email = $this->user->get_all_user_email($args_email);
             if(isset($_POST['btn_update']))
             { 
                $data = $this->input->post(NULL,true);
                $em_array = array();
                $up_id = $data['up_id'];
                $em_array['email'] = $data['email_id'];
                $em_array['passwd'] = $data['password'];
                $this->db->update("user_email",$em_array,array('id'=>$up_id));
                $args_email['conditions']['id'] = $up_id;
                $user_email = $this->user->get_all_user_email($args_email);
                
                $this->message->set('User Details Updated Successfully !!','s');
                redirect('user/report_email');
                 
             }
             
        }
        
        $users = $this->user->get_all($args); 
        $designations = array('1' => 'Super Admin','2' => 'Admin','3'=>'Manager','4'=>'Developer','5'=>'Office Staff','6'=>'Marketting Staff','7'=>'Chairman');

        $this->template->title('Email');
        $this->template->main_heading('Email Update');
        $this->template->slice('cms/message');
        $this->template->slice('user/email_edit',array('users'=>$users,'designations'=>$designations,'user_email'=>$user_email,'up_id'=>$up_id));
        $this->template->render();
     
    }
	    
    }
?>