<?php  if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Vouchers extends MY_Controller
{
	public function __construct()
	{
		parent :: __construct();
		
		$this->load->model('vouchers/voucher_model','vouchers');
		$this->load->library('accounts');
	}

	public function add()
	{
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;

		$voucher_types = $this->vouchers->voucher_types($vtype);
		$voucher_name = $this->vouchers->voucher_name($vtype);

		#----------debit and credit details
		//13 => cash in hand , 14 => bank_accounts
		$cond1=""; $cond2="";
		$action_array = array();
		if($vtype == 1)//payment
		{
			$cond1 = "(b.sgroup_id = 11 or b.sgroup_id = 12 or b.sgroup_id = 23 or b.sgroup_id = 22)";
			$cond2 = "(b.sgroup_id = 13 or b.sgroup_id = 14)";
			$action_array = array();
		}
		elseif($vtype == 2)//receipt
		{
			$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14)";
			$cond2 = "(b.sgroup_id = 9 or b.sgroup_id = 10 or b.sgroup_id = 15)";
			$action_array = array();
		}
		elseif($vtype == 3)//contra
		{
			$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
			$cond2 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
			$action_array = array();
		}
		elseif($vtype == 4)//journal
		{
			$cond1 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
			$cond2 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
			$action_array = array();
		}
		
		$dr_ledgers = $this->vouchers->get_ledgers2($cond1); 
		$cr_ledgers = $this->vouchers->get_ledgers2($cond2);

		$disabled = "";
		$result_array = $this->vouchers->next_voucher_id($vtype);
		if($result_array['vstatus'] == 1)//data in dms_voucher_temps
		{
			$this->session->set_userdata(array('voucher_type' => $result_array['vtype_id'],'voucher_no' => $result_array['vno'],'voucher_date' => $result_array['vdate']));
			$disabled = "disabled";
		}
		else
		{
			$this->session->unset_userdata(array('voucher_type' => '','voucher_no' => '','voucher_date' => ''));
		}

		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['vno'];
		$voucher_date = $result_array['vdate'];

        if(isset($_POST['btn_add']))
		{
		    if($this->session->userdata('voucher_type'))//data in dms_voucher_temps
			{
				$vtype_id = $this->session->userdata('voucher_type');
				$vno = $this->session->userdata('voucher_no');
				$vdate = $this->session->userdata('voucher_date');
			}
			else
			{
				$vtype_id = $this->input->post('vtype_id',true);
				$vno = $this->input->post('vno',true);
				$vdate = date('Y-m-d',strtotime($this->input->post('vdate',true)));
			}

			$vorder_no = $this->vouchers->next_vorder_no($vtype_id);

			$voucher_temp_result = $this->vouchers->get_vouchers(array('table' => 'voucher_temps','columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'vno' => $vno,'vorder_no' => $vorder_no),'numrows' => true));
			if($voucher_temp_result == 0)
			{
				$dr_ledger_temp=$this->input->post('dr_ledger',true);
				$cr_ledger_temp=$this->input->post('cr_ledger',true);
				$vamount_temp=$this->input->post('vamount',true);
				$narration_temp = $this->input->post('narration',true);
				$particulars_temp = $this->input->post('particulars',true);
				$data_voucher_temp=array('vtype_id' => $vtype_id,'vno' => $vno,'vorder_no' => $vorder_no,'vdate' => $vdate,'dr_ledger' => $dr_ledger_temp,'cr_ledger' => $cr_ledger_temp,'vamount' => $vamount_temp,'particulars' => $particulars_temp,'narration' => $narration_temp);
				if($this->vouchers->insert("voucher_temps",$data_voucher_temp))
				{
					$this->message->set($this->lang->line('voucher-add-success'));
				}
				else
				{
					$this->message->set($this->lang->line('voucher-add-error'),'e');
				}
				redirect('vouchers/add/v-type/'.$vtype);
			}
		}

		if(isset($_POST['btn_save']))
		{
			if($vtype != 4)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean');
				if($this->input->post('ccd',true) && !empty($this->input->post('ccd',true)))
				{
					$this->form_validation->set_rules('cd_no','lang:cd-no','required|alpha_numeric|xss_clean');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|is_date|check_date[$voucher_date.>=]");
				}
			}
		
			if($this->form_validation->run('btn_save') === true)
			{
				$voucher_count = $this->vouchers->get_vouchers(array('table' => 'vouchers','columns' => array('id'),'conditions' => array('vtype_id' => $this->session->userdata('voucher_type'),'vno' => $this->session->userdata('voucher_no'),'status !=' => 0),'numrows' => true));
				if($voucher_count == 0)
				{
					$voucher_temp_array = $this->vouchers->get_vouchers(array('table' => 'voucher_temps','columns' => array('vtype_id','vno','vorder_no','vdate','dr_ledger','cr_ledger','vamount','particulars','narration'),'conditions' => array('vtype_id' => $this->session->userdata('voucher_type'),'vno' => $this->session->userdata('voucher_no'))));
					if(!empty($voucher_temp_array))
					{
						$voucher_status = $cq_status = 1;$ccd = 0;

						$this->db->trans_start();

						if($vtype != 4)
						{
							$ccd = $this->input->post('ccd',true);
							if($ccd == 1)
							{
								$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
								if(strtotime($cheque_date) > strtotime($voucher_temp_array[0]['vdate']))
								{
									$cq_status = 0;
									$voucher_status = 3;
								}
							}
						}
						$group_id = $this->vouchers->save_array($voucher_temp_array,$voucher_status);
						if(!empty($ccd))
						{
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$voucher_bank_array = array('cash_type' => $ccd,'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $voucher_temp_array[0]['vdate'],'cq_status' => $cq_status);
							$voucher_bank_array['group_id'] = $group_id;
							$this->vouchers->insert("voucher_banks",$voucher_bank_array);
						}
						$this->vouchers->delete(array('table' => 'voucher_temps','conditions' => array('branch_id' => $this->session->userdata('under_id'),'vtype_id' => $this->session->userdata('voucher_type'),'vno' => $this->session->userdata('voucher_no'),'vdate' => $this->session->userdata('voucher_date'))));

						$this->db->trans_complete();

						$this->message->set($this->lang->line('voucher-save-success'));
					}
				}
				else
				{
					$this->message->set($this->lang->line('voucher-save-error'),'e');
				}
				redirect('vouchers/add/v-type/'.$vtype);
			}
		}

		$voucher_temp_data = $this->vouchers->get_vouchers(array('table' => 'voucher_temps','conditions' => array('vtype_id' => $vtype_id)));
	
		$users = $this->dms->get_users();
		$users[''] = 'Select'; ksort($users);

		$this->template->title("New $voucher_name Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array('Account Voucher' => 'no_link',"$voucher_name" => 'no_link',$this->lang->line('report') => 'vouchers/report/v-type/'.$vtype));
		$this->template->slice('cms/message');
		$this->template->slice('vouchers/add',array('voucher_types' => $voucher_types,'dr_ledgers' => $dr_ledgers,'cr_ledgers' => $cr_ledgers,'voucher_type' => $vtype_id,'voucher_date' => $voucher_date,'voucher_no' => $voucher_no,'disabled' => $disabled,'voucher_temp_data' => $voucher_temp_data,'action_array' => $action_array,'vtype' => $vtype,'users'=>$users));
		$this->template->render();
	}

	public function update_temp()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);

		#----------voucher temp data
		$voucher_temp_id = $this->uri->segment(5,0);
		$row = $this->vouchers->get_vouchers(array('table' => 'dms_voucher_temps','conditions'=>array('id' => $voucher_temp_id)));
		if(!empty($row) && $this->session->userdata('voucher_type'))
		{
			$voucher_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('vdate','lang:date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('vno','lang:voucher-no',"required|xss_clean|is_natural_no_zero|callback_vno_exists[$voucher_temp_data[vtype_id]]");
			$this->form_validation->set_rules('dr_ledger','lang:debit','required|xss_clean');
			$this->form_validation->set_rules('cr_ledger','lang:credit','required|xss_clean');
			$this->form_validation->set_rules('vamount','lang:amount','required|xss_clean|greater_than[0]|less_than[10000000000000]');
			if($this->form_validation->run() === true)
			{
				$dr_ledger_temp=$this->input->post('dr_ledger',true);
				$cr_ledger_temp=$this->input->post('cr_ledger',true);
				$vamount_temp=$this->input->post('vamount',true);
				$particulars_temp = $this->input->post('particulars',true);
				$narration_temp = $this->input->post('narration',true);
				$vdate = date('Y-m-d',strtotime($this->input->post('vdate',true)));
				$vno=$this->input->post('vno',true);
				$data_voucher_temp=array('dr_ledger' => $dr_ledger_temp,'cr_ledger' => $cr_ledger_temp,'vamount' => $vamount_temp,'particulars'=>$particulars_temp,'narration' => $narration_temp);
				if($this->vouchers->update(array('table' => 'dms_voucher_temps','data' => array('vno' => $vno,'vdate' => $vdate),'conditions' => "company_id = ".$this->session->userdata('company_id')." and branch_id = ".$this->session->userdata('under_id')." and vtype_id = ".$voucher_temp_data['vtype_id'])))
				{
					if($this->vouchers->update(array('table' => 'dms_voucher_temps','data' => $data_voucher_temp,'conditions' => array('id' => $voucher_temp_id)))){
						$this->message->set($this->lang->line('voucher-edit-success'));
					}
					else{
						$this->message->set($this->lang->line('voucher-edit-error'),'e');
					}
				}
				redirect('vouchers/add/v-type/'.$vtype);
			}

			#----------voucher type array
			$voucher_types = $this->vouchers->voucher_types($vtype);
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($vtype);

			#----------debit and credit details
			//13 => cash in hand , 14 => bank_accounts
			$cond1="";$cond2="";
			if($vtype == 1)
			{
				$cond1 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
				//$cond2 = "(b.sgroup_id=13 or b.sgroup_id=14)";
			}
			elseif($vtype == 2)
			{
				//$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14)";
				$cond2 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
			}
			elseif($vtype == 3)
			{
				$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
				$cond2 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
			}
			elseif($vtype == 4)
			{
				//$cond1 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
				//$cond2 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
			}
			$dr_ledgers = $this->vouchers->get_ledgers($cond1);
			$cr_ledgers = $this->vouchers->get_ledgers($cond2);
			
			$users = $this->dms->get_users(array('conditions' => array('branch_id' => $this->session->userdata('under_id'),'id>'=>0)));
		    $users[''] = 'Select';ksort($users);

			#-----------template
			$this->template->title("Edit $voucher_name Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("accounting-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("voucher") => 'vouchers/add/v-type/'.$vtype,$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'vouchers/report/v-type/'.$vtype,$this->lang->line('go-back') => 'vouchers/add/v-type/'.$vtype));
			$this->template->slice('dms/message');
			$this->template->slice('vouchers/edit_temp',array('voucher_types' => $voucher_types,'dr_ledgers' => $dr_ledgers,'cr_ledgers' => $cr_ledgers,'voucher_temp_data' => $voucher_temp_data,'users'=>$users));
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function update()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);

		#----------voucher primary key
		$uri_array = $this->uri->uri_to_assoc(5);
		if(isset($uri_array['id']))
		{
			$voucher_id = $uri_array['id'];
			unset($uri_array['id']);

			#----------voucher data
			$row = $this->vouchers->get_vouchers(array('table' => 'dms_vouchers','columns' => array('id','vtype_id','group_id','vno','vorder_no','vdate','dr_ledger','cr_ledger','vamount','particulars','narration'),'conditions'=>array('id' => $voucher_id,'table_name' => "",'status !=' => 0)));
			if(!empty($row))
			{
				$voucher_data = $row[0];
				$narration = $voucher_data['narration'];

				#-----------validation
				$this->form_validation->set_rules('vdate','lang:date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('vno','lang:voucher-no',"required|xss_clean|is_natural_no_zero|callback_vno_exists[$voucher_data[vtype_id].$voucher_data[group_id]]");
				$this->form_validation->set_rules('dr_ledger','lang:debit','required|xss_clean');
				$this->form_validation->set_rules('cr_ledger','lang:credit','required|xss_clean');
				$this->form_validation->set_rules('vamount','lang:amount','required|xss_clean|greater_than[0]|less_than[10000000000000]');
				$this->form_validation->set_rules('narration','lang:narration','xss_clean');
				if($vtype != 4)
				{
					$voucher_date = date('Y-m-d',strtotime($this->input->post('vdate',true)));
					$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean');
					if($this->input->post('ccd',true) && !empty($this->input->post('ccd',true)))
					{
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|alpha_numeric|xss_clean');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|is_date|check_date[$voucher_date.>=]");
					}
				}
				
				if($this->form_validation->run() === true)
				{
					$dr_ledger_temp=$this->input->post('dr_ledger',true);
					$cr_ledger_temp=$this->input->post('cr_ledger',true);
					$vamount_temp=$this->input->post('vamount',true);
					$particulars_temp = $this->input->post('particulars',true);
					$vdate = date('Y-m-d',strtotime($this->input->post('vdate',true)));
					$vno=$this->input->post('vno',true);
					if($this->input->post('narration',true)){
						$narration = $this->input->post('narration',true);
					}
					$data =  array('vno' => $vno,'vdate' => $vdate);
					if($vtype != 4)
					{
						$cash_chq_dd = $this->input->post('ccd',true);
						$cq_status = 1;
						if($cash_chq_dd == 1)
						{
							$cheque_dd_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							if(strtotime($cheque_dd_date) > strtotime($vdate))
							{
								$cq_status = 0;
								$data['status'] = 3;
							}
						}
					}
					$data_voucher_temp=array('dr_ledger' => $dr_ledger_temp,'cr_ledger' => $cr_ledger_temp,'vamount' => $vamount_temp,'particulars'=>$particulars_temp,'narration' => $narration);
					if($this->vouchers->update(array('table' => 'dms_vouchers','data' => $data,'conditions' => array('group_id' => $voucher_data['group_id']))))
					{
						$this->vouchers->update(array('table' => 'dms_vouchers','data' => $data_voucher_temp,'conditions' => array('id' => $voucher_id)));
						if($vtype != 4)
						{
							if(!empty($cash_chq_dd))
							{
								$cheque_dd_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
								$chqdd_no = $this->input->post('cd_no',true);
								if($this->dms->get_data(array('table' => 'dms_voucher_banks','columns' => 'id','conditions' => array('group_id' => $voucher_data['group_id'],'status' => 1))))
								{
									$this->vouchers->update(array('table' => 'dms_voucher_banks','data' => array('cash_type' => $cash_chq_dd,'cd_no' => $chqdd_no,'pdc' => $cheque_dd_date,'vdate' => $vdate,'cq_status' => $cq_status),'conditions' => array('group_id' => $voucher_data['group_id'])));
								}
								else
								{
									$this->vouchers->insert('dms_voucher_banks',array('group_id' => $voucher_data['group_id'],'cash_type' => $cash_chq_dd,'cd_no' => $chqdd_no,'pdc' => $cheque_dd_date,'vdate' => $vdate,'cq_status' => $cq_status));
								}
							}
							else
							{
								$this->vouchers->update(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('group_id' => $voucher_data['group_id'])));
							}
						}
						$this->message->set($this->lang->line('voucher-edit-success'));
					}
					else
					{
						$this->message->set($this->lang->line('voucher-edit-error'),'e');
					}
					redirect('vouchers/report/v-type/'.$vtype.'/'.$this->uri->assoc_to_uri($uri_array));
				}

				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($vtype);

				#----------debit and credit details
				//13 => cash in hand , 14 => bank_accounts
				$cond1 = $cond2 = "";
				if($vtype == 1)//payment
				{
					$cond1 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
					//$cond2 = "(b.sgroup_id=13 or b.sgroup_id=14)";
				}
				elseif($vtype == 2)//receipt
				{
					//$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14)";
					$cond2 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
				}
				elseif($vtype == 3)//contra
				{
					$cond1 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
					$cond2 = "(b.sgroup_id=13 or b.sgroup_id=14 or b.sgroup_id=20)";
				}
				elseif($vtype == 4)//journal
				{
					//$cond1 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
					//$cond2 = "(b.sgroup_id!=13 and b.sgroup_id!=14)";
				}
				$dr_ledgers = $this->vouchers->get_ledgers($cond1);
				$cr_ledgers = $this->vouchers->get_ledgers($cond2);

				#--------------cheque / dd details
				$cd_status = 1;$ccd = 0;$cd_no = "";$pdc = $voucher_data['vdate'];
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.group_id' => $voucher_data['group_id'],'b.status' => 1)));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}
				
				$users = $this->dms->get_users(array('conditions' => array('branch_id' => $this->session->userdata('under_id'),'id>'=>0)));
		        $users[''] = 'Select';ksort($users);

				#-----------template
				$this->template->title("Edit $voucher_name Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("accounting-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("voucher") => 'vouchers/add/v-type/'.$vtype,$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'vouchers/report/v-type/'.$vtype,$this->lang->line('go-back') => 'vouchers/report/v-type/'.$vtype.'/'.$this->uri->assoc_to_uri($uri_array)));
				$this->template->slice('dms/message');
				$this->template->slice('vouchers/edit',array('voucher_types' => $voucher_types,'dr_ledgers' => $dr_ledgers,'cr_ledgers' => $cr_ledgers,'voucher_data' => $voucher_data,'vtype' => $vtype,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'users'=>$users));
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function view()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;$group_id = 0;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(5);

		#----------breadcrumb
		$breadcrumb = array($this->lang->line("accounting-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("voucher") => 'vouchers/add/v-type/'.$vtype,$this->lang->line('report') => 'vouchers/report/v-type/'.$vtype,$this->lang->line("view") => 'no_link');

		if($this->uri->segment(5) && $this->uri->segment(5) == 'group_id')
		{
			#----------group_id
			$group_id = $this->uri->segment(6);
			if($this->uri->segment(7) && $this->uri->segment(7) == 'vt')
			{
				$breadcrumb_url = "daybooks/index/vt/".$this->uri->segment(8);
				$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
			}
			else
			{
				$breadcrumb_url = "ledger_reports/index/";
				if($this->uri->segment(7))
				{
					$breadcrumb_url .= $this->uri->segment(7);
				}
				if($this->uri->segment(8))
				{
					$breadcrumb_url .= "/sid/".$this->uri->segment(8);
				}
				if($this->uri->segment(9))
				{
					$breadcrumb_url .= "/tbp/".$this->uri->segment(9);
				}
				$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
			}
		}
		else
		{
			#----------group_id
			if(isset($uri_array['id'])){
				$group_id = $uri_array['id'];
				unset($uri_array['id']);
			}
			$breadcrumb[$this->lang->line("go-back")] = "vouchers/report/v-type/".$vtype."/".$this->uri->assoc_to_uri($uri_array);
		}

		#-----------fiscal year dates
		$fiscal_dates = $this->dms->get_fiscal_year();

		$voucher_array = $this->dms->get_data(array('table' => 'dms_vouchers as a','columns' => array('a.vtype_id','a.vno','a.vorder_no','a.vdate','a.dr_ledger','a.cr_ledger','a.vamount','a.particulars','a.narration','a.created_by','a.created_on','b.cash_type','b.cd_no','b.pdc'),'join' => array('table' => 'dms_voucher_banks as b','type' => 'left','on' => 'a.group_id = b.group_id and a.status = b.status'),'conditions' => array('a.branch_id' => $this->session->userdata('under_id'),'a.group_id' => $group_id,'a.status' => 1),'between' => "a.vdate between '".$fiscal_dates['start_date']."' and '".$fiscal_dates['end_date']."'"));
		if(!empty($voucher_array))
		{
			$voucher_data = $voucher_array[0];

			#----------voucher name
			$voucher_type = $this->vouchers->voucher_name($voucher_data['vtype_id']);

			#-----------template
			$this->template->title("View $voucher_name Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb($breadcrumb);
			$this->template->slice('dms/message');
			$this->template->slice('vouchers/view',array('voucher_type' => $voucher_type,'voucher_array' => $voucher_array,'vtype' => $vtype,'voucher_name' => $voucher_name));
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}

	}

	public function report()
	{
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;
		$conditions = array('vtype_id' => $vtype,'status' => 1);
		$like_array = array();$vnos="";
        $from_date = $to_date = date('Y-m-d');
		
		$voucher_name = $this->vouchers->voucher_name($vtype);

		$voucher_types = $this->vouchers->voucher_types($vtype);

		$uri_array  = $this->uri->uri_to_assoc(5);

		$redirect = "";

		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('vno','voucher-no','xss_clean|trim');
     	$this->form_validation->set_rules('ledger_id','ledgers','xss_clean|trim');
     	$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|valid_date');
     	$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|valid_date');

		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$conditions['vtype_id'] = $vtype_id;
			$redirect .= '/vt/'.$vtype_id;
			if(!empty($this->input->post('vno',true)))
			{
				$vnos = $this->input->post('vno',true);
				$like_array['vno'] = $vnos;
				$redirect .= '/vn/'.$vnos;
			}
			
			if($this->input->post('from_date',true))
			{
				
			    $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			    $to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			    $between = "vdate between '$from_date' and '$to_date'";
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['vno'] = $vnos;
				$redirect .= '/vn/'.$vnos;
			}
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$between = "vdate between '$from_date' and '$to_date'";
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}	
		}
		
		$between = "vdate between '$from_date' and '$to_date'";

		$voucher_array = $this->vouchers->get_voucher_ids(array('table' => 'vouchers','distinct' => array('vtype_id','vno','vdate'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'vdate|vno','order'=>'DESC'));
        
        $cond1 = "(b.sgroup_id = 11 or b.sgroup_id = 12 or b.sgroup_id = 23)";
        $dr_ledgers = $this->vouchers->get_ledgers($cond1);
        
		$this->template->title("$voucher_name Voucher Reports");
		$this->template->main_heading($this->lang->line("$voucher_name-voucher-report"));
		$this->template->breadcrumb(array($this->lang->line("accounting-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("voucher") => 'vouchers/add/v-type/'.$vtype,$this->lang->line('report') => 'no_link'));
		$this->template->slice('cms/message');
		$this->template->slice('vouchers/search',array('ledgers'=> $dr_ledgers,'voucher_types' => $voucher_types,'vtype' => $vtype,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date));
		if(!empty($voucher_array))
		{
			$action_array = array(302,303);$view_action = 534;$pdf_action = 550;
			if($vtype == 1)
			{
				$action_array = array(266,267);
				$view_action = 530;
				$pdf_action = 546;
			}
			elseif($vtype == 2){
				$action_array = array(271,272);
				$view_action = 531;
				$pdf_action = 547;
			}
			elseif($vtype == 3){
				$action_array = array(275,276);
				$view_action = 532;
				$pdf_action = 548;
			}
			elseif($vtype == 4){
				$action_array = array(279,280);
				$view_action = 533;
				$pdf_action = 549;
			}

			$this->template->slice('vouchers/report',array('voucher_array' => $voucher_array,'vtype_id'=>$vtype_id,'action_array' => $action_array,'view_action' => $view_action,'pdf_action' => $pdf_action));
		}
		$this->template->render();
	}

	public function vno_exists($vno,$vtype = NULL)
	{
		if($vtype == NULL){
			$vtype = $this->input->post('vtype_id',true);
			$where = array('vtype_id' => $vtype,'vno' => $vno,'status !=' => 0);
		}
		else{
			$exp = explode(".",$vtype);
			$where = array('vtype_id' => $exp[0],'vno' => $vno,'status !=' => 0);
			if(array_key_exists(1,$exp)){
				$where['group_id !='] = $exp[1];
			}
		}
		$row = $this->vouchers->get_vouchers(array('table' => 'dms_vouchers','columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function delete_temp()
	{
		$vtype = $this->uri->segment(4);
		$id=$this->uri->segment(5,0);
		$row = $this->vouchers->get_vouchers(array('table' => 'voucher_temps','columns' => array('id'),'conditions' => array('id' => $id)));
		if(!empty($row))
		{
			if($this->vouchers->delete(array('table' => 'voucher_temps','conditions' => array('id' => $id))))
			{
				$this->message->set($this->lang->line('voucher-delete-success'));
			}
			else
			{
				$this->message->set('voucher-delete-error');
			}
		}
		redirect('vouchers/add/v-type/'.$vtype);
	}

	public function delete()
	{
		$vtype = $this->uri->segment(4);

		$uri_array = $this->uri->uri_to_assoc(5);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);
			$row = $this->vouchers->get_vouchers(array('table' => 'vouchers','columns' => array('id'),'conditions' => array('id' => $id,'status !=' => 0)));
			if(!empty($row))
			{
				if($this->vouchers->update(array('table' => 'vouchers','data' => array('status' => 0),'conditions' => array('id' => $id)))){
					$this->message->set($this->lang->line('voucher-delete-success'));
				}
				else
				{
					$this->message->set('voucher-delete-error');
				}
			}
		}
		redirect('vouchers/report/v-type/'.$vtype.'/'.$this->uri->assoc_to_uri($uri_array));
	}

	public function pdf()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);

		$pdf_name = 'voucher';
		$pdf_contents = '';
		if(!$this->uri->segment(6)){
			echo "<script>alert('".$this->lang->line('invalid-voucher')."');window.close();</script>";
		}
		$voucher_id = $this->uri->segment(6);
		if($this->if_exists('dms_vouchers',array('id'=>$voucher_id,'status' => 1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-voucher')."');window.close();</script>";
		}

		$this->load->library('my_pdf');
		$this->load->library('to_words');
		//$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		#----------voucher data
		$voucher_details = $this->vouchers->get_vouchers(array('table' => 'dms_vouchers','columns' => array('group_id','vtype_id','vno','vdate','narration'),'conditions' => array('id' => $voucher_id,'status' => 1)));

		if(empty($voucher_details)){
			echo "<script>alert('".$this->lang->line('invalid-voucher')."');window.close();</script>";
		}
		else
		{
			$voucher = $voucher_details[0];

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($voucher['vtype_id']);
			$pdf_name = $voucher_name;

			#-----------fiscal year dates
			$fiscal_dates = $this->dms->get_fiscal_year();

			#----------voucher bill details
			$voucher_array = $this->dms->get_data(array('table' => 'dms_vouchers as a','columns' => array('a.vorder_no','a.dr_ledger','a.cr_ledger','a.vamount','a.narration','b.cash_type','b.cd_no','b.pdc'),'join' => array('table' => 'dms_voucher_banks as b','type' => 'left','on' => 'a.group_id = b.group_id and a.status = b.status'),'conditions' => array('a.branch_id' => $this->session->userdata('under_id'),'a.group_id' => $voucher['group_id'],'a.status' => 1),'between' => "a.vdate between '".$fiscal_dates['start_date']."' and '".$fiscal_dates['end_date']."'"));

			#----------bill prefix
			$prefix_array = array(1 => 12,2 => 13,3 => 14,4 => 15,5 => '');
			$vtypeID = $this->vouchers->get_vid($voucher['vtype_id']);
			$bill_prefix = get_voucher_prefix($prefix_array[$vtypeID]);

			$pdf_contents = $this->load->view('vouchers/pdf',array('voucher_array' => $voucher_array,'voucher_name' => $voucher_name,'voucher' => $voucher,'bill_prefix' => $bill_prefix),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}
?>