<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Work extends MY_Controller {

    public function __construct(){

        parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('client/client_model','client');
        $this->load->model('work/work_model','work');
        $this->load->model('users/user_model','user');
        $this->load->model('workType/work_type_model','wtype');
        $this->load->model('staff/staff_model','stf');
        $this->load->model('lead/lead_model','lead');
        $this->load->library(array('work_lib'));
        
        require APPPATH. 'views/vendor/autoload.php';
	}

    public function add(){
        if(isset($_POST['btn_save'])){  
             $st=0; $file_upload_error = TRUE; $attach=""; $audio="";
            
            if(!empty($_FILES['wfile']['name'])){
				$ext = pathinfo($_FILES['wfile']['name'], PATHINFO_EXTENSION);
				$attach = rand(0,1000)."work".date('YmdHis').".".$ext;
				$config['upload_path'] =  FCPATH.'assets/files/work/attachment/';
				$config['allowed_types'] = '*';
				$config['file_name'] = $attach;

				$this->load->library('upload');
				$this->upload->initialize($config);

				if(!$this->upload->do_upload('wfile')){
					$file_upload_error = false;
				}
			}
			
			if(!empty($_FILES['waudio']['name'])){
				$ext = pathinfo($_FILES['waudio']['name'], PATHINFO_EXTENSION);
				$audio = rand(0,1000)."work".date('YmdHis').".".$ext;
				$config['upload_path'] =  FCPATH.'assets/files/work/audio/';
				$config['allowed_types'] = '*';
				$config['file_name'] = $audio;

				$this->load->library('upload');
				$this->upload->initialize($config);

				if(!$this->upload->do_upload('waudio')){
					$file_upload_error = false;
				}
			}

			if($file_upload_error == false){
				$this->message->set('Invalid File','e');
			}else{
                $data = $this->input->post(NULL,true);
                unset($data['btn_save']);
                
                $work_array = array();
                $work_array['client_id'] = $data['client_id'];
                $work_array['cdate'] = $data['cdate'];
                $work_array['person'] = $data['person'];
                $work_array['contact_no'] = $data['contact_no'];
                $work_array['category'] = $data['category'];
                $work_array['sub_category'] = $data['sub_category'];
                $work_array['sub_item'] = $data['sub_item'];
                $work_array['file'] = $attach;
                $work_array['audio'] = $audio;
                $work_array['status'] = 1;
                $work_array['wstatus'] = 1;
                $work_array['added_by'] = $data['staff_id'];
                
                foreach($data['desc'] as $did => $desc){
                    if(!empty($desc)){
                        $work_array['description'] = str_replace("'","",$desc);
                        $work_array['ptype'] = $data['payment'][$did];
                        $work_array['priority'] = $data['priority'][$did];
                        $work_array['worder'] = $data['worder'][$did];
                        $work_array['wtime'] = $data['wtime'][$did];
                        
                        $rows = $this->db->query("select * from works where client_id = '$work_array[client_id]' and description='$work_array[description]'")->result_array();
                        if(empty($rows)){
                            $work_id = $this->work->f_save('works',$work_array);
                            if($work_id){
                                if(!empty($data['assign_to'])){
                                    if($work_array['ptype']=='0' || $work_array['ptype']=='1'){
                                        $assign_array = array();
                                        $assign_array['work_id'] = $work_id;
                                        $assign_array['staff_id'] = $data['assign_to'];
                                        $assign_array['adate'] = date('Y-m-d');
                                        $assign_array['status'] = 1;
                                        $this->work->f_save('work_assign',$assign_array);
                                    }
                                }
                                $st++;
                            }
                        }
                    }    
                }
			}
			
            if($st>0){
                $this->message->set('Work Added Successfully !!','s');
            }else{
                $this->message->set('Work could not be Added !!','e');
            }
        }
        
        $args = array();
        $args['conditions'] = array('status'=>1);
        
        $clients = $this->client->listing($args);
        $users = $this->user->listing(array());
        $wcats = $this->work->work_cats();
        
        $this->template->title('Work');
        $this->template->main_heading('Work');
        $this->template->slice('cms/message');
        $this->template->slice('work/add',array('clients'=>$clients,'users'=>$users,'wcats'=>$wcats));
        $this->template->render();
    }
    
    public function report() {
        $from_date = date('Y-m-01');
        $to_date = date('Y-m-t'); 
        $args = array();
        $client = $wstatus = $staff = $ptype = $followup = $created = '';
        $args['fdate'] = $from_date;
        $args['tdate'] = $to_date;
        
        if(isset($_POST['btn_get'])) {
            if(!empty($this->input->post('client',true))) {
                $client = $this->input->post('client',true);
                $args['client'] = $client;
            }
            if(!empty($this->input->post('fdate',true))) {
                $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
                $args['fdate'] = $from_date;
            }
            if(!empty($this->input->post('tdate',true))) {
                $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
                $args['tdate'] = $to_date;
            }
            if(!empty($this->input->post('wstatus',true))) {
                $wstatus = $this->input->post('wstatus',true);
                $args['wstatus'] = $wstatus;
            }
            if(!empty($this->input->post('staff',true))) {
                $staff = $this->input->post('staff',true);
                $args['staff'] = $staff;
            }
            if($this->input->post('ptype',true)!='') {
                $ptype = $this->input->post('ptype',true);
                $args['ptype'] = $ptype;
            }
            if($this->input->post('followup',true)!='') {
                $followup = $this->input->post('followup',true);
            }
            if(!empty($this->input->post('createdby',true))) {
                $created = $this->input->post('createdby',true);
                $args['added_by'] = $created;
            }
        }
        
        if(isset($_POST['btn_save'])) {
            $data = $this->input->post(NULL,true);
            if(!empty($data['posted']) && !empty($data['staff_id'])) {
                $assign_array = array();
                $assign_array['staff_id'] = $data['staff_id'];
                $assign_array['adate'] = date('Y-m-d');
                $assign_array['status'] = 1;
                $st=0;
                foreach($data['posted'] as $work_id) {
                    $assign_array['work_id'] = $work_id;
                    $rows = $this->db->query("select * from work_assign where work_id='$work_id'")->result_array();
                    if(empty($rows)) {
                        if($this->work->f_save('work_assign',$assign_array)) { $st++; }
                    } else {
                        if($this->db->update("work_assign",$assign_array,array('work_id'=>$assign_array['work_id']))){ $st++; }
                    }
                }
                if($st>0) {
                    $this->message->set('Work Assigned Successfully !!','s');
                } else {
                    $this->message->set('Work could not be Assigned !!','e');
                }
            }
        }
        
        if(isset($_POST['btn_complete'])) {
            $data = $this->input->post(NULL,true);
            if(!empty($data['posted'])) {
                $st=0;
                foreach($data['posted'] as $work_id) {
                    if($this->db->update("works",array('wstatus'=>2),array('id'=>$work_id))){ $st++; }
                }
                if($st>0) {
                    $this->message->set('Work Status Updated Successfully !!','s');
                } else {
                    $this->message->set('Work Status could not be Updated !!','e');
                }
            }
        }
        
        if(isset($_POST['btn_terminate'])){
            $data = $this->input->post(NULL,true);
            if(!empty($data['posted'])) {
                $st=0;
                foreach($data['posted'] as $work_id) {
                    if($this->db->update("works",array('wstatus'=>3),array('id'=>$work_id))) { $st++; }
                }
                if($st>0) {
                    $this->message->set('Work Status Updated Successfully !!','s');
                }else{
                    $this->message->set('Work Status could not be Updated !!','e');
                }
            }
        }
        
        if($wstatus == '2') {
            if($this->utype == 7) {
                $args['utype'] = $this->utype;
                $args['staff_id'] = $this->uid;
                $args['staff_id'];
                $works = $this->work->get_completed($args); 
            } else {
                $works = $this->work->get_completed($args);
            }
        } else {
            if($this->utype == 7) {
                $args['utype'] = $this->utype;
                $args['staff_id'] = $this->uid;
                $works = $this->work->get_pending_work($args);
            } else {
                $works = $this->work->get_pending_work($args);
            }
        }
        
        $clients = $this->client->listing(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Work Report');
        $this->template->main_heading('Work Report');
        $this->template->slice('work/search',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date,'wstatus'=>$wstatus,'users'=>$users,'user'=>$staff,'ptype'=>$ptype,'followup'=>$followup,'created'=>$created));
        $this->template->slice('work/report',array('works'=>$works,'users'=>$users,'followup'=>$followup,'wstatus'=>$wstatus));
        $this->template->render();
    }
    
    public function completed(){
        $args = array(); $client = ""; $from_date = $to_date = date('Y-m-d'); $wstatus=""; $staff=""; $ptype="";$informed_by="";$inform="";
        
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('client',true))){
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true))){
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true))){
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		if(!empty($this->input->post('staff',true))){
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
    		if($this->input->post('ptype',true)!=''){
    		    $ptype = $this->input->post('ptype',true);
    		    $args['ptype'] = $ptype;
    		}
    		if($this->input->post('informed_by',true)!=''){
    		    $informed_by = $this->input->post('informed_by',true);
    		    $args['informed_by'] = $informed_by;
    		}
    		if($this->input->post('inform',true)!=''){
    		    $inform = $this->input->post('inform',true);
    		    
    		}
    		 
        }
        else
        {
            $args['fdate'] = $from_date;
            $args['tdate'] = $to_date;
        }
        $works = $this->work->get_completed($args);
        $clients = $this->client->listing(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Completed Work Report');
        $this->template->main_heading('Completed Works');
        $this->template->slice('work/search1',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date,'wstatus'=>$wstatus,'users'=>$users,'user'=>$staff,'ptype'=>$ptype,'informed_by'=>$informed_by,'inform'=>$inform,'redirect'=>'work/completed'));
        $this->template->slice('work/completed',array('works'=>$works,'users'=>$users,'inform'=>$inform));
        $this->template->render();
    }
    
    public function terminated(){
        $args = array(); $client = ""; $from_date = $to_date = ""; $wstatus=""; $staff=""; $ptype="";$informed_by="";
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('client',true))){
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true))){
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true))){
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		if(!empty($this->input->post('staff',true))){
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
    		if($this->input->post('ptype',true)!=''){
    		    $ptype = $this->input->post('ptype',true);
    		    $args['ptype'] = $ptype;
    		}
    		if($this->input->post('informed_by',true)!=''){
    		    $informed_by = $this->input->post('informed_by',true);
    		    $args['informed_by'] = $informed_by;
    		}
        }
        if(isset($_POST['btn_save'])){
            $data = $this->input->post(NULL,true);
            
            $reassign_array = array();$assign_array = array();
            if($data['wstatus'] == '10'){
                $reassign_array['wstatus'] = 0;
            }else{
               $reassign_array['wstatus'] = $data['wstatus'];
            }
            $st=0;
            for($k=1;$k<=$data['no'];$k++){ 
		        if(isset($_POST["aid$k"])){
			        $assign_array['work_id'] = $_POST["aid$k"];
			        $this->db->update("works",$reassign_array,array('id'=>$assign_array['work_id']));
			    }   
            }
            if($st>0){
                $this->message->set('Work ReAssigned Successfully !!','s');
            }else{
                $this->message->set('Work could not be ReAssigned !!','e');
            }
        }
        
        $works = $this->work->get_terminated($args);
        $clients = $this->client->listing(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Terminated Work Report');
        $this->template->main_heading('Terminated Works');
        $this->template->slice('work/search_terminated',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date,'wstatus'=>$wstatus,'users'=>$users,'user'=>$staff,'ptype'=>$ptype,'informed_by'=>$informed_by,'redirect'=>'work/terminated'));
        $this->template->slice('work/terminated',array('works'=>$works,'users'=>$users));
        $this->template->render();
    }
    
    public function delete(){
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        
        $this->db->update("works",array('status'=>0),array('id'=>$del_id));
        redirect('work/report');
    }  
    
    public function update(){
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        
        if(!empty($up_id)){
            $args = array();
            $args['conditions']['w.id'] = $up_id;
            $work = $this->work->get_all($args);
            
            if(isset($_POST['btn_update'])){  
                $file_upload_error = TRUE; $attach=$work[0]['file']; $audio=$work[0]['audio'];
                if(!empty($_FILES['wfile']['name'])){
    				$ext = pathinfo($_FILES['wfile']['name'], PATHINFO_EXTENSION);
    				$attach = rand(0,1000)."work".date('YmdHis').".".$ext;
    				$config['upload_path'] =  FCPATH.'assets/files/work/attachment/';
    				$config['allowed_types'] = '*';
    				$config['file_name'] = $attach;
    
    				$this->load->library('upload');
    				$this->upload->initialize($config);
    
    				if(!$this->upload->do_upload('wfile')){
    					$file_upload_error = false;
    				}
    			}
    			
    			if(!empty($_FILES['waudio']['name'])){
    				$ext = pathinfo($_FILES['waudio']['name'], PATHINFO_EXTENSION);
    				$audio = rand(0,1000)."work".date('YmdHis').".".$ext;
    				$config['upload_path'] =  FCPATH.'assets/files/work/audio/';
    				$config['allowed_types'] = '*';
    				$config['file_name'] = $audio;
    				$this->load->library('upload');
    				$this->upload->initialize($config);
    				if(!$this->upload->do_upload('waudio')){
    					$file_upload_error = false;
    				}
    			}
    
    			if($file_upload_error == false){
    				$this->message->set('Invalid File','e');
    			}else{
                    $data = $this->input->post(NULL,true);
                    unset($data['wfile']);
                    unset($data['waudio']);
                    unset($data['btn_update']);
                    $data['file'] = $attach;
                    $data['audio'] = $audio;
                    if($this->db->update("works",$data,array('id'=>$up_id))){
                        $this->message->set('Work Updated Successfully !!','s');
                    }else{
                        $this->message->set('Work could not be Updated !!','e');
                    }
                    redirect('work/report');
                }
            }
            
            $args = array();
            $args['conditions'] = array('status'=>1);
            
            $clients = $this->client->listing($args);
            $users = $this->user->listing(array());
            $wcats = $this->work->work_cats();
            $ltypes = $this->lead->ltype_list();
            
            $this->template->title('Work Update');
            $this->template->main_heading('Work Update');
            $this->template->slice('cms/message');
            $this->template->slice('work/update',array('clients'=>$clients,'users'=>$users,'wcats'=>$wcats,'ltypes'=>$ltypes,'work'=>$work,'wid'=>$up_id));
            $this->template->render();
        }
    }
    
    public function view(){
        $uri_array = $this->uri->uri_to_assoc(3);
        $work_id = $uri_array['id'];
        if(!empty($work_id)){
            $work_det = $this->work_lib->work_details($work_id);
            $work_assigns = $this->work_lib->work_assigns($work_id);
            $work_updates = $this->work_lib->work_updates($work_id);
            $work_followups = $this->work_lib->work_followups($work_id);
            
            $this->template->title('Work Details');
            $this->template->main_heading('Work Details');
            $this->template->slice('cms/message');
            $this->template->slice('work/view',array('work_det'=>$work_det,'work_assigns'=>$work_assigns,'work_updates'=>$work_updates,'work_followups'=>$work_followups,'work_id'=>$work_id));
            $this->template->render();
        }
    }
    
    public function my_works2(){
        $args = array();
        $works = $this->work->get_all_my_pending_works($args);
        
        $this->template->title('Work');
        $this->template->main_heading('My Works');
        $this->template->slice('work/my_works2',array('works'=>$works));
        $this->template->render();
    }
    
    public function my_works(){
        $this->template->title('Work');
        $this->template->main_heading('My Works');
        $this->template->slice('work/my_works');
        $this->template->render();
    }
    
    public function my_works_ajax(){
        $list = $this->work->get_my_works();
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $work){
            $taken=0; $extra=0;
            $work_updt = $this->dms->get_work_last_updation($work->id);
            $args = array();
            $args['staff'] = $this->uid;
            $args['work_id'] = $work->id;
            $works_all = $this->work->get_work_report_new($args); 
            foreach($works_all as $wrk_st){
                $from_time = strtotime($wrk_st['stime']);
                if($wrk_st['estatus']==0){
                    $to_time = strtotime("now");
                }else{
                    $to_time = strtotime($wrk_st['etime']);
                }    
                $taken += round(($to_time - $from_time)/60);
            }
            if($work->wtime != '0'){
                if($taken > $work->wtime){
                    $extra = $taken - $work->wtime;
                }
            }
            
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = dateFormat($work->cdate);
            $row[] = $work->id;
            $row[] = $work->name;
            $row[] = $work->description;
            $row[] = $work->person;
            $row[] = $work->contact_no;
            $row[] = dateFormat($work->adate);
            $row[] = $work->wtime;
            $row[] = $taken;
            $row[] = $extra;
            
            $wclass=""; $wstatus="";
            if($work->wstatus=='0'){ $wclass="badge-warning"; $wstatus="Ongoing"; }
            else if($work->wstatus=='1'){ $wclass="badge-info"; $wstatus="Pending"; }
            else if($work->wstatus=='2'){ $wclass="badge-success"; $wstatus="Completed"; }
            else if($work->wstatus=='3'){ $wclass="badge-danger"; $wstatus="Terminated"; }
            
            $row[] = '<span class="badge '.$wclass.'">'.$wstatus.'</span>';
           
            $html = '';
            if($work->wstatus != '2'){ 
                if($work_updt=='0'){ 
                    if($work->wtime != '0'){ 
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/1').'" title="Start"><i class="fas fa-play text-lg text-success"></i></a>&nbsp;&nbsp;';
                    }
                }else if($work_updt=='1' || $work_updt=='3'){
                    $html .= '<input type="hidden" name="wrkid" id="wrkid" value="'.$work->id.'">';
                    $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/2').'" title="Pause"><i class="fas fa-pause text-lg text-warning"></i></a>&nbsp;&nbsp;';
                }else if($work_updt=='2'){
                    $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/3').'" title="Resume"><i class="fas fa-forward text-lg text-primary"></i></a>&nbsp;&nbsp;';
                }
                if($work_updt>'0' && $work_updt<4){
                    if($work->category==0){
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/4').'" title="Terminate"><i class="fas fa-stop text-lg text-danger"></i></a>&nbsp;&nbsp;&nbsp;';
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/5').'" title="Completed"><i class="fas fa-check-circle text-lg text-success"></i></a>&nbsp;&nbsp;';
                    }else{
                        $html .= '<a href="'.base_url('work/market_terminate/id/'.$work->id).'" title="Terminate" ><i class="fas fa-stop text-lg text-danger"></i></a>&nbsp;&nbsp;&nbsp;';
                        if($this->uid != '35')
                        {
                        $html .= '<a href="'.base_url('work/market_complete/id/'.$work->id).'" title="Completed"><i class="fas fa-check-circle text-lg text-success"></i></a>&nbsp;&nbsp;';
                        }
                        else
                        {
                          $html .= '<a href="#" title="Completed" class="show-more" data-toggle="modal" data-target="#modal-comp" data-id="'.$work->id.'" id="a"><i class="fas fa-check-circle text-lg text-success"></i></a>&nbsp;&nbsp;';
  
                        }
                    }
                }
            }
            $html .= '<a href="'.base_url('work/view/id/'.$work->id).'" target="blank_" title="View"><i class="fas fa-search text-lg text-primary"></i></a>';
            $row[] = $html;
            $data[] = $row;
        }
 
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->work->count_all(),
            "recordsFiltered" => $this->work->count_my_works_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }
    
    /*public function my_completed_works(){
        $args = array();
        $works = $this->work->get_all_my_completed_works($args);
        
        $this->template->title('Work');
        $this->template->main_heading('My Works');
        $this->template->slice('work/my_completed_works',array('works'=>$works));
        $this->template->render();
    }*/
    
  //=========================================================================================================//  
    
   public function my_completed_works(){
        $args = array(); $client = ""; $from_date = $to_date = date('Y-m-d'); $wstatus=""; $staff=""; $ptype="";$informed_by="";$inform="";
        $uid = $this->session->userdata('uid');
        $args['staff'] = $uid;
        if(isset($_POST['btn_get'])){
            if(!empty($this->input->post('client',true))){
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true))){
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true))){
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		
    		if($this->input->post('ptype',true)!=''){
    		    $ptype = $this->input->post('ptype',true);
    		    $args['ptype'] = $ptype;
    		}
    		if($this->input->post('informed_by',true)!=''){
    		    $informed_by = $this->input->post('informed_by',true);
    		    $args['informed_by'] = $informed_by;
    		}
    		if($this->input->post('inform',true)!=''){
    		    $inform = $this->input->post('inform',true);
    		    
    		}
    		 
        }
        else
        {
            $args['fdate'] = $from_date;
            $args['tdate'] = $to_date;
        }
        $works = $this->work->get_completed($args);
        $clients = $this->client->listing(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Completed Work Report');
        $this->template->main_heading('Completed Works');
        $this->template->slice('work/my_search1',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date,'wstatus'=>$wstatus,'users'=>$users,'user'=>$uid,'ptype'=>$ptype,'informed_by'=>$informed_by,'inform'=>$inform,'redirect'=>'work/my_completed_works'));
        $this->template->slice('work/my_completed',array('works'=>$works,'users'=>$users,'inform'=>$inform));
        $this->template->render();
    } 
    
    
    
    
    
    
    
    /*public function my_completed_works(){
        $this->template->title('Work');
        $this->template->main_heading('My Works');
        $this->template->slice('work/my_completed_works');
        $this->template->render();
    }*/
    
    public function my_completed_works_ajax(){
        $list = $this->work->get_my_completed_works();
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $work){
            $taken=""; $extra="";
            $work_updt = $this->dms->get_work_last_updation($work->id);
            $args = array();
            $args['staff'] = $this->uid;
            $args['work_id'] = $work->id;
            $works_all = $this->work->get_work_report_new($args); 
            foreach($works_all as $wrk_st){
                $from_time = strtotime($wrk_st['stime']);
                if($wrk_st['estatus']==0){
                    $to_time = strtotime("now");
                }else{
                    $to_time = strtotime($wrk_st['etime']);
                }    
                $taken += round(($to_time - $from_time)/60);
            }
            if($work->wtime != '0'){
                if($taken > $work->wtime){
                    $extra = $taken - $work->wtime;
                }
            }
            
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = dateFormat($work->cdate);
            $row[] = $work->id;
            $row[] = $work->name;
            $row[] = $work->description;
            $row[] = $work->person;
            $row[] = $work->contact_no;
            $row[] = dateFormat($work->adate);
            $row[] = $work->wtime;
            $row[] = $taken;
            $row[] = $extra;
            
            $wclass=""; $wstatus="";
            if($work->wstatus=='0'){ $wclass="badge-warning"; $wstatus="Ongoing"; }
            else if($work->wstatus=='1'){ $wclass="badge-info"; $wstatus="Pending"; }
            else if($work->wstatus=='2'){ $wclass="badge-success"; $wstatus="Completed"; }
            else if($work->wstatus=='3'){ $wclass="badge-danger"; $wstatus="Terminated"; }
            
            $row[] = '<span class="badge '.$wclass.'">'.$wstatus.'</span>';
            
            $html = '';
            if($work->wstatus != '2'){ 
                if($work_updt=='0'){ 
                    if($work->wtime != '0'){ 
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/1').'" title="Start"><i class="fas fa-play text-lg text-success"></i></a>&nbsp;&nbsp;';
                    }
                }else if($work_updt=='1' || $work_updt=='3'){
                    $html .= '<input type="hidden" name="wrkid" id="wrkid" value="'.$work->id.'">';
                    $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/2').'" title="Pause"><i class="fas fa-pause text-lg text-warning"></i></a>&nbsp;&nbsp;';
                }else if($work_updt=='2'){
                    $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/3').'" title="Resume"><i class="fas fa-forward text-lg text-primary"></i></a>&nbsp;&nbsp;';
                }
                if($work_updt>'0' && $work_updt<4){
                    if($work->category==0){
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/4').'" title="Terminate"><i class="fas fa-stop text-lg text-danger"></i></a>&nbsp;&nbsp;&nbsp;';
                        $html .= '<a href="'.base_url('work/status_update/id/'.$work->id.'/status/5').'" title="Completed"><i class="fas fa-check-circle text-lg text-success"></i></a>&nbsp;&nbsp;';
                    }else{
                        $html .= '<a href="'.base_url('work/market_terminate/id/'.$work->id).'" title="Terminate"><i class="fas fa-stop text-lg text-danger"></i></a>&nbsp;&nbsp;&nbsp;';
                        $html .= '<a href="'.base_url('work/market_complete/id/'.$work->id).'" title="Completed" data-target="#modal-term" class="show-more"><i class="fas fa-check-circle text-lg text-success"></i></a>&nbsp;&nbsp;';
                    }
                }
            }
            $html .= '<a href="'.base_url('work/view/id/'.$work->id).'" target="blank_" title="View"><i class="fas fa-search text-lg text-primary"></i></a>';
            $row[] = $html;
            $data[] = $row;
        }
       
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->work->count_all(),
            "recordsFiltered" => $this->work->count_my_completed_works_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }
    
 //===========================================================================================================//
    public function status_update(){
        $uid = $this->session->userdata('uid');
        $uri_array = $this->uri->uri_to_assoc(3); 
        $up_id = $uri_array['id'];
        $st = $uri_array['status'];
        $date = date('Y-m-d');
        $datetime = date('Y-m-d H:i:00');
        
        $work_det = $this->work_lib->work_details($up_id);
        $client = $this->work_lib->get_client_name($work_det['client_id']);
        $staff = $this->dms->get_staff_name($uid);
        
        $data = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>$st,'stime'=>$datetime,'status'=>1);
        
        if($st=='1' || $st=='3'){
            $this->db->update("work_status",array('estatus'=>2,'etime'=>$datetime),array('staff_id'=>$uid,'estatus'=>0,'type'=>1,'status'=>1));
            $this->db->update("work_status",array('estatus'=>5,'etime'=>$datetime),array('staff_id'=>$uid,'estatus'=>0,'type >'=>1,'status'=>1));
            if($this->work->f_save('work_status',$data)){
                if($st=='1'){
                    $this->db->update("works",array('wstatus'=>0),array('id'=>$up_id));
                }
            }    
        }else{
            $row = $this->db->select(array('id'))->from('work_status')->where(array('work_id' => $up_id,'staff_id'=>$uid,'estatus'=>0,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row)){
                if($this->db->update("work_status",array('estatus'=>$st,'etime'=>$datetime),array('id'=>$row['id']))){
                    if($st=='4'){
                        $this->db->update("works",array('wstatus'=>3),array('id'=>$up_id));
                    }else if($st=='5'){
                        $this->db->update("works",array('wstatus'=>2),array('id'=>$up_id));
                    }
                }
            }else{
                $data1 = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>3,'stime'=>$datetime,'estatus'=>$st,'etime'=>$datetime,'status'=>1);
                if($this->work->f_save('work_status',$data1)){
                    if($st=='4'){
                        $this->db->update("works",array('wstatus'=>3),array('id'=>$up_id));
                    }else if($st=='5'){
                        $this->db->update("works",array('wstatus'=>2),array('id'=>$up_id));
                    }
                }
            }
        }
        if($st==5){
            $options = array('cluster' => 'ap2', 'useTLS' => true);
            $pusher = new Pusher\Pusher('b9921647655a7403bfa1', '0a258a44f5a3d087a211', '1502055', $options);
            
            $wurl = base_url('work/view_informed_staff_det/id/'.$work_det['id']);
            $data['message'] = '<a href="'.$wurl.'" target="blank_">Ref no : '.$work_det['id'].'<br>Client : '.$client.'<br>Work : '.substr($work_det['description'],0,30).'<br>Staff : '.$staff.'<br>Date & Time : '.date('d/m/Y h:i A').'</a>';
            $data['wid'] = $work_det['id'];
            $data['to'] = 9;
            
            $pusher->trigger('my-channel', 'my-event', $data);
        }
        redirect('work/my_works');
    }
    public function market_complete_old()
    {
        $uid = $this->session->userdata('uid');
        
        $uri_array = $this->uri->uri_to_assoc(3); 
        $up_id = $uri_array['id'];
        $remark = $this->input->post('remark',true);
        $work_det = $this->work_lib->work_details($up_id);
        $work_updates = $this->work_lib->work_updates($up_id);
        
        $start=$work_updates[0]['stime']; $end=""; $wtaken="";
        foreach($work_updates as $update){
            $end = $update['etime'];
            if($update['estatus']=='0'){ $end = date('Y-m-d H:i:00'); }
            $wtaken += round(abs(strtotime($end) - strtotime($update['stime'])) / 60);
        }
        
        $scat = $work_det['sub_category'];
        $sitem = $work_det['sub_item'];
        
        $row_check = $this->db->select('*')->from('work_status')->where(array('type'=>1,'work_id'=>$up_id,'sstatus'=>1))->get()->row_array();
        $cond_time = $row_check['stime'];
        
        $wcount=''; $nattend='';
        if($scat=='1'){
            if($sitem!=''){
                $wcount = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.status'=>1))->get()->num_rows();
                $nattend = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.call_status'=>0,'lp.status'=>1))->get()->num_rows();
            }
        }else if($scat=='2'){
            $wcount = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'created_on >='=>$cond_time))->get()->num_rows();
            $nattend = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'status'=>'Not Attended','created_on >='=>$cond_time))->get()->num_rows();
        }
        
        $date = date('Y-m-d');
        $datetime = date('Y-m-d H:i:00');
        $data = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>3,'stime'=>$datetime,'estatus'=>5,'etime'=>$datetime,'status'=>1,'remarks'=>$remark);
        $row = $this->db->select(array('id'))->from('work_status')->where(array('work_id' => $up_id,'staff_id'=>$uid,'estatus'=>0,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
        if(!empty($row)){
            if($this->db->update("work_status",array('estatus'=>5,'etime'=>$datetime,'remarks'=>$remark),array('id'=>$row['id']))){
                $this->db->update("works",array('wstatus'=>2,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }else{
            if($this->work->f_save('work_status',$data)){
                $this->db->update("works",array('wstatus'=>2,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }
        redirect('work/my_works');
    }
    public function market_complete()
    {
        $uid = $this->session->userdata('uid');
        
        $uri_array = $this->uri->uri_to_assoc(3); 
        $up_id = $uri_array['id'];
       // $up_id = $this->input->post('work',true);
        $remark = $this->input->post('remark',true);
        $work_det = $this->work_lib->work_details($up_id);
        $work_updates = $this->work_lib->work_updates($up_id);
        
        $start=$work_updates[0]['stime']; $end=0; $wtaken=0;
        foreach($work_updates as $update){
            $end = $update['etime'];
            if($update['estatus']=='0'){ $end = date('Y-m-d H:i:00'); }
            $wtaken += round(abs(strtotime($end) - strtotime($update['stime'])) / 60);
        }
        
        $scat = $work_det['sub_category'];
        $sitem = $work_det['sub_item'];
        
        $row_check = $this->db->select('*')->from('work_status')->where(array('type'=>1,'work_id'=>$up_id,'sstatus'=>1))->get()->row_array();
        $cond_time = $row_check['stime'];
        
        $wcount=0; $nattend=0;
        if($scat=='1'){
            if($sitem!=''){
                $wcount = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.status'=>1))->get()->num_rows();
                $nattend = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.call_status'=>0,'lp.status'=>1))->get()->num_rows();
            }
        }else if($scat=='2'){
            $wcount = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'created_on >='=>$cond_time))->get()->num_rows();
            $nattend = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'status'=>'Not Attended','created_on >='=>$cond_time))->get()->num_rows();
        }
        
        $date = date('Y-m-d');
        $datetime = date('Y-m-d H:i:00');
        $data = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>3,'stime'=>$datetime,'estatus'=>5,'etime'=>$datetime,'status'=>1,'remarks'=>$remark);
        $row = $this->db->select(array('id'))->from('work_status')->where(array('work_id' => $up_id,'staff_id'=>$uid,'estatus'=>0,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
        if(!empty($row)){
            if($this->db->update("work_status",array('estatus'=>5,'etime'=>$datetime,'remarks'=>$remark),array('id'=>$row['id']))){
                $this->db->update("works",array('wstatus'=>2,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }else{
            if($this->work->f_save('work_status',$data)){
                $this->db->update("works",array('wstatus'=>2,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }
        redirect('work/my_works');
    }
    
    public function market_terminate(){
        $uid = $this->session->userdata('uid');
        $uri_array = $this->uri->uri_to_assoc(3); 
        $up_id = $uri_array['id'];
        
        $work_det = $this->work_lib->work_details($up_id);
        $work_updates = $this->work_lib->work_updates($up_id);
        
        $start=$work_updates[0]['stime']; $end=""; $wtaken="";
        foreach($work_updates as $update){
            $end = $update['etime'];
            if($update['estatus']=='0'){ $end = date('Y-m-d H:i:00'); }
            
            $wtaken += round(abs(strtotime($end) - strtotime($update['stime'])) / 60);
        }
        
        $scat = $work_det['sub_category'];
        $sitem = $work_det['sub_item'];
        $row_check = $this->db->select('*')->from('work_status')->where(array('type'=>1,'work_id'=>$up_id,'sstatus'=>1))->get()->row_array();
        $cond_time = $row_check['stime'];
        $wcount=''; $nattend='';
        if($scat=='1'){
            if($sitem!=''){
                $wcount = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.status'=>1))->get()->num_rows();
                $nattend = $this->db->select(array('lp.id'))->from('lead_details as l')->join('lead_progress as lp','l.id=lp.lead_id')->where(array('l.ltype'=>$sitem,'lp.pdate'=>date('Y-m-d'),'lp.created_by'=>$uid,'lp.call_status'=>0,'lp.status'=>1))->get()->num_rows();
            }
        }else if($scat=='2'){
            $wcount = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'created_on >='=>$cond_time))->get()->num_rows();
            $nattend = $this->db->select(array('id'))->from('enquiry_followup1')->where(array('date'=>date('Y-m-d'),'created_by'=>$uid,'status'=>'Not Attended','created_on >='=>$cond_time))->get()->num_rows();
        }
        
        $date = date('Y-m-d');
        $datetime = date('Y-m-d H:i:00');
        
        $data = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>3,'stime'=>$datetime,'estatus'=>4,'etime'=>$datetime,'status'=>1);
        
        $row = $this->db->select(array('id'))->from('work_status')->where(array('work_id' => $up_id,'staff_id'=>$uid,'estatus'=>0,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
        if(!empty($row)){
            if($this->db->update("work_status",array('estatus'=>4,'etime'=>$datetime),array('id'=>$row['id']))){
                $this->db->update("works",array('wstatus'=>3,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }else{
            if($this->work->f_save('work_status',$data)){
                $this->db->update("works",array('wstatus'=>3,'wcount'=>$wcount,'nattend'=>$nattend,'wtaken'=>$wtaken),array('id'=>$up_id));
            }
        }
        redirect('work/my_works');
    }
    
    public function status_update1(){
        $uid = $this->session->userdata('uid');
        $uri_array = $this->uri->uri_to_assoc(3); 
        $up_id = $uri_array['id'];
        $st = $uri_array['status'];
        $date = date('Y-m-d');
        $datetime = date('Y-m-d H:i:00');
        $data = array('type'=>1,'work_id'=>$up_id,'staff_id'=>$uid,'udate'=>$date,'sstatus'=>$st,'stime'=>$datetime,'status'=>1);
        if($st=='1' || $st=='3'){
            if($this->work->f_save('work_status',$data)){
                if($st=='1'){
                    $this->db->update("works",array('wstatus'=>0),array('id'=>$up_id));
                }
            }    
        }else{
            $row = $this->db->select(array('id'))->from('work_status')->where(array('work_id' => $up_id,'staff_id'=>$uid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
            if(!empty($row)){
                if($this->db->update("work_status",array('estatus'=>$st,'etime'=>$datetime),array('id'=>$row['id']))){
                    if($st=='4'){
                        $this->db->update("works",array('wstatus'=>3),array('id'=>$up_id));
                    }else if($st=='5'){
                        $this->db->update("works",array('wstatus'=>2),array('id'=>$up_id));
                    }
                }
            }
        }
        redirect('user/home');
    }
    
    public function time_assign()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $client = ""; $works=array(); $args = array();
        if(isset($_POST['btn_get']))
        {  
            $client = $this->input->post('client',true);
            $args['conditions']['client_id'] = $client;
            $args['where'] = "wstatus not in (2,3)";
            
            $works = $this->work->get_all($args);
        }else if(isset($uri_array['id'])){
            $client = $uri_array['id'];
            $args['conditions']['client_id'] = $client;
            $args['where'] = "wstatus not in (2,3)";
            
            $works = $this->work->get_all($args);
        }
        
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true);
            
            $st=0;
            for($k=1;$k<=$data['no'];$k++){ 
		        
		        $time_array = array(); $pt = 0;
		        $work_ids = $_POST["aid$k"];
		        
		        if(isset($_POST["paid$k"])){
		            $time_array['ptype'] = $_POST["paid$k"];
			    }
			    
			    $time_array['wtime'] = $_POST["time$k"];
			    
			    if($this->db->update("works",$time_array,array('id'=>$work_ids))){
                    $st++;
                } 
            }
            
            if($st>0){
                $this->message->set('Work Time Added Successfully !!','s');
            }else{
                $this->message->set('Work Time could not be Added !!','e');
            }
        }
        
        $args = array();
        $args['conditions'] = array('status'=>1);
        
        $clients = $this->client->listing($args);
        
        $this->template->title('Works');
        $this->template->main_heading('Time Assign');
        $this->template->slice('cms/message');
        $this->template->slice('work/time_assign',array('clients'=>$clients,'client'=>$client,'works'=>$works));
        $this->template->render();
    }
    
    public function work_report()
    {
        $args = array(); $staff = ""; $from_date = $to_date = date('Y-m-d'); $works=array();
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
    		if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		
    	  $works = $this->work->get_works($args);	
        }
        
        $users = $this->user->listing(array());
        
        $this->template->title('Work');
        $this->template->main_heading('Work Report');
        $this->template->slice('work/work_search',array('fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('work/work_report',array('works'=>$works,'users'=>$users,'user'=>$staff,'fdate'=>$from_date,'tdate'=>$to_date));
        $this->template->render();
    }
    
    public function daily_works()
    {
        $args = array(); $staff = ""; $from_date = $to_date = date('Y-m-d'); $works=array();$get_daily_works=array();
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
    		if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		
    		$works = $this->work->get_works($args);
    		$get_daily_works = $this->work->get_daily_works($args);
        }
        
        $users = $this->user->listing(array());
        
        $this->template->title('Work');
        $this->template->main_heading('Work Report');
        $this->template->slice('work/daily_work_search',array('fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('work/daily_work_report',array('works'=>$works,'users'=>$users,'user'=>$staff,'fdate'=>$from_date,'tdate'=>$to_date,'get_daily_works'=>$get_daily_works));
        $this->template->render();
    }
    
    public function my_report()
    {
        $args = array(); $from_date = $to_date = date('Y-m-d'); $works=array();
        
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    	    }
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			}
        }
        
        $args['staff'] = $this->session->userdata('uid');
    	$args['fdate'] = $from_date;
    	$args['tdate'] = $to_date;
    	
    	$works = $this->work->get_works($args);
        
        $this->template->title('Work');
        $this->template->main_heading('Work Report');
        $this->template->slice('work/my_search',array('fdate'=>$from_date,'tdate'=>$to_date));
        $this->template->slice('work/my_report',array('works'=>$works,'uid'=>$this->session->userdata('uid'),'fdate'=>$from_date,'tdate'=>$to_date));
        $this->template->render();
    }
    
    public function work_type()
    {
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true);
                
            $worktype_array = array();
            $worktype_array['wtype'] = $data['w_type'];
            $worktype_array['wstatus'] = $data['w_status'];
            $worktype_array['status'] = 2;
            $worktype_array['del_status'] = 1;
            
            $st=0;
            $rows = $this->db->query("select * from work_types where wtype = '$worktype_array[wtype]'")->result_array();
            
            if(empty($rows)){
                if($this->work->f_save('work_types',$worktype_array)){
                    $st++;
                }
            }
            
            if($st>0){
                $this->message->set('Work Type Added Successfully !!','s');
            }else{
                $this->message->set('Work Type could not be Added !!','e');
            }
        }
        
        $args = array();
        $work_types = $this->wtype->get_all($args);
        $wstatus = array(0=>'ADD',1=>'MINUS');
        
        $this->template->title('Work Type');
        $this->template->main_heading('Work Type');
        $this->template->slice('cms/message');
        $this->template->slice('work/work_type',array('wstatus'=>$wstatus,'work_types'=>$work_types));
        $this->template->render();
    }
    public function work_type_update()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $up_id = $uri_array['id'];
        
        if(!empty($up_id))
        {
            $args = array();
            $args['conditions']['id'] = $up_id;
            $worktype = $this->wtype->get_all($args);
            
            if(isset($_POST['btn_update']))
            {  
                $data = $this->input->post(NULL,true);
                unset($data['btn_update']);
                
                if($this->db->update("work_types",$data,array('id'=>$up_id)))
                {
                    $this->message->set('Work Type Updated Successfully !!','s');
                }
                else
                {
                    $this->message->set('Work Type could not be Updated !!','e');
                }
                
                redirect('work/work_type');
            }
             $wstatus = array(0=>'ADD',1=>'MINUS');
            $this->template->title('Work Type Update');
            $this->template->main_heading('Work Type Update');
            $this->template->slice('cms/message');
            $this->template->slice('work/work_type_update',array('worktype'=>$worktype,'wstatus'=>$wstatus,'wtid'=>$up_id));
            $this->template->render();
        }
    }
    
     public function work_type_delete()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $del_id = $uri_array['id'];
        /*$rows = $this->db->query("select * from work_status where wtype = '$worktype_array[wtype]'")->result_array();
            
        if(empty($rows))
        {*/
            $this->db->update("work_types",array('del_status'=>0),array('id'=>$del_id));
        //}
        
        redirect('work/work_type');
    }  
    
    public function call()
    {
        $uid = $this->session->userdata('uid');
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            
            $stime = $data['stime'] = $data['cdate'].' '.$data['stime'];
            $etime = $data['etime'] = $data['cdate'].' '.$data['etime'];
            
            $inst = $this->work->f_save('call_details',$data);       
            if($inst)
            {
                $work_array = array();
                $work_array['type'] = 2;
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $data['cdate'];
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $stime;
                $work_array['estatus'] = 5;
                $work_array['etime'] = $etime;
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                if($insid) 
                {
                    $st++;
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'stime <='=>$stime,'staff_id'=>$uid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row['id']));
                        $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'status'=>1);
                        $this->work->f_save('work_status',$data);
                    }
                    else
                    {
                        $row1 = $this->db->select('*')->from('work_status')->where(array('stime <='=>$stime,'etime >='=>$etime,'staff_id'=>$uid,'id !='=>$insid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                        if(!empty($row1))
                        {
                            $enstat = $row1['estatus'];
                            $entime = $row1['etime'];
                            
                            $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row1['id']));
                            $data = array('type'=>$row1['type'],'work_id'=>$row1['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'estatus'=>$enstat,'etime'=>$entime,'status'=>1);
                            $this->work->f_save('work_status',$data);
                        }
                    }
                }
            }
            if($st>0)
            {
                $this->message->set('Call Details Added Successfully !!','s');
            }
            else
            {
                $this->message->set('Call Details could not be Added !!','e');
            }
            redirect('work/my_works');
        }
    }
    
    public function calls()
    {
        $uid = $this->session->userdata('uid');
        $cur_date = date('Y-m-d');
	    $cur_time = date('H:i:00');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            $data['cdate'] = $cur_date;
            $data['stime'] = $cur_date_time;
            
            $inst = $this->work->f_save('call_details',$data);       
            if($inst)
            {
                $work_array = array();
                $work_array['type'] = 2;
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $cur_date;
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $cur_date_time;
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                if($insid) 
                {
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'udate'=>$cur_date,'staff_id'=>$uid,'id !='=>$insid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        if($row['type']=='1')
                        {
                            $this->db->update("work_status",array('estatus'=>-1,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                        else
                        {
                            $this->db->update("work_status",array('estatus'=>5,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                    }
                }
            }
            
            redirect('user/home');
        }
    }
    
    public function call_report()
    {
        $args=array(); $client=""; $from_date=$to_date=""; $staff="";
       
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('client',true)))
    		{
    		    $client = $this->input->post('client',true);
    		    $args['client'] = $client;
    		}
    		if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
        }
        $call_det = $this->work->get_call_details($args);
        
        $clients = $this->client->listing(array());
        $users = $this->user->listing(array());
        
        $this->template->title('Call Report');
        $this->template->main_heading('Call Report');
        $this->template->slice('work/call_search',array('clients'=>$clients,'client'=>$client,'fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('work/call_report',array('call_det'=>$call_det,'users'=>$users));
        $this->template->render(); 
    }
    
    public function discuss()
    {
        $uid = $this->session->userdata('uid');
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            
            $stime=$data['stime'] = $data['cdate'].' '.$data['stime'];
            $etime=$data['etime'] = $data['cdate'].' '.$data['etime'];
            
            $inst = $this->work->f_save('discussion_details',$data);       
            if($inst)
            {
                $work_array = array();
                $work_array['type'] = 3;
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $data['cdate'];
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $data['stime'];
                $work_array['estatus'] = 5;
                $work_array['etime'] = $data['etime'];
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                
                if($insid) 
                {
                    $st++;
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'stime <='=>$stime,'staff_id'=>$uid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row['id']));
                        $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'status'=>1);
                        $this->work->f_save('work_status',$data);
                    }
                    else
                    {
                        $row1 = $this->db->select('*')->from('work_status')->where(array('stime <='=>$stime,'etime >='=>$etime,'staff_id'=>$uid,'id !='=>$insid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                        if(!empty($row1))
                        {
                            $enstat = $row1['estatus'];
                            $entime = $row1['etime'];
                            
                            $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row1['id']));
                            $data = array('type'=>$row1['type'],'work_id'=>$row1['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'estatus'=>$enstat,'etime'=>$entime,'status'=>1);
                            $this->work->f_save('work_status',$data);
                        }
                    }
                }
            }
            if($st>0)
            {
                $this->message->set('Discussion Details Added Successfully !!','s');
            }
            else
            {
                $this->message->set('Discussion Details could not be Added !!','e');
            }
            redirect('work/my_works');
        }
    }
    
    public function discussion()
    {
        $uid = $this->session->userdata('uid');
        $cur_date = date('Y-m-d');
	    $cur_time = date('H:i:00');
	    $cur_date_time = date('Y-m-d H:i:00');
	    
        if(isset($_POST['btn_save']))
        {
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            $data['cdate'] = $cur_date;
            $data['stime'] = $cur_date_time;
            
            $inst = $this->work->f_save('discussion_details',$data);       
            if($inst)
            {
                $work_array = array();
                $work_array['type'] = 3;
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $cur_date;
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $cur_date_time;
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                if($insid) 
                {
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'udate'=>$cur_date,'staff_id'=>$uid,'id !='=>$insid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        if($row['type']=='1')
                        {
                            $this->db->update("work_status",array('estatus'=>-1,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                        else
                        {
                            $this->db->update("work_status",array('estatus'=>5,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                    }
                }
            }
            
            redirect('user/home');
        }
    }
    
    public function discuss_report()
    {
        $args = array(); $from_date = $to_date = ""; $staff="";
       
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
        }
        
        $disc_det = $this->work->get_discuss_details($args);
        
        $users = $this->user->listing(array());
        
        $this->template->title('Discussion Report');
        $this->template->main_heading('Discussion Report');
        $this->template->slice('work/discuss_search',array('fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('work/discuss_report',array('disc_det'=>$disc_det,'users'=>$users));
        $this->template->render(); 
    }
    
    public function others()
    {
        $uid = $this->session->userdata('uid');
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            
            $inst = $this->work->f_save('other_details',$data);       
            if($inst)
            {
                $row_sfint = $this->db->query("SELECT stime FROM work_status where staff_id='$uid' and udate='$data[cdate]' order by id asc")->row_array();
                if(empty($row_sfint)){
                    $fstintime = '08:30:00';
                    if($data['stime'] <= $fstintime)
                    {
                        $data['stime'] = $fstintime;
                    }
                }
                
                
                $stime = $data['cdate'].' '.$data['stime'];
                $etime = $data['cdate'].' '.$data['etime'];
                
                $work_array = array();
                $work_array['type'] = $data['wtype'];
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $data['cdate'];
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $stime;
                $work_array['estatus'] = 5;
                $work_array['etime'] = $etime;
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                if($insid) 
                {
                    $st++;
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'stime <='=>$stime,'staff_id'=>$uid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row['id']));
                        $data = array('type'=>$row['type'],'work_id'=>$row['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'status'=>1);
                        $this->work->f_save('work_status',$data);
                    }
                    else
                    {
                        $row1 = $this->db->select('*')->from('work_status')->where(array('stime <='=>$stime,'etime >='=>$etime,'staff_id'=>$uid,'id !='=>$insid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
                        if(!empty($row1))
                        {
                            $enstat = $row1['estatus'];
                            $entime = $row1['etime'];
                            
                            $this->db->update("work_status",array('estatus'=>2,'etime'=>$stime),array('id'=>$row1['id']));
                            $data = array('type'=>$row1['type'],'work_id'=>$row1['work_id'],'staff_id'=>$uid,'udate'=>$data['cdate'],'sstatus'=>3,'stime'=>$etime,'estatus'=>$enstat,'etime'=>$entime,'status'=>1);
                            $this->work->f_save('work_status',$data);
                        }
                    }
                }
            }
            if($st>0)
            {
                $this->message->set('Other Details Added Successfully !!','s');
            }
            else
            {
                $this->message->set('Other Details could not be Added !!','e');
            }
            redirect('work/my_works');
        }
    }
    
    public function otherss()
    {
        $uid = $this->session->userdata('uid');
        $cur_date = date('Y-m-d');
	    $cur_time = date('H:i:00');
	    $cur_date_time = date('Y-m-d H:i:00');
        
        if(isset($_POST['btn_save']))
        {  
            $data = $this->input->post(NULL,true); 
            unset($data['btn_save']);
            $data['staff'] = $uid;
            $data['cdate'] = $cur_date;
            $data['stime'] = $cur_time;
            
            $inst = $this->work->f_save('other_details',$data);       
            if($inst)
            {
                $work_array = array();
                $work_array['type'] = $data['wtype'];
                $work_array['work_id'] = $inst;
                $work_array['staff_id'] = $uid;
                $work_array['udate'] = $cur_date;
                $work_array['sstatus'] = 1;
                $work_array['stime'] = $cur_date_time;
                $work_array['remarks'] = $data['remark'];
                $work_array['status'] = 1;
                
                $insid = $this->work->f_save('work_status',$work_array);
                if($insid) 
                {
                    $row = $this->db->select(array('id','work_id','type'))->from('work_status')->where(array('estatus'=>0,'udate'=>$cur_date,'staff_id'=>$uid,'id !='=>$insid,'status'=>1))->order_by('id','desc')->limit(1)->get()->row_array();
                    if(!empty($row))
                    {
                        if($row['type']=='1')
                        {
                            $this->db->update("work_status",array('estatus'=>-1,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                        else
                        {
                            $this->db->update("work_status",array('estatus'=>5,'etime'=>$cur_date_time),array('id'=>$row['id']));
                        }
                    }
                }
            }
           
            redirect('user/home');
        }
    }
    
    public function view_informed_staff()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $work_id = $uri_array['id'];
        
        if(!empty($work_id))
        {
            $args = array();
            $args['conditions']['w.id'] = $work_id;
            $work = $this->work->get_all($args);
            $staff_id = $this->work->get_informed_person($work_id);
            if(isset($_POST['btn_update']))
            { 
                $data = $this->input->post(NULL,true);
                $inform_array = array();
                $inform_array['work_id'] = $work_id;
                $inform_array['staff_id'] = $data['informeded_by'];
                $inform_array['adate'] = $data['cdate'];
                $inform_array['status'] = 1;
                                    
                if($this->work->f_save('work_inform',$inform_array))
                    {
                        $this->message->set('Work Updated Successfully !!','s');
                    }
                    else
                    {
                        $this->message->set('Work could not be Updated !!','e');
                    }
                
                    redirect('work/my_completed_works');
            }
            $users = $this->user->listing(array());
            $this->template->title('Work Details');
            $this->template->main_heading('Work Details');
            $this->template->slice('cms/message');
            $this->template->slice('work/view_informed_staff',array('work'=>$work,'work_id'=>$work_id,'users'=>$users,'staff_id'=>$staff_id));
            $this->template->render();
        }
    }
    
    public function view_informed_staff_det()
    {
        $uri_array = $this->uri->uri_to_assoc(3);
        $work_id = $uri_array['id'];
        $work_det = $this->work_lib->work_details($work_id);
        
        if(!empty($work_id)){
            $staff_id = $this->work->get_informed_person($work_id);
            if(isset($_POST['btn_update'])){ 
                $data = $this->input->post(NULL,true);
                $inform_array = array();
                $inform_array['work_id'] = $work_id;
                $inform_array['staff_id'] = $data['informeded_by'];
                $inform_array['adate'] = $data['cdate'];
                $inform_array['status'] = 1;
                                    
                if($this->work->f_save('work_inform',$inform_array)){
                        $this->message->set('Work Updated Successfully !!','s');
                }else{
                    $this->message->set('Work could not be Updated !!','e');
                }
                redirect('user/home');
            }
            
            $users = $this->user->listing(array());
            
            $this->template->title('Work Details');
            $this->template->main_heading('Work Details');
            $this->template->slice('cms/message');
            $this->template->slice('work/view_informed_staff_det',array('work_id'=>$work_id,'work_det'=>$work_det,'users'=>$users,'staff_id'=>$staff_id));
            $this->template->render();
        }
    }
    
    public function other_report()
    {
        $args = array(); $from_date = $to_date = ""; $staff="";
       
        if(isset($_POST['btn_get']))
        {
            if(!empty($this->input->post('fdate',true)))
    		{
    		    $from_date = date('Y-m-d',strtotime($this->input->post('fdate',true)));
    		    $args['fdate'] = $from_date;
    		}
    		if(!empty($this->input->post('tdate',true)))
    		{
    		    $to_date = date('Y-m-d',strtotime($this->input->post('tdate',true)));   
			    $args['tdate'] = $to_date;
    		}
    		if(!empty($this->input->post('staff',true)))
    		{
    		    $staff = $this->input->post('staff',true);
    		    $args['staff'] = $staff;
    		}
        }
        
        $other_det = $this->work->get_other_details($args);
        
        $users = $this->user->listing(array());
        
        $this->template->title('Other Report');
        $this->template->main_heading('Other Report');
        $this->template->slice('work/other_search',array('fdate'=>$from_date,'tdate'=>$to_date,'users'=>$users,'user'=>$staff));
        $this->template->slice('work/other_report',array('other_det'=>$other_det,'users'=>$users));
        $this->template->render(); 
    }
}    
?>