<? if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Work_estimate extends MY_Controller {

    public function __construct(){
		parent ::__construct();
			
		$this->utype = $this->session->userdata('utype'); 
        $this->uid = $this->session->userdata('uid');
            
        $this->load->model('product/product_model','product');
        $this->load->model('client/client_model','client');
        $this->load->model('estimate/estimate_model','estimate');
        $this->load->model('work/work_model','work');
        //$this->load->library('general');
        $this->load->library(array('general','to_words'));
	}
	
	public function add(){
        $edate=date('Y-m-d'); $client_id=""; $disabled=""; $work_array=array();
        if(isset($_POST['btn_get'])){
            $edate = $this->input->post('edate');
            $client_id = $this->input->post('client_id');
            $disabled = "disabled";
            $work_array = $this->work->get_paid_pending($client_id);
        }
        
        if(isset($_POST['btn_save'])){
            $data = $this->input->post(NULL,true);
            $client = $data['client'];
            $e_date = $data['e_date'];
            $posted = $data['posted'];
            if($client!=''){
                if(!empty($posted)){
                    $row = $this->db->select_max('refno')->from('work_estimate')->get()->row_array();
                    $refno = $row['refno']+1;
                    $est_array = array();
                    $est_array['refno'] = $refno;
                    $est_array['edate'] = $e_date;
                    $est_array['client_id'] = $client;
                    $esid = $this->work->insert("work_estimate",$est_array);
                    if($esid){
                        foreach($posted as $work){
                            $item_array = array();
                            $item_array['eid'] = $esid;
                            $item_array['work_id'] = $work;
                            $item_array['wtime'] = $data["wtime$work"];
                            $item_array['amount'] = $data["wamount$work"];
                            
                            $this->work->insert("work_estimate_items",$item_array);
                        }
                    }
                }else{
                    $this->message->set('Select atleast one item from the list !!','w');
                }
            }else{
                $this->message->set('Invalid Client !!','w');
            }
            redirect('work_estimate/report');
        }
        
        $clients = $this->client->listing(array('status'=>1));
        
        $this->template->title('Work Estimate');
        $this->template->main_heading('Add Work Estimate');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/add',array('clients'=>$clients,'client_id'=>$client_id,'edate'=>$edate,'disabled'=>$disabled,'work_array'=>$work_array));
        $this->template->render();
    }
    
    public function report(){
        $clients = $this->client->listing(array('status'=>1));
        $client_id='';$estatus='all'; $estimates=$args=array(); $fdate=$tdate=date('Y-m-d');
        $row = $this->db->from('work_estimate')->where('status',1)->order_by('edate','asc')->get()->row_array();
        if(!empty($row)){
            $fdate = date('Y-m-d',strtotime($row['edate']));
        }
        if(isset($_POST['btn_get'])){
            $data = $this->input->post(NULL,true);
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
            }
            if($data['tdate']!=''){
                $tdate = date('Y-m-d',strtotime($data['tdate']));
            }
            if($data['estatus']!='all'){
                $estatus = $data['estatus'];
                $args['conditions']['estatus'] = $estatus;
            }
        }
        
        if($fdate!=''){
            $args['conditions']['edate >='] = $fdate;
        }
        if($tdate!=''){
            $args['conditions']['edate <='] = $tdate;
        }
        
        $estimates = $this->work->get_estimate_report($args);
        if(empty($estimates)){
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Work Estimate');
        $this->template->main_heading('Work Estimate Report');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'tdate'=>$tdate,'estimates'=>$estimates));
        $this->template->render();
    }
    
    public function estimate_pdf()
    { 
        $pdf_name = 'Work_estimate'; $pdf_contents = '';
			
		if(!$this->uri->segment(3))
		{
			echo "<script>alert('Invalid Estimate');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		
		$estimate_id = $this->uri->segment(3);
		
		$estimate_det = $this->work->get_estimate_det(array('conditions'=>array('e.id'=>$estimate_id)));

		if(empty($estimate_det))
		{
			echo "<script>alert('Invalid Estimate');window.close();</script>";
		}
		else
		{
		    $pdf_contents = $this->load->view('work_estimate/estimate_pdf',array('estimate_det'=>$estimate_det),true);
		} 
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function view()
    {
        $estimate_id = $this->uri->segment(3);
        
        $statuses = array('0'=>'Pending','1'=>'Invoice');
        $estimate_det = $this->work->get_estimate_det(array('conditions'=>array('e.id'=>$estimate_id)));
        
        if(empty($estimate_det))
        {
            $this->message->set('Invalid Estimate !!','w');
        }
        
        $this->template->title('Work Estimate');
        $this->template->main_heading('View Work Estimate');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/view',array('estimate_det'=>$estimate_det,'statuses'=>$statuses));
        $this->template->render();
    }
    
    public function delete()
    {
        $estimate_id = $this->uri->segment(3);
        
        $row = $this->db->select('*')->from('work_estimate')->where(array('id'=>$estimate_id,'status !='=>0))->get()->row_array();
        if(!empty($row))
        {
            if($this->db->update('work_estimate',array('status'=>0),array('id'=>$estimate_id)))
            {
                $this->db->update('work_estimate_items',array('status'=>0),array('eid'=>$estimate_id));
                $this->message->set('Estimate Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Estimate could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Invalid Estimate !!','w');
        }
        
        redirect('work_estimate/report');
    }
    
    public function invoice()
    {
        $estimate_id = $this->uri->segment(3);
        
        $statuses = array('0'=>'Pending','1'=>'Invoice');
        $estimate_det = $this->work->get_estimate_det(array('conditions'=>array('e.id'=>$estimate_id)));
        
        $row = $this->db->select_max('refno')->from('work_invoice')->get()->row_array();
        $refno = $row['refno']+1;
        
        if(empty($estimate_det))
        {
            $this->message->set('Invalid Estimate !!','w');
            redirect('work_estimate/report');
        }
        else
        {
            if(isset($_POST['btn_save']))
            {
                $data = $this->input->post(NULL,true);
                
                $invoice_array['idate'] = date('Y-m-d',strtotime($data['idate']));
                $invoice_array['refno'] = $refno;
                $invoice_array['es_id'] = $estimate_id;
                $invoice_array['client_id'] = $estimate_det[0]['client_id'];
                
                $inv_id = $this->product->insert('work_invoice',$invoice_array);
                if($inv_id){
                    foreach($estimate_det as $estimate)
                    {
                        $items_array=array();
                        $items_array['inv_id'] = $inv_id;
                        $items_array['work_id'] = $estimate['work_id'];
                        $items_array['wtime'] = $estimate['wtime'];
                        $items_array['amount'] = $estimate['amount'];
                        
                        $this->product->insert('work_invoice_items',$items_array);
                    }
                    
                    $this->db->update('work_estimate',array('estatus'=>1),array('id'=>$estimate_id));
                    
                    $this->message->set('Invoice Generated Successfully !','s');
                }else{
                    $this->message->set('Invoice could not be Generated !','e');
                }
                redirect('work_estimate/report');
            }
        }
        
        $this->template->title('Work Invoice');
        $this->template->main_heading('New Work Invoice');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/invoice',array('estimate_det'=>$estimate_det,'statuses'=>$statuses,'refno'=>$refno,'estimate_id'=>$estimate_id));
        $this->template->render();
    }
    
    public function invoice_report()
    {
        $clients = $this->client->listing(array('status'=>1));
        $client_id=""; $fdate=$edate=date('Y-m-d'); $invoices=array(); $args = array();
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['idate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['idate <='] = $edate;
            }
        }
        
        $invoices = $this->work->get_invoice_report($args);
        
        if(empty($invoices))
        {
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Work Invoice');
        $this->template->main_heading('Work Invoice Report');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/invoice_report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'invoices'=>$invoices));
        $this->template->render();
    }
    
    public function invoice_pdf()
    { 
        $pdf_name = 'Work_invoice'; $pdf_contents = '';
			
		if(!$this->uri->segment(3))
		{
			echo "<script>alert('Invalid Invoice');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		
		$invoice_id = $this->uri->segment(3);
		
		$invoice_det = $this->work->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));

		if(empty($invoice_det))
		{
			echo "<script>alert('Invalid Invoice');window.close();</script>";
		}
		else
		{
		    $pdf_contents = $this->load->view('work_estimate/invoice_pdf',array('invoice_det'=>$invoice_det),true);
		} 
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function view_invoice()
    {
        $invoice_id = $this->uri->segment(3);
        
        $invoice_det = $this->work->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        
        if(empty($invoice_det))
        {
            $this->message->set('Invalid Invoice !!','w');
        }
        
        $this->template->title('Work Invoice');
        $this->template->main_heading('View Work Invoice');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/view_invoice',array('invoice_det'=>$invoice_det));
        $this->template->render();
    }
    
    public function delete_invoice()
    {
        $invoice_id = $this->uri->segment(3);
        
        $row = $this->db->select('*')->from('work_invoice')->where(array('id'=>$invoice_id,'status !='=>0))->get()->row_array();
        if(!empty($row))
        {
            $estimate_id = $row['es_id'];
            if($this->db->update('work_invoice',array('status'=>0),array('id'=>$invoice_id)))
            {
                $this->db->update('work_estimate',array('estatus'=>0),array('id'=>$estimate_id));
                $this->message->set('Invoice Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Invoice could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Invalid Invoice !!','w');
        }
        
        redirect('work_estimate/invoice_report');
    }
    
    public function payment()
    {
        $invoice_id = $this->uri->segment(3);
        $nid=0;
        $invoice_det = $this->work->get_all_invoice(array('conditions'=>array('i.id'=>$invoice_id)));
        $payment_modes = $this->general->payment_modes();
        
        if(empty($invoice_det))
        {
            $this->message->set('Invalid Invoice !!','w');
        }
        else
        {
            if(isset($_POST['btn_save']))
            {
                $data = $this->input->post(NULL,true);
                
                if(!empty($data['posted']))
                {
                    $row = $this->db->select_max('refno')->from('work_payments')->get()->row_array();
                    $refno = $row['refno']+1;
                    $pdate = date('Y-m-d',strtotime($data['pdate']));
                    
                    $pay_array = array('pdate'=>$pdate,'refno'=>$refno,'client_id'=>$invoice_det[0]['client_id'],'pmode'=>$data['pmode']);
                    
                    $pay_id = $this->product->insert('work_payments',$pay_array);
                    if($pay_id)
                    {
                        $total=0; 
                        foreach($data['posted'] as $item_id)
                        {
                            $item_array = array();
                            $item_array['pay_id'] = $pay_id;
                            $item_array['inv_id'] = $item_id;
                            $item_array['work_id'] = $data["work$item_id"];
                            $item_array['amount'] = $data["amount$item_id"];
                            
                            $total += $data["amount$item_id"];
                            
                            $this->product->insert('work_payment_items',$item_array);
                            $this->db->update('work_invoice_items',array('payment_status'=>1),array('id'=>$item_id));
                        }
                        
                        $nid++;
			            $voucher_array= array();
                        $voucher_array['group_id'] = $this->general->get_group_id('vouchers');
                        $voucher_array['vtype_id'] = 2;
                        $voucher_array['vno'] = $refno;
                        $voucher_array['vorder_no'] = $nid;
                        $voucher_array['vdate'] = $pdate;
                        $voucher_array['dr_ledger'] = $data['pmode'];
                        $voucher_array['cr_ledger'] = 19;
                        $voucher_array['vamount'] = $total;
                        $voucher_array['table_name'] = 'work_payments';
                        $voucher_array['table_id'] = $pay_id;
                        $voucher_array['status'] = 1;
                        $this->product->insert('vouchers',$voucher_array);
                    }
                    
                    redirect('work_estimate/invoice_report');
                }
                else
                {
                    $this->message->set('Select atleast one item from the list !!','w');
                }
            }
        }
        
        $this->template->title('Work Payment');
        $this->template->main_heading('Work Payment');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/payment',array('invoice_det'=>$invoice_det,'invoice_id'=>$invoice_id,'payment_modes'=>$payment_modes));
        $this->template->render();
    }
    
    public function payment_report()
    {
        $clients = $this->client->listing(array('status'=>1));
        $client_id=""; $fdate=$edate=date('Y-m-d'); $estimates=array(); $args = array();
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['client_id'] = $client_id;
            }
            if($data['fdate']!=''){
                $fdate = date('Y-m-d',strtotime($data['fdate']));
                $args['conditions']['pdate >='] = $fdate;
            }
            if($data['edate']!=''){
                $edate = date('Y-m-d',strtotime($data['edate']));
                $args['conditions']['pdate <='] = $edate;
            }
        }
        
        $payments = $this->work->get_payment_report($args);
        
        if(empty($payments))
        {
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Work Payment');
        $this->template->main_heading('Work Payment Report');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/payment_report',array('clients'=>$clients,'client_id'=>$client_id,'fdate'=>$fdate,'edate'=>$edate,'payments'=>$payments));
        $this->template->render();
    }
    
    public function payment_pdf()
    { 
        $pdf_name = 'Work_payment'; $pdf_contents = '';
			
		if(!$this->uri->segment(3))
		{
			echo "<script>alert('Invalid Payment');window.close();</script>";
		}
		
		$this->load->library('my_pdf');
		
		$payment_id = $this->uri->segment(3);
		
		$payment_det = $this->work->get_all_payment(array('conditions'=>array('p.id'=>$payment_id)));

		if(empty($payment_det))
		{
			echo "<script>alert('Invalid Payment');window.close();</script>";
		}
		else
		{
		    $pdf_contents = $this->load->view('work_estimate/payment_pdf',array('payment_det'=>$payment_det),true);
		} 
		
        ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
    }
    
    public function view_payment()
    {
        $payment_id = $this->uri->segment(3);
        
        $payment_det = $this->work->get_all_payment(array('conditions'=>array('p.id'=>$payment_id)));
        
        if(empty($payment_det))
        {
            $this->message->set('Invalid Payment !!','w');
        }
        
        $this->template->title('Work Payment');
        $this->template->main_heading('View Work Payment');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/view_payment',array('payment_det'=>$payment_det));
        $this->template->render();
    }
    
    public function delete_payment()
    {
        $payment_id = $this->uri->segment(3);
        
        $row = $this->db->select('*')->from('work_payments')->where(array('id'=>$payment_id,'status !='=>0))->get()->row_array();
        if(!empty($row))
        {
            if($this->db->update('work_payments',array('status'=>0),array('id'=>$payment_id)))
            {
                $rows1 = $this->db->select('*')->from('work_payment_items')->where(array('pay_id'=>$payment_id,'status !='=>0))->get()->result_array();
                foreach($rows1 as $row1)
                {
                    $this->db->update('work_payment_items',array('status'=>0),array('id'=>$row1['id']));
                    $this->db->update('work_invoice_items',array('payment_status'=>0),array('id'=>$row1['inv_id']));
                }
                $this->db->update('vouchers',array('status'=>0),array('table_name'=>'work_payments','table_id'=>$payment_id));
                
                $this->message->set('Invoice Deleted Successfully !!','s');
            }
            else
            {
                $this->message->set('Invoice could not be Deleted !!','e');
            }
        }
        else
        {
            $this->message->set('Invalid Invoice !!','w');
        }
        
        redirect('work_estimate/payment_report');
    }
    
    public function due_report()
    {
        $clients = $this->client->listing(array('status'=>1));
        $client_id=""; $invoices=array(); $args = array();
        if(isset($_POST['btn_get']))
        {
            $data = $this->input->post(NULL,true);
            
            if($data['client_id']!=''){
                $client_id = $data['client_id'];
                $args['conditions']['i.client_id'] = $client_id;
            }
        }
        
        $invoices = $this->work->get_invoice_due_report($args);
        
        if(empty($invoices))
        {
            $this->message->set('No Result Found !!','w');
        }
        
        $this->template->title('Work Invoice');
        $this->template->main_heading('Due Report');
        $this->template->slice('cms/message');
        $this->template->slice('work_estimate/due_report',array('clients'=>$clients,'client_id'=>$client_id,'invoices'=>$invoices));
        $this->template->render();
    }
}