<?php
class Accounts
{
	public $CI;
	public $branch_id;
	public $created_by;

	public function __construct(){

		$this->CI =& get_instance();
		$this->branch_id = $this->CI->session->userdata('under_id');
		$this->created_by = $this->CI->session->userdata('id');
	}

	public function cur_open_bal($ledger_id,$type = 0)
	{ $row = array();
		//type = 1 => returns vat and open_date , 0 => returns open balance and dc
		$open_date = $this->CI->dms->get_fiscal_year()['start_date'];
	
		$row = $this->CI->db->select(array('a.open_date','a.open_amount','b.dc'))->from('ledger_open_bals as a')->join('ledgers as b','a.ledger_id=b.id')->where(array('a.ledger_id' => $ledger_id,'a.open_date' => $open_date,'a.status' => 1))->get()->row_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

	public function get_dc($ledger_id)
	{
		$row = $this->CI->db->select('dc')->get_where('ledgers',array('id' => $ledger_id))->row_array();
		if(!empty($row))
		{
			return $row['dc'];
		}
		return false;
	}

	public function get_legders($args = array())
	{
		if(isset($args['columns']))
		{
			$this->CI->db->select($args['columns'])->from('ledgers as a')->join('account_sub_groups as b','a.sgroup_id=b.id')->where('sgroup_id!=',15)->where('a.status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			if(isset($args['or']))
			{
				$this->CI->db->where($args['or']);
			}
			$row = $this->CI->db->get()->result_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}
		else
		{
			$ledger_array = array();
			$this->CI->db->select(array('id','ledger_name'))->from('ledgers')->where('sgroup_id !=',15)->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			$row = $this->CI->db->get()->result_array();
			foreach($row as $key => $value)
			{
				$ledger_array[$value['id']] = $value['ledger_name'];
			}
			return $ledger_array;
		}
	}

	public function get_ledger_name($ledger_id)
	{
		$row = $this->CI->db->select('ledger_name')->get_where('ledgers',array('id' => $ledger_id))->row_array();
		if(!empty($row)){
			return $row['ledger_name'];
		}
		return false;
	}

	public function get_account_groups($args = array())
	{
		if(isset($args['columns']))
		{
			$this->CI->db->select($args['columns'])->from('account_sub_groups')->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			if(isset($args['or']))
			{
				$this->CI->db->where($args['or']);
			}
			$row = $this->CI->db->get()->result_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}
		else
		{
			$sub_group_array = array();
			$this->CI->db->select(array('id','sub_group'))->from('account_sub_groups')->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			$row = $this->CI->db->get()->result_array();
			foreach($row as $key => $value)
			{
				$sub_group_array[$value['id']] = $value['sub_group'];
			}
			return $sub_group_array;
		}
	}

	public function get_vouchers($args = array())
	{
		$this->CI->db->select($args['columns'])->from('vouchers as a')->join('ledgers as c','a.dr_ledger = c.id or a.cr_ledger=c.id')->join('voucher_banks as b','a.group_id = b.group_id','left')->where(array('a.status' => 1));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		if(isset($args['between']))
		{
			$this->CI->db->where($args['between']['column']." between '".$args['between']['first']."' and '".$args['between']['last']."'");
		}
		$this->CI->db->order_by('a.vdate','asc');
		$this->CI->db->order_by('a.vtype_id','asc');
		$this->CI->db->order_by('a.vno','asc');
		$this->CI->db->order_by('a.vorder_no','asc');
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function voucher_name($vtype_id)
	{
		$row = $this->CI->db->select('vtype')->get_where('voucher_types',array('id' => $vtype_id))->row_array();
		if(!empty($row)){
			return $row['vtype'];
		}
		return false;
	}

	public function last_closed_yr($date = NULL)
	{
		$where = array('close_status' => 0,'status' => 1);
		if($date != NULL){
			$where['end_date <'] = $date;
		}
		$row = $this->CI->db->select(array('id','start_date','end_date'))->from('fiscal_year_master')->where($where)->order_by('fiscal_order','desc')->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function fiscal_years($to_date,$from_date = NULL)
	{
		$to_date = date('Y-m-d',strtotime($to_date));
		$this->CI->db->select(array('id','start_date','end_date'))->from('fiscal_year_master');
		if($from_date != NULL)
		{
			$from_date = date('Y-m-d',strtotime($from_date));
			$this->CI->db->where("start_date between '$from_date' and '$to_date'",NULL,false);
		}
		else
		{
			$this->CI->db->where('start_date <=',$to_date);
		}
		$this->CI->db->where(array('close_status' => 1,'status' => 1))->order_by('fiscal_order','asc');
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function opening_bal($id,$to_date,$type = 0,$from_date = NULL)
	{
		//type = 0 => ledger_id , type = 1 => sgroup_id , type = 2 => ledger_id for all branches , type = 3 => sgroup_id for all branches

		$to_date = date('Y-m-d',strtotime($to_date));
		$closed = $this->last_closed_yr($to_date);
		$this->CI->db->select_sum('open_amount')->from('ledgers as a')->join('ledger_open_bals as b','a.id=b.ledger_id')->where(array('a.status' => 1,'b.status' => 1));
		if($type == 0){
			$this->CI->db->where(array('a.id' => $id,'b.branch_id' => $this->branch_id));
		}
		elseif($type == 1){
			$this->CI->db->where(array('a.sgroup_id' => $id,'b.branch_id' => $this->branch_id));
		}
		elseif($type == 2){
			$this->CI->db->where(array('a.id' => $id));
		}
		else{
			$this->CI->db->where(array('a.sgroup_id' => $id));
		}

		if($closed){
			$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
		}
		if($from_date == NULL){
			$this->CI->db->where('b.open_date <=',$to_date);
		}
		else{
			$from_date = date('Y-m-d',strtotime($from_date));
			$this->CI->db->where("b.open_date between '".$from_date."' and '".$to_date."'");
		}
		$row = $this->CI->db->get()->row_array();
		return $row['open_amount'];
	}

	public function voucher_bal($id,$to_date,$type = 0,$from_date = NULL)
	{
		//type = 0 => ledger_id , type = 1 => sgroup_id , type = 2 => ledger_id for all branches , type = 3 => sgroup_id for all branches

		$where = "a.status=1";
		$condition_array = array();
		$to_date = date('Y-m-d',strtotime($to_date));
		$closed = $this->last_closed_yr($to_date);
		if($type == 0){
			$where .= " and a.branch_id=".$this->branch_id." and b.id = ?";
		}
		elseif($type == 1){
			$where .= " and a.branch_id=".$this->branch_id." and b.sgroup_id = ?";
		}
		elseif($type == 2){
			$where .= " and b.id = ?";
		}
		else{
			$where .= " and b.sgroup_id = ?";
		}
		$condition_array[0] = $id;
		if($from_date == NULL){
			if($closed){
				$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
				if($from_date == $to_date){
					return array('dr_amount' => 0,'cr_amount' => 0);
				}
				else{
					$to_date = date('Y-m-d',(strtotime($to_date)-86400));
				}
				$where .= " and a.vdate between ? and ?";
				$condition_array[1] = $from_date;
				$condition_array[2] = $to_date;
			}
			else{
				$where .= " and a.vdate < ?";
				$condition_array[1] = $to_date;
			}
		}
		else{
			$from_date = date('Y-m-d',strtotime($from_date));
			$where .= " and a.vdate between ? and ?";
			$condition_array[1] = $from_date;
			$condition_array[2] = $to_date;
		}
		$qry1 = "select sum(vamount) as vamount from vouchers as a inner join ledgers as b on a.dr_ledger=b.id where $where";
		$qry2 = "select sum(vamount) as vamount from vouchers as a inner join ledgers as b on a.cr_ledger=b.id where $where";

		$qry1_res = $this->CI->db->query($qry1, $condition_array);
		$qry2_res = $this->CI->db->query($qry2, $condition_array);

		$dr_amount = $qry1_res->row();
		$cr_amount = $qry2_res->row();
		return array('dr_amount' => $dr_amount->vamount,'cr_amount' => $cr_amount->vamount);
	}

	public function get_vid($vtype)
	{
		$row = $this->CI->db->select('vid')->get_where('voucher_types',array('id' => $vtype))->row_array();
		return $row['vid'];
	}

	public function account_group_name($id)
	{
		$row = $this->CI->db->select('sub_group')->get_where('account_sub_groups',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row['sub_group'];
		}
		return false;
	}

	public function get_voucher_sum($args = array())
	{
		$this->CI->db->select_sum('vamount')->from('vouchers')->where(array('status' => 1));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		$row = $this->CI->db->get()->row_array();
		return $row['vamount'];
	}
	
	public function get_voucher_summation($args = array())
	{
		$this->CI->db->select_sum('vamount')->from('vouchers')->where(array('status' => 1,));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		$row = $this->CI->db->get()->row_array();
		return $row['vamount'];
	}
}