<?php
class dms{

var $CI;
var $companyID;
var $branchID;
var $createdBY;

	#---------------------------------------------------------

	public function __construct(){

		$this->CI =& get_instance();
		
		$this->createdBY = $this->CI->session->userdata('uid');
		$this->sessionID = $this->CI->session->userdata('utype');
	}

	#----------------------------------------------------------
	#purpose : to get the company_id of logged user
	public function company_id(){

		$row = $this->CI->db->select('company_id')->get_where('users',array('id'=>$this->createdBY,'status'=>1))->row_array();
		return $row['company_id'];

	}
	
	/*public function Get_menu(){

        $row22=array();
		$row = $this->CI->db->select('*')->get_where('menu_master',array('designation_id'=>$this->sessionID))->row_array();
	
		return $row;

	}*/
	#---------------------------------------------------------
	public function have_access($menu_id){

		if($this->createdBY == -1){ return true; }
		$total = $this->CI->db->select('id')->get_where('user_privileges',array('owner_id'=>$this->createdBY,'menu_id'=>$menu_id,'user_group'=>'individual'))->num_rows();
		if($total == 0){
			return false;
		}else{
			$this->CI->db->select(array('mm.*'));
			$this->CI->db->from('user_privileges up');
			$this->CI->db->join('menu_master mm','up.menu_id=mm.id');
			$this->CI->db->where(array('owner_id'=>$this->createdBY,'up.menu_id'=>$menu_id,'user_group'=>'individual'));
			return $this->CI->db->get()->row_array();
		}

	}
	
	public function get_staff_name($sid){
	    
	    $staff_name ="";
	    
		$row = $this->CI->db->select(array('fname'))->from('users')->where(array('id' => $sid))->get()->row_array();
		
		if(!empty($row)){ $staff_name = $row['fname']; }
		return $staff_name;
	}
	
	public function get_work_type_name($sid){
	    
	    $type_name ="";
	    
		$row = $this->CI->db->select(array('wtype'))->from('work_types')->where(array('id' => $sid))->get()->row_array();
		
		if(!empty($row)){ $type_name = $row['wtype']; }
		return $type_name;
	}
	
	public function get_work_last_updation($wid){

        $ustat = 0;
		$row = $this->CI->db->select(array('sstatus','estatus'))->from('work_status')->where(array('work_id' => $wid,'staff_id'=>$this->createdBY,'status' => 1,'type' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
		
		if(!empty($row))
		{ 
		    $ustat = $row['sstatus'];
		    if(!empty($row['estatus']) && $row['estatus'] !='' && $row['estatus'] !='0' )
		    {
		        $ustat = $row['estatus'];
		    }
		}
		return $ustat;
	}

    public function get_work_last_updation1($wid,$uid){

        $ustat = 0;
		$row = $this->CI->db->select(array('sstatus','estatus'))->from('work_status')->where(array('work_id' => $wid,'staff_id'=>$uid,'status' => 1,'type' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
		
		if(!empty($row))
		{ 
		    $ustat = $row['sstatus'];
		    if(!empty($row['estatus']) && $row['estatus'] !='' && $row['estatus'] !='0' )
		    {
		        $ustat = $row['estatus'];
		    }
		}
		return $ustat;
	}
	
	
	public function get_work_allowed_time($wid){

        $wtime = 0;
		$row = $this->CI->db->select(array('wtime'))->from('works')->where(array('id' => $wid,'status' => 1))->order_by('id','desc')->limit(1)->get()->row_array();
		
		if(!empty($row))
		{ 
		   $wtime = $row['wtime'];
		}
		return $wtime;
	}
	
	public function user_list($args=array())
	{
		$users = array();
		$users[''] = 'Select'; 
		$this->CI->db->select(array('*'));
		$this->CI->db->from('users');
			
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		$this->CI->db->order_by('fname','asc');
			
		$rows = $this->CI->db->get()->result_array();
		if(!empty($rows))
		{
			foreach($rows as $key=>$row)
			{
					$users[$row['id']] = $row['fname'];
			}
		}
		return $users;
	}

	public function worktype_list($args=array())
	{
		$clients = array();
		$clients[''] = 'Select';
		$this->CI->db->select(array('id','wtype','wstatus','del_status'));
		$this->CI->db->from('work_types');
		
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
			
		$rows = $this->CI->db->get()->result_array();
		if(!empty($rows))
		{
				foreach($rows as $key=>$row)
				{
					$clients[$row['id']] = $row['wtype'];
				}
		}
		return $clients;
	}
	
	public function client_list($args=array())
	{
			$clients = array();
			$clients[''] = 'Select';
			$this->CI->db->select(array('*'));
			$this->CI->db->from('client_master');
			
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			
			$rows = $this->CI->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$clients[$row['id']] = $row['name'];
				}
			}
			return $clients;
	}
	
	
	#----------------------------------------------------------
	#purpose : to get the default fiscal years
	public function get_default(){

		$row = $this->CI->db->select(array('id','start_date','end_date'))->from('fiscal_year_master')->where(array('company_id' => $this->CI->session->userdata('company_id'),'status' => 1))->order_by('fiscal_order','asc')->limit(1)->get()->row_array();
		return $row;
	}
	#-----------------------------------------------------------
	#purpose : to get the logged in user's branch
	public function get_branch(){

			$row = $this->CI->db->select('branch_id')->get_where('users',array('id'=>$this->createdBY,'status'=>1))->row_array();
			return $row['branch_id'];
	}
	#-----------------------------------------------------------
	#purpuse:get default physical year id
	public function get_default_fiscal_id(){

		$row = $this->CI->db->select('fiscal_yr_id')->get_where('users',array('company_id'=>$this->companyID,'id'=>$this->createdBY))->row_array();
		if(empty($row)){
			return false;
		}else{
			return $row['fiscal_yr_id'];
		}
	}
#----------------------------------------------get financial year---------------------------------------------------------------
public function get_default_financial_id(){

		$row = $this->CI->db->select('id')->get_where('master_financial_year',array('default1'=>1))->row_array();
		if(empty($row)){
			return false;
		}else{
			return $row['id'];
		}
	}
	
	public function get_default_fiscal_year(){

		$row = $this->CI->db->select(array('s_date','e_date'))->get_where('master_financial_year',array('default1'=>1))->row_array();
		if(!empty($row)){
			if($row['e_date'] == '0000-00-00' || empty($row['e_date'])){
				$row['e_date'] = date('Y-m-d');
			}
			return $row;
		}
		return false;
	}
	
	public function get_acyear($id){

		$row = $this->CI->db->select(array('s_date','e_date'))->get_where('master_financial_year',array('id'=>$id))->row_array();
		return $row['s_date']." - ".$row['e_date'];
	}
#------------------------------------------------------------end----------------------------------------------------------------
	#------------------------------------------------------------
	#purpuse:get financial year starting and ending date
	public function get_fiscal_year(){

		$row = $this->CI->db->select(array('start_date','end_date'))->get_where('fiscal_year_master',array('status'=>1,'close_status'=>1))->row_array();
		if(!empty($row)){
			if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
				$row['end_date'] = date('Y-m-d');
			}
			return $row;
		}
		return false;
	}

	#------------------------------------------------------------
	#purpose get item units of each item
	public function get_units($item_id){

		$this->CI->db->select('unit_id');
		$this->CI->db->from('item_master');
		$this->CI->db->where('id',$item_id);
		$item_unit = $CI->db->get()->row_array();
		if(!empty($item_unit))
		{
			$this->CI->db->select(array('id','symbol'));
			$this->CI->db->from('unit_master');
			$this->CI->db->or_where(array('id'=>$item_unit['unit_id'],'first_unit'=>$item_unit['unit_id'],'second_unit'=>$item_unit['unit_id']));
			$rows = $this->CI->db->get()->result_array();

			$unit =array();
			foreach($rows as $row){
				$unit[$row['id']] = $row['symbol'];
			}
			return $unit;
		}
		return false;
	}

	#------------------------------------------------------------
	#purpose get users
	public function get_users($args = array()){

		$type = 0;
		if(!isset($args['columns'])){
			$type = 1;
			$args['columns'] = array('id','fname','utype');
		}
		$args['conditions']['status'] = 1;
		$rows = $this->CI->db->select($args['columns'])->order_by('fname','ASC')->get_where('users',$args['conditions'])->result_array();
		$users = array();
		if(!empty($rows)){
			foreach($rows as $row){
				if($type == 1){
						$users[$row['id']] = strtoupper($row['fname']);
				}else{
					$users[$row['id']] = $row;
				}
			}
		}
		return $users;
	}

	#------------------------------------------------------------
	#purpose : to get the logged in user's designation_id and desig name
	public function get_desig($user_id,$type = 0){

		$columns = array('designation_id');
		if($type == 1){
			$columns[] = 'designation_name';
		}
		$this->CI->db->select($columns)->from('users as a');
		if($type == 1){
			$this->CI->db->join('designation_master as b','a.designation_id = b.id');
		}
		$this->CI->db->where('a.id',$user_id);
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			if($type == 0){
				return $row['designation_id'];
			}
			return $row;
		}
		return false;
	}

	#------------------------------------------------------------
	#purpose : to get the area name
	public function get_area($area_id){

		$row = $this->CI->db->select('area')->get_where('area_master',array('id'=>$area_id,'status'=>1))->row_array();
		if(!empty($row)){
			return $row['area'];
		}
		return false;
	}

	#------------------------------------------------------------
	#purpose : to get the user name
	public function get_user_name($user_id){

		$row = $this->CI->db->select(array('fname','lname'))->get_where('users',array('id'=>$user_id))->row_array();
		if(!empty($row)){
			return $row['fname']." ".$row['lname'];
		}
		return false;
	}

	#------------------------------------------------------------

	public function get_main_branch($branchID = NULL,$type = 0){

		if(empty($branchID)){
			$row = $this->CI->db->select(array('id','branch_name'))->get_where('branch_master',array('company_id'=>$this->CI->session->userdata('company_id'),'branch_type'=>1,'status'=>1))->row_array();
			if($type == 0){
				return $row['id'];
			}
			return $row['branch_name'];

		}else{

			$row = $this->CI->db->select('branch_type')->get_where('branch_master',array('company_id'=>$this->companyID,'id'=>$branchID,'status'=>1))->row_array();

			if($row['branch_type'] == 1){
				return true;
			}
			return false;
		}
	}

	#------------------------------------------------------------

	public function get_user_branch($userID){

		$row = $this->CI->db->select(array('branch_id','designation_id','department_id'))->get_where('users',array('id'=>$userID))->row_array();

		if($row['designation_id'] == 3){
			$rows = $this->CI->db->select(array('retailer_name','retailer_address','retailer_landline','retailer_mobile'))->get_where('retailer_master',array('id'=>$row['branch_id']))->row_array();

			return array('name'=>$rows['retailer_name'],'address'=>$rows['retailer_address'],'land_line'=>$rows['retailer_landline'],'mobile'=>$rows['retailer_mobile']);

		}else{
			$rows = $this->CI->db->select(array('id','branch_name','branch_address','branch_landline','branch_mobile'))->get_where('branch_master',array('id'=>$row['branch_id']))->row_array();

			return array('id'=>$rows['id'],'name'=>$rows['branch_name'],'address'=>$rows['branch_address'],'land_line'=>$rows['branch_landline'],'mobile'=>$rows['branch_mobile']);
		}
	}

	#------------------------------------------------------------
	#purpose : to get the user phone no
	public function get_user_mobile_no($user_id){

		$row = $this->CI->db->select("mobile")->get_where('users',array('id'=>$user_id))->row_array();
		if(!empty($row)){
			return $row['mobile'];
		}
		return false;
	}

	#------------------------------------------------------------
	#purpose : to get any data from any table
	public function get_data($args = array()){

		$this->CI->db->select($args['columns'])->from($args['table']);
		if(isset($args['join'])){
			if(!isset($args['join']['type'])){
				$args['join']['type'] = 'inner';
			}
			$this->CI->db->join($args['join']['table'],$args['join']['on'],$args['join']['type']);
		}
		if(isset($args['conditions'])){
			$this->CI->db->where($args['conditions']);
		}
		if(isset($args['between'])){
			$this->CI->db->where($args['between'],NULL,false);
		}
		if(isset($args['or'])){
			$this->CI->db->where($args['or']);
		}
		if(isset($args['numrows'])){
			return $this->CI->db->get()->num_rows();
		}
		if(isset($args['order_by'])){
			$this->CI->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit'])){
			$this->CI->db->limit($args['limit'], $args['offset']);
		}
		return $this->CI->db->get()->result_array();
	}

	#---------------------------------------------------------------------

	public function list_user($user_type_id){

		$users = array();
		if($user_type_id == 1){

			$this->CI->load->model('branches/branch_model','branch');
			$users = $this->CI->branch->listing(array('id !='=>$this->CI->session->userdata('under_id')));

		}else if($user_type_id == 3){

			$this->CI->db->select(array('rt.id as r_id','rt.retailer_short_name','u.id'));
			$this->CI->db->from('retailer_master rt');
			$this->CI->db->join('users u','u.branch_id = rt.id');
			$this->CI->db->where(array('u.status'=>1,'u.designation_id'=>$user_type_id,'rt.status'=>1));
			$rows = $this->CI->db->get()->result_array();
			$users = array();
			if(!empty($rows)){
				foreach($rows as $row){
					$users[$row['id']] = $row['retailer_short_name'];
				}
			}

		}else{
			$this->CI->load->model('users/user_model','desig');
			$users = $this->CI->desig->listing(array('designation_id'=>$user_type_id,'branch_id'=>$this->CI->session->userdata('under_id')));

		}
		return $users;
	}

	#---------------------------------------------------------------------

	public function branch_type($id = NULL){
		if($id == NULL){
			$id = $this->CI->session->userdata('under_id');
		}
		$row = $this->CI->db->select('id')->get_where('branch_master',array('id' => $id,'company_id' => $this->CI->session->userdata('company_id'),'branch_type' => 1))->row_array();
		if(!empty($row)){
			return true;
		}
		return false;
	}

	public function desig_name($id)//designation name
	{
		$row = $this->CI->db->select('designation_name')->get_where('designation_master',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row['designation_name'];
		}
		return false;
	}

	public function get_months($start_date,$end_date,$type = 0)
	{
		$month_array = array();
		$start_date_time = strtotime($start_date);
		$end_date_time = strtotime($end_date);
		if($end_date_time >= $start_date_time)
		{
			$actual_end_date = date('Y-m-d', (strtotime($start_date." +1 year")-86400));
			$actual_end_date_time = strtotime($actual_end_date);
			if($end_date_time > $actual_end_date_time)
			{
				$end_date = $actual_end_date;
				$end_date_time = $actual_end_date_time;
			}
			$start_month = date('n',$start_date_time);
			$end_month = date('n',$end_date_time);
			$start_year = date('Y',$start_date_time);
			$end_year = date('Y',$end_date_time);
			if($start_year == $end_year)
			{
				for($i = $start_month;$i<=$end_month;$i++)
				{
					if($type == 1)
					{
						$from_date = $start_year."-".$i."-01";
						$month_from_date = $from_date;
						$days = cal_days_in_month(CAL_GREGORIAN,$i,$start_year);
						$to_date = $start_year."-".$i."-".$days;
						$month_to_date = $to_date;
						if($i == $start_month)
						{
							$from_date = $start_date;
						}
						if($i == $end_month)
						{
							$to_date = $end_date;
						}
						$month_array[$i] = array('month' => date('F',strtotime($from_date)),'from_date' => $from_date,'to_date' => $to_date,'month_from_date' => $month_from_date,'month_to_date' => $month_to_date);
					}
					else
					{
						$date = $start_year."-".$i."-01";
						$month_array[$i] = date('F',strtotime($date));
					}
				}
			}
			else
			{
				for($i = $start_month;$i<=12;$i++)
				{
					if($type == 1)
					{
						$from_date = $start_year."-".$i."-01";
						$month_from_date = $from_date;
						if($i == $start_month)
						{
							$from_date = $start_date;
						}
						$days = cal_days_in_month(CAL_GREGORIAN,$i,$start_year);
						$to_date = $start_year."-".$i."-".$days;
						$month_to_date = $to_date;
						$month_array[$i] = array('month' => date('F',strtotime($from_date)),'from_date' => $from_date,'to_date' => $to_date,'month_from_date' => $month_from_date,'month_to_date' => $month_to_date);
					}
					else
					{
						$date = $start_year."-".$i."-01";
						$month_array[$i] = date('F',strtotime($date));
					}
				}
				for($j = 1;$j<=$end_month;$j++)
				{
					if($type == 1)
					{
						$from_date = $end_year."-".$j."-01";
						$month_from_date = $from_date;
						$days = cal_days_in_month(CAL_GREGORIAN,$j,$end_year);
						$to_date = $end_year."-".$j."-".$days;
						$month_to_date = $to_date;
						if($j == $end_month)
						{
							$to_date = $end_date;
						}
						$month_array[$j] = array('month' => date('F',strtotime($from_date)),'from_date' => $from_date,'to_date' => $to_date,'month_from_date' => $month_from_date,'month_to_date' => $month_to_date);
					}
					else
					{
						$date = $end_year."-".$j."-01";
						$month_array[$j] = date('F',strtotime($date));
					}
				}
			}
		}
		return $month_array;
	}

	#-----------------------------------------------------
	public function get_branches(){

		$branches = array();

		$conditions = array('company_id' => $this->CI->session->userdata('company_id'),'status'=>1);
		if($this->get_main_branch($this->CI->session->userdata('under_id')) === false){
			$conditions['id'] = $this->CI->session->userdata('under_id');
		}
		$rows = $this->CI->db->select(array('id','branch_name','branch_short_name'))->from('branch_master')->where($conditions)->get()->result_array();
		foreach($rows as $key=>$row){
			$branches[$row['id']] = $row['branch_short_name'].' / '.$row['branch_name'];
		}
		return $branches;
	}
	#-----------------------------------------------------
	public function get_item_name($item_id){

		$row = $this->CI->db->select(array('item_code','item_name'))->get_where('item_master',array('id'=>$item_id,'status'=>1))->row_array();
		if(!empty($row)){
			return $row['item_code']."/".$row['item_name'];
		}
		return false;
	}
	#-----------------------------------------------------
	public function stock_value_type($fiscal_yr_id = NULL)
	{
		if($fiscal_yr_id == NULL){
			$fiscal_yr_id = $this->CI->session->userdata('fiscal_yr_id');
		}
		$row = $this->CI->db->select('value_type')->from('dms_stock_value_types')->where(array('company_id' => $this->CI->session->userdata('company_id'),'fiscal_yr_id <=' => $fiscal_yr_id))->order_by('fiscal_yr_id','desc')->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row['value_type'];
		}
		return false;
	}
	#-----------------------------------------------------
	public function get_years()
	{
		$year_array = array();
		$cur_year = date('Y');
		$pre_year = $cur_year - 25;
		$post_year = $cur_year + 25;
		for($i = $pre_year;$i <= $post_year;$i++)
		{
			$year_array[$i] = $i;
		}
		return $year_array;
	}
	#-----------------------------------------------------
	public function get_default_months()
	{
		$month = array('01' => 'January','02' => 'February','03' => 'March','04' => 'April','05' => 'May','06' => 'June','07' => 'July','08' => 'August','09' => 'September','10' => 'October','11' => 'November','12' => 'December');
		return $month;
	}
	#-----------------------------------------------------
	public function transaction_types()
	{
		// return array('' => lang('transaction-type'),1 => lang('cheque'),2 => lang('dd'),3 => lang('neft'),4 => lang('rtgs'),5 => lang('imps'));
		return array('' => lang('transaction-type'),1 => lang('cheque'),2 => lang('card'),3 => 'UPI');
	}

         public function get_qty($customer_id,$bill_no)
        {
          $row = $this->CI->db->select('amount')->get_where('customer_quantity',array('customer_id'=>$customer_id,'bill_no'=>$bill_no))->row_array();
		if(empty($row)){
			return false;
		}else{
			return $row['amount'];
		}
        }
        
        public function payment_modes($conditions=array())
	{
		$modes = array();
		$this->CI->db->select(array('id','ledger_name'))->from('ledgers')->where('id !=',7);
		if(empty($conditions['sub_groups'])){
			$sGroups = array(13,14,0);
		}else{
			$sGroups = $conditions['sub_groups'];
		}
		$this->CI->db->where_in('sgroup_id',$sGroups);
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$modes[$value['id']] = $value['ledger_name'];
			}
		}
		return $modes;
	}
	
	public function get_group_id($table)
	{
		$maxRow = $this->CI->db->select_max('group_id')->get_where($table)->row_array();
		if($maxRow['group_id'] != NULL){
			$maxRow['group_id'] = $maxRow['group_id']+1;
		}else{
			$maxRow['group_id'] = 1;
		}
		return $maxRow['group_id'];
	}
        
}