<?php	
class My_excel{

	var $excelObj=NULL;
	var $excelRdr=NULL;
	var $title = 'DMS excel report';
	var $CI;

	function __construct(){

		$this->CI =& get_instance();
		require_once APPPATH.'third_party/phpExcel/PHPExcel.php';
		$this->excelObj = new PHPExcel();
		$this->excelRdr = new PHPExcel_Reader_Excel2007();
	}
	function get_line(){
		return 5;
	}
	function report_head_line(){
		return 8;
	}
	#-----------------------------------------------------
	function get_columns()
	{
		$columns = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		return $columns;
	}


	#-----------------------------------------------------

	#date : 14-10-2014
	#purpose : set file title
	function set_title($title){
		$this->title = $title;
		$this->excelObj->getProperties()->setTitle($title);
	}

	#-----------------------------------------------------
	#date : 14-10-2014
	#purpose: set description
	function set_description($description){
		$this->excelObj->getProperties()->setDescription($description);
	}

	#-----------------------------------------------------

	#date : 15-10-2014
	#purpose: set borders for entire work sheet
	function set_border($cell=NULL){
		$styleArray = array(
		  'borders' => array(
			  'allborders' => array(
				  'style' => PHPExcel_Style_Border::BORDER_THIN
			  )
		  )
		);
		if(!empty($cell)){
			$this->excelObj->getActiveSheet()->getStyle($cell)->applyFromArray($styleArray);
		}else{
			$this->excelObj->getDefaultStyle()->applyFromArray($styleArray);
		}
	}
	
	#-----------------------------------------------------

	#date : 14-10-2014
	#purpose : set excel column headings and style
	function columns($array,$startingCell='A'){

		$this->set_cell_values($array,$startingCell);
		$endingCell = $startingCell[0];
		$this->set_bg_color_range($startingCell,count($array)-1);			
	}

	#-----------------------------------------------------
	
	function set_wrap_text($start_cell,$end_cell=NULL){
		if(!empty($end_cell)){$cell_address = $start_cell.':'.$end_cell;}else{$cell_address = $start_cell;}
		$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setWrapText(true); 
	}
	
	#-----------------------------------------------------
	
	function set_column_width($column,$width=15){
		$this->excelObj->getActiveSheet()->getColumnDimension($column)->setWidth($width);
	}
	
	#-----------------------------------------------------
	
	function set_font_size($cell,$size=12){
		$this->excelObj->getActiveSheet()->getStyle($cell)->getFont()->setSize($size);
	}
	
	#-----------------------------------------------------

	function set_report_head($headings,$width=array(),$start_line=NULL,$heads=NULL){

		if($start_line == NULL){
			$start_line = $this->report_head_line();
		}
		
		$char=$startingCell='A';
		foreach($headings as $key=>$head){
			if(!is_numeric($key)){
				$char = $key;
			}  
			$this->set_cell_value($char.$start_line,$head);
			if(isset($width[$key]) && !empty($width[$key])){
				$this->set_column_width($char,$width[$key]);
			}
			$char++;
		}
		if(empty($heads)){$heads=count($headings)-1;}
		$this->set_bg_color_range($startingCell.$start_line,$heads);
		$this->excelObj->getActiveSheet()->getStyle($startingCell.$start_line.':'.$char.$start_line)->getFont()->setSize(12);
		$this->excelObj->getActiveSheet()->getStyle($startingCell.$start_line.':'.$char.$start_line)->getFont()->setBold(true);
		$this->excelObj->getActiveSheet()->getStyle($startingCell.$start_line.':'.$char.$start_line)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;
		
	}
	
	#-----------------------------------------------------
	function set_cell_width($widthArray){
		$char='A';
		foreach($widthArray as $key=>$width){
			if(!is_numeric($key)){$char=$key;}
			$this->set_column_width($char,$width);
			$char++;
		}

	}
	#-----------------------------------------------------
	
	function set_data_align($cell_address,$align='C'){
		
		$text_align = array();
		if($align == 'C'){
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}else if($align == 'R'){
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		}else if($align == 'L'){
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
		}else if($align == 'M'){
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
		}else{
			$this->excelObj->getActiveSheet()->getStyle($cell_address)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}
		
	}
	
	#-----------------------------------------------------
	
	function merge_cell($cell){
		$this->excelObj->getActiveSheet()->mergeCells($cell);
	}
	
	#-----------------------------------------------------
	
	#date : 15-10-2014
	#purpose : setting auto cell width option
	function auto_cell_width(){
		for($col = 'A'; $col !== 'Z'; $col++) {
			$this->excelObj->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
		}
	}

	#------------------------------------------------------

	#date : 15-10-2014
	#purpose : fill excel cells from mysql fetch array
	function fill_from_db($result_set,$startingCell='A'){

		#set auto cell width
		$this->auto_cell_width();
		$cellCount = 3;
		foreach($result_set as $row){
			$this->set_cell_values($row,$startingCell.$cellCount);
			$cellCount++;
		}	
	}

	#------------------------------------------------------

	#date : 14-10-2014
	#purpose :set background color - range->upto how many cells horizontally
	function set_bg_color_range($startingCell='A',$range=NULL){

		$endingAlphabet = $startingCell[0];
		for($i=1;$i<=$range;$i++){ $endingAlphabet = ++$endingAlphabet;}

		$lastCellNo = substr($startingCell,1);	
		$endingCell = $endingAlphabet.$lastCellNo;

		$this->excelObj->getActiveSheet()->getStyle($startingCell.':'.$endingCell)->getFill()->applyFromArray(
			array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '#69AADB'),
				'font'=>array('color' => array('rgb'=>'#FFF'))
			)
		);
	}
	
	function set_bg_color($startingCell='A',$range=NULL,$color=NULL){

		$endingAlphabet = $startingCell[0];
		for($i=1;$i<=$range;$i++){ $endingAlphabet = ++$endingAlphabet;}

		$lastCellNo = substr($startingCell,1);	
		$endingCell = $endingAlphabet.$lastCellNo;

		$this->excelObj->getActiveSheet()->getStyle($startingCell.':'.$endingCell)->applyFromArray(
			array(
			    'fill' => array(
    				'type' => PHPExcel_Style_Fill::FILL_SOLID,
    				'color' => array('rgb' => $color)
				)
			)
		);
	}

	#------------------------------------------------------

	#date : 14-10-2014
	#purpose : set multiple values from array input
	function set_cell_values($array,$startingCell=NULL){
		if(empty($startingCell)){$startingCell='A3';}
		$array = array_values($array); #convert into simple array of values
		$this->excelObj->getActiveSheet()->fromArray($array,NULL,$startingCell);
	}

	#-----------------------------------------------------

	#date : 14-10-2014
	#purpose : set individual cell value
	function set_cell_value($cellNo,$value){
		 $this->excelObj->getActiveSheet()->setCellValue($cellNo,$value);
	}

	#-----------------------------------------------------

	#date : 14-10-2014
	#purpose : output final excel sheet
	function output_excel(){
 		$this->excelObj->getActiveSheet()->getPageSetup()->setFitToPage(true);
		require_once APPPATH.'third_party/phpExcel/PHPExcel/IOFactory.php';
		$objWriter = PHPExcel_IOFactory::createWriter($this->excelObj, 'Excel5');
		// Redirect output to a client’s web browser (Excel2007)
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.url_title($this->title).'.xls"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
		header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header ('Pragma: public'); // HTTP/1.0
		$objWriter->save('php://output'); 
	}

	#-----------------------------------------------------------
	function number_format($cell){
		$this->excelObj->getActiveSheet()->getStyle($cell)->getNumberFormat()->setFormatCode('#,##0.00');
	}
	#--------------------------------------------------------------
	function set_bold($cell){
		$this->excelObj->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
	}
	#--------------------------------------------------------------
	function set_headline($heading,$start_cell='A',$end_cell='Z'){
		
		$line = $this->get_line();
		$this->merge_cell($start_cell.$line.':'.$end_cell.$line);
		$this->set_cell_value($start_cell.$line,$heading);
		$this->set_font_size('A'.$line,14);
		$this->set_bold('A'.$line);
	}
	#--------------------------------------------------------------
	function read_file($file_name){
		$file = BASEPATH."assets/files/purchase/".$file_name;
		//echo $file;die;
		$this->excelObj = $this->excelRdr->load($file);
		$last_row = $this->excelObj->getActiveSheet()->getHighestRow();
		return $last_row;
	}
	
	
	#--------------------------------------------------------------

	function __call($method,$args){
		die("Ooops!! Vipin's my_excel class doesn't have a function called <strong><i>".$method."</i></strong>");
	}
	#--------------------------------------------------------------
}
?>