<?php
class My_pdf{
	
	var $obj_pdf;
	var $pdf_contents = NULL;
		
	public function __construct()
	{
		$this->CI =& get_instance();
					
		require_once APPPATH.'third_party/TCPDF/tcpdf.php';
		
		$this->obj_pdf = new TCPDF('P', 'mm','A4');
		$this->obj_pdf->setPrintHeader(false);
		$this->obj_pdf->setPrintFooter(false);
		$this->obj_pdf->SetMargins(0, 0, 0, true);
		$this->obj_pdf->SetAutoPageBreak(TRUE, 0);
		$this->obj_pdf->AddPage();
		$path = base_url('assets/images/relent_templates.svg');
		$this->obj_pdf->ImageSVG($path, $x='', $y='', $w='', $h='', $link='', $align='', $palign='', $border=0, $fitonpage=false);
		$this->obj_pdf->setPageMark();
	}
	
	public function set_content($pdf_contents)
	{
		$this->pdf_contents .= $pdf_contents;
	}

	public function set_margin($left,$top,$right=-1,$keepmargins=false)
	{
		$this->obj_pdf->SetMargins ($left, $top,$right,$keepmargins);
	}
	
	public function set_image($image_file,$x=NULL,$y=NULL,$w=40,$h=40,$type=NULL,$link=NULL,$align=NULL,$resize=false,$dpi=300,$palign=NULL,$ismask=false,$imgmask=false,$border=0,$fitbox=false,$hidden=false, $fitonpage=false)
	{
		$this->obj_pdf->setJPEGQuality(75);
		if(file_exists($image_file))
		{
			$this->obj_pdf->Image($image_file,$x,$y,$w,$h,$type,$link,$align,$resize,$dpi,$palign,$ismask,$imgmask,$border,$fitbox,$hidden,$fitonpage);		
		}
	}
	
	public function set_barcode($code)
	{
		$style = array('position' => 'L','align' => 'L','stretch' => false,'fitwidth' => false,'cellfitalign' => '','border' => false,'hpadding' => '','vpadding' => '','fgcolor' => array(0,0,0),'bgcolor' => false,'text' => true,'font' => 'helvetica','fontsize' => 8,'stretchtext' => 100);
		$this->obj_pdf->write1DBarcode($code, 'MSI', '', '', '', 10, 0.6, $style, 'N');
	}
	
	public function add_page($orientation='P',$format='A4',$keepmargins=false,$tocpage=false)
	{
		$this->obj_pdf->writeHTML($this->pdf_contents, true, false, true, false,'');
		$this->pdf_contents = NULL;
		$this->obj_pdf->AddPage($orientation,$format,$keepmargins,$tocpage);
	}

	public function set_footer()
	{
		$this->obj_pdf->setFooterData(array(0,64,0), array(0,64,128));
	}
	
	public function output($file_name=NULL,$pdf_contents=NULL)
	{
		$this->pdf_contents .= $pdf_contents;
		if(empty($file_name))
		{
			$file_name = 'receipt_'.date('d_M-Y');
		}
		$this->obj_pdf->SetTitle(utf8_encode($file_name));
        $this->obj_pdf->writeHTML($this->pdf_contents, true, false, true, false,'');
        $this->obj_pdf->Output($file_name.'.pdf', 'I');
	}
}
?>