<?php 
	
	class Template{
	
		var $title = 'DMS';
		var $css = array();
		var $script = array();
		var $content = array();
		var $append_content = array();
		var $sidebar_1 = array();
		var $sidebar_2 = array();
		var $links = array();
		var $buttons = array();
		var $footer;
		var $data;
		var $script_codes = array();
		var $messages;
		var $breadcrumb = array();
		var $sub_heading = 'DMS';
		var $main_heading = 'DMS';
		private $CI;
		
		
	#------------------------------------------------------	
		public function __construct(){
			$this->CI =& get_instance();
		}
	
	#------------------------------------------------------	
		
		public function title($title){
			$this->title = $title;
		}
	#------------------------------------------------------
		
		public function css($styles = array()){	

			#get template folder
			#$temp_folder = $this->get_template_folder();

			if(is_array($styles)){
				foreach($styles as $css){
				
					$this->css[] = base_url().'assets/'.$css.'.css';
					
				}
			}else{
				$this->css[] = base_url().'assets/'.$styles.'.css';
			}
			
			#print_r($this->css);
		
		}
		
	#-----------------------------------------------------	
		
		public function online_css($styles = array()){
		
			if(is_array($styles)){
				foreach($styles as $css){
				
					$this->css[] = $css.'.css';
				
				}
			}else{
				$this->css[] = $styles.'.css';
			}
		}
	#------------------------------------------------------

		public function script($scripts){	

			#get template folder
			#$temp_folder = $this->get_template_folder();
			
			if(is_array($scripts)){
				foreach($scripts as $js){
			
					$this->script[] = base_url().'assets/'.$js.'.js';
			
				}
			}else{
				$this->script[] =  base_url().'assets/'.$scripts.'.js?v=1.0.0';
			}			
		
		}

	#------------------------------------------------------
	
		function instant_script($js){
			echo '<script src="'.base_url().'assets/'.$js.'.js"></script>';
		}	

	#------------------------------------------------------	
		public function other_script($scripts){	

			
			if(is_array($scripts)){
				foreach($scripts as $js){
					$this->script[] = base_url().'assets/scripts/'.$js.'.js';
				}
			}else{
				$this->script[] =  base_url().'assets/scripts/'.$scripts.'.js?v=3.5.1';
			}			
		
		}

	#------------------------------------------------------

		public function custom_script($scripts){

			if(is_array($scripts)){

				foreach($scripts as $js){
			
					$this->script[] = base_url().'assets/'.$js.'.js';
			
				}
			}else{
				$this->script[] =  base_url().'assets/'.$scripts.'.js';
			}		
		}	

	#------------------------------------------------------	

		public function custom_css($styles = array()){	

			#get template folder
			#$temp_folder = $this->get_template_folder();

			if(is_array($styles)){
				foreach($styles as $css){
				
					$this->css[] = base_url().'assets/'.$css.'.css';
					
				}
			}else{
				$this->css[] = base_url().'assets/'.$styles.'.css';
			}
			
			#print_r($this->css);
		
		}
		
		#------------------------------------------------------
		public function online_script($scripts){	
			
			if(is_array($scripts)){
	
				foreach($scripts as $script){
				
					$this->script[] = $script;
			
				}
			}else{
				$this->script[] = $scripts;	
			}	
		
		}
	#------------------------------------------------------

		public function sidebar_1($view,$data=NULL){
			
				$CI =& get_instance();
				$this->sidebar_1[] = $CI->load->view($view,$data,true);
		}
		
	#------------------------------------------------------

		public function sidebar_2($view,$data=NULL){
		
				$CI =& get_instance();
				$this->sidebar_2[] = $CI->load->view($view,$data,true);
		}

	#------------------------------------------------------
	
		public function sub_heading($text){

			$this->sub_heading = $text;
		}	
		
	#------------------------------------------------------
		public function main_heading($text){

			$this->main_heading = $text;
		}	
		
	#------------------------------------------------------
		
		#individual views
		public function slice($view,$data = NULL,$wrapper=NULL){
			
			$CI =& get_instance();
			
			$view_load = '';

			#if we need to wrapper view with a div
			if($wrapper){

				$view_load .= '<div ';
				foreach ($wrapper as $attr => $value) {
					$view_load .= $attr.'="'.$value.'"';
				}
				$view_load .= '>';
			}

			$view_load .= $CI->load->view($view,$data,true);

			#if wrapper div is set
			if($wrapper){
				$view_load .= '</div>';
			}

			$this->content[] = $view_load;
		
		}
	#------------------------------------------------------

		public function append($view,$data = NULL,$wrapper=NULL){
			
			$CI =& get_instance();
			
			$view_load = '';

			#if we need to wrapper view with a div
			if($wrapper){

				$view_load .= '<div ';
				foreach ($wrapper as $attr => $value) {
					$view_load .= $attr.'="'.$value.'"';
				}
				$view_load .= '>';
			}

			$view_load .= $CI->load->view($view,$data,true);

			#if wrapper div is set
			if($wrapper){
				$view_load .= '</div>';
			}

			$this->append_content[] = $view_load;
		
		}
	#------------------------------------------------------

		#individual messages
		public function message($message,$type){
		
			$CI =& get_instance();
			$this->messages[$message] = $type;
		
		}
	#-------------------------------------------------------	
		
		#footer
		public function footer($view,$data){
			
			$CI =& get_instance();
			$this->footer = $CI->load->view($view,$data,true);
		
		}
	#-----------------------------------------------------------
		
		public function add_link($name,$url,$attributes = NULL){
		
		   $this->links[] = anchor($url,$name,$attributes);
		}
		
	#-----------------------------------------------------------

		public function add_button($value,$attributes = NULL){
			
			$button = '<button type="button"';
			
			if($attributes){
			
				foreach($attributes as $attr=>$attr_value)
					$button .= $attr.'="'.$attr_value.'" ';
			
			}
			
			$button .= '>'.$value.'</button>';
			
			$this->buttons[] = $button;
		
		}
	#-----------------------------------------------------------
		#render the final template
		public function render($template_name=NULL,$data = NULL){
		
			$CI =& get_instance();

			if($data){
				$this->data = $data;
				
			}
			
			#title
			$this->data['title'] = $this->title;

			if(!$template_name){
				$template_name = $this->get_template_folder();
				$CI->load->view('templates/'.$template_name,$this->data);
			}else{
				$CI->load->view($template_name,$this->data);
			}	
	
		}
		
	#-------------------------------------------------------------	
		
		public function flush_sidebar_1(){
			
			$CI =& get_instance();
			$this->sidebar_1 = array();
		}
	#-------------------------------------------------------------

		public function get_template_folder(){

			$CI =& get_instance();

			$CI->db->select('template')->from('template_master');
			$CI->db->join('users','users.user_template=template_master.id');
			$CI->db->where('users.id',$CI->session->userdata('uid'));
			#$CI->db->where('default_status',1);
			$row = $CI->db->get()->row_array();
			#echo $CI->db->last_query();
			return $row['template'];
		}

	#---------------------------------------------------------------	

		public function breadcrumb($items){

			if(is_array($items)){
				
				foreach($items as $name=>$link){
					if(is_array($link)){
						$this->breadcrumb[$name] = $link[0];
					}else{
						if($this->CI->check_access_breadcrumb($link) === true){
							$this->breadcrumb[$name] = $link;
						}
					}
				}
			}
		}

	#---------------------------------------------------------------	

	}
?>