<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledger_model extends MY_Model
{
	public function get_sub_groups($cond = NULL)
	{
		$where = "";
		if(!empty($cond)){
			$where = " and (b.id != 15 and b.id != 23)";
		}
		
		$this->db->select(array('a.primary_group','b.id','b.sub_group'))->from('account_primary_groups as a')->join('account_sub_groups as b','a.id = b.primary_group_id','inner')->where("b.status = 1$where");
		$row = $this->db->get()->result_array();
		$data = array();
		$data[""] = "select";
		foreach($row as $key => $value)
		{
			$data[$value['primary_group']][$value['id']] = $value['sub_group'];
		}
		return $data;
	}

	public function get_dc($id)
	{
		$row = $this->db->select('dc')->get_where('account_sub_groups',array('id' => $id))->row_array();
		return $row['dc'];
	}

	public function insert($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

	public function update($args = array())
	{
		if($this->my_update($args['table'],$args['data'],$args['conditions']))
		{
			return true;
		}
		return false;
	}

	public function get($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('a.sub_group','b.id','b.ledger_name','b.sgroup_id','b.dc');
		}
		$this->db->select($args['columns'])->from('account_sub_groups as a')->join('ledgers as b','a.id=b.sgroup_id','inner')->where('b.status',1);

		if(!empty($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows'])){
			return $this->db->count_all_results();
		}
		if(isset($args['order_by'])){
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit'])){
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function if_exist_open_bal($args = array())
	{
		$args['conditions']['status'] = 1;
		$row = $this->db->select('id')->get_where('ledger_open_bals',$args['conditions'])->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}

	public function check_ledger($ledger_id)
	{
		if(!$this->db->from('vouchers')->where(array('dr_ledger' => $ledger_id,'status !=' => 0))->count_all_results())
		{
			return $this->db->from('vouchers')->where(array('cr_ledger' => $ledger_id,'status !=' => 0))->count_all_results();
		}
		return true;
	}

	public function check_exists($ledger_name,$ledger_id = NULL)
	{
		$where = array('ledger_name' => $ledger_name,'status' => 1);
		if($ledger_id != NULL){
			$where['id!='] = $ledger_id;
		}
		return $this->db->from('ledgers')->where($where)->count_all_results();
	}
}
?>