<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Client_model extends MY_Model
	{
	    public function get_all($args)
		{
			$this->db->select(array('*'));
			$this->db->from('client_master');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_name($cid)
		{
			$this->db->select('name');
			$this->db->from('client_master');
			$this->db->where('id',$cid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ return $row['name']; }
			
			return false;
		}
		
		public function get_details($cid)
		{
			$this->db->select('*');
			$this->db->from('client_master');
			$this->db->where('id',$cid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ return $row; }
			
			return false;
		}
		
		public function get_all_inactive($args)
		{
			$this->db->select(array('*'));
			$this->db->from('client_master');
			$this->db->where('status',2);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function listing($args=array())
		{
			$clients = array();
			$clients[''] = 'Select';
			$this->db->select(array('id','name','mobile_no','contact_no'));
			$this->db->from('client_master');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$this->db->order_by('name','asc');
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$clients[$row['id']] = $row['name'];
				}
			}
			return $clients;
		}
		
		
		public function list_branch($args)
		{
			$branchs = array();
			$branchs[''] = 'Select';
			$this->db->select(array('id','name','mobile_no','contact_no'));
			$this->db->from('client_branch');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$this->db->order_by('name','asc');
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$branchs[$row['id']] = $row['name'];
				}
			}
			return $branchs;
		}
		
		
		
	    public function get_enquiry_det($args)
		{
		    $cond="";
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and enq_date >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and enq_date <='$tdate'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		    if(isset($args['enq_status']) && $args['enq_status'] != '')
		    {
		        $enq_status = $args['enq_status'];
		        $cond .= " and status='$enq_status'";
		    }
		    if(isset($args['status']) && $args['status'] != '')
		    {
		        $status = $args['status'];
		        if($status=='1')
		        {
		            $cond .= " and url_soft!=''";
		        }
		        else if($status=='2')
		        {
		            $cond .= " and url_soft=''";
		        }
		    }
		    
		    $res = $this->db->query("SELECT * FROM `enquiry` where id > '0' $cond")->result_array();
			
			return $res;
		}
		
		
		 public function get_enquiry_det1($args)
		{
		    $cond="";
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and enq_date >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and enq_date <='$tdate'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		   if(isset($args['enq_status']) && $args['enq_status'] != '')
		    {
		        $enq_status = $args['enq_status'];
		        $cond .= " and status='$enq_status'";
		    }
		    else 
		    {
		      
		       $enq_status = $args['enq_status'];
		       $cond .= " and status='$enq_status'";  
		       
		    }
		    if(isset($args['status']) && $args['status'] != '')
		    {
		        $status = $args['status'];
		        if($status=='1')
		        {
		            $cond .= " and url_soft!=''";
		        }
		        else if($status=='2')
		        {
		            $cond .= " and url_soft=''";
		        }
		    }
		    
		    $res = $this->db->query("SELECT * FROM `enquiry` where id >'0' $cond")->result_array();
			
			return $res;
		}

	
	    public function get_enquiry_demo_det($args)
		{
		    $cond="";
		     if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and demo_date >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and demo_date <='$tdate'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and demo_staff='$staff'";
		    }
		    if(isset($args['demo_type']) && $args['demo_type'] != '')
		    {
		        $demo_type = $args['demo_type'];
		        $cond .= " and demo_type='$demo_type'";
		    }
		    $res = $this->db->query("SELECT * FROM `enquiry` where status=1 and demo_status='1' $cond")->result_array();
			
			return $res;
		}
	
	    public function get_enquiry_rejected_det($args)
		{
		    $cond="";
		     if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and enq_date >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and enq_date <='$tdate'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		    $res = $this->db->query("SELECT * FROM `enquiry` where status=2 $cond")->result_array();
			
			return $res;
		}	

		public function enquiry_details($enqid){

    		$row = $this->db->select('*')->get_where('enquiry',array('id'=>$enqid))->row_array();
    		return $row;
    	}
	
	    public function get_follwup_status($enq_no){
			$this->db->select('u.*');
			$this->db->from('enquiry_followup1 u');
		    $this->db->where(array('u.enq_no'=>$enq_no));
			$enq = $this->db->get()->result_array();
       
			if(empty($enq)){
				return false;
			}
			return $enq;
		}
	
	    public function get_last_follwup_status($enq_no){
			$this->db->select('u.*');
			$this->db->from('enquiry_followup1 u');
		    $this->db->where(array('u.enq_no'=>$enq_no));
			$this->db->order_by("id", "desc");
			$this->db->limit(1);  
			$enq = $this->db->get()->result_array();
			if(empty($enq)){
				return false;
			}
			return $enq;
		}
		
		public function get_branches($args)
		{
			$this->db->select('*');
			$this->db->from('client_branch');
			$this->db->where('status',1);
			
            if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_branches_list($args)
		{
		    $branches = array();
			$this->db->select('*');
			$this->db->from('client_branch');
			$this->db->where('status',1);
			
            if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			$rows = $this->db->get()->result_array();
			
			foreach($rows as $row)
			{
			    $branches[$row['id']] = $row['name'];
			}
			
			return $branches;
		}
		
		public function get_branch_name($cid)
		{
			$this->db->select('name');
			$this->db->from('client_branch');
			$this->db->where('id',$cid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ return $row['name']; }
			
			return false;
		}
		
		public function get_branch_details($cid)
		{
			$this->db->select('*');
			$this->db->from('client_branch');
			$this->db->where('id',$cid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ return $row; }
			
			return false;
		}
		
	
		
		public function get_demo_pwd_det()
		{
		    $branches = array();
			$this->db->select('*');
			$this->db->from('demo_usn_pwd');
		
		    return $this->db->get()->result_array();
		
		}
		
		
		public function get_all_agreement_not_attached($args)
		{
			$this->db->select(array('*'));
			$this->db->from('client_master');
			$this->db->where('status',1);
			$this->db->where('file_attach',2);
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function criterias($args=array()){
		    $criterias = array();
		    $rows = $this->db->get_where('feedback_criteria',$args)->result_array();
		    foreach($rows as $row){
		        $criterias[$row['id']] = $row['criteria'];
		    }
		    
		    return $criterias;
		}
		
		public function get_mails($args){
            $this->db->select(array('m.*','c.name'));
			$this->db->from('client_mail m');
			$this->db->join('client_master c','m.client_id=c.id');
			if(!empty($args)){
                $this->db->where($args);
			}
            return $this->db->get()->result_array();
		}
	}
?>