<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Estimate_model extends MY_Model
	{
	    public function get_report($args)
		{
			$this->db->select('*');
			$this->db->from('estimate as e');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
	    
	    public function get_all($args)
		{
			$this->db->select(array('e.id as eid','e.client_id','e.branch_id','e.edate','e.estatus','e.remarks','ei.*'));
			$this->db->from('estimate as e');
			$this->db->join('estimate_items as ei','e.id=ei.es_id');
			$this->db->where(array('e.status'=>1,'ei.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_estimate_amount($eid)
		{
		    $amount=0;
		    $this->db->select('sum(cost) as amount');
			$this->db->from('estimate_items');
			$this->db->where('es_id',$eid);
			$this->db->where('status',1);
			
			$row = $this->db->get()->row_array();
			if(!empty($row)){ $amount = $row['amount']; }
			
			return $amount;
		}
		
		public function get_invoice_report($args)
		{
			$this->db->select('*');
			$this->db->from('invoice');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			if(isset($args['where']))
			{
				$this->db->where($args['where']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_all_invoice($args)
		{
			$this->db->select(array('i.id as iid','i.client_id','i.branch_id','i.idate','i.refno','i.remarks','ii.*'));
			$this->db->from('invoice as i');
			$this->db->join('invoice_items as ii','i.id=ii.inv_id');
			$this->db->where(array('i.status'=>1,'ii.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			if(isset($args['where']))
			{
				$this->db->where($args['where']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_invoice_amount($iid)
		{
		    $amount=0;
		    $this->db->select('sum(cost) as amount');
			$this->db->from('invoice_items');
			$this->db->where('inv_id',$iid);
			$this->db->where('status',1);
			
			$row = $this->db->get()->row_array();
			if(!empty($row)){ $amount = $row['amount']; }
			
			return $amount;
		}
		
		public function get_due($invid,$edate=NULL)
		{
		    $cost=0; $paid=0; $due=0;
		    if($edate==NULL){ $edate=date('Y-m-d'); }
		    
		    $this->db->select('*');
			$this->db->from('invoice_items');
		    $this->db->where('id',$invid);
		    $row = $this->db->get()->row_array();
		    $cost = $row['cost'];
		    
		    $this->db->select('sum(i.amount) as paid');
			$this->db->from('invoice_payment_items as i');
			$this->db->join('invoice_payments as p','i.pay_id=p.id');
		    $this->db->where('i.inv_id',$invid);
		    $this->db->where('p.pdate <=',$edate);
		    $this->db->where('i.status =',1);
		    $this->db->where('p.status =',1);
		    $row1 = $this->db->get()->row_array();
		    $paid = $row1['paid'];
		    
		    $due = $cost-$paid;
		    
		    return $due;
		}
		
		public function get_payment_report($args)
		{
			$this->db->select('*');
			$this->db->from('invoice_payments');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{ 
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_all_payment($args)
		{
			$this->db->select(array('p.id as pid','p.client_id','p.branch_id','p.pdate','p.refno','p.bill_no','p.remark','p.pmode','pi.*'));
			$this->db->from('invoice_payments as p');
			$this->db->join('invoice_payment_items as pi','p.id=pi.pay_id');
			$this->db->where(array('p.status'=>1,'pi.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_payment_amount($pid)
		{
		    $amount=0;
		    $this->db->select('sum(amount) as amount');
			$this->db->from('invoice_payment_items');
			$this->db->where('pay_id',$pid);
			$this->db->where('status',1);
			
			$row = $this->db->get()->row_array();
			if(!empty($row)){ $amount = $row['amount']; }
			
			return $amount;
		}
		
		public function get_invoice_due_report($args)
		{
			$this->db->select(array('i.*','wi.id as itemid'));
			$this->db->from('invoice as i');
			$this->db->join('invoice_items as wi','i.id=wi.inv_id');
			$this->db->where(array('i.status'=>1,'wi.status'=>1,'wi.payment_status'=>0));
		    //$this->db->group_by('i.id');
			$this->db->order_by('i.idate','asc');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_expiry_report($args)
		{
			$this->db->select('*');
			$this->db->from('expiry_notification');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			if(isset($args['where']))
			{
				$this->db->where($args['where']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
	}
?>