<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Expense_model extends MY_Model
	{
	    public function insert($table,$data)
    	{
    		$result = $this->f_save($table,$data);
    		if($result)
    		{
    			return $result;
    		}
    		return false;
    	}
    	
    	public function get_expenses($args)
		{
			$this->db->select(array('e.*','sum(ei.amount) as amount'));
			$this->db->from('expense as e');
			$this->db->join('expense_items as ei','e.id=ei.expense_id');
			$this->db->where(array('e.status'=>1,'ei.status'=>1));
			$this->db->group_by('e.id');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_all($args)
		{
			$this->db->select(array('e.*','ei.id as eid','ei.particulars','ei.amount','ei.attachment'));
			$this->db->from('expense as e');
			$this->db->join('expense_items as ei','e.id=ei.expense_id');
			$this->db->where(array('e.status'=>1,'ei.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
	}