<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Lead_model extends MY_Model
	{
	    var $table = 'lead_details';
	    var $column_order1 = array(null, 'refno','cdate','ltype','cname','mobile',null,'lstatus','percentage',null,'principal','manager','location','last_date','last_remarks','whatsapp','email','collected_by');
	    var $column_order = array(null,null, 'refno','cdate','ltype','cname','location','mobile','principal','manager','percentage',null,'whatsapp','email','collected_by','assigned_to');
        var $column_search = array('refno','cname','location','mobile','whatsapp','email'); 
        var $order = array('percentage'=>'desc','id' => 'asc');
	    
	    public function ltype_list()
		{
			$ltypes = array();
			$this->db->select(array('id','ltype_name'));
			$this->db->from('lead_types');
			$this->db->where('status',1);
			$this->db->order_by('ltype_name','asc');
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$ltypes[$row['id']] = $row['ltype_name'];
				}
			}
			return $ltypes;
		}
		
		public function lstatus_list()
		{
			$lstatuses = array();
			$this->db->select(array('id','remark'));
			$this->db->from('lead_status');
			$this->db->where('status',1);
			$this->db->order_by('id','asc');
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$lstatuses[$row['id']] = $row['remark'];
				}
			}
			return $lstatuses;
		}
		
		public function lstatuses()
		{
			$lstatuses = array();
			$this->db->select('*');
			$this->db->from('lead_status');
			$this->db->where('status',1);
			$this->db->order_by('id','asc');
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$lstatuses[$row['id']] = array('remark'=>$row['remark'],'color'=>$row['color']);
				}
			}
			return $lstatuses;
		}
		
		public function get_lstatus_id($lstatus)
		{
		    $lsid=1;
		    $this->db->select('id');
			$this->db->from('lead_status');
			$this->db->where('remark',$lstatus);
			$row = $this->db->get()->row_array();
			if(!empty($row)){ $lsid = $row['id']; }
			
			return $lsid;
		}
		
		public function get_all_leads($args)
		{ 
		    $this->db->select('*');
			$this->db->from('lead_details');
			$this->db->where('status',1);
			
			if(isset($args['where']))
			{
			    $where = $args['where'];
			    $this->db->where("$where");
			}
			if(isset($args['between']))
			{
			    $this->db->where($args['between'],NULL,false);
    		}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_assigned($args)
		{ 
		    $this->db->select('*');
			$this->db->from('lead_details');
			$this->db->where('status',1);
			$this->db->where('assigned_to',$this->session->userdata('uid'));
			
			if(isset($args['where']))
			{
			    $where = $args['where'];
			    $this->db->where("$where");
			}
			if(isset($args['between']))
			{
			    $this->db->where($args['between'],NULL,false);
    		}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_count_by_status($args)
		{ 
		    $count_array = array();
		    $this->db->select(array('lstatus','count(*) as cnt'));
			$this->db->from('lead_details');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            
			$this->db->group_by('lstatus');
			
			$rows = $this->db->get()->result_array();
			
			foreach($rows as $row)
			{
			    $count_array[$row['lstatus']] = $row['cnt'];
			}
			return $count_array;
		}
		
		public function get_call_count($args)
		{ 
		    $count_array = array();
		    $this->db->select('*');
			$this->db->from('lead_details');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            
			return $this->db->count_all_results();
		}
		
		public function call_count_by_ltype($args)
		{ 
		    $count_array = array();
		    $this->db->select(array('ltype','count(*) as cnt'));
			$this->db->from('lead_details');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$this->db->group_by('ltype',1);
            
			$rows = $this->db->get()->result_array();
			foreach($rows as $row)
			{
			    $count_array[$row['ltype']] = $row['cnt'];
			}
			return $count_array;
		}
		
		public function lead_details($lead_id)
		{ 
		    $this->db->select('*');
			$this->db->from('lead_details');
			$this->db->where('id',$lead_id);
			
			return $this->db->get()->row_array();
		}
		
		public function get_followups($args)
        {
            $this->db->select(array('p.*','l.refno','l.ltype','l.cname','l.location','l.mobile','l.landline','l.lstatus'));
			$this->db->from('lead_progress as p');
			$this->db->join('lead_details as l','p.lead_id=l.id');
			$this->db->where('p.status',1);
			
			if(isset($args['where']))
			{
			    $where = $args['where'];
			    $this->db->where("$where");
			}
			if(isset($args['between']))
			{
			    $this->db->where($args['between'],NULL,false);
    		}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
        }
        
		public function follow_details($lead_id)
		{ 
		    $this->db->select('*');
			$this->db->from('lead_progress');
			$this->db->where('lead_id',$lead_id);
			
			return $this->db->get()->result_array();
		}
		
		public function get_report()
        {
            $this->get_report_query();
            if($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
            $query = $this->db->get();
            return $query->result();
        }
     
        public function count_report_filtered()
        {
            $this->get_report_query();
            $query = $this->db->get();
            return $query->num_rows();
        }
     
        private function get_report_query()
        {
            if($this->input->post('ltype'))
            {
                $this->db->where('ltype', $this->input->post('ltype'));
            }
            if(!empty($this->input->post('fdate')))
            {
                $from_date = date('Y-m-d',strtotime($this->input->post('fdate')));
                $this->db->where('cdate >=',$from_date);
            }
            if(!empty($this->input->post('tdate')))
            {
                $to_date = date('Y-m-d',strtotime($this->input->post('tdate')));
                $this->db->where('cdate <=',$to_date);
            }
            if($this->input->post('collect'))
            {
                $this->db->where('collected_by', $this->input->post('collect'));
            }
            if($this->input->post('assign'))
            {
                $this->db->where('assigned_to', $this->input->post('assign'));
            }
            if($this->input->post('stat'))
            {
                if($this->input->post('stat')=='called'){
                    $this->db->where('lstatus >', 1);
                }else{
                    $this->db->where('lstatus', $this->input->post('stat'));
                }
            }
            $this->db->from('lead_details');
            $i = 0;
            
            if($_POST['search']['value']) // if datatable send POST for search
            {
                $this->db->like('refno', $_POST['search']['value']);
                $this->db->or_like('cname', $_POST['search']['value']);
                $this->db->or_like('location', $_POST['search']['value']);
                $this->db->or_like('mobile', $_POST['search']['value']);
                $this->db->or_like('whatsapp', $_POST['search']['value']);
                $this->db->or_like('email', $_POST['search']['value']);
            }
         
            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            } 
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
		
		private function _get_datatables_query()
        {
            if($this->input->post('ltype'))
            {
                $this->db->where('ltype', $this->input->post('ltype'));
            }
            if(!empty($this->input->post('fdate')))
            {
                $from_date = date('Y-m-d',strtotime($this->input->post('fdate')));
                $this->db->where('cdate >=',$from_date);
            }
            if(!empty($this->input->post('tdate')))
            {
                $to_date = date('Y-m-d',strtotime($this->input->post('tdate')));
                $this->db->where('cdate <=',$to_date);
            }
            if($this->input->post('collect'))
            {
                $this->db->where('collected_by', $this->input->post('collect'));
            }
            if($this->input->post('stat'))
            {
                $this->db->where('lstatus', $this->input->post('stat'));
            }
     
            $this->db->where('assigned_to',$this->session->userdata('uid'));
     
            $this->db->from('lead_details');
            $i = 0;
            
            if($_POST['search']['value']) // if datatable send POST for search
            {
                $this->db->like('refno', $_POST['search']['value']);
                $this->db->or_like('cname', $_POST['search']['value']);
                $this->db->or_like('location', $_POST['search']['value']);
                $this->db->or_like('mobile', $_POST['search']['value']);
                $this->db->or_like('whatsapp', $_POST['search']['value']);
                $this->db->or_like('email', $_POST['search']['value']);
            }
         
            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order1[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            } 
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
     
        public function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }
     
        public function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }
     
        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
        
        public function get_proposals($args)
        {
            $this->db->select(array('p.*','l.ltype','l.lstatus'));
			$this->db->from('lead_proposal as p');
			$this->db->join('lead_details as l','p.lead_id=l.id');
			$this->db->where('p.status',1);
			
			if(isset($args['where']))
			{
			    $where = $args['where'];
			    $this->db->where("$where");
			}
			if(isset($args['between']))
			{
			    $this->db->where($args['between'],NULL,false);
    		}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
        }
	}