<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
    class Mail_model extends MY_Model{
        
        var $table = 'mail_queue';
        var $column_order = array(null,'m.recipient', 'm.subject','u.fname','m.created_on','m.status');
        var $order = array('m.id' => 'asc');

        public function insert($table,$data){
            $result = $this->f_save($table,$data);
            if($result){
                return $result;
            }
            return false;
        }
    	
        public function get_template($tid){
            $this->db->select('*');
			$this->db->from('mail_template');
			$this->db->where('id',$tid);
			return $this->db->get()->row_array();
        }

        public function get_templates(){
            $this->db->select('*');
			$this->db->from('mail_template');
			$this->db->where('status',1);
			return $this->db->get()->result_array();
        }

        public function template_list(){
            $templates = array();
            $templates[''] = 'Select';
            $this->db->select('*');
			$this->db->from('mail_template');
			$this->db->where('status',1);
			$rows = $this->db->get()->result_array();
			foreach($rows as $row){
			    $templates[$row['id']] = $row['title'];
			}
			return $templates;
        }
    	
        public function get_mails($args){ 
		    $this->db->select(array('m.*','t.title','l.ltype_name'));
			$this->db->from('mail_logs m');
			$this->db->join('mail_template t','m.template_id=t.id');
			$this->db->join('lead_types l','m.ltype_id=l.id');
			$this->db->where('m.status',1);
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_mail_counts($args) { 
            $this->db->select(array(
                'm.date', 
                't.title', 
                'l.ltype_name', 
                'COUNT(*) as total',
                'SUM(CASE WHEN m.status = "pending" THEN 1 ELSE 0 END) as pending_count',
                'SUM(CASE WHEN m.status = "sent" THEN 1 ELSE 0 END) as sent_count',
                'SUM(CASE WHEN m.status = "failed" THEN 1 ELSE 0 END) as failed_count'
            ));
            $this->db->from('mail_queue m');
            $this->db->join('mail_template t', 'm.template_id = t.id');
            $this->db->join('lead_types l', 'm.ltype_id = l.id');
            if (isset($args['conditions'])) {
                $this->db->where($args['conditions']);
            }
            $this->db->group_by(['m.ltype_id', 'm.date']);
        
            return $this->db->get()->result_array();
        }
		
		public function add_to_queue($ltype, $template, $recipient, $subject, $message, $attachment=NULL){
            $data = array(
                'ltype_id' => $ltype,
                'template_id' => $template,
                'recipient' => $recipient,
                'subject' => $subject,
                'message' => $message,
                'attachment' => $attachment,
                'date' => date('Y-m-d'),
                'status' => 'pending'
            );
            return $this->insert('mail_queue', $data);
        }
        
        public function get_pending_emails(){
            $this->db->where('status', 'pending');
            $this->db->order_by('id', 'ASC'); // Order by id in ascending order
            $this->db->limit(20); // Limit to first 30 rows
            $query = $this->db->get('mail_queue');
            return $query->result();
        }
        
        public function mark_as_sent($id){
            $this->db->where('id', $id);
            return $this->db->update('mail_queue', array('status' => 'sent'));
        }
        
        public function mark_as_fail($id){
            $this->db->where('id', $id);
            return $this->db->update('mail_queue', array('status' => 'failed'));
        }
        
        public function get_emails()
		{
		    $this->get_emails_query();
            if($this->input->post('length') != -1){
                $this->db->limit($this->input->post('length'), $this->input->post('start'));
            }
            $query = $this->db->get();
            return $query->result();
		}
		
		public function count_emails_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
        
        public function count_emails_filtered()
        {
            $this->get_emails_query();
            $query = $this->db->get();
            return $query->num_rows();
        }
		
		private function get_emails_query()
        {
            $this->db->select(array('m.*','l.ltype_name','ld.cname','ld.location','u.fname'));
            $this->db->from('mail_queue as m');
            $this->db->join('lead_types as l','m.ltype_id=l.id','left');
            $this->db->join('lead_details as ld','m.recipient=ld.email','left'); 
            $this->db->join('users as u','m.created_by=u.id');
            
            if($this->input->post('fdate') && $this->input->post('tdate')) {
                $fdate = date('Y-m-d', strtotime($this->input->post('fdate')));
                $tdate = date('Y-m-d', strtotime($this->input->post('tdate')));
                $this->db->where("DATE(m.created_on) >=", $fdate);
                $this->db->where("DATE(m.created_on) <=", $tdate);
            }
            if ($this->input->post('ltype')) {
                $this->db->where('m.ltype_id', $this->input->post('ltype'));
            }
            if ($this->input->post('status')) {
                $this->db->where('m.status', $this->input->post('status'));
            }
            
            $i = 0;
            if(isset($_POST['search']['value'])){
                $skey = $_POST['search']['value'];
                $this->db->where("(m.recipient like '%$skey%' or m.subject like '%$skey%' or u.fname like '%$skey%')");
            }
         
            if(isset($_POST['order'])){
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }else if(isset($this->order)){
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
        
        public function get_ltype_emails()
		{
		    $this->get_ltype_emails_query();
            if($this->input->post('length') != -1){
                $this->db->limit($this->input->post('length'), $this->input->post('start'));
            }
            $query = $this->db->get();
            return $query->result();
		}
		
		private function get_ltype_emails_query()
        {
            $this->db->select(array('m.*','l.ltype_name','u.fname'));
            $this->db->from('mail_queue as m');
            $this->db->join('lead_types as l','m.ltype_id=l.id','left');
            $this->db->join('users as u','m.created_by=u.id');
            
            if($this->input->post('fdate') && $this->input->post('tdate')) {
                $fdate = date('Y-m-d', strtotime($this->input->post('fdate')));
                $tdate = date('Y-m-d', strtotime($this->input->post('tdate')));
                $this->db->where("DATE(m.created_on) >=", $fdate);
                $this->db->where("DATE(m.created_on) <=", $tdate);
            }
            if ($this->input->post('ltype')) {
                $this->db->where('m.ltype_id', $this->input->post('ltype'));
            }
            if ($this->input->post('status')) {
                $this->db->where('m.status', $this->input->post('status'));
            }
            
            $i = 0;
            if(isset($_POST['search']['value'])){
                $skey = $_POST['search']['value'];
                $this->db->where("(m.recipient like '%$skey%' or m.subject like '%$skey%' or u.fname like '%$skey%')");
            }
            
            $this->db->group_by(array('m.date','m.template_id'));
         
            if(isset($_POST['order'])){
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }else if(isset($this->order)){
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
        
        public function count_ltype_emails_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
        
        public function count_ltype_emails_filtered()
        {
            $this->get_ltype_emails_query();
            $query = $this->db->get();
            return $query->num_rows();
        }
	}