<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Product_model extends MY_Model
	{
	    public function insert($table,$data)
    	{
    		$result = $this->f_save($table,$data);
    		if($result)
    		{
    			return $result;
    		}
    		return false;
    	}
	    
	    public function get_all($args)
		{
			$this->db->select(array('*'));
			$this->db->from('products');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function product_list($type=NULL)
		{
		    $products = array();
		    $this->db->select('*');
			$this->db->from('products');
			$this->db->where('status',1);
			if($type!=NULL){
			    $this->db->where('ptype',$type);
			}
			$rows = $this->db->get()->result_array();
			$products[''] = 'Select';
			foreach($rows as $row){
			    $products[$row['id']] = $row['name'];
			}
			return $products;
		}
		
		public function get_name($pid)
		{
			$this->db->select('name');
			$this->db->from('products');
			$this->db->where('id',$pid);
			$row = $this->db->get()->row_array();
			if(!empty($row)){
			    return $row['name'];
			}
			return false;
		}
		
		public function payment_types()
		{
			$this->db->select(array('*'));
			$this->db->from('payment_types');
			$this->db->where('status',1);
			
			return $this->db->get()->result_array();
		}
		
		public function payment_type_list()
		{
		    $pay_types = array();
			$this->db->select(array('*'));
			$this->db->from('payment_types');
			$this->db->where('status',1);
			$rows = $this->db->get()->result_array();
			
			foreach($rows as $row)
			{
			    $pay_types[$row['type']] = $row['type'];
			}
			
			return $pay_types;
		}
		
		public function module_list()
		{
		    $modules = array();
			$this->db->select(array('*'));
			$this->db->from('modules');
			$this->db->where('status',1);
			$rows = $this->db->get()->result_array();
			
			foreach($rows as $row)
			{
			    $modules[$row['id']] = $row['name'];
			}
			
			return $modules;
		}
	}
?>	