<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Server_model extends MY_Model
	{
	    public function get_all($args)
		{
			$this->db->select(array('*'));
			$this->db->from('servers');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function server_list()
		{
		    $servers = array();
			$this->db->select(array('*'));
			$this->db->from('servers');
			$this->db->where('status',1);
			$rows = $this->db->get()->result_array();
			
			foreach($rows as $row){
			    $servers[$row['id']] = $row['server_name'];
			}
			
			return $servers;
		}
	}
?>	